/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.model.oaattachment.OaAttachmentCrForm;
import com.bringspring.oa.model.oaattachment.OaAttachmentInfoVO;
import com.bringspring.oa.model.oaattachment.OaAttachmentListVO;
import com.bringspring.oa.model.oaattachment.OaAttachmentPagination;
import com.bringspring.oa.model.oaattachment.OaAttachmentUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9644\u4ef6"}, value="oa")
@RequestMapping(value={"/api/oa/OaAttachment"})
public class OaAttachmentController {
    private static final Logger log = LoggerFactory.getLogger(OaAttachmentController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractProjectService contractProjectService;
    @Autowired
    private OaAttachmentService oaAttachmentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaAttachmentPagination oaAttachmentPagination) throws IOException {
        List<OaAttachmentEntity> list = this.oaAttachmentService.getList(oaAttachmentPagination);
        for (OaAttachmentEntity oaAttachmentEntity : list) {
            oaAttachmentEntity.setUrl(this.baseDataUtil.getFileNameInJson(oaAttachmentEntity.getUrl()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaAttachmentListVO.class);
        for (OaAttachmentListVO oaAttachmentListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaAttachmentPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @GetMapping(value={"/getListByContractIdAndFileType/{contractId}/{fileType}"})
    public ActionResult getListByContractIdAndType(@PathVariable(value="contractId") String contractId, @PathVariable(value="fileType") String fileType) {
        return ActionResult.success(this.oaAttachmentService.getListByContractIdAndFileType(contractId, fileType));
    }

    @GetMapping(value={"/getListByContractIdAndFileType/{contractId}"})
    public ActionResult getListByContractId(@PathVariable(value="contractId") String contractId) {
        List<OaAttachmentEntity> listByContractId = this.oaAttachmentService.getListByContractId(contractId);
        return ActionResult.success();
    }

    @GetMapping(value={"/getListByContractIdAndFileTypeNew/{contractId}"})
    public ActionResult getListByContractIdNew(@PathVariable(value="contractId") String contractId) {
        List<OaAttachmentEntity> listByContractId = this.oaAttachmentService.getListByContractId(contractId);
        listByContractId.stream().forEach(entity -> {
            OaAttachmentInfoVO jsonToBean = (OaAttachmentInfoVO)JsonUtil.getJsonToBean((Object)entity, OaAttachmentInfoVO.class);
            entity.setAttachmentEntityList(CollectionUtil.list((boolean)false, (Object[])new OaAttachmentInfoVO[]{jsonToBean}));
        });
        return ActionResult.success(listByContractId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaAttachmentCrForm oaAttachmentCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            OaAttachmentEntity entity = (OaAttachmentEntity)JsonUtil.getJsonToBean((Object)oaAttachmentCrForm, OaAttachmentEntity.class);
            entity.setId(mainId);
            this.oaAttachmentService.save(entity);
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaAttachmentInfoVO> info(@PathVariable(value="id") String id) {
        OaAttachmentEntity entity = this.oaAttachmentService.getInfo(id);
        OaAttachmentInfoVO vo = (OaAttachmentInfoVO)JsonUtil.getJsonToBean((Object)entity, OaAttachmentInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaAttachmentInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OaAttachmentEntity entity = this.oaAttachmentService.getInfo(id);
        OaAttachmentInfoVO vo = (OaAttachmentInfoVO)JsonUtil.getJsonToBean((Object)entity, OaAttachmentInfoVO.class);
        vo.setUrl(this.baseDataUtil.getFileNameInJson(vo.getUrl()));
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaAttachmentUpForm oaAttachmentUpForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            OaAttachmentEntity entity = this.oaAttachmentService.getInfo(id);
            if (entity != null) {
                OaAttachmentEntity subentity = (OaAttachmentEntity)JsonUtil.getJsonToBean((Object)oaAttachmentUpForm, OaAttachmentEntity.class);
                this.oaAttachmentService.update(id, subentity);
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }
}

