/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.SaleNoContractStatusEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmClueInfoService;
import com.bringspring.crm.service.CrmCustomerOpportunityService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaBeforeSaleSupportEntity;
import com.bringspring.oa.model.oaBeforesalesupport.OaBeforeSalePaginationVO;
import com.bringspring.oa.model.oaBeforesalesupport.OaBeforeSaleSupportCrForm;
import com.bringspring.oa.model.oaBeforesalesupport.OaBeforeSaleSupportInfoVO;
import com.bringspring.oa.model.oaBeforesalesupport.OaBeforeSaleSupportListVO;
import com.bringspring.oa.model.oaBeforesalesupport.OaBeforeSaleSupportPagination;
import com.bringspring.oa.model.oaBeforesalesupport.OaBeforeSaleSupportPaginationExportModel;
import com.bringspring.oa.model.oaBeforesalesupport.OaBeforeSaleSupportUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaBeforeSaleSupportService;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.BeforeSaleSupportListEntity;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.BeforeSaleSupportListService;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.utils.Constants;
import com.bringspring.visit.utils.UserRelationUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u552e\u524d\u7ba1\u7406"}, value="visit")
@RequestMapping(value={"/api/visit/BeforeSaleSupport"})
public class OaBeforeSaleSupportController {
    private static final Logger log = LoggerFactory.getLogger(OaBeforeSaleSupportController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaBeforeSaleSupportService beforeSaleSupportService;
    @Autowired
    private BeforeSaleSupportListService beforeSaleSupportListService;
    @Autowired
    private CrmCustomerOpportunityService crmCustomerOpportunityService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmClueInfoService crmClueInfoService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserRelationUtil userRelationUtil;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaBeforeSaleSupportPagination beforeSaleSupportPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        List role = this.userRelationService.getListByObjectType(userInfo.getUserId(), "Role");
        List roleIds = role.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
        if (roleIds.contains("497777648534223557")) {
            beforeSaleSupportPagination.setShowScope("all");
        }
        List<OaBeforeSaleSupportEntity> list = this.beforeSaleSupportService.getList(beforeSaleSupportPagination);
        List projectReporting = this.rkProjectReportingService.list();
        List listVO = JsonUtil.getJsonToList(list, OaBeforeSaleSupportListVO.class);
        List dictTypeList = this.dictionaryTypeService.list();
        for (OaBeforeSaleSupportListVO entity : listVO) {
            entity.setCustomerType(this.baseDataUtil.getDictName(entity.getCustomerType(), "visitCustomerType"));
            entity.setSupportContent(this.baseDataUtil.getDictName(entity.getSupportContent(), "supprotContent"));
            entity.setSupportType(this.baseDataUtil.getDictName(entity.getSupportType(), "supprotType"));
            OrganizeEntity info = this.organizeService.getInfo(entity.getCompanyId());
            if (ObjectUtil.isNotEmpty((Object)info)) {
                OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)info.getPropertyJson(), OrganizeCrModel.class);
                entity.setCompanyName(jsonToBean.getShortName());
            }
            if (ObjectUtil.isNotEmpty((Object)dictTypeList) && StringUtils.isNotEmpty((String)entity.getSupportProjectStage())) {
                for (DictionaryTypeEntity dict : dictTypeList) {
                    if (!dict.getId().equals(entity.getSupportProjectStage())) continue;
                    entity.setSupportProjectStage(dict.getFullName());
                }
            }
            entity.setSupportProductId(this.crmProductService.getInfoByListId(entity.getSupportProductId()).stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
            entity.setCustomerId(this.crmCustomerService.getInfo(entity.getCustomerId()).getName());
            entity.setApplyPerson(this.baseDataUtil.userSelectValueNoAccount(entity.getApplyPerson()));
            entity.setApplyPersonDepartment(this.baseDataUtil.comSelectValues(entity.getApplyPersonDepartment()));
            if (!StringUtil.isNotEmpty((String)entity.getAssociationReport())) continue;
            for (RkProjectReportingEntity report : projectReporting) {
                if (!report.getId().equals(entity.getAssociationReport())) continue;
                entity.setAssociationReport(report.getCustomerName());
            }
        }
        for (OaBeforeSaleSupportListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        OaBeforeSalePaginationVO page = (OaBeforeSalePaginationVO)((Object)JsonUtil.getJsonToBean((Object)((Object)beforeSaleSupportPagination), OaBeforeSalePaginationVO.class));
        vo.setPagination((PaginationVO)page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaBeforeSaleSupportCrForm beforeSaleSupportCrForm) throws Exception {
        String productIds;
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OaBeforeSaleSupportEntity entity = (OaBeforeSaleSupportEntity)JsonUtil.getJsonToBean((Object)((Object)beforeSaleSupportCrForm), OaBeforeSaleSupportEntity.class);
        entity.setId(mainId);
        entity.setEnabledMark(Constants.BEFORE_SALE_ENABLEDMARK_VERIFY);
        entity.setApplyPerson(userInfo.getUserId());
        entity.setApplyPersonDepartment(userInfo.getDepartmentId());
        entity.setApplyCompanyId(userInfo.getOrganizeId());
        CrmCustomerEntity crmCustomerEntity = this.crmCustomerService.getInfo(entity.getCustomerId());
        if (ObjectUtil.isNotEmpty((Object)crmCustomerEntity)) {
            entity.setCustomerArea(crmCustomerEntity.getAddress());
            entity.setCustomerAreaRegional(this.getAreaReaRegional(crmCustomerEntity.getAddress(), userInfo.getOrganizeId()));
            beforeSaleSupportCrForm.setCustomerAreaRegional(entity.getCustomerAreaRegional());
        }
        String flowEngineId = "514067476582238277";
        entity.setId(mainId);
        if (StringUtil.isNotEmpty((String)beforeSaleSupportCrForm.getSupportProductId()) && ObjectUtil.isNotEmpty((Object)(productIds = beforeSaleSupportCrForm.getSupportProductId()).split(","))) {
            CrmProductCategoryEntity category;
            String productId = productIds.split(",")[0];
            productId = productId.replace("[", "");
            productId = productId.replace("]", "");
            CrmProductEntity product = this.crmProductService.getInfo(productId = productId.replace("\"", ""));
            if (ObjectUtil.isNotEmpty((Object)product) && ObjectUtil.isNotEmpty((Object)(category = this.crmProductCategoryService.getInfo(product.getCategoryId())))) {
                entity.setProductCompanyId(category.getParentId());
                beforeSaleSupportCrForm.setProductCompanyId(entity.getProductCompanyId());
            }
        }
        if (CollectionUtil.isNotEmpty(beforeSaleSupportCrForm.getAttachmentFile())) {
            List oaAttachmentEntityList = JsonUtil.getJsonToList(beforeSaleSupportCrForm.getAttachmentFile(), OaAttachmentEntity.class);
            for (OaAttachmentEntity entitys : oaAttachmentEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setObjId(entity.getId());
                entitys.setFileType(AttachmentTypeEnum.PROJECT_BEFORE_SUPPORT_TYPE.getType());
                this.oaAttachmentService.save(entitys);
            }
        }
        this.beforeSaleSupportService.save(entity);
        this.beforeSaleSupportService.insertSaleSupportList(entity, beforeSaleSupportCrForm);
        FlowUtil.saveOrSubmit((String)beforeSaleSupportCrForm.getTaskId(), (String)flowEngineId, (String)beforeSaleSupportCrForm.getTemplateId(), (String)mainId, (Object)entity, (Integer)beforeSaleSupportCrForm.getStatus(), (String)this.crmCustomerService.getInfo(beforeSaleSupportCrForm.getCustomerId()).getName());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    private String getAreaReaRegional(String address, String company) throws DataException {
        if (StringUtil.isNotEmpty((String)address)) {
            List addressList = JsonUtil.getJsonToList((String)address, String.class);
            if (CollectionUtil.isNotEmpty((Collection)addressList)) {
                List userList = this.userService.getListByOraganizetionId(company);
                List userRelationList = this.userRelationService.getListByObjectId(address, "Area");
                if (CollectionUtil.isNotEmpty(userRelationList = userRelationList.stream().filter(a -> userList.stream().map(UserEntity::getId).collect(Collectors.toList()).contains(a.getUserId())).collect(Collectors.toList()))) {
                    List userAllList = this.userRelationService.getListByUserIdAll(userRelationList.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList()));
                    if (CollectionUtil.isEmpty(userAllList = userAllList.stream().filter(a -> a.getObjectType().equals("AreaManager")).collect(Collectors.toList()))) {
                        addressList.remove(addressList.size() - 1);
                        return this.getAreaReaRegional(JsonUtil.getObjectToString((Object)addressList), company);
                    }
                    return ((UserRelationEntity)userAllList.get(0)).getUserId();
                }
                addressList.remove(addressList.size() - 1);
                return this.getAreaReaRegional(JsonUtil.getObjectToString((Object)addressList), company);
            }
            return null;
        }
        return null;
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaBeforeSaleSupportPaginationExportModel beforeSaleSupportPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)beforeSaleSupportPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaBeforeSaleSupportPagination beforeSaleSupportPagination = (OaBeforeSaleSupportPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)beforeSaleSupportPaginationExportModel), OaBeforeSaleSupportPagination.class));
        List<OaBeforeSaleSupportEntity> list = this.beforeSaleSupportService.getTypeList(beforeSaleSupportPagination, beforeSaleSupportPaginationExportModel.getDataType());
        for (OaBeforeSaleSupportEntity oaBeforeSaleSupportEntity : list) {
            oaBeforeSaleSupportEntity.setCustomerType(this.baseDataUtil.getDictName(oaBeforeSaleSupportEntity.getCustomerType(), "visitCustomerType"));
            oaBeforeSaleSupportEntity.setSupportContent(this.baseDataUtil.getDictName(oaBeforeSaleSupportEntity.getSupportContent(), "supprotContent"));
            oaBeforeSaleSupportEntity.setSupportType(this.baseDataUtil.getDictName(oaBeforeSaleSupportEntity.getSupportType(), "supprotType"));
            oaBeforeSaleSupportEntity.setTechnicalRequirement(this.baseDataUtil.getDictName(oaBeforeSaleSupportEntity.getTechnicalRequirement(), "technologyDegree"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaBeforeSaleSupportListVO.class);
        for (OaBeforeSaleSupportListVO oaBeforeSaleSupportListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)beforeSaleSupportPaginationExportModel.getSelectKey()) ? beforeSaleSupportPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block40: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"customerId"));
                        continue block40;
                    }
                    case "customerCatagory": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u95f4\u5546/\u96c6\u6210\u5546", (Object)"customerCatagory"));
                        continue block40;
                    }
                    case "customerType": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u7c7b\u578b", (Object)"customerType"));
                        continue block40;
                    }
                    case "wetherKnow": {
                        entitys.add(new ExcelExportEntity("\u9886\u5bfc\u662f\u5426\u77e5\u6653", (Object)"wetherKnow"));
                        continue block40;
                    }
                    case "supportProductId": {
                        entitys.add(new ExcelExportEntity("\u652f\u6301\u4ea7\u54c1", (Object)"supportProductId"));
                        continue block40;
                    }
                    case "supportContent": {
                        entitys.add(new ExcelExportEntity("\u652f\u6301\u7c7b\u578b", (Object)"supportContent"));
                        continue block40;
                    }
                    case "supportType": {
                        entitys.add(new ExcelExportEntity("\u652f\u6301\u65b9\u5f0f", (Object)"supportType"));
                        continue block40;
                    }
                    case "associationSaleChance": {
                        entitys.add(new ExcelExportEntity("\u5173\u8054\u5546\u673a", (Object)"associationSaleChance"));
                        continue block40;
                    }
                    case "associationReport": {
                        entitys.add(new ExcelExportEntity("\u5173\u8054\u62a5\u5907", (Object)"associationReport"));
                        continue block40;
                    }
                    case "startTime": {
                        entitys.add(new ExcelExportEntity("\u5f00\u59cb\u65f6\u95f4", (Object)"startTime"));
                        continue block40;
                    }
                    case "endTime": {
                        entitys.add(new ExcelExportEntity("\u7ed3\u675f\u65f6\u95f4", (Object)"endTime"));
                        continue block40;
                    }
                    case "technicalRequirement": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba", (Object)"technicalRequirement"));
                        continue block40;
                    }
                    case "wetherAccompany": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u966a\u540c", (Object)"wetherAccompany"));
                        continue block40;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block40;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaBeforeSaleSupportInfoVO> info(@PathVariable(value="id") String id) {
        OaBeforeSaleSupportEntity entity = this.beforeSaleSupportService.getInfo(id);
        OaBeforeSaleSupportInfoVO vo = (OaBeforeSaleSupportInfoVO)JsonUtil.getJsonToBean((Object)entity, OaBeforeSaleSupportInfoVO.class);
        vo.setCustomerName(this.crmCustomerService.getInfo(vo.getCustomerId()).getName());
        vo.setSupportProductName(this.crmProductService.getInfoByListId(vo.getSupportProductId()).stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
        vo.setApplyPersonName(this.baseDataUtil.userSelectValueNoAccount(vo.getApplyPerson()));
        vo.setApplyPersonDepartmentName(this.baseDataUtil.comSelectValues(vo.getApplyPersonDepartment()));
        if (StringUtils.isNotEmpty((String)vo.getClueId())) {
            vo.setClueName(this.crmClueInfoService.getInfo(vo.getClueId()).getName());
        }
        if (StringUtils.isNotEmpty((String)vo.getAssociationReport())) {
            RkProjectReportingEntity reporting = this.rkProjectReportingService.getInfo(vo.getAssociationReport());
            vo.setAssociationReportName(reporting.getCustomerName());
        }
        if (entity.getAssociationSaleChance().length() > 0) {
            vo.setAssociationSaleChanceName(this.crmCustomerOpportunityService.getInfo(entity.getAssociationSaleChance()).getDescription());
        }
        List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
        vo.setAttachmentFile(oaAttachmentEntityList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaBeforeSaleSupportInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OaBeforeSaleSupportEntity entity = this.beforeSaleSupportService.getInfo(id);
        OaBeforeSaleSupportInfoVO vo = (OaBeforeSaleSupportInfoVO)JsonUtil.getJsonToBean((Object)entity, OaBeforeSaleSupportInfoVO.class);
        vo.setCustomerType(this.baseDataUtil.getDictName(vo.getCustomerType(), "visitCustomerType"));
        vo.setSupportContent(this.baseDataUtil.getDictName(vo.getSupportContent(), "supprotContent"));
        vo.setSupportType(this.baseDataUtil.getDictName(vo.getSupportType(), "supprotType"));
        vo.setParticipant(this.baseDataUtil.getDictName(vo.getParticipant(), "participant"));
        vo.setCustomerName(this.crmCustomerService.getInfo(vo.getCustomerId()).getName());
        vo.setSupportProductName(this.crmProductService.getInfoByListId(vo.getSupportProductId()).stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
        vo.setApplyPersonName(this.baseDataUtil.userSelectValueNoAccount(vo.getApplyPerson()));
        vo.setApplyPersonDepartmentName(this.baseDataUtil.comSelectValues(vo.getApplyPersonDepartment()));
        vo.setSupportUserid(this.baseDataUtil.userSelectValueNoAccount(vo.getSupportUserid()));
        vo.setCollaborativePerson(this.baseDataUtil.userSelectValueNoAccount(vo.getCollaborativePerson()));
        List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
        vo.setAttachmentFile(oaAttachmentEntityList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaBeforeSaleSupportUpForm beforeSaleSupportUpForm) throws DataException, WorkFlowException {
        String flowEngineId = "514067476582238277";
        UserInfo userInfo = this.userProvider.get();
        OaBeforeSaleSupportEntity entity = this.beforeSaleSupportService.getInfo(id);
        if (entity != null) {
            CrmCustomerEntity crmCustomerEntity;
            OaBeforeSaleSupportEntity subentity = (OaBeforeSaleSupportEntity)JsonUtil.getJsonToBean((Object)((Object)beforeSaleSupportUpForm), OaBeforeSaleSupportEntity.class);
            subentity.setApplyCompanyId(userInfo.getOrganizeId());
            if (StringUtil.isNotEmpty((String)subentity.getSupportProductId())) {
                String productIds = subentity.getSupportProductId();
                if (ObjectUtil.isNotEmpty((Object)productIds.split(","))) {
                    CrmProductCategoryEntity category;
                    String productId = productIds.split(",")[0];
                    productId = productId.replace("[", "");
                    productId = productId.replace("]", "");
                    CrmProductEntity product = this.crmProductService.getInfo(productId = productId.replace("\"", ""));
                    if (ObjectUtil.isNotEmpty((Object)product) && ObjectUtil.isNotEmpty((Object)(category = this.crmProductCategoryService.getInfo(product.getCategoryId())))) {
                        subentity.setProductCompanyId(category.getParentId());
                        beforeSaleSupportUpForm.setProductCompanyId(entity.getProductCompanyId());
                    }
                }
                this.oaAttachmentService.deleteByObjId(subentity.getId());
                if (CollectionUtil.isNotEmpty(beforeSaleSupportUpForm.getAttachmentFile())) {
                    List oaAttachmentEntityList = JsonUtil.getJsonToList(beforeSaleSupportUpForm.getAttachmentFile(), OaAttachmentEntity.class);
                    for (OaAttachmentEntity entitys : oaAttachmentEntityList) {
                        entitys.setId(RandomUtil.uuId());
                        entitys.setObjId(entity.getId());
                        entitys.setFileType(AttachmentTypeEnum.PROJECT_BEFORE_SUPPORT_TYPE.getType());
                        this.oaAttachmentService.save(entitys);
                    }
                }
            }
            if (ObjectUtil.isNotEmpty((Object)(crmCustomerEntity = this.crmCustomerService.getInfo(entity.getCustomerId())))) {
                subentity.setCustomerArea(crmCustomerEntity.getAddress());
                subentity.setCustomerAreaRegional(this.getAreaReaRegional(crmCustomerEntity.getAddress(), userInfo.getOrganizeId()));
                beforeSaleSupportUpForm.setCustomerAreaRegional(subentity.getCustomerAreaRegional());
            }
            this.beforeSaleSupportService.update(id, subentity);
            BeforeSaleSupportListEntity beforeSaleSupportListEntity = (BeforeSaleSupportListEntity)JsonUtil.getJsonToBean((Object)subentity, BeforeSaleSupportListEntity.class);
            this.rkAttachmentService.deleteByObjId(subentity.getId());
            if (CollectionUtil.isNotEmpty(beforeSaleSupportUpForm.getAttachmentFile())) {
                List oaAttachmentEntityList = JsonUtil.getJsonToList(beforeSaleSupportUpForm.getAttachmentFile(), RkAttachmentEntity.class);
                for (RkAttachmentEntity entitys : oaAttachmentEntityList) {
                    entitys.setId(RandomUtil.uuId());
                    entitys.setObjId(entity.getId());
                    entitys.setFileType(AttachmentTypeEnum.PROJECT_BEFORE_SUPPORT_TYPE.getType());
                    this.rkAttachmentService.save((Object)entitys);
                }
            }
            if (beforeSaleSupportUpForm.getStatus() == 0) {
                beforeSaleSupportListEntity.setStatus(SaleNoContractStatusEnum.DRAFT_STATUS.getStatus());
            } else {
                beforeSaleSupportListEntity.setStatus(SaleNoContractStatusEnum.AUDIT_STATUS.getStatus());
            }
            this.beforeSaleSupportListService.updateById((Object)beforeSaleSupportListEntity);
            FlowUtil.saveOrSubmit((String)beforeSaleSupportUpForm.getTaskId(), (String)flowEngineId, (String)beforeSaleSupportUpForm.getTemplateId(), (String)id, (Object)subentity, (Integer)beforeSaleSupportUpForm.getStatus(), (String)this.crmCustomerService.getInfo(beforeSaleSupportUpForm.getCustomerId()).getName());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/verify/{id}"})
    @DSTransactional
    public ActionResult agreeAndReject(@PathVariable(value="id") String id, @RequestBody @Valid OaBeforeSaleSupportUpForm beforeSaleSupportUpForm) throws Exception {
        boolean b;
        UserInfo userInfo = this.userProvider.get();
        if (beforeSaleSupportUpForm != null && (b = this.beforeSaleSupportService.agreeAndReject(beforeSaleSupportUpForm))) {
            return ActionResult.success((String)"\u5ba1\u6838\u6210\u529f");
        }
        return ActionResult.success((String)"\u5df2\u9a73\u56de");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaBeforeSaleSupportEntity entity = this.beforeSaleSupportService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.beforeSaleSupportService.delete(entity);
            this.beforeSaleSupportListService.delete(this.beforeSaleSupportListService.getInfo(id));
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

