/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.erp.entity.ErpMaterialEntity;
import com.bringspring.erp.service.ErpMaterialService;
import com.bringspring.oa.entity.OaBudgetBuyEntity;
import com.bringspring.oa.entity.OaBudgetChangeEntity;
import com.bringspring.oa.entity.OaBuyDetailEntity;
import com.bringspring.oa.entity.OaBuyGoodsEntity;
import com.bringspring.oa.model.oabudgetbuy.OaBudgetBuyCrForm;
import com.bringspring.oa.model.oabudgetbuy.OaBudgetBuyInfoVO;
import com.bringspring.oa.model.oabudgetbuy.OaBudgetBuyListVO;
import com.bringspring.oa.model.oabudgetbuy.OaBudgetBuyPagination;
import com.bringspring.oa.model.oabudgetbuy.OaBudgetBuyPaginationExportModel;
import com.bringspring.oa.model.oabudgetbuy.OaBudgetBuyUpForm;
import com.bringspring.oa.model.oabudgetbuy.OaBudgetChangeModel;
import com.bringspring.oa.service.OaBudgetBuyService;
import com.bringspring.oa.service.OaBudgetChangeService;
import com.bringspring.oa.service.OaBuyDetailService;
import com.bringspring.oa.service.OaBuyGoodsService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7ba1\u7406\u9884\u7b97\u91c7\u8d2d"}, value="oa")
@RequestMapping(value={"/api/oa/OaBudgetBuy"})
public class OaBudgetBuyController {
    private static final Logger log = LoggerFactory.getLogger(OaBudgetBuyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaBudgetBuyService oabudgetbuyService;
    @Autowired
    private OaBudgetChangeService oaBudgetChangeService;
    @Autowired
    private OaBuyDetailService oaBuyDetailService;
    @Autowired
    private OaBuyGoodsService oaBuyGoodsService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private ErpMaterialService erpMaterialService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaBudgetBuyPagination oabudgetbuyPagination) throws IOException {
        List<OaBudgetBuyEntity> list = this.oabudgetbuyService.getList(oabudgetbuyPagination);
        for (OaBudgetBuyEntity oaBudgetBuyEntity : list) {
            oaBudgetBuyEntity.setSealType(this.baseDataUtil.getDictName(oaBudgetBuyEntity.getSealType(), "502747994043452933"));
            oaBudgetBuyEntity.setApplyUploads(this.baseDataUtil.getFileNameInJson(oaBudgetBuyEntity.getApplyUploads()));
            oaBudgetBuyEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaBudgetBuyEntity.getCreatorUserId()));
            oaBudgetBuyEntity.setDeptId(this.baseDataUtil.comSelectValue(oaBudgetBuyEntity.getDeptId(), "last"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaBudgetBuyListVO.class);
        for (OaBudgetBuyListVO oabudgetbuyVO : listVO) {
            oabudgetbuyVO.setCompanyId(this.baseDataUtil.comSelectValue(oabudgetbuyVO.getCompanyId(), "last"));
        }
        for (OaBudgetBuyListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oabudgetbuyPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaBudgetBuyCrForm oabudgetbuyCrForm = (OaBudgetBuyCrForm)((Object)JsonUtil.getJsonToBean(crData, OaBudgetBuyCrForm.class));
        String flowEngineId = "509715938258459653";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oabudgetbuyCrForm.setCreatorUserId(userInfo.getUserId());
        oabudgetbuyCrForm.setCreatorTime(DateUtil.getNow());
        oabudgetbuyCrForm.setDeptId(StringUtils.isEmpty((String)userInfo.getDepartmentId()) ? userInfo.getOrganizeId() : userInfo.getDepartmentId());
        OaBudgetBuyEntity entity = (OaBudgetBuyEntity)JsonUtil.getJsonToBean((Object)((Object)oabudgetbuyCrForm), OaBudgetBuyEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        this.oabudgetbuyService.save(entity);
        List OaBudgetChangeList = JsonUtil.getJsonToList(oabudgetbuyCrForm.getOaBudgetChangeList(), OaBudgetChangeEntity.class);
        for (OaBudgetChangeEntity entitys : OaBudgetChangeList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setParentId(entity.getId());
            this.oaBudgetChangeService.save(entitys);
        }
        List<OaBuyDetailEntity> OaBuyDetailList = oabudgetbuyCrForm.getOaBuyDetailList();
        if (CollectionUtil.isNotEmpty(OaBuyDetailList)) {
            boolean assetsHave = OaBuyDetailList.stream().noneMatch(a -> a.getBudgetType().equals("Z"));
            boolean feeHave = OaBuyDetailList.stream().noneMatch(a -> a.getBudgetType().equals("F"));
            boolean outStandard = OaBuyDetailList.stream().noneMatch(a -> a.getAssetsExceed().equals("0"));
            List type = CollectionUtil.list((boolean)false);
            if (!assetsHave) {
                type.add("Z");
            }
            if (!feeHave) {
                type.add("F");
            }
            entity.setApplyType(JsonUtil.getObjectToString((Object)type));
            entity.setOutStandard(outStandard ? "S" : "F");
        }
        for (OaBuyDetailEntity entitys : OaBuyDetailList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setParentId(entity.getId());
            this.oaBuyDetailService.save(entitys);
        }
        List<OaBuyGoodsEntity> OaBuyGoodsList = oabudgetbuyCrForm.getOaBuyGoodsList();
        for (OaBuyGoodsEntity entitys : OaBuyGoodsList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setParentId(entity.getId());
            this.oaBuyGoodsService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)oabudgetbuyCrForm.getTaskId(), (String)flowEngineId, (String)oabudgetbuyCrForm.getTemplateId(), (String)mainId, (Object)((Object)oabudgetbuyCrForm), (Integer)oabudgetbuyCrForm.getStatus(), (String)oabudgetbuyCrForm.getApplyTitle());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaBudgetBuyPaginationExportModel oabudgetbuyPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oabudgetbuyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaBudgetBuyPagination oabudgetbuyPagination = (OaBudgetBuyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oabudgetbuyPaginationExportModel), OaBudgetBuyPagination.class));
        List<OaBudgetBuyEntity> list = this.oabudgetbuyService.getTypeList(oabudgetbuyPagination, oabudgetbuyPaginationExportModel.getDataType());
        for (OaBudgetBuyEntity oaBudgetBuyEntity : list) {
            oaBudgetBuyEntity.setSealType(this.baseDataUtil.getDictName(oaBudgetBuyEntity.getSealType(), "502747994043452933"));
            oaBudgetBuyEntity.setApplyUploads(this.baseDataUtil.getFileNameInJson(oaBudgetBuyEntity.getApplyUploads()));
            oaBudgetBuyEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaBudgetBuyEntity.getCreatorUserId()));
            oaBudgetBuyEntity.setDeptId(this.baseDataUtil.comSelectValue(oaBudgetBuyEntity.getDeptId(), "last"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaBudgetBuyListVO.class);
        for (OaBudgetBuyListVO oabudgetbuyVO : listVO) {
            String applyType = oabudgetbuyVO.getApplyType();
            if (StrUtil.isNotEmpty((CharSequence)applyType)) {
                List applyTypeStr = CollectionUtil.list((boolean)false);
                List types = JsonUtil.getJsonToList((String)applyType, String.class);
                for (String type : types) {
                    if (type.equals("Z")) {
                        applyTypeStr.add("\u8d44\u4ea7");
                        continue;
                    }
                    if (!type.equals("F")) continue;
                    applyTypeStr.add("\u8d39\u7528");
                }
                if (CollectionUtil.isNotEmpty((Collection)applyTypeStr)) {
                    oabudgetbuyVO.setApplyType(applyTypeStr.stream().collect(Collectors.joining(",")));
                }
            }
            oabudgetbuyVO.setApplyBuySelf("1".equals(oabudgetbuyVO.getApplyBuySelf()) ? "\u7533\u8bf7\u90e8\u95e8" : "\u5546\u52a1\u90e8");
            oabudgetbuyVO.setIsSignContract("1".equals(oabudgetbuyVO.getIsSignContract()) ? "\u662f" : "\u5426");
            oabudgetbuyVO.setIsConsumables("1".equals(oabudgetbuyVO.getIsConsumables()) ? "\u662f" : "\u5426");
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oabudgetbuyPaginationExportModel.getSelectKey()) ? oabudgetbuyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block36: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "applyTitle": {
                        entitys.add(new ExcelExportEntity("\u4e3b\u9898", (Object)"applyTitle"));
                        continue block36;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block36;
                    }
                    case "isSignContract": {
                        entitys.add(new ExcelExportEntity("\u6709\u65e0\u5408\u540c", (Object)"isSignContract"));
                        continue block36;
                    }
                    case "applyBuySelf": {
                        entitys.add(new ExcelExportEntity("\u7b7e\u8ba2\u5408\u540c\u90e8\u95e8", (Object)"applyBuySelf"));
                        continue block36;
                    }
                    case "isConsumables": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4e3a\u4f4e\u503c\u6613\u8017\u54c1", (Object)"isConsumables"));
                        continue block36;
                    }
                    case "sealType": {
                        entitys.add(new ExcelExportEntity("\u76d6\u7ae0\u7c7b\u578b", (Object)"sealType"));
                        continue block36;
                    }
                    case "applyType": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u7c7b\u578b", (Object)"applyType"));
                        continue block36;
                    }
                    case "applyUploads": {
                        entitys.add(new ExcelExportEntity("\u9644\u4ef6", (Object)"applyUploads"));
                        continue block36;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"creatorUserId"));
                        continue block36;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65e5\u671f", (Object)"creatorTime"));
                        continue block36;
                    }
                    case "deptId": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u90e8\u95e8", (Object)"deptId"));
                        continue block36;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block36;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaBudgetBuyInfoVO> info(@PathVariable(value="id") String id) {
        OaBudgetBuyEntity entity = this.oabudgetbuyService.getInfo(id);
        OaBudgetBuyInfoVO vo = (OaBudgetBuyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaBudgetBuyInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setCgyName(this.baseDataUtil.userSelectValue(vo.getCgy()));
        vo.setSealTypeName(this.baseDataUtil.getDictName(vo.getSealType(), "sealCertificatesType"));
        vo.setPaymentMethodTypeName(this.baseDataUtil.getDictName(vo.getPaymentMethodType(), "procurePayment"));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setDeptId(this.baseDataUtil.comSelectValue(vo.getDeptId(), "last"));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        List<OaBudgetChangeEntity> OaBudgetChangeList = this.oabudgetbuyService.GetOaBudgetChangeList(id);
        for (OaBudgetChangeEntity oaBudgetChangeEntity : OaBudgetChangeList) {
        }
        vo.setOaBudgetChangeList(JsonUtil.getJsonToList(OaBudgetChangeList, OaBudgetChangeModel.class));
        List<OaBuyDetailEntity> oaBuyDetailList = this.oabudgetbuyService.GetOaBuyDetailList(id);
        if (CollectionUtil.isNotEmpty(oaBuyDetailList)) {
            vo.setOaBuyDetailList(oaBuyDetailList);
        } else {
            List emptyDetail = CollectionUtil.list((boolean)false);
            vo.setOaBuyDetailList(emptyDetail);
        }
        List<OaBuyGoodsEntity> OaBuyGoodsList = this.oabudgetbuyService.GetOaBuyGoodsList(id);
        if (CollectionUtil.isNotEmpty(OaBuyGoodsList)) {
            for (OaBuyGoodsEntity oaBuyGoodsEntity : OaBuyGoodsList) {
                ErpMaterialEntity e;
                if (!StrUtil.isNotEmpty((CharSequence)oaBuyGoodsEntity.getMaterialCode()) || !ObjectUtil.isNotEmpty((Object)(e = this.erpMaterialService.getCodeInfo(oaBuyGoodsEntity.getMaterialCode())))) continue;
                oaBuyGoodsEntity.setMaterialName(e.getFullName());
            }
            vo.setOaBuyGoodsList(OaBuyGoodsList);
        } else {
            List list = CollectionUtil.list((boolean)false);
            vo.setOaBuyGoodsList(list);
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaBudgetBuyUpForm oabudgetbuyUpForm = (OaBudgetBuyUpForm)((Object)JsonUtil.getJsonToBean(upData, OaBudgetBuyUpForm.class));
        String flowEngineId = "509715938258459653";
        UserInfo userInfo = this.userProvider.get();
        OaBudgetBuyEntity entity = this.oabudgetbuyService.getInfo(id);
        if (entity != null) {
            oabudgetbuyUpForm.setDeptId(entity.getDeptId());
            oabudgetbuyUpForm.setLastModifyTime(DateUtil.getNow());
            OaBudgetBuyEntity subentity = (OaBudgetBuyEntity)JsonUtil.getJsonToBean((Object)((Object)oabudgetbuyUpForm), OaBudgetBuyEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            List OaBuyDetailList = JsonUtil.getJsonToList(oabudgetbuyUpForm.getOaBuyDetailList(), OaBuyDetailEntity.class);
            if (CollectionUtil.isNotEmpty((Collection)OaBuyDetailList)) {
                boolean assetsHave = OaBuyDetailList.stream().noneMatch(a -> a.getBudgetType().equals("Z"));
                boolean feeHave = OaBuyDetailList.stream().noneMatch(a -> a.getBudgetType().equals("F"));
                boolean outStandard = OaBuyDetailList.stream().noneMatch(a -> a.getAssetsExceed().equals("0"));
                List type = CollectionUtil.list((boolean)false);
                if (!assetsHave) {
                    type.add("Z");
                }
                if (!feeHave) {
                    type.add("F");
                }
                subentity.setApplyType(JsonUtil.getObjectToString((Object)type));
                subentity.setOutStandard(outStandard ? "S" : "F");
            }
            this.oabudgetbuyService.update(id, subentity);
            QueryWrapper OaBudgetChangequeryWrapper = new QueryWrapper();
            OaBudgetChangequeryWrapper.lambda().eq(OaBudgetChangeEntity::getParentId, (Object)entity.getId());
            this.oaBudgetChangeService.remove((Wrapper)OaBudgetChangequeryWrapper);
            List OaBudgetChangeList = JsonUtil.getJsonToList(oabudgetbuyUpForm.getOaBudgetChangeList(), OaBudgetChangeEntity.class);
            for (Object entitys : OaBudgetChangeList) {
                ((OaBudgetChangeEntity)entitys).setId(RandomUtil.uuId());
                ((OaBudgetChangeEntity)entitys).setParentId(entity.getId());
                this.oaBudgetChangeService.save(entitys);
            }
            QueryWrapper OaBuyDetailqueryWrapper = new QueryWrapper();
            OaBuyDetailqueryWrapper.lambda().eq(OaBuyDetailEntity::getParentId, (Object)entity.getId());
            this.oaBuyDetailService.remove((Wrapper)OaBuyDetailqueryWrapper);
            for (OaBuyDetailEntity entitys : OaBuyDetailList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setParentId(entity.getId());
                this.oaBuyDetailService.save(entitys);
            }
            QueryWrapper OaBuyGoodsqueryWrapper = new QueryWrapper();
            OaBuyGoodsqueryWrapper.lambda().eq(OaBuyGoodsEntity::getParentId, (Object)entity.getId());
            this.oaBuyGoodsService.remove((Wrapper)OaBuyGoodsqueryWrapper);
            List OaBuyGoodsList = JsonUtil.getJsonToList(oabudgetbuyUpForm.getOaBuyGoodsList(), OaBuyGoodsEntity.class);
            for (OaBuyGoodsEntity entitys : OaBuyGoodsList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setParentId(entity.getId());
                this.oaBuyGoodsService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)oabudgetbuyUpForm.getTaskId(), (String)flowEngineId, (String)oabudgetbuyUpForm.getTemplateId(), (String)id, (Object)((Object)oabudgetbuyUpForm), (Integer)oabudgetbuyUpForm.getStatus(), (String)oabudgetbuyUpForm.getApplyTitle());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaBudgetBuyEntity entity = this.oabudgetbuyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oabudgetbuyService.delete(entity);
            QueryWrapper queryWrapperOaBudgetChange = new QueryWrapper();
            queryWrapperOaBudgetChange.lambda().eq(OaBudgetChangeEntity::getParentId, (Object)entity.getId());
            this.oaBudgetChangeService.remove((Wrapper)queryWrapperOaBudgetChange);
            QueryWrapper queryWrapperOaBuyDetail = new QueryWrapper();
            queryWrapperOaBuyDetail.lambda().eq(OaBuyDetailEntity::getParentId, (Object)entity.getId());
            this.oaBuyDetailService.remove((Wrapper)queryWrapperOaBuyDetail);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

