/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.PurchaseGoodsListEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkMaterialEntity;
import com.bringspring.contract.entity.RkPurchaseApplyListEntity;
import com.bringspring.contract.model.rkpurchaseapply.RkPurchaseApplyListPagination;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkMaterialService;
import com.bringspring.contract.service.RkPurchaseApplyListService;
import com.bringspring.oa.entity.OaBudgetBuyEntity;
import com.bringspring.oa.entity.OaBuyDetailEntity;
import com.bringspring.oa.entity.OaBuyGoodsEntity;
import com.bringspring.oa.model.oabuydetail.OaBuyDetailCrForm;
import com.bringspring.oa.model.oabuydetail.OaBuyDetailInfoVO;
import com.bringspring.oa.model.oabuydetail.OaBuyDetailListVO;
import com.bringspring.oa.model.oabuydetail.OaBuyDetailPagination;
import com.bringspring.oa.model.oabuydetail.OaBuyDetailPaginationExportModel;
import com.bringspring.oa.model.oabuydetail.OaBuyDetailUpForm;
import com.bringspring.oa.service.OaBudgetBuyService;
import com.bringspring.oa.service.OaBuyDetailService;
import com.bringspring.oa.service.OaBuyGoodsService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d44\u4ea7\u8d39\u7528\u5f85\u91c7"}, value="oa")
@RequestMapping(value={"/api/oa/OaBuyDetail"})
public class OaBuyDetailController {
    private static final Logger log = LoggerFactory.getLogger(OaBuyDetailController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaBuyDetailService oaBuyDetailService;
    @Autowired
    private OaBuyGoodsService oaBuyGoodsService;
    @Autowired
    private RkMaterialService rkMaterialService;
    @Autowired
    private OaBudgetBuyService oaBudgetBuyService;
    @Autowired
    private RkPurchaseApplyListService rkPurchaseApplyListService;
    @Autowired
    private RkContractProcureService rkContractProcureService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaBuyDetailPagination oaBuyDetailPagination) throws IOException {
        List<OaBuyDetailEntity> list = this.oaBuyDetailService.getList(oaBuyDetailPagination);
        for (OaBuyDetailEntity oaBuyDetailEntity : list) {
            oaBuyDetailEntity.setBuyer(this.baseDataUtil.userSelectValues(oaBuyDetailEntity.getBuyer()));
            oaBuyDetailEntity.setAssetsLevel(this.baseDataUtil.getDictName(oaBuyDetailEntity.getAssetsLevel(), "assetsLevelOptions"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaBuyDetailListVO.class);
        for (OaBuyDetailListVO oaBuyDetailListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaBuyDetailPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getGoodsList"})
    public ActionResult getGoodsList(@RequestBody OaBuyDetailPagination oaBuyDetailPagination) throws IOException {
        List<OaBuyGoodsEntity> list = this.oaBuyGoodsService.getList(oaBuyDetailPagination);
        for (OaBuyGoodsEntity oaBuyGoodsEntity : list) {
            OaBuyDetailEntity oaBuyDetailEntity = this.oaBuyDetailService.getInfo(oaBuyGoodsEntity.getDetailId());
            if (!ObjectUtil.isNotEmpty((Object)oaBuyDetailEntity)) continue;
            oaBuyGoodsEntity.setAssetsLevel(this.baseDataUtil.getDictName(oaBuyDetailEntity.getAssetsLevel(), "assetsLevelOptions"));
            oaBuyGoodsEntity.setAssetsRemarks(oaBuyDetailEntity.getAssetsRemarks());
            oaBuyGoodsEntity.setModel(oaBuyDetailEntity.getModel());
            oaBuyGoodsEntity.setDetail(oaBuyDetailEntity.getDetail());
        }
        List listVO = JsonUtil.getJsonToList(list, OaBuyDetailListVO.class);
        for (OaBuyDetailListVO oaBuyDetailVO : listVO) {
            OaBudgetBuyEntity parentVo = this.oaBudgetBuyService.getInfo(oaBuyDetailVO.getParentId());
            oaBuyDetailVO.setCreatorUserId(this.baseDataUtil.userSelectValue(parentVo.getCreatorUserId()));
            oaBuyDetailVO.setCreatorDeptId(this.baseDataUtil.comSelectValue(parentVo.getDeptId(), "last"));
            String taxRate = oaBuyDetailVO.getTaxRate();
            oaBuyDetailVO.setTaxRate(this.baseDataUtil.getDictName(taxRate, "contractRate"));
            oaBuyDetailVO.setTaxRate(StrUtil.isEmpty((CharSequence)oaBuyDetailVO.getTaxRate()) ? taxRate : oaBuyDetailVO.getTaxRate());
            oaBuyDetailVO.setBuyer(parentVo.getCgyName());
            oaBuyDetailVO.setApplyStatus(parentVo.getEnabledMark().toString());
            RkPurchaseApplyListPagination rkPurchaseApplyListPagination = new RkPurchaseApplyListPagination();
            rkPurchaseApplyListPagination.setParentId(oaBuyDetailVO.getParentId());
            rkPurchaseApplyListPagination.setMaterialCode(oaBuyDetailVO.getMaterialCode());
            List purchaseList = this.rkPurchaseApplyListService.getListForAssets(rkPurchaseApplyListPagination);
            if (!CollectionUtil.isNotEmpty((Collection)purchaseList)) continue;
            oaBuyDetailVO.setProcureCode(((RkPurchaseApplyListEntity)purchaseList.get(0)).getHtCode());
            RkContractProcureEntity rkContractProcureEntity = this.rkContractProcureService.getInfo(((RkPurchaseApplyListEntity)purchaseList.get(0)).getHtId());
            if (!ObjectUtil.isNotEmpty((Object)rkContractProcureEntity)) continue;
            oaBuyDetailVO.setProcureStatus(rkContractProcureEntity.getEnableMark());
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaBuyDetailPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaBuyDetailCrForm oaBuyDetailCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OaBuyDetailEntity entity = (OaBuyDetailEntity)JsonUtil.getJsonToBean((Object)oaBuyDetailCrForm, OaBuyDetailEntity.class);
        entity.setId(mainId);
        this.oaBuyDetailService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaBuyDetailPaginationExportModel oaBuyDetailPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaBuyDetailPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaBuyDetailPagination oaBuyDetailPagination = (OaBuyDetailPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaBuyDetailPaginationExportModel), OaBuyDetailPagination.class));
        List<OaBuyDetailEntity> list = this.oaBuyDetailService.getTypeList(oaBuyDetailPagination, oaBuyDetailPaginationExportModel.getDataType());
        for (OaBuyDetailEntity oaBuyDetailEntity : list) {
            oaBuyDetailEntity.setBuyer(this.baseDataUtil.userSelectValues(oaBuyDetailEntity.getBuyer()));
            oaBuyDetailEntity.setAssetsLevel(this.baseDataUtil.getDictName(oaBuyDetailEntity.getAssetsLevel(), "assetsLevelOptions"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaBuyDetailListVO.class);
        for (OaBuyDetailListVO oaBuyDetailListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaBuyDetailPaginationExportModel.getSelectKey()) ? oaBuyDetailPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block74: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block74;
                    }
                    case "parentId": {
                        entitys.add(new ExcelExportEntity("\u5916\u952e", (Object)"parentId"));
                        continue block74;
                    }
                    case "budgetId": {
                        entitys.add(new ExcelExportEntity("\u9884\u7b97id", (Object)"budgetId"));
                        continue block74;
                    }
                    case "buyName": {
                        entitys.add(new ExcelExportEntity("\u540d\u79f0", (Object)"buyName"));
                        continue block74;
                    }
                    case "buyBrand": {
                        entitys.add(new ExcelExportEntity("\u54c1\u724c", (Object)"buyBrand"));
                        continue block74;
                    }
                    case "materialCode": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u7f16\u7801", (Object)"materialCode"));
                        continue block74;
                    }
                    case "materialId": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599id", (Object)"materialId"));
                        continue block74;
                    }
                    case "buyCount": {
                        entitys.add(new ExcelExportEntity("\u6570\u91cf", (Object)"buyCount"));
                        continue block74;
                    }
                    case "buyPrice": {
                        entitys.add(new ExcelExportEntity("\u5355\u4ef7", (Object)"buyPrice"));
                        continue block74;
                    }
                    case "contacts": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba", (Object)"contacts"));
                        continue block74;
                    }
                    case "contactsTel": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u7535\u8bdd", (Object)"contactsTel"));
                        continue block74;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u540d\u79f0", (Object)"supplierName"));
                        continue block74;
                    }
                    case "supplierContacts": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba", (Object)"supplierContacts"));
                        continue block74;
                    }
                    case "supplierTel": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u8054\u7cfb\u7535\u8bdd", (Object)"supplierTel"));
                        continue block74;
                    }
                    case "taxRate": {
                        entitys.add(new ExcelExportEntity("\u7a0e\u7387", (Object)"taxRate"));
                        continue block74;
                    }
                    case "buyer": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5458", (Object)"buyer"));
                        continue block74;
                    }
                    case "assetsRemarks": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u4e13\u5458\u5907\u6ce8", (Object)"assetsRemarks"));
                        continue block74;
                    }
                    case "assetsLevel": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u7533\u8bf7\u6807\u51c6", (Object)"assetsLevel"));
                        continue block74;
                    }
                    case "assetsHave": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u6709\u65e0\u5e93\u5b58", (Object)"assetsHave"));
                        continue block74;
                    }
                    case "contractId": {
                        entitys.add(new ExcelExportEntity("\u7b7e\u5408\u540cid", (Object)"contractId"));
                        continue block74;
                    }
                    case "assetsExceed": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u8d85\u6807", (Object)"assetsExceed"));
                        continue block74;
                    }
                    case "contractState": {
                        entitys.add(new ExcelExportEntity("\u7b7e\u5408\u540c\u72b6\u6001", (Object)"contractState"));
                        continue block74;
                    }
                    case "budgetHave": {
                        entitys.add(new ExcelExportEntity("\u6709\u65e0\u9884\u7b97", (Object)"budgetHave"));
                        continue block74;
                    }
                    case "budgetDescription": {
                        entitys.add(new ExcelExportEntity("\u9884\u7b97\u63cf\u8ff0", (Object)"budgetDescription"));
                        continue block74;
                    }
                    case "budgetMount": {
                        entitys.add(new ExcelExportEntity("\u9884\u7b97\u91d1\u989d", (Object)"budgetMount"));
                        continue block74;
                    }
                    case "budgetSupplier": {
                        entitys.add(new ExcelExportEntity("\u9884\u7b97\u4f9b\u5e94\u5546", (Object)"budgetSupplier"));
                        continue block74;
                    }
                    case "budgetType": {
                        entitys.add(new ExcelExportEntity("\u9884\u7b97\u7c7b\u578b", (Object)"budgetType"));
                        continue block74;
                    }
                    case "addBudgetMount": {
                        entitys.add(new ExcelExportEntity("\u65b0\u589e\u9884\u7b97\u91d1\u989d", (Object)"addBudgetMount"));
                        continue block74;
                    }
                    case "addBudgetDescription": {
                        entitys.add(new ExcelExportEntity("\u65b0\u589e\u9884\u7b97\u63cf\u8ff0", (Object)"addBudgetDescription"));
                        continue block74;
                    }
                    case "addBudgetSupplier": {
                        entitys.add(new ExcelExportEntity("\u65b0\u589e\u9884\u7b97\u4f9b\u5e94\u5546", (Object)"addBudgetSupplier"));
                        continue block74;
                    }
                    case "addBudgetType": {
                        entitys.add(new ExcelExportEntity("\u65b0\u589e\u9884\u7b97\u7c7b\u578b", (Object)"addBudgetType"));
                        continue block74;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaBuyDetailInfoVO> info(@PathVariable(value="id") String id) {
        OaBuyDetailEntity entity = this.oaBuyDetailService.getInfo(id);
        OaBuyDetailInfoVO vo = (OaBuyDetailInfoVO)JsonUtil.getJsonToBean((Object)entity, OaBuyDetailInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/infoGoods/{id}"})
    public ActionResult<OaBuyDetailInfoVO> infoGoods(@PathVariable(value="id") String id) {
        OaBuyGoodsEntity entity = (OaBuyGoodsEntity)this.oaBuyGoodsService.getById((Serializable)((Object)id));
        OaBuyDetailInfoVO vo = (OaBuyDetailInfoVO)JsonUtil.getJsonToBean((Object)entity, OaBuyDetailInfoVO.class);
        OaBudgetBuyEntity parentVo = this.oaBudgetBuyService.getInfo(vo.getParentId());
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(parentVo.getCreatorUserId()));
        vo.setCreatorDeptId(this.baseDataUtil.comSelectValue(parentVo.getDeptId(), "last"));
        String taxRate = vo.getTaxRate();
        vo.setTaxRate(this.baseDataUtil.getDictName(taxRate, "contractRate"));
        vo.setTaxRate(StrUtil.isEmpty((CharSequence)vo.getTaxRate()) ? taxRate : vo.getTaxRate());
        vo.setBuyer(parentVo.getCgyName());
        vo.setApplyStatus(parentVo.getEnabledMark().toString());
        RkPurchaseApplyListPagination rkPurchaseApplyListPagination = new RkPurchaseApplyListPagination();
        rkPurchaseApplyListPagination.setParentId(vo.getParentId());
        rkPurchaseApplyListPagination.setMaterialCode(vo.getMaterialCode());
        List purchaseList = this.rkPurchaseApplyListService.getListForAssets(rkPurchaseApplyListPagination);
        if (CollectionUtil.isNotEmpty((Collection)purchaseList)) {
            vo.setProcureCode(((RkPurchaseApplyListEntity)purchaseList.get(0)).getHtCode());
            RkContractProcureEntity rkContractProcureEntity = this.rkContractProcureService.getInfo(((RkPurchaseApplyListEntity)purchaseList.get(0)).getHtId());
            if (ObjectUtil.isNotEmpty((Object)rkContractProcureEntity)) {
                vo.setProcureStatus(rkContractProcureEntity.getEnableMark());
                vo.setProcureAmount(rkContractProcureEntity.getProcureAmount().toString());
                vo.setProcureSupplierName(rkContractProcureEntity.getSupplierName());
                vo.setProcureTime(DateUtil.format((Date)rkContractProcureEntity.getCreatorTime(), (String)"YYYY-MM-DD"));
                vo.setProcureName(rkContractProcureEntity.getProcureName());
            }
        }
        vo.setAssetsLevel(this.baseDataUtil.getDictName(vo.getAssetsLevel(), "assetsLevelOptions"));
        vo.setBandName(parentVo.getBandName());
        vo.setJobName(parentVo.getJobType());
        vo.setCreatorTime(DateUtil.format((Date)parentVo.getCreatorTime(), (String)"YYYY-MM-DD"));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaBuyDetailInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OaBuyDetailEntity entity = this.oaBuyDetailService.getInfo(id);
        OaBuyDetailInfoVO vo = (OaBuyDetailInfoVO)JsonUtil.getJsonToBean((Object)entity, OaBuyDetailInfoVO.class);
        vo.setBuyer(this.baseDataUtil.userSelectValues(vo.getBuyer()));
        vo.setAssetsLevel(this.baseDataUtil.getDictName(vo.getAssetsLevel(), "assetsLevelOptions"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaBuyDetailUpForm oaBuyDetailUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OaBuyDetailEntity entity = this.oaBuyDetailService.getInfo(id);
        if (entity != null) {
            OaBuyDetailEntity subentity = (OaBuyDetailEntity)JsonUtil.getJsonToBean((Object)oaBuyDetailUpForm, OaBuyDetailEntity.class);
            this.oaBuyDetailService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaBuyDetailEntity entity = this.oaBuyDetailService.getInfo(id);
        if (entity != null) {
            this.oaBuyDetailService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/createMaterial/{id}"})
    public ActionResult createMaterial(@PathVariable(value="id") String id, @RequestBody @Valid OaBuyDetailUpForm oaBuyDetailUpForm) throws DataException {
        RkMaterialEntity rkMaterialEntity = (RkMaterialEntity)JsonUtil.getJsonToBean((Object)oaBuyDetailUpForm, RkMaterialEntity.class);
        String mainId = RandomUtil.uuId();
        rkMaterialEntity.setId(mainId);
        this.rkMaterialService.create(rkMaterialEntity);
        UserInfo userInfo = this.userProvider.get();
        OaBuyDetailEntity entity = this.oaBuyDetailService.getInfo(id);
        if (entity != null) {
            OaBuyDetailEntity subentity = (OaBuyDetailEntity)JsonUtil.getJsonToBean((Object)oaBuyDetailUpForm, OaBuyDetailEntity.class);
            subentity.setMaterialId(mainId);
            this.oaBuyDetailService.update(id, subentity);
            oaBuyDetailUpForm.setMaterialId(mainId);
            this.insertGoods(oaBuyDetailUpForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/relationMaterial/{applyId}/{id}"})
    public ActionResult relationMaterial(@PathVariable(value="applyId") String applyId, @PathVariable(value="id") String id) {
        RkMaterialEntity rkMaterialEntity = this.rkMaterialService.getInfo(id);
        OaBuyDetailEntity entity = this.oaBuyDetailService.getInfo(applyId);
        if (entity != null) {
            entity.setMaterialId(id);
            entity.setMaterialCode(rkMaterialEntity.getMaterialCode());
            this.oaBuyDetailService.update(applyId, entity);
            OaBuyDetailUpForm oaBuyDetailUpForm = (OaBuyDetailUpForm)JsonUtil.getJsonToBean((Object)entity, OaBuyDetailUpForm.class);
            this.insertGoods(oaBuyDetailUpForm);
            return ActionResult.success((String)"\u5173\u8054\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    private boolean insertGoods(OaBuyDetailUpForm oaBuyDetailUpForm) {
        PurchaseGoodsListEntity purchaseGoodsListEntity = (PurchaseGoodsListEntity)JsonUtil.getJsonToBean((Object)oaBuyDetailUpForm, PurchaseGoodsListEntity.class);
        purchaseGoodsListEntity.setMaterialCode(purchaseGoodsListEntity.getMaterialCode());
        purchaseGoodsListEntity.setMaterialId(purchaseGoodsListEntity.getMaterialId());
        purchaseGoodsListEntity.setMaterialName(purchaseGoodsListEntity.getMaterialName());
        purchaseGoodsListEntity.setMaterialType(purchaseGoodsListEntity.getMaterialType());
        purchaseGoodsListEntity.setMaterialBrand(purchaseGoodsListEntity.getMaterialBrand());
        return true;
    }
}

