/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.erp.entity.ErpMaterialEntity;
import com.bringspring.erp.service.ErpMaterialService;
import com.bringspring.oa.entity.OaConsumingApplyEntity;
import com.bringspring.oa.entity.OaConsumingDetailEntity;
import com.bringspring.oa.model.oaConsumingApply.OaConsumingApplyCrForm;
import com.bringspring.oa.model.oaConsumingApply.OaConsumingApplyInfoVO;
import com.bringspring.oa.model.oaConsumingApply.OaConsumingApplyListVO;
import com.bringspring.oa.model.oaConsumingApply.OaConsumingApplyPagination;
import com.bringspring.oa.model.oaConsumingApply.OaConsumingApplyPaginationExportModel;
import com.bringspring.oa.model.oaConsumingApply.OaConsumingApplyUpForm;
import com.bringspring.oa.model.oaConsumingApply.OaConsumingDetailModel;
import com.bringspring.oa.service.OaConsumingApplyService;
import com.bringspring.oa.service.OaConsumingDetailService;
import com.bringspring.purchase.model.oaPurchasePlan.OaPurchasePlanUpCountVO;
import com.bringspring.purchase.service.OaPurchasePlanService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9886\u7528\u7533\u8bf7\u8868 \u4e3b\u8868"}, value="oa")
@RequestMapping(value={"/api/oa/OaConsumingApply"})
public class OaConsumingApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaConsumingApplyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaConsumingApplyService oaConsumingApplyService;
    @Autowired
    private OaConsumingDetailService oaConsumingDetailService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private ErpMaterialService erpMaterialService;
    @Autowired
    private OaPurchasePlanService oaPurchasePlanService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaConsumingApplyPagination oaConsumingApplyPagination) throws IOException {
        List<OaConsumingApplyEntity> list = this.oaConsumingApplyService.getList(oaConsumingApplyPagination);
        for (OaConsumingApplyEntity oaConsumingApplyEntity : list) {
            oaConsumingApplyEntity.setSaleManager(this.baseDataUtil.userSelectValues(oaConsumingApplyEntity.getSaleManager()));
            oaConsumingApplyEntity.setProjectManager(this.baseDataUtil.userSelectValues(oaConsumingApplyEntity.getProjectManager()));
            oaConsumingApplyEntity.setApplyPerson(this.baseDataUtil.userSelectValues(oaConsumingApplyEntity.getApplyPerson()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaConsumingApplyListVO.class);
        for (OaConsumingApplyListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity;
            CrmCustomerEntity customerEntity;
            RkContractProjectEntity projectEntity;
            RkContractEntity rkContractEntity;
            if (!StrUtil.isBlank((CharSequence)vo.getContractId()) && ObjectUtil.isNotEmpty((Object)(rkContractEntity = this.contractService.getInfo(vo.getContractId())))) {
                vo.setContractId(rkContractEntity.getContractName());
            }
            if (!StrUtil.isBlank((CharSequence)vo.getProjectId()) && ObjectUtil.isNotEmpty((Object)(projectEntity = this.rkContractProjectService.getInfo(vo.getProjectId())))) {
                vo.setProjectId(projectEntity.getProjectName());
            }
            if (!StrUtil.isBlank((CharSequence)vo.getCustomerId()) && ObjectUtil.isNotEmpty((Object)(customerEntity = this.crmCustomerService.getInfo(vo.getCustomerId())))) {
                vo.setCustomerId(customerEntity.getName());
            }
            if ((flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus})) != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaConsumingApplyPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaConsumingApplyCrForm oaConsumingApplyCrForm = (OaConsumingApplyCrForm)((Object)JsonUtil.getJsonToBean(crData, OaConsumingApplyCrForm.class));
        String flowEngineId = "577758014920998725";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OaConsumingApplyEntity entity = (OaConsumingApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaConsumingApplyCrForm), OaConsumingApplyEntity.class);
        entity.setId(mainId);
        entity.setEnabledMark(oaConsumingApplyCrForm.getStatus());
        entity.setCompanyId(userInfo.getOrganizeId());
        this.oaConsumingApplyService.save(entity);
        List OaConsumingDetailList = JsonUtil.getJsonToList(oaConsumingApplyCrForm.getOaConsumingDetailList(), OaConsumingDetailEntity.class);
        for (OaConsumingDetailEntity entitys : OaConsumingDetailList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setApplyId(entity.getId());
            this.oaConsumingDetailService.save(entitys);
        }
        if (oaConsumingApplyCrForm.getStatus() == 1) {
            List planList = JsonUtil.getJsonToList((Object)OaConsumingDetailList, OaPurchasePlanUpCountVO.class);
            this.oaPurchasePlanService.updateAppliedCount(planList, "add");
        }
        RkContractProjectEntity projectEntity = this.rkContractProjectService.getInfo(oaConsumingApplyCrForm.getProjectId());
        String title = "";
        if (ObjectUtil.isNotEmpty((Object)projectEntity)) {
            title = projectEntity.getProjectName();
        }
        FlowUtil.saveOrSubmit((String)oaConsumingApplyCrForm.getTaskId(), (String)flowEngineId, (String)oaConsumingApplyCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaConsumingApplyCrForm), (Integer)oaConsumingApplyCrForm.getStatus(), (String)title);
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaConsumingApplyPaginationExportModel oaConsumingApplyPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)oaConsumingApplyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaConsumingApplyPagination oaConsumingApplyPagination = (OaConsumingApplyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaConsumingApplyPaginationExportModel), OaConsumingApplyPagination.class));
        List<OaConsumingApplyEntity> list = this.oaConsumingApplyService.getTypeList(oaConsumingApplyPagination, oaConsumingApplyPaginationExportModel.getDataType());
        for (OaConsumingApplyEntity oaConsumingApplyEntity : list) {
            oaConsumingApplyEntity.setSaleManager(this.baseDataUtil.userSelectValues(oaConsumingApplyEntity.getSaleManager()));
            oaConsumingApplyEntity.setProjectManager(this.baseDataUtil.userSelectValues(oaConsumingApplyEntity.getProjectManager()));
            oaConsumingApplyEntity.setApplyPerson(this.baseDataUtil.userSelectValues(oaConsumingApplyEntity.getApplyPerson()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaConsumingApplyListVO.class);
        for (OaConsumingApplyListVO oaConsumingApplyListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)oaConsumingApplyPaginationExportModel.getSelectKey()) ? oaConsumingApplyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block34: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "contractId": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540cid", (Object)"contractId"));
                        continue block34;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540ccode", (Object)"contractCode"));
                        continue block34;
                    }
                    case "saleManager": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u7ecf\u7406", (Object)"saleManager"));
                        continue block34;
                    }
                    case "contractLevel": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7ea7\u522b", (Object)"contractLevel"));
                        continue block34;
                    }
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237id", (Object)"customerId"));
                        continue block34;
                    }
                    case "projectId": {
                        entitys.add(new ExcelExportEntity("\u9879\u76eeid", (Object)"projectId"));
                        continue block34;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode"));
                        continue block34;
                    }
                    case "projectManager": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"projectManager"));
                        continue block34;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u8bf4\u660e", (Object)"description"));
                        continue block34;
                    }
                    case "applyPerson": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"applyPerson"));
                        continue block34;
                    }
                    case "applyDate": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65f6\u95f4", (Object)"applyDate"));
                        continue block34;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaConsumingApplyInfoVO> info(@PathVariable(value="id") String id) {
        RkContractProjectEntity projectEntity;
        CrmCustomerEntity customerEntity;
        OaConsumingApplyEntity entity = this.oaConsumingApplyService.getInfo(id);
        OaConsumingApplyInfoVO vo = (OaConsumingApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaConsumingApplyInfoVO.class);
        List<OaConsumingDetailEntity> OaConsumingDetailList = this.oaConsumingApplyService.GetOaConsumingDetailList(id);
        List consumingDetailModels = JsonUtil.getJsonToList(OaConsumingDetailList, OaConsumingDetailModel.class);
        for (OaConsumingDetailModel consumingDetailModel : consumingDetailModels) {
            ErpMaterialEntity codeInfo = this.erpMaterialService.getCodeInfo(consumingDetailModel.getMaterialCode());
            if (!ObjectUtil.isNotEmpty((Object)codeInfo)) continue;
            consumingDetailModel.setMaterialName(codeInfo.getFullName());
            consumingDetailModel.setMaterialBrand(codeInfo.getBrand());
            consumingDetailModel.setMaterialModel(codeInfo.getModel());
        }
        vo.setOaConsumingDetailList(consumingDetailModels);
        if (!StrUtil.isBlank((CharSequence)vo.getSaleManager())) {
            vo.setSaleManagerName(this.baseDataUtil.userSelectValue(vo.getSaleManager()));
        }
        if (!StrUtil.isBlank((CharSequence)vo.getCustomerId()) && ObjectUtil.isNotEmpty((Object)(customerEntity = this.crmCustomerService.getInfo(vo.getCustomerId())))) {
            vo.setCustomerId(customerEntity.getName());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getProjectId()) && ObjectUtil.isNotEmpty((Object)(projectEntity = this.rkContractProjectService.getInfo(vo.getProjectId())))) {
            vo.setProjectName(projectEntity.getProjectName());
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaConsumingApplyUpForm oaConsumingApplyUpForm = (OaConsumingApplyUpForm)((Object)JsonUtil.getJsonToBean(upData, OaConsumingApplyUpForm.class));
        String flowEngineId = "577758014920998725";
        OaConsumingApplyEntity entity = this.oaConsumingApplyService.getInfo(id);
        if (entity != null) {
            OaConsumingApplyEntity subentity = (OaConsumingApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaConsumingApplyUpForm), OaConsumingApplyEntity.class);
            subentity.setEnabledMark(oaConsumingApplyUpForm.getStatus());
            this.oaConsumingApplyService.update(id, subentity);
            this.oaConsumingDetailService.deleteListByApplyId(id);
            List OaConsumingDetailList = JsonUtil.getJsonToList(oaConsumingApplyUpForm.getOaConsumingDetailList(), OaConsumingDetailEntity.class);
            for (OaConsumingDetailEntity entitys : OaConsumingDetailList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setApplyId(entity.getId());
                this.oaConsumingDetailService.save(entitys);
            }
            if (oaConsumingApplyUpForm.getStatus() == 1) {
                List planList = JsonUtil.getJsonToList((Object)OaConsumingDetailList, OaPurchasePlanUpCountVO.class);
                this.oaPurchasePlanService.updateAppliedCount(planList, "add");
            }
            RkContractProjectEntity projectEntity = this.rkContractProjectService.getInfo(oaConsumingApplyUpForm.getProjectId());
            String title = "";
            if (ObjectUtil.isNotEmpty((Object)projectEntity)) {
                title = projectEntity.getProjectName();
            }
            FlowUtil.saveOrSubmit((String)oaConsumingApplyUpForm.getTaskId(), (String)flowEngineId, (String)oaConsumingApplyUpForm.getTemplateId(), (String)id, (Object)((Object)oaConsumingApplyUpForm), (Integer)oaConsumingApplyUpForm.getStatus(), (String)title);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaConsumingApplyEntity entity = this.oaConsumingApplyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaConsumingApplyService.delete(entity);
            this.oaConsumingDetailService.deleteListByApplyId(id);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

