/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.contract.model.rkcontractproduct.RkContractProductListVO;
import com.bringspring.crm.model.crmproductversion.CrmProductVersionListVO;
import com.bringspring.crm.service.CrmProductVersionService;
import com.bringspring.oa.entity.OaContractProductApplyEntity;
import com.bringspring.oa.service.OaContractProductApplyService;
import io.swagger.annotations.Api;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\u5173\u8054\u4ea7\u54c1"}, value="contract")
@RequestMapping(value={"/api/oa/contract/RkContractProduct"})
public class OaContractProductController {
    private static final Logger log = LoggerFactory.getLogger(OaContractProductController.class);
    @Autowired
    private OaContractProductApplyService oaContractProductApplyService;
    @Autowired
    private CrmProductVersionService crmProductVersionService;

    @GetMapping(value={"/getListByContractId/{contractId}"})
    public ActionResult getListByContractId(@PathVariable(value="contractId") String contractId) {
        List<OaContractProductApplyEntity> listByContractId = this.oaContractProductApplyService.getListByContractId(contractId);
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractProductListVO.class);
        for (RkContractProductListVO vo : jsonToList) {
            List listByProductId = this.crmProductVersionService.getListByProductId(vo.getProductId());
            List versionListVOS = JsonUtil.getJsonToList((Object)listByProductId, CrmProductVersionListVO.class);
            vo.setVersionList(versionListVOS);
        }
        return ActionResult.success((Object)jsonToList);
    }
}

