/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkContractVerifyEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.model.rkContractVerify.RkContractVerifyInfoVO;
import com.bringspring.contract.model.rkContractVerify.RkContractVerifyListVO;
import com.bringspring.contract.model.rkContractVerify.RkContractVerifyPagination;
import com.bringspring.contract.model.rkContractVerify.RkContractVerifyPaginationExportModel;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentListVO;
import com.bringspring.contract.model.rkcontracttax.RkContractTaxInfoVO;
import com.bringspring.contract.service.OaContractCustomerService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractCollectionRecordService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractVerifyService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ReturnPlanEnum;
import com.bringspring.contract.utils.RoleUtils;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaContractPaymentApplyEntity;
import com.bringspring.oa.entity.OaContractProductApplyEntity;
import com.bringspring.oa.entity.OaContractTaxApplyEntity;
import com.bringspring.oa.entity.OaContractUpdateApplyEntity;
import com.bringspring.oa.entity.OaContractVoidedApplyEntity;
import com.bringspring.oa.model.oacontractupdate.OaContractUpdateCrForm;
import com.bringspring.oa.model.oacontractupdate.OaContractUpdateUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaContractPaymentApplyService;
import com.bringspring.oa.service.OaContractProductApplyService;
import com.bringspring.oa.service.OaContractTaxApplyService;
import com.bringspring.oa.service.OaContractUpdateAppyService;
import com.bringspring.oa.service.OaContractVoidedApplyService;
import com.bringspring.quotation.entity.SaleQuotationEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitEntity;
import com.bringspring.quotation.service.SaleQuotationProfitService;
import com.bringspring.quotation.service.SaleQuotationService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\u53d8\u66f4"}, value="OaContractUpdateChangeController")
@RequestMapping(value={"/oa/contract/update"})
public class OaContractUpdateChangeController {
    private static final Logger log = LoggerFactory.getLogger(OaContractUpdateChangeController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaContractUpdateAppyService oaContractUpdateAppyService;
    @Autowired
    private UserService userService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkContractCollectionRecordService contractCollectionRecordService;
    @Autowired
    private RkContractReturnPlanService contractReturnPlanService;
    @Autowired
    private RoleUtils roleUtils;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private OaContractPaymentApplyService oaContractPaymentApplyService;
    @Autowired
    private OaContractTaxApplyService oaContractTaxApplyService;
    @Autowired
    private OaContractProductApplyService oaContractProductApplyService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private OaContractVoidedApplyService oaContractVoidedApplyService;
    @Autowired
    private RkContractVerifyService rkContractVerifyService;
    @Autowired
    private OaContractCustomerService oaContractCustomerService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private SaleQuotationService saleQuotationService;
    @Autowired
    private SaleQuotationProfitService saleQuotationProfitService;
    @Autowired
    private SaleNoContractService saleNoContractService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractVerifyPagination rkContractVerifyPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        rkContractVerifyPagination.setUserId(userInfo.getUserId());
        rkContractVerifyPagination.setCompanyId(organizeId);
        List region = rkContractVerifyPagination.getCustomerRegion();
        if (CollectionUtil.isNotEmpty((Collection)region)) {
            List searchRegion = CollectionUtil.list((boolean)false);
            region.stream().forEach(l -> searchRegion.add(l.get(0)));
            rkContractVerifyPagination.setSearchCustomerRegion(searchRegion);
        }
        List<OaContractUpdateApplyEntity> list = this.oaContractUpdateAppyService.getList(rkContractVerifyPagination);
        for (OaContractUpdateApplyEntity oaContractUpdateApplyEntity : list) {
            oaContractUpdateApplyEntity.setContractTaxRate(this.baseDataUtil.getDictName(oaContractUpdateApplyEntity.getContractTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            oaContractUpdateApplyEntity.setSalerId(this.baseDataUtil.userSelectValueNoAccount(oaContractUpdateApplyEntity.getSalerId()));
            oaContractUpdateApplyEntity.setContractType(this.baseDataUtil.getDictName(oaContractUpdateApplyEntity.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            oaContractUpdateApplyEntity.setFinancialAcceptanceUser(this.baseDataUtil.userSelectValues(oaContractUpdateApplyEntity.getFinancialAcceptanceUser()));
            oaContractUpdateApplyEntity.setSalesSupportUser(this.baseDataUtil.userSelectValues(oaContractUpdateApplyEntity.getSalesSupportUser()));
            oaContractUpdateApplyEntity.setOpportunityAssistanceUser(this.baseDataUtil.userSelectValues(oaContractUpdateApplyEntity.getOpportunityAssistanceUser()));
            oaContractUpdateApplyEntity.setProposalProducer(this.baseDataUtil.userSelectValues(oaContractUpdateApplyEntity.getProposalProducer()));
            oaContractUpdateApplyEntity.setAssistingUser(this.baseDataUtil.userSelectValues(oaContractUpdateApplyEntity.getAssistingUser()));
            oaContractUpdateApplyEntity.setRegion(oaContractUpdateApplyEntity.getRegionName());
            oaContractUpdateApplyEntity.setIsNeedPayAdvance(oaContractUpdateApplyEntity.getIsNeedPayAdvance());
            oaContractUpdateApplyEntity.setIsStamp(oaContractUpdateApplyEntity.getIsStamp());
            oaContractUpdateApplyEntity.setCustomerRegion(oaContractUpdateApplyEntity.getCustomerRegionName());
            oaContractUpdateApplyEntity.setDepartment(oaContractUpdateApplyEntity.getDepartmentTreeName());
            oaContractUpdateApplyEntity.setIncomeType(this.baseDataUtil.getDictName(oaContractUpdateApplyEntity.getIncomeType(), ""));
            oaContractUpdateApplyEntity.setIndustryType(this.baseDataUtil.getDictName(oaContractUpdateApplyEntity.getIndustryType(), ""));
            oaContractUpdateApplyEntity.setCustomerName(ObjectUtil.isEmpty((Object)oaContractUpdateApplyEntity.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)oaContractUpdateApplyEntity.getCustomerId()))).getName());
            if (StringUtils.isNotEmpty((String)oaContractUpdateApplyEntity.getChangeAbout())) {
                oaContractUpdateApplyEntity.setChangeAboutName(this.baseDataUtil.getDictName(oaContractUpdateApplyEntity.getChangeAbout(), "ContractChangeAbout"));
            }
            if (!ObjectUtil.isEmpty((Object)oaContractUpdateApplyEntity.getIsAgent()) && oaContractUpdateApplyEntity.getIsAgent() == 1) {
                RkAgentEntity byId = (RkAgentEntity)this.agentService.getById((Serializable)((Object)oaContractUpdateApplyEntity.getAgentId()));
                oaContractUpdateApplyEntity.setAgentId(ObjectUtil.isEmpty((Object)oaContractUpdateApplyEntity.getAgentId()) ? "" : byId.getName());
                oaContractUpdateApplyEntity.setAgentType(ObjectUtil.isEmpty((Object)oaContractUpdateApplyEntity.getAgentId()) ? "" : this.baseDataUtil.getDictName(byId.getType(), ""));
            }
            if (!ObjectUtil.isEmpty((Object)oaContractUpdateApplyEntity.getIsAgent()) && oaContractUpdateApplyEntity.getIsAgent() == 0) {
                oaContractUpdateApplyEntity.setAgentId(oaContractUpdateApplyEntity.getCustomerName());
            }
            oaContractUpdateApplyEntity.setMasterId(ObjectUtil.isEmpty((Object)oaContractUpdateApplyEntity.getMasterId()) ? "" : ((OaContractUpdateApplyEntity)this.oaContractUpdateAppyService.getById((Serializable)((Object)oaContractUpdateApplyEntity.getMasterId()))).getContractName());
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractVerifyListVO.class);
        for (RkContractVerifyListVO rkContractVerifyVO : listVO) {
            rkContractVerifyVO.setEnableMarkDesc(this.baseDataUtil.getDictName(rkContractVerifyVO.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
            List planList = this.contractReturnPlanService.getPlanByContractId(rkContractVerifyVO.getId());
            List collect = planList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getDueDate()) && x.getReturnState() != ReturnPlanEnum.END.getState() && DateUtil.dateToString((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd").compareTo(DateUtil.dateToString((Date)x.getDueDate(), (String)"yyyy-MM-dd")) > 0).collect(Collectors.toList());
            BigDecimal arrearsAmount = collect.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
            rkContractVerifyVO.setArrearsAmount(arrearsAmount);
            rkContractVerifyVO.setIsOverdue(Integer.valueOf(CollectionUtil.isNotEmpty(collect) ? 1 : 0));
            rkContractVerifyVO.setNotReturnAmount(MathUtils.substract((String)rkContractVerifyVO.getContractAmount(), (String)rkContractVerifyVO.getReturnAmount()));
        }
        for (RkContractVerifyListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity;
            String s;
            if (StrUtil.isNotEmpty((CharSequence)vo.getSalesLiaison()) && StrUtil.isNotEmpty((CharSequence)(s = this.baseDataUtil.userSelectValues(vo.getSalesLiaison())))) {
                vo.setSalesLiaisonName(s);
            }
            if ((flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus})) != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)rkContractVerifyPagination, PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractVerifyInfoVO> info(@PathVariable(value="id") String id) {
        SaleNoContractEntity noContract;
        SaleQuotationProfitEntity profit;
        String userSelectValue;
        SaleQuotationEntity quotation;
        RkAgentEntity agent;
        OaContractUpdateApplyEntity entity;
        entity.setCustomerName(ObjectUtil.isEmpty((Object)(entity = this.oaContractUpdateAppyService.getInfo(id)).getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()))).getName());
        String[] split = entity.getDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",");
        RkContractVerifyInfoVO vo = (RkContractVerifyInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractVerifyInfoVO.class);
        if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
            vo.setCustomerNames(this.oaContractCustomerService.getCustomerNamesByContractId(vo.getId()));
            vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            vo.setCustomerList(this.oaContractCustomerService.getListByContractId(vo.getId()));
        }
        if ("1".equals(vo.getIsAgent()) && StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = this.agentService.getInfo(vo.getAgentId()))) {
            vo.setAgentName(agent.getName());
        }
        vo.setDepartmentTree(Arrays.asList(split));
        vo.setSalerName(entity.getSalerName());
        vo.setContractLevel(entity.getContractLevel());
        vo.setContractTypeDesc(this.baseDataUtil.getDictName(vo.getContractTypeDesc(), Constants.CONTRACT_TYPE_DICT_ID));
        vo.setIndustryTypeDesc(this.baseDataUtil.getDictName(vo.getIndustryType(), ""));
        vo.setIncomeTypeDesc(this.baseDataUtil.getDictName(vo.getIncomeType(), ""));
        vo.setRegionName(entity.getRegionName());
        vo.setDepartmentName(entity.getDepartmentTreeName());
        vo.setIsNeedPayAdvance(entity.getIsNeedPayAdvance());
        vo.setIsStamp(entity.getIsStamp());
        vo.setIsSubcontract(entity.getIsSubcontract());
        vo.setProfitAmount(entity.getProfitAmount());
        if (!ObjectUtil.isEmpty((Object)vo.getIsArchived()) && StrUtil.equals((CharSequence)vo.getIsArchived(), (CharSequence)"1")) {
            vo.setArchivedLocation(this.baseDataUtil.getDictName(vo.getArchivedLocation(), Constants.ARCHIVELOCATION_DICT_ID));
            vo.setArchivedBy(this.baseDataUtil.userSelectValueNoAccount(vo.getArchivedBy()));
        }
        if (!ObjectUtil.isEmpty((Object)vo.getIsAgent()) && StrUtil.equals((CharSequence)vo.getIsAgent(), (CharSequence)"1")) {
            if (!ObjectUtil.isEmpty((Object)vo.getAgentId())) {
                vo.setAgentName(((RkAgentEntity)this.agentService.getById((Serializable)((Object)vo.getAgentId()))).getName());
            }
        } else {
            vo.setAgentName(vo.getCustomerName());
        }
        vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        List<OaContractPaymentApplyEntity> listByContractId = this.oaContractPaymentApplyService.getListByContractId(id);
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
        vo.setPaymentList(jsonToList);
        List<OaContractTaxApplyEntity> rkContractTaxEntities = this.oaContractTaxApplyService.listByContractId(id);
        List jsonToList1 = JsonUtil.getJsonToList(rkContractTaxEntities, RkContractTaxInfoVO.class);
        vo.setTaxList(jsonToList1);
        List<OaAttachmentEntity> attachmentEntityList = this.oaAttachmentService.getListByContractIdAndFileType(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
        List attachmentList = JsonUtil.getJsonToList(attachmentEntityList, RkAttachmentCrForm.class);
        if (CollectionUtil.isNotEmpty((Collection)attachmentList)) {
            vo.setAttachmentList(attachmentList);
        } else {
            vo.setAttachmentList(new ArrayList());
        }
        attachmentEntityList = this.oaAttachmentService.getListByContractIdAndFileType(id, AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType());
        attachmentList = JsonUtil.getJsonToList(attachmentEntityList, RkAttachmentCrForm.class);
        if (CollectionUtil.isNotEmpty((Collection)attachmentList)) {
            vo.setDoubleSignedAttachmentList(attachmentList);
        } else {
            vo.setDoubleSignedAttachmentList(new ArrayList());
        }
        List planList = this.contractReturnPlanService.getPlanByContractId(vo.getId());
        if (CollectionUtil.isNotEmpty((Collection)planList)) {
            BigDecimal bigDecimal = planList.stream().map(RkContractReturnPlanEntity::getReceivableAmount).reduce(BigDecimal::add).get();
            vo.setPlanTotalAmount(bigDecimal);
        }
        vo.setPlanNum(Integer.valueOf(planList.size()));
        List collect = planList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getDueDate()) && x.getReturnState() != ReturnPlanEnum.END.getState() && DateUtil.dateToString((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd").compareTo(DateUtil.dateToString((Date)x.getDueDate(), (String)"yyyy-MM-dd")) > 0).collect(Collectors.toList());
        BigDecimal arrearsAmount = collect.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
        vo.setArrearsAmount(arrearsAmount);
        vo.setIsOverdue(Integer.valueOf(CollectionUtil.isNotEmpty(collect) ? 1 : 0));
        if (StringUtils.isNotEmpty((String)entity.getOpportunityId())) {
            List<String> idList = Arrays.asList(entity.getOpportunityId().split(","));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(RkProjectReportingEntity::getId, idList);
            List reportingList = this.rkProjectReportingService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)reportingList)) {
                String opportunityName = reportingList.stream().map(RkProjectReportingEntity::getReportingProject).collect(Collectors.joining(","));
                vo.setOpportunityName(opportunityName);
            }
        }
        String quotationPrefix = "";
        if (StringUtils.isNotEmpty((String)entity.getQuotationId()) && null != (quotation = this.saleQuotationService.getInfo(entity.getQuotationId()))) {
            if (StringUtils.isNotEmpty((String)quotation.getSerialNumber())) {
                quotationPrefix = quotation.getSerialNumber();
            } else {
                CrmCustomerEntity customer;
                RkProjectReportingEntity reporting = this.rkProjectReportingService.getInfo(quotation.getOpportunityId());
                if (StringUtils.isNotEmpty((String)reporting.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(reporting.getCustomerId()))) {
                    quotationPrefix = customer.getName();
                }
            }
            userSelectValue = this.baseDataUtil.userSelectValue(quotation.getQuotationUser());
            String quotationName = quotationPrefix + "-" + userSelectValue;
            vo.setQuotationName(quotationName);
        }
        if (StringUtils.isNotEmpty((String)entity.getQuotationProfitId()) && null != (profit = this.saleQuotationProfitService.getInfo(entity.getQuotationProfitId()))) {
            userSelectValue = this.baseDataUtil.userSelectValue(profit.getSaleId());
            vo.setQuotationProfitName(quotationPrefix + "-" + userSelectValue);
        }
        if (StringUtils.isNotEmpty((String)vo.getNoContractId()) && null != (noContract = this.saleNoContractService.getInfo(vo.getNoContractId()))) {
            vo.setNoContractName(noContract.getContractName());
            vo.setNoContractAssociationId(noContract.getContractId());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"getByContractId/{contractId}"})
    public ActionResult getByProjectId(@PathVariable(value="contractId") String contractId) {
        List<OaContractUpdateApplyEntity> byProjectId = this.oaContractUpdateAppyService.getByContractId(contractId);
        List<OaContractVoidedApplyEntity> byProjectId1 = this.oaContractVoidedApplyService.getByContractId(contractId);
        List list = CollectionUtil.list((boolean)false, (Object[])new Object[]{contractId});
        if (CollectionUtil.isNotEmpty(byProjectId)) {
            list.addAll(byProjectId.stream().map(OaContractUpdateApplyEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty(byProjectId1)) {
            list.addAll(byProjectId1.stream().map(OaContractVoidedApplyEntity::getId).collect(Collectors.toList()));
        }
        return ActionResult.success((Object)list);
    }

    @GetMapping(value={"countByContractId/{contractId}"})
    public ActionResult countByProjectId(@PathVariable(value="contractId") String contractId) {
        long updateApplyCount = this.oaContractUpdateAppyService.countByContractId(contractId);
        long voidedAppplyCount = this.oaContractVoidedApplyService.countByContractId(contractId);
        RkContractVerifyEntity byId = (RkContractVerifyEntity)this.rkContractVerifyService.getById((Serializable)((Object)contractId));
        String add = MathUtils.add((String)String.valueOf(updateApplyCount), (String)String.valueOf(voidedAppplyCount));
        if (ObjectUtil.isNotNull((Object)byId)) {
            add = MathUtils.add((String)add, (String)"1");
        }
        HashMap map = MapUtil.newHashMap();
        map.put("flowCount", add);
        return ActionResult.success((Object)map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @RepeatSubmit
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaContractUpdateCrForm oaContractUpdateCrForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String[] split;
            String flowEngineId = "559987138326703365";
            String contractId = oaContractUpdateCrForm.getContractId();
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            String organizeId = userInfo.getOrganizeId();
            if (StrUtil.isNotBlank((CharSequence)oaContractUpdateCrForm.getCompanyId())) {
                organizeId = oaContractUpdateCrForm.getCompanyId();
            }
            oaContractUpdateCrForm.setCompanyId(organizeId);
            if (StrUtil.isNotBlank((CharSequence)oaContractUpdateCrForm.getSalesLiaison())) {
                oaContractUpdateCrForm.setSalesLiaisonName(this.baseDataUtil.userSelectValues(oaContractUpdateCrForm.getSalesLiaison()));
                UserEntity byId = (UserEntity)this.userService.getById((Serializable)((Object)oaContractUpdateCrForm.getSalesLiaison()));
                oaContractUpdateCrForm.setLiaisonDepartment(byId.getOrganizeId());
                oaContractUpdateCrForm.setLiaisonCompany(this.userService.getUserCompany(oaContractUpdateCrForm.getSalesLiaison()));
            }
            OaContractUpdateApplyEntity entity = (OaContractUpdateApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaContractUpdateCrForm), OaContractUpdateApplyEntity.class);
            entity.setId(mainId);
            if (!ObjectUtil.isEmpty((Object)entity.getDepartmentTree()) && (split = entity.getDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
                entity.setDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getDepartmentTree()));
                entity.setDepartmentOne(split[0]);
                entity.setDepartmentOneName(this.baseDataUtil.comSelectValues(entity.getDepartmentOne()));
                entity.setDepartment(split[split.length - 1]);
                entity.setDepartmentName(this.baseDataUtil.comSelectValues(entity.getDepartment()));
            }
            entity.setEnableMark(this.baseDataUtil.getDictName(entity.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
            if (ObjectUtil.isNotEmpty((Object)entity.getIsStampType())) {
                entity.setStampTypeName(this.baseDataUtil.getDictName(entity.getIsStampType(), Constants.STAMP_TYPE_DICT_ID));
            }
            entity.setContractLevel(this.baseDataUtil.getDictName(entity.getContractLevel(), Constants.CONTRACT_LEVEL_DICT_ID));
            if (StringUtils.isNotEmpty((String)oaContractUpdateCrForm.getCustomerAddress())) {
                split = oaContractUpdateCrForm.getCustomerAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
                for (int i = 0; i < split.length; ++i) {
                    if (i == 0) {
                        entity.setCustomerRegion(split[0]);
                        entity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
                        continue;
                    }
                    if (i == 1) {
                        entity.setCustomerProv(split[1]);
                        entity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
                        continue;
                    }
                    if (i != 2) continue;
                    entity.setCustomerCity(split[2]);
                    entity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
                }
                entity.setCustomerAddressName(this.baseDataUtil.provinceData(oaContractUpdateCrForm.getCustomerAddress()));
            }
            if (StringUtils.isNotEmpty((String)entity.getCustomerIds())) {
                this.oaContractCustomerService.insertListByCustomerIds(entity.getId(), entity.getCustomerIds());
            }
            if (ObjectUtil.equals((Object)entity.getIsAgent(), (Object)1)) {
                entity.setAgentIds(entity.getAgentId());
            } else {
                entity.setAgentId(entity.getCustomerId());
                entity.setAgentIds(entity.getCustomerIds());
            }
            if (StringUtils.isNotEmpty((String)entity.getChangeAbout())) {
                entity.setChangeAboutName(this.baseDataUtil.getDictName(entity.getChangeAbout(), "ContractChangeAbout"));
                oaContractUpdateCrForm.setChangeAboutName(entity.getChangeAboutName());
            }
            this.oaContractUpdateAppyService.save(entity);
            oaContractUpdateCrForm.setDepartmentName(entity.getDepartmentName());
            oaContractUpdateCrForm.setSalerId(entity.getSalerId());
            oaContractUpdateCrForm.setDepartmentOneName(entity.getDepartmentOneName());
            oaContractUpdateCrForm.setStampTypeName(entity.getStampTypeName());
            oaContractUpdateCrForm.setIsStampType(entity.getIsStampType());
            oaContractUpdateCrForm.setIsStamp(entity.getIsStamp());
            oaContractUpdateCrForm.setContractLevel(entity.getContractLevel());
            if (CollectionUtil.isNotEmpty((Collection)oaContractUpdateCrForm.getTaxList())) {
                List jsonToList = JsonUtil.getJsonToList((Object)oaContractUpdateCrForm.getTaxList(), OaContractTaxApplyEntity.class);
                jsonToList.stream().forEach(tax -> {
                    tax.setContractId(mainId);
                    tax.setId(RandomUtil.uuId());
                });
                this.oaContractTaxApplyService.saveBatch(jsonToList);
            }
            List paymentList = oaContractUpdateCrForm.getPaymentList();
            List jsonToList = JsonUtil.getJsonToList((Object)paymentList, OaContractPaymentApplyEntity.class);
            jsonToList.stream().forEach(payment -> {
                payment.setContractId(entity.getId());
                payment.setId(RandomUtil.uuId());
                if (!ObjectUtil.isEmpty((Object)entity.getContractAmount()) && !ObjectUtil.isEmpty((Object)payment.getPaymentRatio())) {
                    String multiply = MathUtils.multiply((String)(entity.getContractAmount() + ""), (String)(payment.getPaymentRatio() + ""));
                    String divide = MathUtils.divide((String)multiply, (String)"100", (int)2);
                    payment.setReceivableAmount(MathUtils.toBigDecimal((Object)divide));
                }
            });
            this.oaContractPaymentApplyService.saveBatch(jsonToList);
            List productList = oaContractUpdateCrForm.getProductList();
            productList.stream().forEach(product -> product.setContractId(mainId));
            List productEntityList = JsonUtil.getJsonToList((Object)productList, OaContractProductApplyEntity.class);
            this.oaContractProductApplyService.saveBatch(productEntityList);
            List attachmentList = oaContractUpdateCrForm.getAttachmentList();
            attachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setContractId(mainId);
                attach.setObjId(mainId);
                attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList((Object)attachmentList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(attachmentEntityList);
            List doubleSignedAttachmentList = oaContractUpdateCrForm.getDoubleSignedAttachmentList();
            if (CollectionUtil.isNotEmpty((Collection)doubleSignedAttachmentList)) {
                doubleSignedAttachmentList.stream().forEach(attach -> {
                    attach.setContractId(mainId);
                    attach.setObjId(mainId);
                    attach.setFileType(AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType());
                });
                List doubleSignedAttachmentEntityList = JsonUtil.getJsonToList((Object)doubleSignedAttachmentList, OaAttachmentEntity.class);
                this.oaAttachmentService.saveBatch(doubleSignedAttachmentEntityList);
                entity.setDoubleSignedAttachment(1);
            }
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)contractId));
            String flowTitle = oaContractUpdateCrForm.getContractCode() + "-" + oaContractUpdateCrForm.getContractName();
            if (byId != null) {
                flowTitle = byId.getContractCode() + "" + byId.getContractName();
                byId.setChangeTaskId(mainId);
                this.contractService.updateById((Object)byId);
            }
            FlowUtil.saveOrSubmit((String)oaContractUpdateCrForm.getTaskId(), (String)flowEngineId, (String)oaContractUpdateCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaContractUpdateCrForm), (Integer)oaContractUpdateCrForm.getStatus(), (String)flowTitle);
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RepeatSubmit
    @PutMapping(value={"execute/{id}"})
    public ActionResult execute(@PathVariable(value="id") String id) throws DataException {
        OaContractUpdateApplyEntity byId = (OaContractUpdateApplyEntity)this.oaContractUpdateAppyService.getById((Serializable)((Object)id));
        if (!ObjectUtil.isNotNull((Object)byId)) return ActionResult.fail((String)"\u53d8\u66f4\u6d41\u7a0b\u4e0d\u5b58\u5728");
        RkContractEntity byId1 = (RkContractEntity)this.contractService.getById((Serializable)((Object)byId.getContractId()));
        if (!ObjectUtil.equals((Object)byId1.getChangeTaskEnable(), (Object)2)) return ActionResult.fail((String)"\u53d8\u66f4\u6d41\u7a0b\u8fd8\u672a\u5ba1\u6838\u901a\u8fc7,\u6682\u65f6\u4e0d\u80fd\u786e\u8ba4\u53d8\u66f4");
        HashMap execute = this.oaContractUpdateAppyService.execute(id);
        if (!ObjectUtil.isNotNull(execute.get("error"))) return ActionResult.success((String)"\u786e\u8ba4\u53d8\u66f4\u6210\u529f");
        return ActionResult.fail((String)execute.get("error").toString());
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkContractVerifyPaginationExportModel rkContractVerifyPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkContractVerifyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractVerifyPagination rkContractVerifyPagination = (RkContractVerifyPagination)JsonUtil.getJsonToBean((Object)rkContractVerifyPaginationExportModel, RkContractVerifyPagination.class);
        List<OaContractUpdateApplyEntity> list = this.oaContractUpdateAppyService.getTypeList(rkContractVerifyPagination, rkContractVerifyPaginationExportModel.getDataType());
        for (OaContractUpdateApplyEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractVerifyListVO.class);
        for (RkContractVerifyListVO rkContractVerifyListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkContractVerifyPaginationExportModel.getSelectKey()) ? rkContractVerifyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block26: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block26;
                    }
                    case "masterId": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"masterId"));
                        continue block26;
                    }
                    case "contractType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"contractType"));
                        continue block26;
                    }
                    case "specialType": {
                        entitys.add(new ExcelExportEntity("\u7279\u6b8a\u5408\u540c", (Object)"specialType"));
                        continue block26;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u603b\u91d1\u989d", (Object)"contractAmount"));
                        continue block26;
                    }
                    case "isNeedPayAdvance": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u9700\u8981\u57ab\u8d44", (Object)"isNeedPayAdvance"));
                        continue block26;
                    }
                    case "departmentName": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8\u540d\u79f0", (Object)"departmentName"));
                        continue block26;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    @DSTransactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        List<String> allIdList = Arrays.asList(idList);
        ArrayList<String> columnIdList = new ArrayList<String>(20);
        int i = 0;
        for (String allId : allIdList) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)allId, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity == null) {
                columnIdList.add(allId);
                continue;
            }
            if (!taskEntity.getStatus().equals(0)) continue;
            try {
                FlowUtil.deleteByProcessId((String)allId);
                columnIdList.add(allId);
                ++i;
            }
            catch (WorkFlowException e) {
                e.printStackTrace();
            }
        }
        this.oaContractUpdateAppyService.removeByIds(columnIdList);
        if (i == 0 && columnIdList.size() == 0) {
            return ActionResult.fail((String)"\u6d41\u7a0b\u5df2\u53d1\u8d77\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/detailApp/{id}"})
    public ActionResult<RkContractVerifyInfoVO> detailAppInfo(@PathVariable(value="id") String id) {
        OaContractUpdateApplyEntity entity = this.oaContractUpdateAppyService.getInfo(id);
        RkContractVerifyInfoVO vo = (RkContractVerifyInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractVerifyInfoVO.class);
        vo.setSalerId(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
        vo.setRegion(this.baseDataUtil.provinceData(vo.getRegion()));
        vo.setDepartment(entity.getDepartmentTreeName());
        vo.setIsNeedPayAdvance(vo.getIsNeedPayAdvance());
        vo.setIsStamp(vo.getIsStamp());
        vo.setIsSubcontract(vo.getIsSubcontract());
        vo.setProfitAmount(vo.getProfitAmount());
        vo.setStartContractTime(vo.getStartContractTime());
        vo.setEndContractTime(vo.getEndContractTime());
        vo.setPaymentMethodType(this.baseDataUtil.getDictName(vo.getPaymentMethodType(), Constants.PAYMENT_METHOD_TYPE));
        vo.setIndustryType(this.baseDataUtil.getDictName(vo.getIndustryType(), Constants.INDUSTRY_TYPE));
        vo.setContractTaxRate(this.baseDataUtil.getDictName(vo.getContractTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        vo.setIsStampType(this.baseDataUtil.getDictName(vo.getIsStampType(), Constants.STAMP_TYPE_DICT_ID));
        vo.setIncomeType(this.baseDataUtil.getDictName(vo.getIncomeType(), Constants.CONTRACT_INCOME_TYPE_DICT_ID));
        vo.setContractLevel(this.baseDataUtil.getDictName(vo.getContractLevel(), Constants.CONTRACT_LEVEL_DICT_ID));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractVerifyInfoVO> detailInfo(@PathVariable(value="id") String id) {
        String collect1;
        OaContractUpdateApplyEntity entity = this.oaContractUpdateAppyService.getInfo(id);
        RkContractVerifyInfoVO vo1 = (RkContractVerifyInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractVerifyInfoVO.class);
        vo1.setSalerId(this.baseDataUtil.userSelectValue(vo1.getSalerId()));
        vo1.setIsNeedPayAdvance(vo1.getIsNeedPayAdvance());
        vo1.setIsStamp(vo1.getIsStamp());
        vo1.setIsSubcontract(vo1.getIsSubcontract());
        vo1.setProfitAmount(vo1.getProfitAmount());
        vo1.setStartContractTime(vo1.getStartContractTime());
        vo1.setEndContractTime(vo1.getEndContractTime());
        vo1.setContractTaxRate(this.baseDataUtil.getDictName(vo1.getContractTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        vo1.setCostTaxRate(this.baseDataUtil.getDictName(vo1.getCostTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        vo1.setContractType(this.baseDataUtil.getDictName(vo1.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        vo1.setIsStampType(this.baseDataUtil.getDictName(vo1.getIsStampType(), Constants.STAMP_TYPE_DICT_ID));
        vo1.setPaymentMethodType(this.baseDataUtil.getDictName(vo1.getPaymentMethodType(), Constants.PAYMENT_METHOD_TYPE));
        vo1.setIndustryType(this.baseDataUtil.getDictName(vo1.getIndustryType(), Constants.INDUSTRY_TYPE));
        vo1.setIncomeType(this.baseDataUtil.getDictName(vo1.getIncomeType(), Constants.CONTRACT_INCOME_TYPE_DICT_ID));
        vo1.setContractTypeDesc(this.baseDataUtil.getDictName(vo1.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        vo1.setFinancialAcceptanceUser(this.baseDataUtil.userSelectValues(vo1.getFinancialAcceptanceUser()));
        vo1.setSalesSupportUser(this.baseDataUtil.userSelectValues(vo1.getSalesSupportUser()));
        vo1.setOpportunityAssistanceUser(this.baseDataUtil.userSelectValues(vo1.getOpportunityAssistanceUser()));
        vo1.setProposalProducer(this.baseDataUtil.userSelectValues(vo1.getProposalProducer()));
        vo1.setAssistingUser(this.baseDataUtil.userSelectValues(vo1.getAssistingUser()));
        vo1.setRegion(entity.getRegionName());
        vo1.setDepartment(entity.getDepartmentTreeName());
        vo1.setCustomerName(ObjectUtil.isEmpty((Object)vo1.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo1.getCustomerId()))).getName());
        if (!ObjectUtil.isEmpty((Object)vo1.getIsAgent()) && StrUtil.equals((CharSequence)vo1.getIsAgent(), (CharSequence)"1")) {
            RkAgentEntity byId = (RkAgentEntity)this.agentService.getById((Serializable)((Object)vo1.getAgentId()));
            vo1.setAgentName(ObjectUtil.isEmpty((Object)vo1.getAgentId()) ? "" : byId.getName());
            vo1.setAgentType(ObjectUtil.isEmpty((Object)vo1.getAgentId()) ? "" : this.baseDataUtil.getDictName(byId.getType(), ""));
        }
        if (!ObjectUtil.isEmpty((Object)vo1.getIsAgent()) && StrUtil.equals((CharSequence)vo1.getIsAgent(), (CharSequence)"0")) {
            vo1.setAgentName(vo1.getCustomerName());
        }
        vo1.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo1.getCreatorUserId()));
        vo1.setMasterId(ObjectUtil.isEmpty((Object)vo1.getMasterId()) ? "" : ((OaContractUpdateApplyEntity)this.oaContractUpdateAppyService.getById((Serializable)((Object)vo1.getMasterId()))).getContractName());
        vo1.setEnableMarkDesc(this.baseDataUtil.getDictName(vo1.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
        vo1.setCustomerRegion(entity.getCustomerRegionName());
        vo1.setArchivedByDesc(this.baseDataUtil.userSelectValueNoAccount(vo1.getArchivedBy()));
        vo1.setArchivedLocationDesc(this.baseDataUtil.getDictName(vo1.getArchivedLocation(), ""));
        List planList = this.contractReturnPlanService.getPlanByContractId(vo1.getId());
        vo1.setPlanNum(Integer.valueOf(planList.size()));
        List collect = planList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getDueDate()) && x.getReturnState() != ReturnPlanEnum.END.getState() && DateUtil.dateToString((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd").compareTo(DateUtil.dateToString((Date)x.getDueDate(), (String)"yyyy-MM-dd")) > 0).collect(Collectors.toList());
        BigDecimal arrearsAmount = collect.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
        vo1.setArrearsAmount(arrearsAmount);
        List<OaContractPaymentApplyEntity> listByContractId = this.oaContractPaymentApplyService.getListByContractId(id);
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
        vo1.setPaymentList(jsonToList);
        List<OaContractTaxApplyEntity> rkContractTaxEntities = this.oaContractTaxApplyService.listByContractId(id);
        List jsonToList1 = JsonUtil.getJsonToList(rkContractTaxEntities, RkContractTaxInfoVO.class);
        vo1.setTaxList(jsonToList1);
        if (vo1.getIsMoreTax() != null && vo1.getIsMoreTax() == 1 && CollectionUtil.isNotEmpty((Collection)jsonToList1)) {
            collect1 = jsonToList1.stream().filter(i -> !i.getTaxType().equals("cost")).map(RkContractTaxInfoVO::getTaxName).collect(Collectors.joining(","));
            vo1.setContractTaxRate(collect1);
        }
        if (vo1.getCostIsMoreTax() != null && vo1.getCostIsMoreTax() == 1 && CollectionUtil.isNotEmpty((Collection)jsonToList1)) {
            collect1 = jsonToList1.stream().filter(i -> i.getTaxType().equals("cost")).map(RkContractTaxInfoVO::getTaxName).collect(Collectors.joining(","));
            vo1.setCostTaxRate(collect1);
        }
        return ActionResult.success((Object)vo1);
    }

    @GetMapping(value={"/detailForm/{id}"})
    public ActionResult<RkContractVerifyInfoVO> detailForm(@PathVariable(value="id") String id) {
        OaContractUpdateApplyEntity entity = this.oaContractUpdateAppyService.getInfo(id);
        RkContractVerifyInfoVO vo1 = (RkContractVerifyInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractVerifyInfoVO.class);
        vo1.setIsNeedPayAdvance(vo1.getIsNeedPayAdvance());
        vo1.setIsStamp(vo1.getIsStamp());
        vo1.setIsSubcontract(vo1.getIsSubcontract());
        vo1.setProfitAmount(vo1.getProfitAmount());
        vo1.setStartContractTime(vo1.getStartContractTime());
        vo1.setEndContractTime(vo1.getEndContractTime());
        vo1.setContractTaxRate(this.baseDataUtil.getDictName(vo1.getContractTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        vo1.setSalerId(this.baseDataUtil.userSelectValueNoAccount(vo1.getSalerId()));
        vo1.setContractType(this.baseDataUtil.getDictName(vo1.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        vo1.setIsStampType(this.baseDataUtil.getDictName(vo1.getIsStampType(), Constants.STAMP_TYPE_DICT_ID));
        vo1.setPaymentMethodType(this.baseDataUtil.getDictName(vo1.getPaymentMethodType(), ""));
        vo1.setContractTypeDesc(this.baseDataUtil.getDictName(vo1.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        vo1.setIndustryType(this.baseDataUtil.getDictName(vo1.getIndustryType(), ""));
        vo1.setIncomeType(this.baseDataUtil.getDictName(vo1.getIncomeType(), ""));
        vo1.setFinancialAcceptanceUser(this.baseDataUtil.userSelectValues(vo1.getFinancialAcceptanceUser()));
        vo1.setSalesSupportUser(this.baseDataUtil.userSelectValues(vo1.getSalesSupportUser()));
        vo1.setOpportunityAssistanceUser(this.baseDataUtil.userSelectValues(vo1.getOpportunityAssistanceUser()));
        vo1.setProposalProducer(this.baseDataUtil.userSelectValues(vo1.getProposalProducer()));
        vo1.setAssistingUser(this.baseDataUtil.userSelectValues(vo1.getAssistingUser()));
        vo1.setRegion(entity.getRegionName());
        vo1.setDepartment(entity.getDepartmentTreeName());
        vo1.setCustomerName(ObjectUtil.isEmpty((Object)vo1.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo1.getCustomerId()))).getName());
        if (!ObjectUtil.isEmpty((Object)vo1.getIsAgent()) && StrUtil.equals((CharSequence)vo1.getIsAgent(), (CharSequence)"1")) {
            RkAgentEntity byId = (RkAgentEntity)this.agentService.getById((Serializable)((Object)vo1.getAgentId()));
            vo1.setAgentName(ObjectUtil.isEmpty((Object)vo1.getAgentId()) ? "" : byId.getName());
            vo1.setAgentType(ObjectUtil.isEmpty((Object)vo1.getAgentId()) ? "" : this.baseDataUtil.getDictName(byId.getType(), ""));
        }
        if (!ObjectUtil.isEmpty((Object)vo1.getIsAgent()) && StrUtil.equals((CharSequence)vo1.getIsAgent(), (CharSequence)"0")) {
            vo1.setAgentName(vo1.getCustomerName());
        }
        vo1.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo1.getCreatorUserId()));
        vo1.setMasterId(ObjectUtil.isEmpty((Object)vo1.getMasterId()) ? "" : ((OaContractUpdateApplyEntity)this.oaContractUpdateAppyService.getById((Serializable)((Object)vo1.getMasterId()))).getContractName());
        vo1.setEnableMarkDesc(this.baseDataUtil.getDictName(vo1.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
        vo1.setCustomerRegion(entity.getCustomerRegionName());
        vo1.setArchivedByDesc(this.baseDataUtil.userSelectValueNoAccount(vo1.getArchivedBy()));
        vo1.setArchivedLocationDesc(this.baseDataUtil.getDictName(vo1.getArchivedLocation(), ""));
        List planList = this.contractReturnPlanService.getPlanByContractId(vo1.getId());
        vo1.setPlanNum(Integer.valueOf(planList.size()));
        List collect = planList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getDueDate()) && x.getReturnState() != ReturnPlanEnum.END.getState() && DateUtil.dateToString((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd").compareTo(DateUtil.dateToString((Date)x.getDueDate(), (String)"yyyy-MM-dd")) > 0).collect(Collectors.toList());
        BigDecimal arrearsAmount = collect.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
        vo1.setArrearsAmount(arrearsAmount);
        List<OaContractPaymentApplyEntity> listByContractId = this.oaContractPaymentApplyService.getListByContractId(id);
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
        vo1.setPaymentList(jsonToList);
        List<OaContractTaxApplyEntity> rkContractTaxEntities = this.oaContractTaxApplyService.listByContractId(id);
        List jsonToList1 = JsonUtil.getJsonToList(rkContractTaxEntities, RkContractTaxInfoVO.class);
        vo1.setTaxList(jsonToList1);
        if (vo1.getIsMoreTax() != null && vo1.getIsMoreTax() == 1 && CollectionUtil.isNotEmpty((Collection)jsonToList1)) {
            String collect1 = jsonToList1.stream().map(RkContractTaxInfoVO::getTaxName).collect(Collectors.joining(","));
            vo1.setContractTaxRate(collect1);
        }
        return ActionResult.success((Object)vo1);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaContractUpdateUpForm oaContractUpdateUpForm) throws DataException, WorkFlowException {
        String flowEngineId = "559987138326703365";
        UserInfo userInfo = this.userProvider.get();
        OaContractUpdateApplyEntity entity = this.oaContractUpdateAppyService.getInfo(id);
        if (entity != null) {
            List doubleSignedAttachmentList;
            String[] split;
            OaContractUpdateApplyEntity subentity;
            if (StrUtil.isNotBlank((CharSequence)oaContractUpdateUpForm.getSalesLiaison())) {
                oaContractUpdateUpForm.setSalesLiaisonName(this.baseDataUtil.userSelectValues(oaContractUpdateUpForm.getSalesLiaison()));
                UserEntity byId = (UserEntity)this.userService.getById((Serializable)((Object)oaContractUpdateUpForm.getSalesLiaison()));
                oaContractUpdateUpForm.setLiaisonDepartment(byId.getOrganizeId());
                oaContractUpdateUpForm.setLiaisonCompany(this.userService.getUserCompany(oaContractUpdateUpForm.getSalesLiaison()));
            }
            if (!ObjectUtil.isEmpty((Object)(subentity = (OaContractUpdateApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaContractUpdateUpForm), OaContractUpdateApplyEntity.class)).getDepartmentTree()) && (split = subentity.getDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
                subentity.setDepartmentTreeName(this.baseDataUtil.comSelectValues(subentity.getDepartmentTree()));
                subentity.setDepartmentOne(split[0]);
                subentity.setDepartmentOneName(this.baseDataUtil.comSelectValues(subentity.getDepartmentOne()));
                subentity.setDepartment(split[split.length - 1]);
                subentity.setDepartmentName(this.baseDataUtil.comSelectValues(subentity.getDepartment()));
            }
            if (ObjectUtil.isNotEmpty((Object)subentity.getIsStampType())) {
                subentity.setIsStampType(subentity.getIsStampType());
                subentity.setStampTypeName(this.baseDataUtil.getDictName(entity.getIsStampType(), Constants.STAMP_TYPE_DICT_ID));
            }
            subentity.setContractLevel(this.baseDataUtil.getDictName(subentity.getContractLevel(), Constants.CONTRACT_LEVEL_DICT_ID));
            if (CollectionUtil.isNotEmpty((Collection)oaContractUpdateUpForm.getTaxList())) {
                List jsonToList = JsonUtil.getJsonToList((Object)oaContractUpdateUpForm.getTaxList(), OaContractTaxApplyEntity.class);
                jsonToList.stream().forEach(tax -> {
                    tax.setContractId(entity.getId());
                    tax.setId(RandomUtil.uuId());
                });
                this.oaContractTaxApplyService.deleteByContractId(entity.getId());
                this.oaContractTaxApplyService.saveBatch(jsonToList);
            }
            this.oaContractPaymentApplyService.deleteByContractId(oaContractUpdateUpForm.getId());
            List paymentList = oaContractUpdateUpForm.getPaymentList();
            List jsonToList = JsonUtil.getJsonToList((Object)paymentList, OaContractPaymentApplyEntity.class);
            jsonToList.stream().forEach(payment -> {
                payment.setContractId(entity.getId());
                payment.setId(RandomUtil.uuId());
                if (!ObjectUtil.isEmpty((Object)entity.getContractAmount()) && !ObjectUtil.isEmpty((Object)payment.getPaymentRatio())) {
                    String multiply = MathUtils.multiply((String)(entity.getContractAmount() + ""), (String)(payment.getPaymentRatio() + ""));
                    String string = MathUtils.divide((String)multiply, (String)"100", (int)2);
                }
            });
            if (CollectionUtil.isNotEmpty((Collection)jsonToList)) {
                this.oaContractPaymentApplyService.saveBatch(jsonToList);
            }
            this.oaContractProductApplyService.deleteByContractId(oaContractUpdateUpForm.getId());
            List productList = oaContractUpdateUpForm.getProductList();
            productList.stream().forEach(product -> product.setContractId(oaContractUpdateUpForm.getId()));
            List productEntityList = JsonUtil.getJsonToList((Object)productList, OaContractProductApplyEntity.class);
            if (CollectionUtil.isNotEmpty((Collection)productEntityList)) {
                this.oaContractProductApplyService.saveBatch(productEntityList);
            }
            this.oaAttachmentService.deleteByContractId(oaContractUpdateUpForm.getId());
            List attachmentList = oaContractUpdateUpForm.getAttachmentList();
            attachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setContractId(oaContractUpdateUpForm.getId());
                attach.setObjId(RandomUtil.uuId());
                attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList((Object)attachmentList, OaAttachmentEntity.class);
            if (CollectionUtil.isNotEmpty((Collection)attachmentEntityList)) {
                this.oaAttachmentService.saveBatch(attachmentEntityList);
            }
            if (CollectionUtil.isNotEmpty((Collection)(doubleSignedAttachmentList = oaContractUpdateUpForm.getDoubleSignedAttachmentList()))) {
                doubleSignedAttachmentList.stream().forEach(attach -> {
                    attach.setContractId(oaContractUpdateUpForm.getId());
                    attach.setObjId(RandomUtil.uuId());
                    attach.setFileType(AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType());
                });
                List doubleSignedAttachmentEntityList = JsonUtil.getJsonToList((Object)doubleSignedAttachmentList, OaAttachmentEntity.class);
                this.oaAttachmentService.saveBatch(doubleSignedAttachmentEntityList);
                entity.setDoubleSignedAttachment(1);
            }
            if (StringUtils.isNotEmpty((String)subentity.getChangeAbout())) {
                subentity.setChangeAboutName(this.baseDataUtil.getDictName(subentity.getChangeAbout(), "ContractChangeAbout"));
                oaContractUpdateUpForm.setChangeAboutName(subentity.getChangeAboutName());
            }
            this.oaContractUpdateAppyService.update(id, subentity);
            oaContractUpdateUpForm.setDepartmentName(subentity.getDepartmentName());
            oaContractUpdateUpForm.setDepartmentOneName(subentity.getDepartmentOneName());
            oaContractUpdateUpForm.setStampTypeName(subentity.getStampTypeName());
            oaContractUpdateUpForm.setIsStamp(subentity.getIsStamp());
            oaContractUpdateUpForm.setIsStampType(subentity.getIsStampType());
            oaContractUpdateUpForm.setContractLevel(subentity.getContractLevel());
            oaContractUpdateUpForm.setSalerId(subentity.getSalerId());
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)subentity.getContractId()));
            String flowTitle = oaContractUpdateUpForm.getContractCode() + "-" + oaContractUpdateUpForm.getContractName();
            if (byId != null) {
                flowTitle = byId.getContractCode() + "" + byId.getContractName();
            }
            FlowUtil.saveOrSubmit((String)oaContractUpdateUpForm.getTaskId(), (String)flowEngineId, (String)oaContractUpdateUpForm.getTemplateId(), (String)id, (Object)((Object)oaContractUpdateUpForm), (Integer)oaContractUpdateUpForm.getStatus(), (String)flowTitle);
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaContractUpdateApplyEntity entity = this.oaContractUpdateAppyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaContractUpdateAppyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

