/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.model.rkContractVerify.RkContractVerifyInfoVO;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentListVO;
import com.bringspring.contract.model.rkcontracttax.RkContractTaxInfoVO;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractTaxService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.ReturnPlanEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaContractVoidedApplyEntity;
import com.bringspring.oa.model.oacontractvoided.OaContractVoidedCrForm;
import com.bringspring.oa.model.oacontractvoided.OaContractVoidedInfoVO;
import com.bringspring.oa.model.oacontractvoided.OaContractVoidedUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaContractVoidedApplyService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9500\u552e\u5408\u540c\u4f5c\u5e9f"}, value="OaContractVoidedApplyController")
@RequestMapping(value={"/oa/contract/voided"})
public class OaContractVoidedApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaContractVoidedApplyController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private OaContractVoidedApplyService oaContractVoidedApplyService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private RkContractPaymentService contractPaymentService;
    @Autowired
    private RkContractTaxService contractTaxService;
    @Autowired
    private RkContractProductService contractProductService;
    @Autowired
    private RkContractReturnPlanService contractReturnPlanService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private OaAttachmentService oaAttachmentService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @RepeatSubmit
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaContractVoidedCrForm oaContractVoidedCrForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String flowEngineId = "562969701760647301";
            String contractId = oaContractVoidedCrForm.getContractId();
            String mainId = RandomUtil.uuId();
            OaContractVoidedApplyEntity entity = (OaContractVoidedApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaContractVoidedCrForm), OaContractVoidedApplyEntity.class);
            entity.setId(mainId);
            this.oaContractVoidedApplyService.save(entity);
            if (CollectionUtil.isNotEmpty(oaContractVoidedCrForm.getVoidedAttachmentList())) {
                List jsonToList = JsonUtil.getJsonToList(oaContractVoidedCrForm.getVoidedAttachmentList(), OaAttachmentEntity.class);
                jsonToList.stream().forEach(e -> {
                    e.setId(RandomUtil.uuId());
                    e.setObjId(mainId);
                    e.setContractId(contractId);
                });
                this.oaAttachmentService.saveBatch(jsonToList);
            }
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)contractId));
            String flowTitle = byId.getContractName();
            byId.setVoidedTaskId(mainId);
            this.contractService.updateById((Object)byId);
            FlowUtil.saveOrSubmit((String)oaContractVoidedCrForm.getTaskId(), (String)flowEngineId, (String)oaContractVoidedCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaContractVoidedCrForm), (Integer)oaContractVoidedCrForm.getStatus(), (String)flowTitle);
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaContractVoidedUpForm oaContractVoidedUpForm) throws DataException, WorkFlowException {
        String flowEngineId = "562969701760647301";
        UserInfo userInfo = this.userProvider.get();
        OaContractVoidedApplyEntity entity = this.oaContractVoidedApplyService.getInfo(id);
        if (entity != null) {
            OaContractVoidedApplyEntity subentity = (OaContractVoidedApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaContractVoidedUpForm), OaContractVoidedApplyEntity.class);
            this.oaContractVoidedApplyService.update(id, subentity);
            this.oaAttachmentService.deleteByObjId(id);
            if (CollectionUtil.isNotEmpty(oaContractVoidedUpForm.getVoidedAttachmentList())) {
                List jsonToList = JsonUtil.getJsonToList(oaContractVoidedUpForm.getVoidedAttachmentList(), OaAttachmentEntity.class);
                jsonToList.stream().forEach(e -> {
                    e.setId(RandomUtil.uuId());
                    e.setObjId(id);
                    e.setContractId(entity.getContractId());
                });
                this.oaAttachmentService.saveBatch(jsonToList);
            }
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)entity.getContractId()));
            String flowTitle = byId.getContractName();
            FlowUtil.saveOrSubmit((String)oaContractVoidedUpForm.getTaskId(), (String)flowEngineId, (String)oaContractVoidedUpForm.getTemplateId(), (String)id, (Object)((Object)oaContractVoidedUpForm), (Integer)oaContractVoidedUpForm.getStatus(), (String)flowTitle);
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaContractVoidedInfoVO> info(@PathVariable(value="id") String id) {
        RkContractEntity entity;
        OaContractVoidedApplyEntity applyEntity = this.oaContractVoidedApplyService.getInfo(id);
        entity.setCustomerName(ObjectUtil.isEmpty((Object)(entity = (RkContractEntity)this.contractService.getById((Serializable)((Object)applyEntity.getContractId()))).getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()))).getName());
        String[] split = entity.getDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",");
        OaContractVoidedInfoVO vo = (OaContractVoidedInfoVO)((Object)JsonUtil.getJsonToBean((Object)entity, OaContractVoidedInfoVO.class));
        vo.setId(id);
        vo.setVoidedRemark(applyEntity.getVoidedRemark());
        vo.setVoidedAttachmentList(this.oaAttachmentService.listByBussinessObjId(id));
        vo.setDepartmentTree(Arrays.asList(split));
        vo.setSalerName(entity.getSalerName());
        vo.setContractLevel(entity.getContractLevel());
        vo.setContractTypeDesc(this.baseDataUtil.getDictName(vo.getContractTypeDesc(), Constants.CONTRACT_TYPE_DICT_ID));
        vo.setIndustryTypeDesc(this.baseDataUtil.getDictName(vo.getIndustryType(), ""));
        vo.setIncomeTypeDesc(this.baseDataUtil.getDictName(vo.getIncomeType(), ""));
        vo.setRegionName(entity.getRegionName());
        vo.setDepartmentName(entity.getDepartmentTreeName());
        vo.setIsNeedPayAdvance(entity.getIsNeedPayAdvance());
        vo.setIsStamp(entity.getIsStamp());
        vo.setIsSubcontract(entity.getIsSubcontract());
        vo.setProfitAmount(entity.getProfitAmount());
        if (!ObjectUtil.isEmpty((Object)vo.getIsArchived()) && StrUtil.equals((CharSequence)vo.getIsArchived(), (CharSequence)"1")) {
            vo.setArchivedLocation(this.baseDataUtil.getDictName(vo.getArchivedLocation(), Constants.ARCHIVELOCATION_DICT_ID));
            vo.setArchivedBy(this.baseDataUtil.userSelectValueNoAccount(vo.getArchivedBy()));
        }
        if (!ObjectUtil.isEmpty((Object)vo.getIsAgent()) && StrUtil.equals((CharSequence)vo.getIsAgent(), (CharSequence)"1")) {
            if (!ObjectUtil.isEmpty((Object)vo.getAgentId())) {
                vo.setAgentName(((RkAgentEntity)this.agentService.getById((Serializable)((Object)vo.getAgentId()))).getName());
            }
        } else {
            vo.setAgentName(vo.getCustomerName());
        }
        vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        List listByContractId = this.contractPaymentService.getListByContractId(applyEntity.getContractId());
        List jsonToList = JsonUtil.getJsonToList((Object)listByContractId, RkContractPaymentListVO.class);
        vo.setPaymentList(jsonToList);
        List rkContractTaxEntities = this.contractTaxService.listByContractId(applyEntity.getContractId());
        List jsonToList1 = JsonUtil.getJsonToList((Object)rkContractTaxEntities, RkContractTaxInfoVO.class);
        vo.setTaxList(jsonToList1);
        List planList = this.contractReturnPlanService.getPlanByContractId(vo.getId());
        if (CollectionUtil.isNotEmpty((Collection)planList)) {
            BigDecimal bigDecimal = planList.stream().map(RkContractReturnPlanEntity::getReceivableAmount).reduce(BigDecimal::add).get();
            vo.setPlanTotalAmount(bigDecimal);
        }
        vo.setPlanNum(planList.size());
        List collect = planList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getDueDate()) && x.getReturnState() != ReturnPlanEnum.END.getState() && DateUtil.dateToString((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd").compareTo(DateUtil.dateToString((Date)x.getDueDate(), (String)"yyyy-MM-dd")) > 0).collect(Collectors.toList());
        BigDecimal arrearsAmount = collect.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
        vo.setArrearsAmount(arrearsAmount);
        vo.setIsOverdue(CollectionUtil.isNotEmpty(collect) ? 1 : 0);
        return ActionResult.success((Object)((Object)vo));
    }

    @RepeatSubmit
    @PutMapping(value={"execute/{id}"})
    public ActionResult execute(@PathVariable(value="id") String id) {
        String userId = this.userProvider.get().getUserId();
        OaContractVoidedApplyEntity byId = (OaContractVoidedApplyEntity)this.oaContractVoidedApplyService.getById((Serializable)((Object)id));
        RkContractEntity byId1 = (RkContractEntity)this.contractService.getById((Serializable)((Object)byId.getContractId()));
        if (ObjectUtil.isNotNull((Object)byId1)) {
            if (!ObjectUtil.equals((Object)byId1.getVoidedTaskEnable(), (Object)2)) {
                return ActionResult.fail((String)"\u4f5c\u5e9f\u6d41\u7a0b\u8fd8\u672a\u5ba1\u6838\u901a\u8fc7\uff0c\u4e0d\u80fd\u4f5c\u5e9f");
            }
        } else {
            return ActionResult.fail((String)"\u5408\u540c\u4e0d\u5b58\u5728");
        }
        this.contractService.voidedContract(byId.getContractId(), byId.getVoidedRemark(), userId);
        return ActionResult.success((String)"\u786e\u8ba4\u4f5c\u5e9f\u6210\u529f");
    }

    @GetMapping(value={"/detailApp/{id}"})
    public ActionResult<RkContractVerifyInfoVO> detailAppInfo(@PathVariable(value="id") String id) {
        OaContractVoidedApplyEntity byId = (OaContractVoidedApplyEntity)this.oaContractVoidedApplyService.getById((Serializable)((Object)id));
        RkContractEntity entity = this.contractService.getInfo(byId.getContractId());
        RkContractVerifyInfoVO vo = (RkContractVerifyInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractVerifyInfoVO.class);
        vo.setVoidedRemark(byId.getVoidedRemark());
        vo.setSalerId(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
        vo.setRegion(this.baseDataUtil.provinceData(vo.getRegion()));
        vo.setDepartment(entity.getDepartmentTreeName());
        vo.setIsNeedPayAdvance(vo.getIsNeedPayAdvance());
        vo.setIsStamp(vo.getIsStamp());
        vo.setIsSubcontract(vo.getIsSubcontract());
        vo.setProfitAmount(vo.getProfitAmount());
        vo.setStartContractTime(vo.getStartContractTime());
        vo.setEndContractTime(vo.getEndContractTime());
        vo.setPaymentMethodType(this.baseDataUtil.getDictName(vo.getPaymentMethodType(), Constants.PAYMENT_METHOD_TYPE));
        vo.setIndustryType(this.baseDataUtil.getDictName(vo.getIndustryType(), Constants.INDUSTRY_TYPE));
        vo.setContractTaxRate(this.baseDataUtil.getDictName(vo.getContractTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        vo.setIsStampType(this.baseDataUtil.getDictName(vo.getIsStampType(), Constants.STAMP_TYPE_DICT_ID));
        vo.setIncomeType(this.baseDataUtil.getDictName(vo.getIncomeType(), Constants.CONTRACT_INCOME_TYPE_DICT_ID));
        vo.setContractLevel(this.baseDataUtil.getDictName(vo.getContractLevel(), Constants.CONTRACT_LEVEL_DICT_ID));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractVerifyInfoVO> detailInfo(@PathVariable(value="id") String id) {
        String collect1;
        OaContractVoidedApplyEntity byId = (OaContractVoidedApplyEntity)this.oaContractVoidedApplyService.getById((Serializable)((Object)id));
        RkContractEntity entity = this.contractService.getInfo(byId.getContractId());
        RkContractVerifyInfoVO vo1 = (RkContractVerifyInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractVerifyInfoVO.class);
        vo1.setVoidedRemark(byId.getVoidedRemark());
        vo1.setSalerId(this.baseDataUtil.userSelectValue(vo1.getSalerId()));
        vo1.setIsNeedPayAdvance(vo1.getIsNeedPayAdvance());
        vo1.setIsStamp(vo1.getIsStamp());
        vo1.setIsSubcontract(vo1.getIsSubcontract());
        vo1.setProfitAmount(vo1.getProfitAmount());
        vo1.setStartContractTime(vo1.getStartContractTime());
        vo1.setEndContractTime(vo1.getEndContractTime());
        vo1.setContractTaxRate(this.baseDataUtil.getDictName(vo1.getContractTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        vo1.setCostTaxRate(this.baseDataUtil.getDictName(vo1.getCostTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        vo1.setContractType(this.baseDataUtil.getDictName(vo1.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        vo1.setIsStampType(this.baseDataUtil.getDictName(vo1.getIsStampType(), Constants.STAMP_TYPE_DICT_ID));
        vo1.setPaymentMethodType(this.baseDataUtil.getDictName(vo1.getPaymentMethodType(), Constants.PAYMENT_METHOD_TYPE));
        vo1.setIndustryType(this.baseDataUtil.getDictName(vo1.getIndustryType(), Constants.INDUSTRY_TYPE));
        vo1.setIncomeType(this.baseDataUtil.getDictName(vo1.getIncomeType(), Constants.CONTRACT_INCOME_TYPE_DICT_ID));
        vo1.setContractTypeDesc(this.baseDataUtil.getDictName(vo1.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        vo1.setFinancialAcceptanceUser(this.baseDataUtil.userSelectValues(vo1.getFinancialAcceptanceUser()));
        vo1.setSalesSupportUser(this.baseDataUtil.userSelectValues(vo1.getSalesSupportUser()));
        vo1.setOpportunityAssistanceUser(this.baseDataUtil.userSelectValues(vo1.getOpportunityAssistanceUser()));
        vo1.setProposalProducer(this.baseDataUtil.userSelectValues(vo1.getProposalProducer()));
        vo1.setAssistingUser(this.baseDataUtil.userSelectValues(vo1.getAssistingUser()));
        vo1.setRegion(entity.getRegionName());
        vo1.setDepartment(entity.getDepartmentTreeName());
        vo1.setCustomerName(ObjectUtil.isEmpty((Object)vo1.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo1.getCustomerId()))).getName());
        if (!ObjectUtil.isEmpty((Object)vo1.getIsAgent()) && StrUtil.equals((CharSequence)vo1.getIsAgent(), (CharSequence)"1")) {
            RkAgentEntity agentEntity = (RkAgentEntity)this.agentService.getById((Serializable)((Object)vo1.getAgentId()));
            vo1.setAgentName(ObjectUtil.isEmpty((Object)vo1.getAgentId()) ? "" : agentEntity.getName());
            vo1.setAgentType(ObjectUtil.isEmpty((Object)vo1.getAgentId()) ? "" : this.baseDataUtil.getDictName(agentEntity.getType(), ""));
        }
        if (!ObjectUtil.isEmpty((Object)vo1.getIsAgent()) && StrUtil.equals((CharSequence)vo1.getIsAgent(), (CharSequence)"0")) {
            vo1.setAgentName(vo1.getCustomerName());
        }
        vo1.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo1.getCreatorUserId()));
        vo1.setMasterId(ObjectUtil.isEmpty((Object)vo1.getMasterId()) ? "" : ((RkContractEntity)this.contractService.getById((Serializable)((Object)vo1.getMasterId()))).getContractName());
        vo1.setEnableMarkDesc(this.baseDataUtil.getDictName(vo1.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
        vo1.setCustomerRegion(entity.getCustomerRegionName());
        vo1.setArchivedByDesc(this.baseDataUtil.userSelectValueNoAccount(vo1.getArchivedBy()));
        vo1.setArchivedLocationDesc(this.baseDataUtil.getDictName(vo1.getArchivedLocation(), ""));
        List planList = this.contractReturnPlanService.getPlanByContractId(vo1.getId());
        vo1.setPlanNum(Integer.valueOf(planList.size()));
        List collect = planList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getDueDate()) && x.getReturnState() != ReturnPlanEnum.END.getState() && DateUtil.dateToString((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd").compareTo(DateUtil.dateToString((Date)x.getDueDate(), (String)"yyyy-MM-dd")) > 0).collect(Collectors.toList());
        BigDecimal arrearsAmount = collect.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
        vo1.setArrearsAmount(arrearsAmount);
        List listByContractId = this.contractPaymentService.getListByContractId(id);
        List jsonToList = JsonUtil.getJsonToList((Object)listByContractId, RkContractPaymentListVO.class);
        vo1.setPaymentList(jsonToList);
        List rkContractTaxEntities = this.contractTaxService.listByContractId(id);
        List jsonToList1 = JsonUtil.getJsonToList((Object)rkContractTaxEntities, RkContractTaxInfoVO.class);
        vo1.setTaxList(jsonToList1);
        if (vo1.getIsMoreTax() != null && vo1.getIsMoreTax() == 1 && CollectionUtil.isNotEmpty((Collection)jsonToList1)) {
            collect1 = jsonToList1.stream().filter(i -> !i.getTaxType().equals("cost")).map(RkContractTaxInfoVO::getTaxName).collect(Collectors.joining(","));
            vo1.setContractTaxRate(collect1);
        }
        if (vo1.getCostIsMoreTax() != null && vo1.getCostIsMoreTax() == 1 && CollectionUtil.isNotEmpty((Collection)jsonToList1)) {
            collect1 = jsonToList1.stream().filter(i -> i.getTaxType().equals("cost")).map(RkContractTaxInfoVO::getTaxName).collect(Collectors.joining(","));
            vo1.setCostTaxRate(collect1);
        }
        return ActionResult.success((Object)vo1);
    }
}

