/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.oa.entity.OaFeeStatementEntity;
import com.bringspring.oa.entity.OaFeeStatementRecordEntity;
import com.bringspring.oa.entity.OaFeeStatementTypeEntity;
import com.bringspring.oa.model.oaFeeStatementRecord.OaFeeStatementRecordInfoVO;
import com.bringspring.oa.model.oafeestatement.OaFeeStatementCrForm;
import com.bringspring.oa.model.oafeestatement.OaFeeStatementInfoVO;
import com.bringspring.oa.model.oafeestatement.OaFeeStatementListVO;
import com.bringspring.oa.model.oafeestatement.OaFeeStatementPagination;
import com.bringspring.oa.model.oafeestatement.OaFeeStatementPaginationExportModel;
import com.bringspring.oa.model.oafeestatement.OaFeeStatementUpForm;
import com.bringspring.oa.model.oafeestatementtype.OaFeeStatementTypeInfoVO;
import com.bringspring.oa.service.OaFeeStatementRecordService;
import com.bringspring.oa.service.OaFeeStatementService;
import com.bringspring.oa.service.OaFeeStatementTypeService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u516c\u53f8\u5185\u7ed3\u7b97\u5355"}, value="oa")
@RequestMapping(value={"/api/oa/OaFeeStatement"})
public class OaFeeStatementController {
    private static final Logger log = LoggerFactory.getLogger(OaFeeStatementController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaFeeStatementService oaFeeStatementService;
    @Autowired
    private OaFeeStatementRecordService oaFeeStatementRecordService;
    @Autowired
    private OaFeeStatementTypeService oaFeeStatementTypeService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaFeeStatementPagination oaFeeStatementPagination) throws IOException {
        List<OaFeeStatementEntity> list = this.oaFeeStatementService.getList(oaFeeStatementPagination);
        for (OaFeeStatementEntity oaFeeStatementEntity : list) {
            oaFeeStatementEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaFeeStatementEntity.getCreatorUserId()));
            oaFeeStatementEntity.setCustomer(this.baseDataUtil.getDictName(oaFeeStatementEntity.getCustomer(), "539402717295029381"));
            oaFeeStatementEntity.setBCompany(this.baseDataUtil.getDictName(oaFeeStatementEntity.getBCompany(), "539402717295029381"));
            oaFeeStatementEntity.setStatementType(this.baseDataUtil.getDictName(oaFeeStatementEntity.getStatementType(), "609005292012728261"));
            oaFeeStatementEntity.setOthersApprover(this.baseDataUtil.userSelectValues(oaFeeStatementEntity.getOthersApprover()));
            oaFeeStatementEntity.setInvoiceType(this.baseDataUtil.getDictName(oaFeeStatementEntity.getInvoiceType(), "4412015332126938291"));
            oaFeeStatementEntity.setTaxRate(this.baseDataUtil.getDictName(oaFeeStatementEntity.getTaxRate(), "4360623057975783731"));
            oaFeeStatementEntity.setAttachments(this.baseDataUtil.getFileNameInJson(oaFeeStatementEntity.getAttachments()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaFeeStatementListVO.class);
        for (OaFeeStatementListVO vo : listVO) {
            vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setTaxRateName(vo.getTaxRate());
            if (!ObjectUtil.isNotEmpty((Object)vo.getContractCompanyId())) continue;
            vo.setContractCompanyName(((OrganizeEntity)this.organizeService.getById((Serializable)((Object)vo.getContractCompanyId()))).getShortName());
        }
        for (OaFeeStatementListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaFeeStatementPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @RepeatSubmit
    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OaFeeStatementCrForm oaFeeStatementCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "617265313825717381";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaFeeStatementCrForm.setCreatorUserId(userInfo.getUserId());
        oaFeeStatementCrForm.setCreatorTime(DateUtil.getNow());
        oaFeeStatementCrForm.setCreatorUserId(this.baseDataUtil.userSelectValue(oaFeeStatementCrForm.getCreatorUserId()));
        oaFeeStatementCrForm.setCustomerName(this.baseDataUtil.getDictName(oaFeeStatementCrForm.getCustomer(), "539402717295029381"));
        oaFeeStatementCrForm.setBCompanyName(this.baseDataUtil.getDictName(oaFeeStatementCrForm.getBCompany(), "539402717295029381"));
        oaFeeStatementCrForm.setStatementTypeName(this.baseDataUtil.getDictName(oaFeeStatementCrForm.getStatementType(), "609005292012728261"));
        oaFeeStatementCrForm.setInvoiceTypeName(this.baseDataUtil.getDictName(oaFeeStatementCrForm.getInvoiceType(), "4412015332126938291"));
        oaFeeStatementCrForm.setTaxRateName(this.baseDataUtil.getDictName(oaFeeStatementCrForm.getTaxRate(), "4360623057975783731"));
        if (StringUtils.isNotEmpty((Object[])oaFeeStatementCrForm.getSettlementDate())) {
            oaFeeStatementCrForm.setSettlementStartDate(oaFeeStatementCrForm.getSettlementDate()[0]);
            oaFeeStatementCrForm.setSettlementEndDate(oaFeeStatementCrForm.getSettlementDate()[1]);
        }
        oaFeeStatementCrForm.setSettlementAmount(StringUtils.replace((String)oaFeeStatementCrForm.getSettlementAmount(), (String)",", (String)""));
        String title = oaFeeStatementCrForm.getCustomerName();
        if (StrUtil.equals((CharSequence)"\u5176\u4ed6", (CharSequence)oaFeeStatementCrForm.getStatementTypeName())) {
            title = "-" + title + oaFeeStatementCrForm.getStatementTypeOthers();
        }
        if (oaFeeStatementCrForm.getStatementType().equals("617266047224937605")) {
            this.oaFeeStatementService.saveSettlementRecord(mainId, oaFeeStatementCrForm);
        }
        OaFeeStatementEntity entity = (OaFeeStatementEntity)JsonUtil.getJsonToBean((Object)oaFeeStatementCrForm, OaFeeStatementEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        this.oaFeeStatementService.save(entity);
        FlowUtil.saveOrSubmit((String)oaFeeStatementCrForm.getTaskId(), (String)flowEngineId, (String)oaFeeStatementCrForm.getTemplateId(), (String)mainId, (Object)oaFeeStatementCrForm, (Integer)oaFeeStatementCrForm.getStatus(), (String)title);
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/Export"})
    public ActionResult Export(@RequestBody OaFeeStatementPaginationExportModel oaFeeStatementPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaFeeStatementPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaFeeStatementPagination oaFeeStatementPagination = (OaFeeStatementPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaFeeStatementPaginationExportModel), OaFeeStatementPagination.class));
        List<OaFeeStatementEntity> list = this.oaFeeStatementService.getTypeList(oaFeeStatementPagination, oaFeeStatementPaginationExportModel.getDataType());
        for (OaFeeStatementEntity oaFeeStatementEntity : list) {
            oaFeeStatementEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaFeeStatementEntity.getCreatorUserId()));
            oaFeeStatementEntity.setCustomer(this.baseDataUtil.getDictName(oaFeeStatementEntity.getCustomer(), "539402717295029381"));
            oaFeeStatementEntity.setBCompany(this.baseDataUtil.getDictName(oaFeeStatementEntity.getBCompany(), "539402717295029381"));
            oaFeeStatementEntity.setStatementType(this.baseDataUtil.getDictName(oaFeeStatementEntity.getStatementType(), "609005292012728261"));
            oaFeeStatementEntity.setOthersApprover(this.baseDataUtil.userSelectValues(oaFeeStatementEntity.getOthersApprover()));
            oaFeeStatementEntity.setInvoiceType(this.baseDataUtil.getDictName(oaFeeStatementEntity.getInvoiceType(), "4412015332126938291"));
            oaFeeStatementEntity.setTaxRate(this.baseDataUtil.getDictName(oaFeeStatementEntity.getTaxRate(), "4360623057975783731"));
            oaFeeStatementEntity.setAttachments(this.baseDataUtil.getFileNameInJson(oaFeeStatementEntity.getAttachments()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaFeeStatementListVO.class);
        for (OaFeeStatementListVO vo : listVO) {
            vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setTaxRateName(vo.getTaxRate());
            vo.setContractCompanyName(((OrganizeEntity)this.organizeService.getById((Serializable)((Object)vo.getContractCompanyId()))).getShortName());
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaFeeStatementPaginationExportModel.getSelectKey()) ? oaFeeStatementPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block42: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "contractCompanyName": {
                        entitys.add(new ExcelExportEntity("\u7ed3\u7b97\u516c\u53f8", (Object)"contractCompanyName"));
                        continue block42;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u7532\u65b9\uff08\u4ed8\u6b3e\u65b9\uff09", (Object)"customerName"));
                        continue block42;
                    }
                    case "bCompanyName": {
                        entitys.add(new ExcelExportEntity("\u4e59\u65b9\uff08\u6536\u6b3e\u65b9\uff09", (Object)"bCompanyName"));
                        continue block42;
                    }
                    case "statementTypeName": {
                        entitys.add(new ExcelExportEntity("\u7c7b\u578b", (Object)"statementTypeName"));
                        continue block42;
                    }
                    case "settlementStartDate": {
                        entitys.add(new ExcelExportEntity("\u7ed3\u7b97\u5f00\u59cb\u65e5\u671f", (Object)"settlementStartDate"));
                        continue block42;
                    }
                    case "settlementEndDate": {
                        entitys.add(new ExcelExportEntity("\u7ed3\u7b97\u7ed3\u675f\u65e5\u671f", (Object)"settlementEndDate"));
                        continue block42;
                    }
                    case "invoiceTypeName": {
                        entitys.add(new ExcelExportEntity("\u53d1\u7968\u7c7b\u578b", (Object)"invoiceTypeName"));
                        continue block42;
                    }
                    case "taxItems": {
                        entitys.add(new ExcelExportEntity("\u7a0e\u76ee", (Object)"taxItems"));
                        continue block42;
                    }
                    case "taxRateName": {
                        entitys.add(new ExcelExportEntity("\u7a0e\u7387", (Object)"taxRateName"));
                        continue block42;
                    }
                    case "confirmIncome": {
                        entitys.add(new ExcelExportEntity("\u786e\u8ba4\u6536\u5165(\u5143)", (Object)"confirmIncome"));
                        continue block42;
                    }
                    case "baseCharge": {
                        entitys.add(new ExcelExportEntity("\u57fa\u7840\u8d39\u7528(\u5143)", (Object)"baseCharge"));
                        continue block42;
                    }
                    case "paymentReward": {
                        entitys.add(new ExcelExportEntity("\u56de\u6b3e\u5956\u52b1(\u5143)", (Object)"paymentReward"));
                        continue block42;
                    }
                    case "settlementAmount": {
                        entitys.add(new ExcelExportEntity("\u7ed3\u7b97\u91d1\u989d(\u5143)", (Object)"settlementAmount"));
                        continue block42;
                    }
                    case "creatorUserName": {
                        entitys.add(new ExcelExportEntity("\u63d0\u4ea4\u4eba", (Object)"creatorUserName"));
                        continue block42;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u63d0\u4ea4\u65f6\u95f4", (Object)"creatorTime"));
                        continue block42;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u7ed3\u7b97\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaFeeStatementInfoVO> info(@PathVariable(value="id") String id) {
        OaFeeStatementEntity entity = this.oaFeeStatementService.getInfo(id);
        OaFeeStatementInfoVO vo = (OaFeeStatementInfoVO)JsonUtil.getJsonToBean((Object)entity, OaFeeStatementInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        if (ObjectUtil.isNotEmpty((Object)entity.getSettlementStartDate()) && ObjectUtil.isNotEmpty((Object)entity.getSettlementEndDate())) {
            Date[] res = new Date[]{entity.getSettlementStartDate(), entity.getSettlementEndDate()};
            vo.setSettlementDate(res);
        }
        List<OaFeeStatementRecordEntity> recordList = this.oaFeeStatementRecordService.getInfoByStatementId(id);
        List recordInfoVOList = JsonUtil.getJsonToList(recordList, OaFeeStatementRecordInfoVO.class);
        recordInfoVOList.stream().forEach(record -> {
            RkContractEntity contractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)record.getContractId()));
            if (ObjectUtil.isNotEmpty((Object)contractEntity)) {
                record.setContractName(contractEntity.getContractName());
                record.setContractCode(contractEntity.getContractCode());
                record.setContractAmount(contractEntity.getContractAmount());
                record.setValidContractAmount(contractEntity.getValidContractAmount());
                record.setSalerName(contractEntity.getSalerName());
                record.setArchivedTime(contractEntity.getArchivedTime());
                Object customer = null;
                RkAgentEntity agent = null;
                HashMap customerMap = MapUtil.newHashMap();
                HashMap agentMap = MapUtil.newHashMap();
                List companyCustomer = this.crmCustomerService.getCompanyCustomer();
                companyCustomer.stream().forEach(x -> customerMap.put(x.getId(), x));
                this.rkAgentService.listSimpleIdAndName().stream().forEach(x -> agentMap.put(x.getId(), x));
                if (StringUtils.isNotEmpty((String)contractEntity.getCustomerIds())) {
                    String customerNames = "";
                    List customerNameList = CollectionUtil.list((boolean)false);
                    if (StrUtil.isNotBlank((CharSequence)contractEntity.getCustomerIds())) {
                        String[] split;
                        for (String customerId : split = contractEntity.getCustomerIds().split(",")) {
                            if (!customerMap.containsKey(customerId)) continue;
                            CrmCustomerEntity customer1 = (CrmCustomerEntity)customerMap.get(customerId);
                            customerNameList.add(customer1.getName());
                        }
                    }
                    if (CollectionUtil.isNotEmpty((Collection)customerNameList)) {
                        customerNames = StrUtil.join((CharSequence)",", (Iterable)customerNameList);
                    }
                    if (StrUtil.isBlank((CharSequence)customerNames)) {
                        customerNames = this.saleContractCustomerService.getCustomerNamesByContractId(record.getContractId());
                    }
                    record.setCustomerNames(customerNames);
                }
                if ("1".equals(contractEntity.getIsAgent())) {
                    if (StringUtils.isNotEmpty((String)contractEntity.getAgentId()) && null != (agent = agentMap.containsKey(contractEntity.getAgentId()) ? (RkAgentEntity)agentMap.get(contractEntity.getAgentId()) : this.rkAgentService.getInfo(contractEntity.getAgentId()))) {
                        record.setAgentName(agent.getName());
                    }
                } else {
                    record.setAgentName(record.getCustomerNames());
                }
            }
        });
        vo.setRecordList(recordInfoVOList);
        List<OaFeeStatementTypeEntity> serviceFeeList = this.oaFeeStatementTypeService.getListByStatementId(id, "serviceFee");
        List serviceFeeInfoVOList = JsonUtil.getJsonToList(serviceFeeList, OaFeeStatementTypeInfoVO.class);
        serviceFeeInfoVOList.stream().forEach(service -> this.setStatementTypeList((OaFeeStatementTypeInfoVO)service));
        vo.setServiceFeelList(serviceFeeInfoVOList);
        List<OaFeeStatementTypeEntity> returnPaymentList = this.oaFeeStatementTypeService.getListByStatementId(id, "returnPayment");
        List returnPaymentInfoVOList = JsonUtil.getJsonToList(returnPaymentList, OaFeeStatementTypeInfoVO.class);
        returnPaymentInfoVOList.stream().forEach(returnPayment -> this.setStatementTypeList((OaFeeStatementTypeInfoVO)returnPayment));
        vo.setReturnPaymentList(returnPaymentInfoVOList);
        return ActionResult.success((Object)vo);
    }

    public void setStatementTypeList(OaFeeStatementTypeInfoVO oaFeeStatementTypeInfoVO) {
        RkContractEntity contractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)oaFeeStatementTypeInfoVO.getContractId()));
        if (ObjectUtil.isNotEmpty((Object)contractEntity)) {
            oaFeeStatementTypeInfoVO.setContractName(contractEntity.getContractName());
            oaFeeStatementTypeInfoVO.setContractCode(contractEntity.getContractCode());
            oaFeeStatementTypeInfoVO.setContractAmount(contractEntity.getContractAmount());
            oaFeeStatementTypeInfoVO.setValidContractAmount(contractEntity.getValidContractAmount());
            oaFeeStatementTypeInfoVO.setSalerName(contractEntity.getSalerName());
            oaFeeStatementTypeInfoVO.setArchivedTime(contractEntity.getArchivedTime());
            Object customer = null;
            RkAgentEntity agent = null;
            HashMap customerMap = MapUtil.newHashMap();
            HashMap agentMap = MapUtil.newHashMap();
            List companyCustomer = this.crmCustomerService.getCompanyCustomer();
            companyCustomer.stream().forEach(x -> customerMap.put(x.getId(), x));
            this.rkAgentService.listSimpleIdAndName().stream().forEach(x -> agentMap.put(x.getId(), x));
            if (StringUtils.isNotEmpty((String)contractEntity.getCustomerIds())) {
                String customerNames = "";
                List customerNameList = CollectionUtil.list((boolean)false);
                if (StrUtil.isNotBlank((CharSequence)contractEntity.getCustomerIds())) {
                    String[] split;
                    for (String customerId : split = contractEntity.getCustomerIds().split(",")) {
                        if (!customerMap.containsKey(customerId)) continue;
                        CrmCustomerEntity customer1 = (CrmCustomerEntity)customerMap.get(customerId);
                        customerNameList.add(customer1.getName());
                    }
                }
                if (CollectionUtil.isNotEmpty((Collection)customerNameList)) {
                    customerNames = StrUtil.join((CharSequence)",", (Iterable)customerNameList);
                }
                if (StrUtil.isBlank((CharSequence)customerNames)) {
                    customerNames = this.saleContractCustomerService.getCustomerNamesByContractId(oaFeeStatementTypeInfoVO.getId());
                }
                oaFeeStatementTypeInfoVO.setCustomerNames(customerNames);
            }
            if ("1".equals(contractEntity.getIsAgent())) {
                if (StringUtils.isNotEmpty((String)contractEntity.getAgentId()) && null != (agent = agentMap.containsKey(contractEntity.getAgentId()) ? (RkAgentEntity)agentMap.get(contractEntity.getAgentId()) : this.rkAgentService.getInfo(contractEntity.getAgentId()))) {
                    oaFeeStatementTypeInfoVO.setAgentName(agent.getName());
                }
            } else {
                oaFeeStatementTypeInfoVO.setAgentName(oaFeeStatementTypeInfoVO.getCustomerNames());
            }
        }
    }

    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaFeeStatementUpForm oaFeeStatementUpForm) throws DataException, WorkFlowException {
        oaFeeStatementUpForm.setCreatorUserId(this.baseDataUtil.userSelectValue(oaFeeStatementUpForm.getCreatorUserId()));
        oaFeeStatementUpForm.setCustomerName(this.baseDataUtil.getDictName(oaFeeStatementUpForm.getCustomer(), "539402717295029381"));
        oaFeeStatementUpForm.setBCompanyName(this.baseDataUtil.getDictName(oaFeeStatementUpForm.getBCompany(), "539402717295029381"));
        oaFeeStatementUpForm.setStatementTypeName(this.baseDataUtil.getDictName(oaFeeStatementUpForm.getStatementType(), "609005292012728261"));
        oaFeeStatementUpForm.setInvoiceTypeName(this.baseDataUtil.getDictName(oaFeeStatementUpForm.getInvoiceType(), "4412015332126938291"));
        oaFeeStatementUpForm.setTaxRateName(this.baseDataUtil.getDictName(oaFeeStatementUpForm.getTaxRate(), "4360623057975783731"));
        if (StringUtils.isNotEmpty((Object[])oaFeeStatementUpForm.getSettlementDate())) {
            oaFeeStatementUpForm.setSettlementStartDate(oaFeeStatementUpForm.getSettlementDate()[0]);
            oaFeeStatementUpForm.setSettlementEndDate(oaFeeStatementUpForm.getSettlementDate()[1]);
        }
        oaFeeStatementUpForm.setSettlementAmount(StringUtils.replace((String)oaFeeStatementUpForm.getSettlementAmount(), (String)",", (String)""));
        String title = oaFeeStatementUpForm.getCustomerName();
        if (StrUtil.equals((CharSequence)"\u5176\u4ed6", (CharSequence)oaFeeStatementUpForm.getStatementTypeName())) {
            title = "-" + title + oaFeeStatementUpForm.getStatementTypeOthers();
        }
        String flowEngineId = "617265313825717381";
        UserInfo userInfo = this.userProvider.get();
        OaFeeStatementEntity entity = this.oaFeeStatementService.getInfo(id);
        if (entity != null) {
            OaFeeStatementEntity subentity = (OaFeeStatementEntity)JsonUtil.getJsonToBean((Object)oaFeeStatementUpForm, OaFeeStatementEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            if (oaFeeStatementUpForm.getStatementType().equals("617266047224937605")) {
                this.oaFeeStatementService.updateSettlementRecord(id, oaFeeStatementUpForm);
            }
            subentity.setCompanyId(userInfo.getOrganizeId());
            this.oaFeeStatementService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)oaFeeStatementUpForm.getTaskId(), (String)flowEngineId, (String)oaFeeStatementUpForm.getTemplateId(), (String)id, (Object)oaFeeStatementUpForm, (Integer)oaFeeStatementUpForm.getStatus(), (String)title);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaFeeStatementEntity entity = this.oaFeeStatementService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaFeeStatementService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

