/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.oa.entity.OaFeeStatementRecordEntity;
import com.bringspring.oa.model.oaFeeStatementRecord.OaFeeStatementRecordCrForm;
import com.bringspring.oa.model.oaFeeStatementRecord.OaFeeStatementRecordInfoVO;
import com.bringspring.oa.model.oaFeeStatementRecord.OaFeeStatementRecordListVO;
import com.bringspring.oa.model.oaFeeStatementRecord.OaFeeStatementRecordPagination;
import com.bringspring.oa.model.oaFeeStatementRecord.OaFeeStatementRecordPaginationExportModel;
import com.bringspring.oa.model.oaFeeStatementRecord.OaFeeStatementRecordUpForm;
import com.bringspring.oa.service.OaFeeStatementRecordService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u667a\u533b\u7ed3\u7b97\u5355\u660e\u7ec6"}, value="oa")
@RequestMapping(value={"/api/oa/OaFeeStatementRecord"})
public class OaFeeStatementRecordController {
    private static final Logger log = LoggerFactory.getLogger(OaFeeStatementRecordController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaFeeStatementRecordService oaFeeStatementRecordService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private CrmCustomerService crmCustomerService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaFeeStatementRecordPagination oaFeeStatementRecordPagination) throws IOException {
        List<OaFeeStatementRecordEntity> list = this.oaFeeStatementRecordService.getList(oaFeeStatementRecordPagination);
        for (OaFeeStatementRecordEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, OaFeeStatementRecordListVO.class);
        for (OaFeeStatementRecordListVO oaFeeStatementRecordListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaFeeStatementRecordPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid OaFeeStatementRecordCrForm oaFeeStatementRecordCrForm) throws DataException {
        this.oaFeeStatementRecordService.create(oaFeeStatementRecordCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaFeeStatementRecordInfoVO> info(@PathVariable(value="id") String id) {
        OaFeeStatementRecordEntity entity = this.oaFeeStatementRecordService.getInfo(id);
        OaFeeStatementRecordInfoVO vo = (OaFeeStatementRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, OaFeeStatementRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaFeeStatementRecordInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OaFeeStatementRecordEntity entity = this.oaFeeStatementRecordService.getInfo(id);
        OaFeeStatementRecordInfoVO vo = (OaFeeStatementRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, OaFeeStatementRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaFeeStatementRecordUpForm oaFeeStatementRecordUpForm) throws DataException {
        this.oaFeeStatementRecordService.update(id, oaFeeStatementRecordUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaFeeStatementRecordEntity entity = this.oaFeeStatementRecordService.getInfo(id);
        if (entity != null) {
            this.oaFeeStatementRecordService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/ExportForSettlementRecord"})
    public ActionResult ExportForSettlementRecord(@RequestBody OaFeeStatementRecordPaginationExportModel oaFeeStatementRecordPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)oaFeeStatementRecordPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaFeeStatementRecordPagination oaFeeStatementRecordPagination = (OaFeeStatementRecordPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaFeeStatementRecordPaginationExportModel), OaFeeStatementRecordPagination.class));
        List<OaFeeStatementRecordEntity> list = this.oaFeeStatementRecordService.getTypeList(oaFeeStatementRecordPagination, oaFeeStatementRecordPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, OaFeeStatementRecordListVO.class);
        listVO.stream().forEach(record -> {
            RkContractEntity contractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)record.getContractId()));
            record.setContractCode(contractEntity.getContractCode());
            record.setArchivedTime(contractEntity.getArchivedTime());
            record.setSalerName(contractEntity.getSalerName());
            record.setContractAmount(contractEntity.getContractAmount());
            record.setValidContractAmount(contractEntity.getValidContractAmount());
            if (ObjectUtil.isEmpty((Object)record.getValidContractAmount())) {
                record.setValidContractAmount(BigDecimal.ZERO);
            }
            Object customer = null;
            RkAgentEntity agent = null;
            HashMap customerMap = MapUtil.newHashMap();
            HashMap agentMap = MapUtil.newHashMap();
            List companyCustomer = this.crmCustomerService.getCompanyCustomer();
            companyCustomer.stream().forEach(x -> customerMap.put(x.getId(), x));
            this.rkAgentService.listSimpleIdAndName().stream().forEach(x -> agentMap.put(x.getId(), x));
            if (StringUtils.isNotEmpty((String)contractEntity.getCustomerIds())) {
                String customerNames = "";
                List customerNameList = CollectionUtil.list((boolean)false);
                if (StrUtil.isNotBlank((CharSequence)contractEntity.getCustomerIds())) {
                    String[] split;
                    for (String customerId : split = contractEntity.getCustomerIds().split(",")) {
                        if (!customerMap.containsKey(customerId)) continue;
                        CrmCustomerEntity customer1 = (CrmCustomerEntity)customerMap.get(customerId);
                        customerNameList.add(customer1.getName());
                    }
                }
                if (CollectionUtil.isNotEmpty((Collection)customerNameList)) {
                    customerNames = StrUtil.join((CharSequence)",", (Iterable)customerNameList);
                }
                if (StrUtil.isBlank((CharSequence)customerNames)) {
                    customerNames = this.saleContractCustomerService.getCustomerNamesByContractId(record.getContractId());
                }
                record.setCustomerNames(customerNames);
            }
            if ("1".equals(contractEntity.getIsAgent())) {
                if (StringUtils.isNotEmpty((String)contractEntity.getAgentId()) && null != (agent = agentMap.containsKey(contractEntity.getAgentId()) ? (RkAgentEntity)agentMap.get(contractEntity.getAgentId()) : this.rkAgentService.getInfo(contractEntity.getAgentId()))) {
                    record.setAgentName(agent.getName());
                }
            } else {
                record.setAgentName(record.getCustomerNames());
            }
            if (ObjectUtil.isNotEmpty((Object)record.getReturnSettlementAmount())) {
                record.setNeedReturnSettlementAmount(record.getReturnSettlementAmount());
            }
            if (ObjectUtil.isEmpty((Object)record.getBaseFeeAmount())) {
                record.setBaseFeeAmount(BigDecimal.ZERO);
            }
            if (ObjectUtil.isEmpty((Object)record.getThisBaseAmount())) {
                record.setThisBaseAmount(BigDecimal.ZERO);
            }
            if (ObjectUtil.isEmpty((Object)record.getReturnSettlementAmount())) {
                record.setReturnSettlementAmount(BigDecimal.ZERO);
            }
            record.setBaseFeeAmountCopy(ObjectUtil.isNotEmpty((Object)record.getBaseFeeAmount()) ? record.getBaseFeeAmount() : BigDecimal.ZERO.add(ObjectUtil.isNotEmpty((Object)record.getReturnSettlementAmount()) ? record.getReturnSettlementAmount() : BigDecimal.ZERO));
            record.setThisBaseAmountCopy(ObjectUtil.isNotEmpty((Object)record.getThisBaseAmount()) ? record.getThisBaseAmount() : BigDecimal.ZERO.add(ObjectUtil.isNotEmpty((Object)record.getReturnSettlementAmount()) ? record.getNeedReturnSettlementAmount() : BigDecimal.ZERO));
        });
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)oaFeeStatementRecordPaginationExportModel.getSelectKey()) ? oaFeeStatementRecordPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.createSettlementRecordExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadVO createSettlementRecordExcel(String temporaryFilePath, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block38: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "archivedTime": {
                        entitys.add(new ExcelExportEntity("\u5f52\u6863\u65e5\u671f", (Object)"archivedTime"));
                        continue block38;
                    }
                    case "salerName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u4eba\u5458", (Object)"salerName"));
                        continue block38;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block38;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u5bf9\u8c61", (Object)"agentName"));
                        continue block38;
                    }
                    case "customerNames": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerNames"));
                        continue block38;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u91d1\u989d(\u5143)", (Object)"contractAmount"));
                        continue block38;
                    }
                    case "validContractAmount": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u5408\u540c\u91d1\u989d(\u5143)", (Object)"validContractAmount"));
                        continue block38;
                    }
                    case "baseFeeAmount": {
                        entitys.add(new ExcelExportEntity("\u786e\u8ba4\u6536\u5165\u57fa\u7840\u670d\u52a1\u8d39(\u5143)", (Object)"baseFeeAmount"));
                        continue block38;
                    }
                    case "returnSettlementAmount": {
                        entitys.add(new ExcelExportEntity("\u786e\u8ba4\u6536\u5165\u56de\u6b3e\u6fc0\u52b1(\u5143)", (Object)"returnSettlementAmount"));
                        continue block38;
                    }
                    case "baseFeeAmountCopy": {
                        entitys.add(new ExcelExportEntity("\u786e\u8ba4\u6536\u5165\u5408\u8ba1(\u5143)", (Object)"baseFeeAmountCopy"));
                        continue block38;
                    }
                    case "thisBaseAmount": {
                        entitys.add(new ExcelExportEntity("\u652f\u4ed8\u7ed3\u7b97\u57fa\u7840\u670d\u52a1\u8d39(\u5143)", (Object)"thisBaseAmount"));
                        continue block38;
                    }
                    case "needReturnSettlementAmount": {
                        entitys.add(new ExcelExportEntity("\u652f\u4ed8\u7ed3\u7b97\u56de\u6b3e\u6fc0\u52b1(\u5143)", (Object)"needReturnSettlementAmount"));
                        continue block38;
                    }
                    case "thisBaseAmountCopy": {
                        entitys.add(new ExcelExportEntity("\u652f\u4ed8\u7ed3\u7b97\u5408\u8ba1(\u5143)", (Object)"thisBaseAmountCopy"));
                        continue block38;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u7ed3\u7b97\u660e\u7ec6\u8868\u5355");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u7ed3\u7b97\u660e\u7ec6\u8868\u5355" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

