/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.model.rkattachment.RkAttachmentListVO;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.utils.Records;
import com.bringspring.oa.entity.OaFileBorrowEntity;
import com.bringspring.oa.entity.OaFileBorrowRelationEntity;
import com.bringspring.oa.model.oa_file_borrow.OaFileBorrowRelationModel;
import com.bringspring.oa.model.oafileborrow.OaFileBorrowCrForm;
import com.bringspring.oa.model.oafileborrow.OaFileBorrowInfoVO;
import com.bringspring.oa.model.oafileborrow.OaFileBorrowListVO;
import com.bringspring.oa.model.oafileborrow.OaFileBorrowPagination;
import com.bringspring.oa.model.oafileborrow.OaFileBorrowUpForm;
import com.bringspring.oa.service.OaFileBorrowRelationService;
import com.bringspring.oa.service.OaFileBorrowService;
import com.bringspring.oa.service.OaFileRecordService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6863\u6848\u501f\u9605"}, value="example")
@RequestMapping(value={"/api/oa/OaFileBorrow"})
public class OaFileBorrowController {
    private static final Logger log = LoggerFactory.getLogger(OaFileBorrowController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaFileBorrowService oaFileBorrowService;
    @Autowired
    private OaFileBorrowRelationService oaFileBorrowRelationService;
    @Autowired
    private OaFileRecordService oaFileRecordService;
    @Autowired
    private RkAttachmentService rkAttachmentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaFileBorrowPagination oaFileBorrowPagination) throws IOException {
        List<OaFileBorrowEntity> list = this.oaFileBorrowService.getList(oaFileBorrowPagination);
        for (OaFileBorrowEntity oaFileBorrowEntity : list) {
            oaFileBorrowEntity.setApplyId(this.baseDataUtil.userSelectValue(oaFileBorrowEntity.getApplyId()));
            oaFileBorrowEntity.setApplyDepartment(this.baseDataUtil.comSelectValue(oaFileBorrowEntity.getApplyDepartment(), "last"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaFileBorrowListVO.class);
        for (OaFileBorrowListVO oaFileBorrowVO : listVO) {
            List<OaFileBorrowRelationEntity> relationEntityList = this.oaFileBorrowService.listByBorrowId(oaFileBorrowVO.getId());
            List jsonToList = JsonUtil.getJsonToList(relationEntityList, OaFileBorrowRelationModel.class);
            oaFileBorrowVO.setOaFileBorrowList(jsonToList);
        }
        for (OaFileBorrowListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaFileBorrowPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaFileBorrowCrForm oaFileBorrowCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "508981915051865477";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaFileBorrowCrForm.setApplyId(userInfo.getUserId());
        oaFileBorrowCrForm.setApplyDepartment(StringUtils.isEmpty((String)userInfo.getDepartmentId()) ? userInfo.getOrganizeId() : userInfo.getDepartmentId());
        oaFileBorrowCrForm.setApplyDate(DateUtil.getNow());
        OaFileBorrowEntity entity = (OaFileBorrowEntity)JsonUtil.getJsonToBean((Object)((Object)oaFileBorrowCrForm), OaFileBorrowEntity.class);
        entity.setId(mainId);
        this.oaFileBorrowService.save(entity);
        List oaFileBorrowList = JsonUtil.getJsonToList(oaFileBorrowCrForm.getOaFileBorrowList(), OaFileBorrowRelationEntity.class);
        List<String> borrowList = oaFileBorrowCrForm.getBorrowList();
        for (OaFileBorrowRelationEntity entitys : oaFileBorrowList) {
            entitys.setRecordId(entitys.getId());
            entitys.setId(RandomUtil.uuId());
            entitys.setBorrowId(entity.getId());
            entitys.setNumber(entitys.getNumber());
            entitys.setBorrowShape(entitys.getBorrowShape());
            entitys.setRecordCode(entitys.getRecordCode());
            entitys.setRecordName(entitys.getRecordName());
            entitys.setChoseType(entitys.getChoseType());
            entitys.setCreatorTime(new Date());
            entitys.setCreatorUserId(userInfo.getUserId());
            this.oaFileBorrowRelationService.save(entitys);
        }
        List recordEntities = this.oaFileRecordService.listByIds(borrowList);
        recordEntities.stream().forEach(record -> {
            record.setBorrowPerson(userInfo.getUserId());
            record.setRecordStatus("not Returned");
            record.setRecordStatusName(this.baseDataUtil.getDictName(record.getRecordStatus(), Records.RECORD_STATUS_DICT));
            this.oaFileRecordService.updateById(record);
        });
        FlowUtil.saveOrSubmit((String)oaFileBorrowCrForm.getTaskId(), (String)flowEngineId, (String)oaFileBorrowCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaFileBorrowCrForm), (Integer)oaFileBorrowCrForm.getStatus());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaFileBorrowInfoVO> info(@PathVariable(value="id") String id) {
        OaFileBorrowEntity entity = this.oaFileBorrowService.getInfo(id);
        OaFileBorrowInfoVO vo = (OaFileBorrowInfoVO)JsonUtil.getJsonToBean((Object)entity, OaFileBorrowInfoVO.class);
        vo.setApplyId(this.baseDataUtil.userSelectValue(vo.getApplyId()));
        vo.setApplyDepartment(this.baseDataUtil.comSelectValue(vo.getApplyDepartment(), "last"));
        if (vo.getApplyDate() != null) {
            vo.setApplyDate(vo.getApplyDate());
        }
        vo.setIsShow(vo.getIsShow());
        List<OaFileBorrowRelationEntity> oaFileBorrowRelationList = this.oaFileBorrowService.listByBorrowId(id);
        for (OaFileBorrowRelationEntity oaFileBorrowRelationEntity : oaFileBorrowRelationList) {
        }
        oaFileBorrowRelationList.stream().forEach(borrow -> {
            String recordId = borrow.getRecordId();
            List listByContractId = this.rkAttachmentService.getListByContractId(recordId);
            List jsonToList = JsonUtil.getJsonToList((Object)listByContractId, RkAttachmentListVO.class);
            borrow.setAttachmentList(jsonToList);
        });
        vo.setOaFileBorrowList(JsonUtil.getJsonToList(oaFileBorrowRelationList, OaFileBorrowRelationModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaFileBorrowUpForm oaFileBorrowUpForm) throws DataException, WorkFlowException {
        String flowEngineId = "508981915051865477";
        UserInfo userInfo = this.userProvider.get();
        OaFileBorrowEntity entity = this.oaFileBorrowService.getInfo(id);
        if (entity != null) {
            oaFileBorrowUpForm.setApplyDepartment(entity.getApplyDepartment());
            OaFileBorrowEntity subentity = (OaFileBorrowEntity)JsonUtil.getJsonToBean((Object)((Object)oaFileBorrowUpForm), OaFileBorrowEntity.class);
            subentity.setApplyId(entity.getApplyId());
            subentity.setApplyDate(entity.getApplyDate());
            this.oaFileBorrowService.updateBorrow(id, oaFileBorrowUpForm);
            FlowUtil.saveOrSubmit((String)oaFileBorrowUpForm.getTaskId(), (String)flowEngineId, (String)oaFileBorrowUpForm.getTemplateId(), (String)id, (Object)((Object)oaFileBorrowUpForm), (Integer)oaFileBorrowUpForm.getStatus());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaFileBorrowEntity entity = this.oaFileBorrowService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaFileBorrowService.delete(entity);
            QueryWrapper queryWrapperOa_file_borrow_relation = new QueryWrapper();
            queryWrapperOa_file_borrow_relation.lambda().eq(OaFileBorrowRelationEntity::getBorrowId, (Object)entity.getId());
            this.oaFileBorrowRelationService.remove((Wrapper)queryWrapperOa_file_borrow_relation);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

