/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.oa.entity.OaFmsAllocationAttachmentEntity;
import com.bringspring.oa.entity.OaFmsAllocationFormEntity;
import com.bringspring.oa.model.oafmsallocationform.OaFmsAllocationFormCrForm;
import com.bringspring.oa.model.oafmsallocationform.OaFmsAllocationFormInfoVO;
import com.bringspring.oa.model.oafmsallocationform.OaFmsAllocationFormListVO;
import com.bringspring.oa.model.oafmsallocationform.OaFmsAllocationFormPagination;
import com.bringspring.oa.model.oafmsallocationform.OaFmsAllocationFormUpForm;
import com.bringspring.oa.model.oafmsallocationformAttachment.OaFmsAllocationAttachmentImportVO;
import com.bringspring.oa.model.oafmsallocationformAttachment.OaFmsAllocationFormAttachmentModel;
import com.bringspring.oa.service.OaFmsAllocationAttachmentService;
import com.bringspring.oa.service.OaFmsAllocationFormService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u8d44\u91d1\u8c03\u62e8"}, value="oa")
@RequestMapping(value={"/api/oa/OaFmsAllocationForm"})
public class OaFmsAllocationFormController {
    private static final Logger log = LoggerFactory.getLogger(OaFmsAllocationFormController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaFmsAllocationFormService oaFmsAllocationFormService;
    @Autowired
    private OaFmsAllocationAttachmentService oa_fmsAllocationAttachmentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaFmsAllocationFormPagination oaFmsAllocationFormPagination) throws IOException {
        List<OaFmsAllocationFormEntity> list = this.oaFmsAllocationFormService.getList(oaFmsAllocationFormPagination);
        for (OaFmsAllocationFormEntity iterator : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, OaFmsAllocationFormListVO.class);
        for (OaFmsAllocationFormListVO oaFmsAllocationFormVO : listVO) {
            oaFmsAllocationFormVO.setApplicationId(this.baseDataUtil.userSelectValue(oaFmsAllocationFormVO.getApplicationId()));
        }
        for (OaFmsAllocationFormListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaFmsAllocationFormPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaFmsAllocationFormCrForm oaFmsAllocationFormCrForm = (OaFmsAllocationFormCrForm)((Object)JsonUtil.getJsonToBean(crData, OaFmsAllocationFormCrForm.class));
        String visualId = "554219179322906309";
        if (StringUtils.isNotEmpty((String)oaFmsAllocationFormCrForm.getFlowId())) {
            visualId = oaFmsAllocationFormCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaFmsAllocationFormCrForm.setApplyTypeName(this.baseDataUtil.getDictName(oaFmsAllocationFormCrForm.getApplyType(), "FmsAllocationApplyTypeOptions"));
        OaFmsAllocationFormEntity entity = (OaFmsAllocationFormEntity)JsonUtil.getJsonToBean((Object)((Object)oaFmsAllocationFormCrForm), OaFmsAllocationFormEntity.class);
        entity.setId(mainId);
        entity.setApplicationDate(new Date());
        entity.setApplicant(userInfo.getUserId());
        entity.setApplicationId(this.baseDataUtil.getBillNumber("FundAllocationID", Boolean.valueOf(false)));
        entity.setApplicantName(userInfo.getRealName());
        entity.setDeptId(userInfo.getDepartmentId());
        entity.setDeptName(this.baseDataUtil.comSelectValues(entity.getDeptId()));
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setApplyCompanyName(this.baseDataUtil.getDictName(entity.getApplyCompany(), "FmsSealApplicationCompany"));
        this.oaFmsAllocationFormService.save(entity);
        List Oa_fms_allocation_form_attachmentList = JsonUtil.getJsonToList(oaFmsAllocationFormCrForm.getOaFmsAllocationFormAttachmentList(), OaFmsAllocationAttachmentEntity.class);
        for (OaFmsAllocationAttachmentEntity entitys : Oa_fms_allocation_form_attachmentList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setAttachmentId(entity.getId());
            this.oa_fmsAllocationAttachmentService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)oaFmsAllocationFormCrForm.getTaskId(), (String)visualId, (String)oaFmsAllocationFormCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaFmsAllocationFormCrForm), (Integer)oaFmsAllocationFormCrForm.getStatus(), (String)oaFmsAllocationFormCrForm.getApplyTitle());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaFmsAllocationFormInfoVO> info(@PathVariable(value="id") String id) {
        OaFmsAllocationFormEntity entity = this.oaFmsAllocationFormService.getInfo(id);
        OaFmsAllocationFormInfoVO vo = (OaFmsAllocationFormInfoVO)JsonUtil.getJsonToBean((Object)entity, OaFmsAllocationFormInfoVO.class);
        List<OaFmsAllocationAttachmentEntity> Oa_fms_allocation_form_attachmentList = this.oaFmsAllocationFormService.GetOa_fms_allocation_form_attachmentList(id);
        for (OaFmsAllocationAttachmentEntity oaFmsAllocationAttachmentEntity : Oa_fms_allocation_form_attachmentList) {
        }
        vo.setOaFmsAllocationFormAttachmentList(JsonUtil.getJsonToList(Oa_fms_allocation_form_attachmentList, OaFmsAllocationFormAttachmentModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaFmsAllocationFormUpForm oaFmsAllocationFormUpForm = (OaFmsAllocationFormUpForm)((Object)JsonUtil.getJsonToBean(upData, OaFmsAllocationFormUpForm.class));
        String visualId = "554219179322906309";
        if (StringUtils.isNotEmpty((String)oaFmsAllocationFormUpForm.getFlowId())) {
            visualId = oaFmsAllocationFormUpForm.getFlowId();
        }
        UserInfo userInfo = this.userProvider.get();
        OaFmsAllocationFormEntity entity = this.oaFmsAllocationFormService.getInfo(id);
        if (entity != null) {
            oaFmsAllocationFormUpForm.setApplyTypeName(this.baseDataUtil.getDictName(oaFmsAllocationFormUpForm.getApplyType(), "FmsAllocationApplyTypeOptions"));
            OaFmsAllocationFormEntity subentity = (OaFmsAllocationFormEntity)JsonUtil.getJsonToBean((Object)((Object)oaFmsAllocationFormUpForm), OaFmsAllocationFormEntity.class);
            subentity.setApplyCompanyName(this.baseDataUtil.getDictName(subentity.getApplyCompany(), "FmsSealApplicationCompany"));
            this.oaFmsAllocationFormService.update(id, subentity);
            QueryWrapper Oa_fms_allocation_form_attachmentqueryWrapper = new QueryWrapper();
            Oa_fms_allocation_form_attachmentqueryWrapper.lambda().eq(OaFmsAllocationAttachmentEntity::getAttachmentId, (Object)entity.getId());
            this.oa_fmsAllocationAttachmentService.remove((Wrapper)Oa_fms_allocation_form_attachmentqueryWrapper);
            List Oa_fms_allocation_form_attachmentList = JsonUtil.getJsonToList(oaFmsAllocationFormUpForm.getOaFmsAllocationFormAttachmentList(), OaFmsAllocationAttachmentEntity.class);
            for (OaFmsAllocationAttachmentEntity entitys : Oa_fms_allocation_form_attachmentList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setAttachmentId(entity.getId());
                this.oa_fmsAllocationAttachmentService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)oaFmsAllocationFormUpForm.getTaskId(), (String)visualId, (String)oaFmsAllocationFormUpForm.getTemplateId(), (String)id, (Object)((Object)oaFmsAllocationFormUpForm), (Integer)oaFmsAllocationFormUpForm.getStatus(), (String)oaFmsAllocationFormUpForm.getApplyTitle());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaFmsAllocationFormEntity entity = this.oaFmsAllocationFormService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaFmsAllocationFormService.delete(entity);
            QueryWrapper queryWrapperOa_fms_allocation_form_attachment = new QueryWrapper();
            queryWrapperOa_fms_allocation_form_attachment.lambda().eq(OaFmsAllocationAttachmentEntity::getAttachmentId, (Object)entity.getId());
            this.oa_fmsAllocationAttachmentService.remove((Wrapper)queryWrapperOa_fms_allocation_form_attachment);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u8d44\u91d1\u8c03\u62e8\u660e\u7ec6\u5bfc\u5165\u6a21\u677f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u8d44\u91d1\u8c03\u62e8\u660e\u7ec6\u5bfc\u5165\u6a21\u677f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List fileImportList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, OaFmsAllocationAttachmentImportVO.class);
        if (CollectionUtil.isEmpty((Collection)fileImportList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fileImportList.size() > 100) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e100\u6761");
        }
        Map<String, Object> map = this.oa_fmsAllocationAttachmentService.importPreview(fileImportList);
        return ActionResult.success(map);
    }
}

