/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.service.OaContractCustomerService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaNoContractApplyEntity;
import com.bringspring.oa.model.oanocontractapply.OaNoContractApplyCrForm;
import com.bringspring.oa.model.oanocontractapply.OaNoContractApplyInfoVO;
import com.bringspring.oa.model.oanocontractapply.OaNoContractApplyListVO;
import com.bringspring.oa.model.oanocontractapply.OaNoContractApplyPagination;
import com.bringspring.oa.model.oanocontractapply.OaNoContractApplyPaginationExportModel;
import com.bringspring.oa.model.oanocontractapply.OaNoContractApplyUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaContractProductApplyService;
import com.bringspring.oa.service.OaNoContractApplyService;
import com.bringspring.purchase.service.OaContractPurchasePlanService;
import com.bringspring.quotation.entity.SaleQuotationEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitEntity;
import com.bringspring.quotation.service.SaleQuotationProfitService;
import com.bringspring.quotation.service.SaleQuotationService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u65e0\u5408\u540c\u7533\u8bf7"}, value="contract")
@RequestMapping(value={"/api/contract/OaNoContractApply"})
public class OaNoContractApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaNoContractApplyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private OaNoContractApplyService oaNoContractApplyService;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private OaContractProductApplyService oaContractProductApplyService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private SaleQuotationService saleQuotationService;
    @Autowired
    private SaleQuotationProfitService saleQuotationProfitService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private OaContractCustomerService oaContractCustomerService;
    @Autowired
    private OaContractPurchasePlanService oaContractPurchasePlanService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaNoContractApplyPagination oaNoContractApplyPagination) throws IOException {
        List<OaNoContractApplyEntity> list = this.oaNoContractApplyService.getList(oaNoContractApplyPagination);
        List listVO = JsonUtil.getJsonToList(list, OaNoContractApplyListVO.class);
        this.appendListVo(listVO);
        for (OaNoContractApplyListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaNoContractApplyPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private void appendListVo(List<OaNoContractApplyListVO> listVO) {
        for (OaNoContractApplyListVO vo : listVO) {
            vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        }
    }

    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaNoContractApplyCrForm oaNoContractApplyCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "616289745525295749";
        if (StrUtil.isNotBlank((CharSequence)oaNoContractApplyCrForm.getFlowId())) {
            flowEngineId = oaNoContractApplyCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        oaNoContractApplyCrForm.setId(mainId);
        this.oaNoContractApplyService.insertContractApply(oaNoContractApplyCrForm);
        FlowUtil.saveOrSubmit((String)oaNoContractApplyCrForm.getTaskId(), (String)flowEngineId, (String)oaNoContractApplyCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaNoContractApplyCrForm), (Integer)oaNoContractApplyCrForm.getStatus(), (String)oaNoContractApplyCrForm.getContractName());
        if (oaNoContractApplyCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaNoContractApplyPaginationExportModel oaNoContractApplyPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaNoContractApplyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaNoContractApplyPagination oaNoContractApplyPagination = (OaNoContractApplyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaNoContractApplyPaginationExportModel), OaNoContractApplyPagination.class));
        List<OaNoContractApplyEntity> list = this.oaNoContractApplyService.getTypeList(oaNoContractApplyPagination, oaNoContractApplyPaginationExportModel.getDataType());
        for (OaNoContractApplyEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, OaNoContractApplyListVO.class);
        for (OaNoContractApplyListVO oaNoContractApplyListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaNoContractApplyPaginationExportModel.getSelectKey()) ? oaNoContractApplyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block44: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block44;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block44;
                    }
                    case "opportunityId": {
                        entitys.add(new ExcelExportEntity("\u5546\u673a", (Object)"opportunityId"));
                        continue block44;
                    }
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerId"));
                        continue block44;
                    }
                    case "incomeType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u4ea7\u54c1\u5927\u7c7b", (Object)"incomeType"));
                        continue block44;
                    }
                    case "customerAddress": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237\u5730\u5740", (Object)"customerAddress"));
                        continue block44;
                    }
                    case "expectedSignDate": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u5408\u540c\u7b7e\u8ba2\u65e5\u671f", (Object)"expectedSignDate"));
                        continue block44;
                    }
                    case "biddingStatus": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237\u62db\u6807\u72b6\u6001", (Object)"biddingStatus"));
                        continue block44;
                    }
                    case "contractSigningStatus": {
                        entitys.add(new ExcelExportEntity("\u7ecf\u9500\u5408\u540c\u7b7e\u8ba2\u72b6\u6001", (Object)"contractSigningStatus"));
                        continue block44;
                    }
                    case "businessRiskAssessment": {
                        entitys.add(new ExcelExportEntity("\u5546\u52a1\u98ce\u9669\u8bc4\u4f30", (Object)"businessRiskAssessment"));
                        continue block44;
                    }
                    case "expectedContractAmount": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u9884\u6d4b\u91d1\u989d", (Object)"expectedContractAmount"));
                        continue block44;
                    }
                    case "bidWinningSituation": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u6807\u60c5\u51b5", (Object)"bidWinningSituation"));
                        continue block44;
                    }
                    case "reasonForEntry": {
                        entitys.add(new ExcelExportEntity("\u5165\u573a\u7406\u7531", (Object)"reasonForEntry"));
                        continue block44;
                    }
                    case "implScope": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u65bd\u8303\u56f4", (Object)"implScope"));
                        continue block44;
                    }
                    case "quotationId": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4ef7", (Object)"quotationId"));
                        continue block44;
                    }
                    case "quotationProfitId": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4ef7\u6bdb\u5229", (Object)"quotationProfitId"));
                        continue block44;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaNoContractApplyInfoVO> info(@PathVariable(value="id") String id) {
        SaleQuotationProfitEntity profit;
        String userSelectValue;
        SaleQuotationEntity quotation;
        RkAgentEntity agent;
        OaNoContractApplyEntity entity = this.oaNoContractApplyService.getInfo(id);
        OaNoContractApplyInfoVO vo = (OaNoContractApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaNoContractApplyInfoVO.class);
        vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
        if (StringUtils.isNotEmpty((String)vo.getContractType())) {
            vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), "contractType"));
        }
        if ("1".equals(vo.getIsAgent()) && StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = this.agentService.getInfo(vo.getAgentId()))) {
            vo.setAgentName(agent.getName());
        }
        if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
            vo.setCustomerNames(this.oaContractCustomerService.getCustomerNamesByContractId(vo.getId()));
            vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            vo.setCustomerList(this.oaContractCustomerService.getListByContractId(vo.getId()));
        }
        if (StringUtils.isNotEmpty((String)vo.getCustomerAddress())) {
            vo.setCustomerAddressName(this.baseDataUtil.provinceData(vo.getCustomerAddress()));
        }
        if (StringUtils.isNotEmpty((String)entity.getOpportunityId())) {
            List<String> idList = Arrays.asList(entity.getOpportunityId().split(","));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(RkProjectReportingEntity::getId, idList);
            List reportingList = this.rkProjectReportingService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)reportingList)) {
                String opportunityName = reportingList.stream().map(RkProjectReportingEntity::getReportingProject).collect(Collectors.joining(","));
                vo.setOpportunityName(opportunityName);
            }
        }
        String quotationPrefix = "";
        if (StringUtils.isNotEmpty((String)entity.getQuotationId()) && null != (quotation = this.saleQuotationService.getInfo(entity.getQuotationId()))) {
            if (StringUtils.isNotEmpty((String)quotation.getSerialNumber())) {
                quotationPrefix = quotation.getSerialNumber();
            } else {
                CrmCustomerEntity customer;
                RkProjectReportingEntity reporting = this.rkProjectReportingService.getInfo(quotation.getOpportunityId());
                if (StringUtils.isNotEmpty((String)reporting.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(reporting.getCustomerId()))) {
                    quotationPrefix = customer.getName();
                }
            }
            userSelectValue = this.baseDataUtil.userSelectValue(quotation.getQuotationUser());
            String quotationName = quotationPrefix + "-" + userSelectValue;
            vo.setQuotationName(quotationName);
        }
        if (StringUtils.isNotEmpty((String)entity.getQuotationProfitId()) && null != (profit = this.saleQuotationProfitService.getInfo(entity.getQuotationProfitId()))) {
            userSelectValue = this.baseDataUtil.userSelectValue(profit.getSaleId());
            vo.setQuotationProfitName(quotationPrefix + "-" + userSelectValue);
        }
        List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.getListByContractId(id);
        vo.setAttachmentList(oaAttachmentEntityList);
        List purchasePlanList = this.oaContractPurchasePlanService.getPlanListByNoContractId(id);
        vo.setPurchasePlanList(purchasePlanList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaNoContractApplyInfoVO> detailInfo(@PathVariable(value="id") String id) {
        SaleQuotationProfitEntity profit;
        String userSelectValue;
        SaleQuotationEntity quotation;
        RkAgentEntity agent;
        OaNoContractApplyEntity entity = this.oaNoContractApplyService.getInfo(id);
        OaNoContractApplyInfoVO vo = (OaNoContractApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaNoContractApplyInfoVO.class);
        vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
        vo.setIncomeTypeName(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
        vo.setContractTypeName(this.baseDataUtil.getDictName(entity.getContractType(), "contractType"));
        vo.setBiddingStatusName(this.baseDataUtil.getDictName(entity.getBiddingStatus(), "biddingStatus"));
        vo.setContractSigningStatusName(this.baseDataUtil.getDictName(entity.getContractSigningStatus(), "contractSigningStatus"));
        vo.setBusinessRiskAssessmentName(this.baseDataUtil.getDictName(entity.getBusinessRiskAssessment(), "businessRiskAssessment"));
        vo.setBidWinningSituationName(this.baseDataUtil.getDictName(entity.getBidWinningSituation(), "bidWinningSituation"));
        if ("1".equals(vo.getIsAgent()) && StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = this.agentService.getInfo(vo.getAgentId()))) {
            vo.setAgentName(agent.getName());
        }
        if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
            vo.setCustomerNames(this.oaContractCustomerService.getCustomerNamesByContractId(vo.getId()));
            vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            vo.setCustomerList(this.oaContractCustomerService.getListByContractId(vo.getId()));
        }
        vo.setCustomerAddressName(this.baseDataUtil.provinceData(vo.getCustomerAddress()));
        if (StringUtils.isNotEmpty((String)entity.getOpportunityId())) {
            List<String> idList = Arrays.asList(entity.getOpportunityId().split(","));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(RkProjectReportingEntity::getId, idList);
            List reportingList = this.rkProjectReportingService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)reportingList)) {
                String opportunityName = reportingList.stream().map(RkProjectReportingEntity::getReportingProject).collect(Collectors.joining(","));
                vo.setOpportunityName(opportunityName);
            }
        }
        String quotationPrefix = "";
        if (StringUtils.isNotEmpty((String)entity.getQuotationId()) && null != (quotation = this.saleQuotationService.getInfo(entity.getQuotationId()))) {
            if (StringUtils.isNotEmpty((String)quotation.getSerialNumber())) {
                quotationPrefix = quotation.getSerialNumber();
            } else {
                CrmCustomerEntity customer;
                RkProjectReportingEntity reporting = this.rkProjectReportingService.getInfo(quotation.getOpportunityId());
                if (StringUtils.isNotEmpty((String)reporting.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(reporting.getCustomerId()))) {
                    quotationPrefix = customer.getName();
                }
            }
            userSelectValue = this.baseDataUtil.userSelectValue(quotation.getQuotationUser());
            String quotationName = quotationPrefix + "-" + userSelectValue;
            vo.setQuotationName(quotationName);
        }
        if (StringUtils.isNotEmpty((String)entity.getQuotationProfitId()) && null != (profit = this.saleQuotationProfitService.getInfo(entity.getQuotationProfitId()))) {
            userSelectValue = this.baseDataUtil.userSelectValue(profit.getSaleId());
            vo.setQuotationProfitName(quotationPrefix + "-" + userSelectValue);
        }
        List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.getListByContractId(id);
        vo.setAttachmentList(oaAttachmentEntityList);
        List purchasePlanList = this.oaContractPurchasePlanService.getPlanListByNoContractId(id);
        vo.setPurchasePlanList(purchasePlanList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaNoContractApplyUpForm oaNoContractApplyUpForm) throws DataException {
        String flowEngineId = "616289745525295749";
        OaNoContractApplyEntity entity = this.oaNoContractApplyService.getInfo(id);
        if (entity != null) {
            this.oaNoContractApplyService.editContractApply(oaNoContractApplyUpForm);
            try {
                FlowUtil.saveOrSubmit((String)oaNoContractApplyUpForm.getTaskId(), (String)flowEngineId, (String)oaNoContractApplyUpForm.getTemplateId(), (String)id, (Object)((Object)oaNoContractApplyUpForm), (Integer)oaNoContractApplyUpForm.getStatus(), (String)oaNoContractApplyUpForm.getContractName());
            }
            catch (WorkFlowException e) {
                throw new RuntimeException(e);
            }
            if (oaNoContractApplyUpForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaNoContractApplyEntity entity = this.oaNoContractApplyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaNoContractApplyService.delete(entity);
            this.oaContractProductApplyService.deleteByContractId(id);
        }
        this.saleNoContractService.removeInfo(id);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/generateCode/{type}/{id}"})
    @DSTransactional
    public ActionResult generateCode(@PathVariable(value="type") String type, @PathVariable(value="id") String id) throws DataException {
        this.oaNoContractApplyService.generateCode(type, id);
        return ActionResult.success((String)"\u751f\u6210\u6210\u529f");
    }
}

