/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.oa.entity.OaOfficeSuppliesCategoryEntity;
import com.bringspring.oa.model.oaofficesuppliesapplication.OaOfficeSuppliesApplicationDetailListVo;
import com.bringspring.oa.model.oaofficesuppliescategory.OaOfficeSuppliesCategoryPaginationExportModel;
import com.bringspring.oa.model.oaofficesuppliescategory.OaofficesuppliescategoryCrForm;
import com.bringspring.oa.model.oaofficesuppliescategory.OaofficesuppliescategoryInfoVO;
import com.bringspring.oa.model.oaofficesuppliescategory.OaofficesuppliescategoryListVO;
import com.bringspring.oa.model.oaofficesuppliescategory.OaofficesuppliescategoryPagination;
import com.bringspring.oa.model.oaofficesuppliescategory.OaofficesuppliescategoryUpForm;
import com.bringspring.oa.service.OaOfficeSuppliesCategoryService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u529e\u516c\u7528\u54c1\u54c1\u7c7b"}, value="example")
@RequestMapping(value={"/api/cd/Oaofficesuppliescategory"})
public class OaOfficeSuppliesCategoryController {
    private static final Logger log = LoggerFactory.getLogger(OaOfficeSuppliesCategoryController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaOfficeSuppliesCategoryService oaofficesuppliescategoryService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaofficesuppliescategoryPagination oaofficesuppliescategoryPagination) throws IOException {
        List<OaOfficeSuppliesCategoryEntity> list = this.oaofficesuppliescategoryService.getList(oaofficesuppliescategoryPagination);
        for (OaOfficeSuppliesCategoryEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, OaofficesuppliescategoryListVO.class);
        for (OaofficesuppliescategoryListVO oaofficesuppliescategoryListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaofficesuppliescategoryPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaofficesuppliescategoryCrForm oaofficesuppliescategoryCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaofficesuppliescategoryCrForm.setOfficeCode(this.baseDataUtil.getBillNumber("OfficeSuppliesCategoryCode", Boolean.valueOf(false)));
        oaofficesuppliescategoryCrForm.setCompanyId(userInfo.getOrganizeId());
        OaOfficeSuppliesCategoryEntity entity = (OaOfficeSuppliesCategoryEntity)JsonUtil.getJsonToBean((Object)oaofficesuppliescategoryCrForm, OaOfficeSuppliesCategoryEntity.class);
        entity.setId(mainId);
        this.oaofficesuppliescategoryService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaofficesuppliescategoryInfoVO> info(@PathVariable(value="id") String id) {
        OaOfficeSuppliesCategoryEntity entity = this.oaofficesuppliescategoryService.getInfo(id);
        OaofficesuppliescategoryInfoVO vo = (OaofficesuppliescategoryInfoVO)JsonUtil.getJsonToBean((Object)entity, OaofficesuppliescategoryInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaofficesuppliescategoryInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OaOfficeSuppliesCategoryEntity entity = this.oaofficesuppliescategoryService.getInfo(id);
        OaofficesuppliescategoryInfoVO vo = (OaofficesuppliescategoryInfoVO)JsonUtil.getJsonToBean((Object)entity, OaofficesuppliescategoryInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaofficesuppliescategoryUpForm oaofficesuppliescategoryUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OaOfficeSuppliesCategoryEntity entity = this.oaofficesuppliescategoryService.getInfo(id);
        if (entity != null) {
            oaofficesuppliescategoryUpForm.setCompanyId(userInfo.getOrganizeId());
            OaOfficeSuppliesCategoryEntity subentity = (OaOfficeSuppliesCategoryEntity)JsonUtil.getJsonToBean((Object)oaofficesuppliescategoryUpForm, OaOfficeSuppliesCategoryEntity.class);
            this.oaofficesuppliescategoryService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaOfficeSuppliesCategoryEntity entity = this.oaofficesuppliescategoryService.getInfo(id);
        if (entity != null) {
            this.oaofficesuppliescategoryService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaOfficeSuppliesCategoryPaginationExportModel oaOfficeSuppliesCategoryPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaOfficeSuppliesCategoryPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaofficesuppliescategoryPagination officeSuppliesApplicationPagination = (OaofficesuppliescategoryPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaOfficeSuppliesCategoryPaginationExportModel), OaofficesuppliescategoryPagination.class));
        List<OaOfficeSuppliesCategoryEntity> list = this.oaofficesuppliescategoryService.getTypeList(officeSuppliesApplicationPagination, oaOfficeSuppliesCategoryPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, OaOfficeSuppliesApplicationDetailListVo.class);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaOfficeSuppliesCategoryPaginationExportModel.getSelectKey()) ? oaOfficeSuppliesCategoryPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block26: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block26;
                    }
                    case "officeCode": {
                        entitys.add(new ExcelExportEntity("\u7f16\u7801", (Object)"officeCode"));
                        continue block26;
                    }
                    case "officeName": {
                        entitys.add(new ExcelExportEntity("\u540d\u79f0", (Object)"officeName"));
                        continue block26;
                    }
                    case "officeSpecifications": {
                        entitys.add(new ExcelExportEntity("\u89c4\u683c", (Object)"officeSpecifications"));
                        continue block26;
                    }
                    case "officeUnit": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u91cf\u5355\u4f4d", (Object)"officeUnit"));
                        continue block26;
                    }
                    case "warehouseCount": {
                        entitys.add(new ExcelExportEntity("\u5e93\u5b58\u6570\u91cf", (Object)"warehouseCount"));
                        continue block26;
                    }
                    case "warehousePrice": {
                        entitys.add(new ExcelExportEntity("\u5e93\u5b58\u5355\u4ef7", (Object)"warehousePrice"));
                        continue block26;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

