/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.OaAcceptRemainWorkEntity;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaProjectAcceptApplyEntity;
import com.bringspring.oa.model.oaprojectacceptapply.OaProjectAcceptApplyCrForm;
import com.bringspring.oa.model.oaprojectacceptapply.OaProjectAcceptApplyInfoVO;
import com.bringspring.oa.model.oaprojectacceptapply.OaProjectAcceptApplyUpForm;
import com.bringspring.oa.service.OaAcceptRemainWorkService;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaProjectAcceptApplyService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u9a8c\u6536\u7533\u8bf7"}, value="oa")
@RequestMapping(value={"/api/oa/OaProjectAcceptApply"})
public class OaProjectAcceptApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaProjectAcceptApplyController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaProjectAcceptApplyService oaProjectAcceptApplyService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private OaAcceptRemainWorkService oaAcceptRemainWorkService;

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OaProjectAcceptApplyCrForm oaProjectAcceptApplyCrForm) throws DataException, WorkFlowException {
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)oaProjectAcceptApplyCrForm.getProjectId()));
        if (ObjectUtil.isNotEmpty((Object)byId)) {
            String flowEngineId = "535059679735193029";
            if (StrUtil.isNotBlank((CharSequence)oaProjectAcceptApplyCrForm.getFlowId())) {
                flowEngineId = oaProjectAcceptApplyCrForm.getFlowId();
            }
            String mainId = RandomUtil.uuId();
            oaProjectAcceptApplyCrForm.setMainId(mainId);
            oaProjectAcceptApplyCrForm.setRegionalHead(byId.getRegionalHead());
            oaProjectAcceptApplyCrForm.setProjectHeader(byId.getProjectHeader());
            oaProjectAcceptApplyCrForm.setExecuteUser(byId.getExecuteUser());
            this.oaProjectAcceptApplyService.saveAcceptApply(oaProjectAcceptApplyCrForm);
            byId.setAcceptApplyId(mainId);
            this.rkContractProjectService.updateById((Object)byId);
            if (CollectionUtil.isNotEmpty(oaProjectAcceptApplyCrForm.getAcceptRemainWorkList())) {
                List<OaAcceptRemainWorkEntity> acceptRemainWorkList = oaProjectAcceptApplyCrForm.getAcceptRemainWorkList();
                acceptRemainWorkList.stream().forEach(remain -> {
                    remain.setId(RandomUtil.uuId());
                    remain.setAcceptId(mainId);
                    remain.setCreatorTime(new Date());
                    remain.setCreatorUserId(this.userProvider.get().getUserId());
                });
                this.oaAcceptRemainWorkService.saveBatch(acceptRemainWorkList);
            }
            FlowUtil.saveOrSubmit((String)oaProjectAcceptApplyCrForm.getTaskId(), (String)flowEngineId, (String)oaProjectAcceptApplyCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaProjectAcceptApplyCrForm), (Integer)oaProjectAcceptApplyCrForm.getStatus(), (String)byId.getProjectName());
        }
        if (oaProjectAcceptApplyCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaProjectAcceptApplyInfoVO> info(@PathVariable(value="id") String id) {
        RkContractProjectEntity byId;
        OaProjectAcceptApplyEntity entity = this.oaProjectAcceptApplyService.getInfo(id);
        OaProjectAcceptApplyInfoVO vo = (OaProjectAcceptApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaProjectAcceptApplyInfoVO.class);
        if (StrUtil.isNotEmpty((CharSequence)vo.getProjectId()) && ObjectUtil.isNotNull((Object)(byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)vo.getProjectId()))))) {
            vo.setProjectName(byId.getProjectName());
        }
        List<OaAttachmentEntity> attachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
        vo.setAttachmentList(attachmentEntityList);
        List<OaAttachmentEntity> remarkList = this.oaAttachmentService.getListByContractIdAndFileType(id, AttachmentTypeEnum.PROJECT_ACCEPT_TYPE.getType());
        vo.setRemarkAttachmentList(remarkList);
        List<OaAcceptRemainWorkEntity> remainList = this.oaAcceptRemainWorkService.listByAcceptId(id);
        vo.setAcceptRemainWorkList(remainList);
        List<OaAttachmentEntity> screenList = this.oaAttachmentService.getListByContractIdAndFileType(id, "picture");
        vo.setProjectScreenshotList(screenList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaProjectAcceptApplyUpForm oaProjectAcceptApplyUpForm) throws DataException, WorkFlowException {
        OaProjectAcceptApplyEntity entity;
        String flowEngineId = "535059679735193029";
        if (StrUtil.isNotBlank((CharSequence)oaProjectAcceptApplyUpForm.getFlowId())) {
            flowEngineId = oaProjectAcceptApplyUpForm.getFlowId();
        }
        if ((entity = this.oaProjectAcceptApplyService.getInfo(id)) != null) {
            RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)oaProjectAcceptApplyUpForm.getProjectId()));
            oaProjectAcceptApplyUpForm.setRegionalHead(byId.getRegionalHead());
            oaProjectAcceptApplyUpForm.setProjectHeader(byId.getProjectHeader());
            oaProjectAcceptApplyUpForm.setExecuteUser(byId.getExecuteUser());
            OaProjectAcceptApplyEntity subentity = (OaProjectAcceptApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaProjectAcceptApplyUpForm), OaProjectAcceptApplyEntity.class);
            this.oaProjectAcceptApplyService.update(id, subentity);
            this.oaProjectAcceptApplyService.saveAcceptApply(id, oaProjectAcceptApplyUpForm);
            FlowUtil.saveOrSubmit((String)oaProjectAcceptApplyUpForm.getTaskId(), (String)flowEngineId, (String)oaProjectAcceptApplyUpForm.getTemplateId(), (String)id, (Object)((Object)oaProjectAcceptApplyUpForm), (Integer)oaProjectAcceptApplyUpForm.getStatus(), (String)byId.getProjectName());
            if (oaProjectAcceptApplyUpForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaProjectAcceptApplyEntity entity = this.oaProjectAcceptApplyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaProjectAcceptApplyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

