/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaProjectChangeHeaderApplyEntity;
import com.bringspring.oa.model.oaprojectchangeheaderapply.OaProjectChangeHeaderApplyCrForm;
import com.bringspring.oa.model.oaprojectchangeheaderapply.OaProjectChangeHeaderApplyInfoVO;
import com.bringspring.oa.model.oaprojectchangeheaderapply.OaProjectChangeHeaderApplyUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaProjectChangeHeaderApplyService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u53d8\u66f4\u9879\u76ee\u7ecf\u7406\u7533\u8bf7"}, value="oa")
@RequestMapping(value={"/api/oa/OaProjectChangeHeaderApply"})
public class OaProjectChangeHeaderApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaProjectChangeHeaderApplyController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaProjectChangeHeaderApplyService oaProjectChangeHeaderApplyService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OaAttachmentService oaAttachmentService;

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OaProjectChangeHeaderApplyCrForm oaProjectChangeHeaderApplyCrForm) throws DataException, WorkFlowException {
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)oaProjectChangeHeaderApplyCrForm.getProjectId()));
        String flowEngineId = "535744072015422469";
        if (StrUtil.isNotBlank((CharSequence)oaProjectChangeHeaderApplyCrForm.getFlowId())) {
            flowEngineId = oaProjectChangeHeaderApplyCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        oaProjectChangeHeaderApplyCrForm.setMainId(mainId);
        this.oaProjectChangeHeaderApplyService.changeHeaderApply(oaProjectChangeHeaderApplyCrForm);
        FlowUtil.saveOrSubmit((String)oaProjectChangeHeaderApplyCrForm.getTaskId(), (String)flowEngineId, (String)oaProjectChangeHeaderApplyCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaProjectChangeHeaderApplyCrForm), (Integer)oaProjectChangeHeaderApplyCrForm.getStatus(), (String)byId.getProjectName());
        if (oaProjectChangeHeaderApplyCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaProjectChangeHeaderApplyInfoVO> info(@PathVariable(value="id") String id) {
        RkContractProjectEntity byId;
        OaProjectChangeHeaderApplyEntity entity = this.oaProjectChangeHeaderApplyService.getInfo(id);
        OaProjectChangeHeaderApplyInfoVO vo = (OaProjectChangeHeaderApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaProjectChangeHeaderApplyInfoVO.class);
        vo.setOldProjectHeaderName(this.baseDataUtil.userSelectValue(vo.getOldProjectHeader()));
        vo.setNewProjectHeaderName(this.baseDataUtil.userSelectValue(vo.getNewProjectHeader()));
        if (StrUtil.isNotEmpty((CharSequence)vo.getProjectId()) && ObjectUtil.isNotNull((Object)(byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)vo.getProjectId()))))) {
            vo.setProjectName(byId.getProjectName());
        }
        List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
        vo.setAttachmentList(oaAttachmentEntityList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaProjectChangeHeaderApplyUpForm oaProjectChangeHeaderApplyUpForm) throws DataException, WorkFlowException {
        OaProjectChangeHeaderApplyEntity entity;
        String flowEngineId = "535744072015422469";
        if (StrUtil.isNotBlank((CharSequence)oaProjectChangeHeaderApplyUpForm.getFlowId())) {
            flowEngineId = oaProjectChangeHeaderApplyUpForm.getFlowId();
        }
        if ((entity = this.oaProjectChangeHeaderApplyService.getInfo(id)) != null) {
            RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)oaProjectChangeHeaderApplyUpForm.getProjectId()));
            OaProjectChangeHeaderApplyEntity subentity = (OaProjectChangeHeaderApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaProjectChangeHeaderApplyUpForm), OaProjectChangeHeaderApplyEntity.class);
            this.oaProjectChangeHeaderApplyService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)oaProjectChangeHeaderApplyUpForm.getTaskId(), (String)flowEngineId, (String)oaProjectChangeHeaderApplyUpForm.getTemplateId(), (String)id, (Object)((Object)oaProjectChangeHeaderApplyUpForm), (Integer)oaProjectChangeHeaderApplyUpForm.getStatus(), (String)byId.getProjectName());
            if (oaProjectChangeHeaderApplyUpForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaProjectChangeHeaderApplyEntity entity = this.oaProjectChangeHeaderApplyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaProjectChangeHeaderApplyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

