/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaProjectPlanChangeApplyEntity;
import com.bringspring.oa.model.oaprojectplanchangeapply.OaProjectPlanChangeApplyCrForm;
import com.bringspring.oa.model.oaprojectplanchangeapply.OaProjectPlanChangeApplyInfoVO;
import com.bringspring.oa.model.oaprojectplanchangeapply.OaProjectPlanChangeApplyUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaProjectPlanChangeApplyService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u8ba1\u5212\u8c03\u6574\u7533\u8bf7"}, value="oa")
@RequestMapping(value={"/api/oa/OaProjectPlanChangeApply"})
public class OaProjectPlanChangeApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaProjectPlanChangeApplyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private OaProjectPlanChangeApplyService oaProjectPlanChangeApplyService;
    @Autowired
    private OaAttachmentService oaAttachmentService;

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OaProjectPlanChangeApplyCrForm oaProjectPlanChangeApplyCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "585460439857496773";
        if (StrUtil.isNotBlank((CharSequence)oaProjectPlanChangeApplyCrForm.getFlowId())) {
            flowEngineId = oaProjectPlanChangeApplyCrForm.getFlowId();
        }
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)oaProjectPlanChangeApplyCrForm.getProjectId()));
        String mainId = RandomUtil.uuId();
        oaProjectPlanChangeApplyCrForm.setMainId(mainId);
        this.oaProjectPlanChangeApplyService.createApply(oaProjectPlanChangeApplyCrForm);
        FlowUtil.saveOrSubmit((String)oaProjectPlanChangeApplyCrForm.getTaskId(), (String)flowEngineId, (String)oaProjectPlanChangeApplyCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaProjectPlanChangeApplyCrForm), (Integer)oaProjectPlanChangeApplyCrForm.getStatus(), (String)byId.getProjectName());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaProjectPlanChangeApplyInfoVO> info(@PathVariable(value="id") String id) {
        OaProjectPlanChangeApplyEntity entity = this.oaProjectPlanChangeApplyService.getInfo(id);
        OaProjectPlanChangeApplyInfoVO vo = (OaProjectPlanChangeApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaProjectPlanChangeApplyInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
        vo.setAttachmentList(oaAttachmentEntityList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaProjectPlanChangeApplyUpForm oaProjectPlanChangeApplyUpForm) throws DataException, WorkFlowException {
        String flowEngineId = "585460439857496773";
        if (StrUtil.isNotBlank((CharSequence)oaProjectPlanChangeApplyUpForm.getFlowId())) {
            flowEngineId = oaProjectPlanChangeApplyUpForm.getFlowId();
        }
        oaProjectPlanChangeApplyUpForm.setId(id);
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)oaProjectPlanChangeApplyUpForm.getProjectId()));
        OaProjectPlanChangeApplyEntity entity = this.oaProjectPlanChangeApplyService.getInfo(id);
        if (entity != null) {
            this.oaProjectPlanChangeApplyService.updateApply(oaProjectPlanChangeApplyUpForm);
            FlowUtil.saveOrSubmit((String)oaProjectPlanChangeApplyUpForm.getTaskId(), (String)flowEngineId, (String)oaProjectPlanChangeApplyUpForm.getTemplateId(), (String)id, (Object)((Object)oaProjectPlanChangeApplyUpForm), (Integer)oaProjectPlanChangeApplyUpForm.getStatus(), (String)byId.getProjectName());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaProjectPlanChangeApplyEntity entity = this.oaProjectPlanChangeApplyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaProjectPlanChangeApplyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

