/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectQuestionService;
import com.bringspring.crm.entity.CrmRichTextEntity;
import com.bringspring.crm.service.CrmRichTextService;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaProjectQuestionApplyEntity;
import com.bringspring.oa.model.oaprojectquestionapply.OaProjectQuestionApplyCrForm;
import com.bringspring.oa.model.oaprojectquestionapply.OaProjectQuestionApplyInfoVO;
import com.bringspring.oa.model.oaprojectquestionapply.OaProjectQuestionApplyListVO;
import com.bringspring.oa.model.oaprojectquestionapply.OaProjectQuestionApplyPagination;
import com.bringspring.oa.model.oaprojectquestionapply.OaProjectQuestionApplyPaginationExportModel;
import com.bringspring.oa.model.oaprojectquestionapply.OaProjectQuestionApplyUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaProjectQuestionApplyService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u95ee\u9898\u63d0\u62a5\u7533\u8bf7"}, value="oa")
@RequestMapping(value={"/api/oa/OaProjectQuestionApply"})
public class OaProjectQuestionApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaProjectQuestionApplyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaProjectQuestionApplyService oaProjectQuestionApplyService;
    @Autowired
    private CrmRichTextService crmRichTextService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private RkProjectQuestionService rkProjectQuestionService;
    @Autowired
    private RkAttachmentService rkAttachmentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaProjectQuestionApplyPagination oaProjectQuestionApplyPagination) throws IOException {
        List<OaProjectQuestionApplyEntity> list = this.oaProjectQuestionApplyService.getList(oaProjectQuestionApplyPagination);
        for (OaProjectQuestionApplyEntity oaProjectQuestionApplyEntity : list) {
            oaProjectQuestionApplyEntity.setType(this.baseDataUtil.getDictName(oaProjectQuestionApplyEntity.getType(), "projectQuestionType"));
            oaProjectQuestionApplyEntity.setPriority(this.baseDataUtil.getDictName(oaProjectQuestionApplyEntity.getPriority(), "projectPriority"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaProjectQuestionApplyListVO.class);
        for (OaProjectQuestionApplyListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaProjectQuestionApplyPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaProjectQuestionApplyCrForm oaProjectQuestionApplyCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "581382469735956677";
        if (StrUtil.isNotBlank((CharSequence)oaProjectQuestionApplyCrForm.getFlowId())) {
            flowEngineId = oaProjectQuestionApplyCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        oaProjectQuestionApplyCrForm.setMainId(mainId);
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)oaProjectQuestionApplyCrForm.getProjectId()));
        oaProjectQuestionApplyCrForm.setRegionalHead(ObjectUtil.isNotEmpty((Object)byId) ? byId.getRegionalHead() : "");
        this.oaProjectQuestionApplyService.createQuestion(oaProjectQuestionApplyCrForm);
        FlowUtil.saveOrSubmit((String)oaProjectQuestionApplyCrForm.getTaskId(), (String)flowEngineId, (String)oaProjectQuestionApplyCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaProjectQuestionApplyCrForm), (Integer)oaProjectQuestionApplyCrForm.getStatus(), (String)(ObjectUtil.isNotEmpty((Object)byId) ? byId.getProjectName() : ""));
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaProjectQuestionApplyPaginationExportModel oaProjectQuestionApplyPaginationExportModel) throws IOException {
        if (StrUtil.isEmpty((CharSequence)oaProjectQuestionApplyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaProjectQuestionApplyPagination oaProjectQuestionApplyPagination = (OaProjectQuestionApplyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaProjectQuestionApplyPaginationExportModel), OaProjectQuestionApplyPagination.class));
        List<OaProjectQuestionApplyEntity> list = this.oaProjectQuestionApplyService.getTypeList(oaProjectQuestionApplyPagination, oaProjectQuestionApplyPaginationExportModel.getDataType());
        for (OaProjectQuestionApplyEntity oaProjectQuestionApplyEntity : list) {
            oaProjectQuestionApplyEntity.setType(this.baseDataUtil.getDictName(oaProjectQuestionApplyEntity.getType(), "projectQuestionType"));
            oaProjectQuestionApplyEntity.setPriority(this.baseDataUtil.getDictName(oaProjectQuestionApplyEntity.getPriority(), "projectPriority"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaProjectQuestionApplyListVO.class);
        for (OaProjectQuestionApplyListVO oaProjectQuestionApplyListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StrUtil.isEmpty((CharSequence)oaProjectQuestionApplyPaginationExportModel.getSelectKey()) ? oaProjectQuestionApplyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block26: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237id", (Object)"customerId"));
                        continue block26;
                    }
                    case "projectId": {
                        entitys.add(new ExcelExportEntity("\u9879\u76eeid", (Object)"projectId"));
                        continue block26;
                    }
                    case "projectHeader": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"projectHeader"));
                        continue block26;
                    }
                    case "type": {
                        entitys.add(new ExcelExportEntity("\u95ee\u9898\u7c7b\u578b", (Object)"type"));
                        continue block26;
                    }
                    case "startDate": {
                        entitys.add(new ExcelExportEntity("\u5f00\u59cb\u65f6\u95f4", (Object)"startDate"));
                        continue block26;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u95ee\u9898\u63cf\u8ff0", (Object)"description"));
                        continue block26;
                    }
                    case "priority": {
                        entitys.add(new ExcelExportEntity("\u4f18\u5148\u7ea7", (Object)"priority"));
                        continue block26;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaProjectQuestionApplyInfoVO> info(@PathVariable(value="id") String id) {
        OaProjectQuestionApplyEntity entity = this.oaProjectQuestionApplyService.getInfo(id);
        OaProjectQuestionApplyInfoVO vo = (OaProjectQuestionApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaProjectQuestionApplyInfoVO.class);
        RkContractProjectEntity rkProjectQuestionEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)vo.getProjectId()));
        List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
        vo.setAttachmentList(oaAttachmentEntityList);
        CrmRichTextEntity info = this.crmRichTextService.getInfo(entity.getId());
        if (ObjectUtil.isNotEmpty((Object)info)) {
            vo.setDescriptionText(info.getDescriptionText());
        }
        UserInfo userInfo = this.userProvider.get();
        String applyProjectRole = "Other";
        if (ObjectUtil.isNotEmpty((Object)rkProjectQuestionEntity)) {
            if (userInfo.getUserId().equals(rkProjectQuestionEntity.getRegionalHead())) {
                applyProjectRole = "RegionalHead";
            } else if (userInfo.getUserId().equals(rkProjectQuestionEntity.getProjectHeader())) {
                applyProjectRole = "ProjectHeader";
            } else if (userInfo.getUserId().equals(rkProjectQuestionEntity.getExecuteUser())) {
                applyProjectRole = "ExecuteUser";
            }
        }
        vo.setApplyProjectRole(applyProjectRole);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaProjectQuestionApplyUpForm oaProjectQuestionApplyUpForm) throws DataException, WorkFlowException {
        OaProjectQuestionApplyEntity entity;
        String flowEngineId = "581382469735956677";
        if (StrUtil.isNotBlank((CharSequence)oaProjectQuestionApplyUpForm.getFlowId())) {
            flowEngineId = oaProjectQuestionApplyUpForm.getFlowId();
        }
        if ((entity = this.oaProjectQuestionApplyService.getInfo(id)) != null) {
            this.oaProjectQuestionApplyService.updateQuestion(oaProjectQuestionApplyUpForm);
            RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()));
            FlowUtil.saveOrSubmit((String)oaProjectQuestionApplyUpForm.getTaskId(), (String)flowEngineId, (String)oaProjectQuestionApplyUpForm.getTemplateId(), (String)id, (Object)((Object)oaProjectQuestionApplyUpForm), (Integer)oaProjectQuestionApplyUpForm.getStatus(), (String)(ObjectUtil.isNotEmpty((Object)byId) ? byId.getProjectName() : ""));
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        this.oaProjectQuestionApplyService.deleteFlowAndService(id);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

