/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.oa.entity.OaPropertyDisposalEntity;
import com.bringspring.oa.entity.OaPropertyDisposalRelationEntity;
import com.bringspring.oa.model.oapropertydisposal.DisposalImportReturnVO;
import com.bringspring.oa.model.oapropertydisposal.DisposalImportVO;
import com.bringspring.oa.model.oapropertydisposal.OaPropertyDisposalCrForm;
import com.bringspring.oa.model.oapropertydisposal.OaPropertyDisposalInfoVO;
import com.bringspring.oa.model.oapropertydisposal.OaPropertyDisposalListVO;
import com.bringspring.oa.model.oapropertydisposal.OaPropertyDisposalPagination;
import com.bringspring.oa.model.oapropertydisposal.OaPropertyDisposalUpForm;
import com.bringspring.oa.model.oapropertydisposalrelation.OaPropertyDisposalRelationModel;
import com.bringspring.oa.service.OaPropertyDisposalRelationService;
import com.bringspring.oa.service.OaPropertyDisposalService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u56fa\u5b9a\u8d44\u4ea7\u5904\u7f6e\u5ba1\u6279\u8868"}, value="oa")
@RequestMapping(value={"/api/oa/OaPropertyDisposal"})
public class OaPropertyDisposalController {
    private static final Logger log = LoggerFactory.getLogger(OaPropertyDisposalController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaPropertyDisposalService oaPropertyDisposalService;
    @Autowired
    private OaPropertyDisposalRelationService oa_Property_Disposal_RelationService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaPropertyDisposalPagination oaPropertyDisposalPagination) throws IOException {
        List<OaPropertyDisposalEntity> list = this.oaPropertyDisposalService.getList(oaPropertyDisposalPagination);
        for (OaPropertyDisposalEntity oaPropertyDisposalEntity : list) {
            oaPropertyDisposalEntity.setDepartment(this.baseDataUtil.comSelectValue(oaPropertyDisposalEntity.getDepartment(), "last"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaPropertyDisposalListVO.class);
        for (OaPropertyDisposalListVO oaPropertyDisposalListVO : listVO) {
        }
        for (OaPropertyDisposalListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaPropertyDisposalPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaPropertyDisposalCrForm oaPropertyDisposalCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "518052411177188101";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaPropertyDisposalCrForm.setApplyDate(DateUtil.getNow());
        oaPropertyDisposalCrForm.setDepartment(StringUtils.isEmpty((String)userInfo.getDepartmentId()) ? userInfo.getOrganizeId() : userInfo.getDepartmentId());
        OaPropertyDisposalEntity entity = (OaPropertyDisposalEntity)JsonUtil.getJsonToBean((Object)((Object)oaPropertyDisposalCrForm), OaPropertyDisposalEntity.class);
        entity.setId(mainId);
        this.oaPropertyDisposalService.save(entity);
        List Oa_Property_Disposal_RelationList = JsonUtil.getJsonToList(oaPropertyDisposalCrForm.getOapropertydisposalList(), OaPropertyDisposalRelationEntity.class);
        for (OaPropertyDisposalRelationEntity entitys : Oa_Property_Disposal_RelationList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setDisposalId(entity.getId());
            this.oa_Property_Disposal_RelationService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)oaPropertyDisposalCrForm.getTaskId(), (String)flowEngineId, (String)oaPropertyDisposalCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaPropertyDisposalCrForm), (Integer)oaPropertyDisposalCrForm.getStatus());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaPropertyDisposalInfoVO> info(@PathVariable(value="id") String id) {
        OaPropertyDisposalEntity entity = this.oaPropertyDisposalService.getInfo(id);
        OaPropertyDisposalInfoVO vo = (OaPropertyDisposalInfoVO)JsonUtil.getJsonToBean((Object)entity, OaPropertyDisposalInfoVO.class);
        if (vo.getApplyDate() != null) {
            vo.setApplyDate(vo.getApplyDate());
        }
        vo.setDepartment(this.baseDataUtil.comSelectValue(vo.getDepartment(), "last"));
        List<OaPropertyDisposalRelationEntity> Oa_Property_Disposal_RelationList = this.oaPropertyDisposalService.GetOa_Property_Disposal_RelationList(id);
        for (OaPropertyDisposalRelationEntity oaPropertyDisposalRelationEntity : Oa_Property_Disposal_RelationList) {
        }
        vo.setOaPropertyDisposalList(JsonUtil.getJsonToList(Oa_Property_Disposal_RelationList, OaPropertyDisposalRelationModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaPropertyDisposalUpForm oaPropertyDisposalUpForm) throws DataException, WorkFlowException {
        String flowEngineId = "518052411177188101";
        UserInfo userInfo = this.userProvider.get();
        OaPropertyDisposalEntity entity = this.oaPropertyDisposalService.getInfo(id);
        if (entity != null) {
            oaPropertyDisposalUpForm.setDepartment(entity.getDepartment());
            OaPropertyDisposalEntity subentity = (OaPropertyDisposalEntity)JsonUtil.getJsonToBean((Object)((Object)oaPropertyDisposalUpForm), OaPropertyDisposalEntity.class);
            subentity.setApplyDate(entity.getApplyDate());
            this.oaPropertyDisposalService.update(id, subentity);
            QueryWrapper Oa_Property_Disposal_RelationqueryWrapper = new QueryWrapper();
            Oa_Property_Disposal_RelationqueryWrapper.lambda().eq(OaPropertyDisposalRelationEntity::getDisposalId, (Object)entity.getId());
            this.oa_Property_Disposal_RelationService.remove((Wrapper)Oa_Property_Disposal_RelationqueryWrapper);
            List Oa_Property_Disposal_RelationList = JsonUtil.getJsonToList(oaPropertyDisposalUpForm.getOapropertydisposalList(), OaPropertyDisposalRelationEntity.class);
            for (OaPropertyDisposalRelationEntity entitys : Oa_Property_Disposal_RelationList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setDisposalId(entity.getId());
                this.oa_Property_Disposal_RelationService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)oaPropertyDisposalUpForm.getTaskId(), (String)flowEngineId, (String)oaPropertyDisposalUpForm.getTemplateId(), (String)id, (Object)((Object)oaPropertyDisposalUpForm), (Integer)oaPropertyDisposalUpForm.getStatus());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaPropertyDisposalEntity entity = this.oaPropertyDisposalService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaPropertyDisposalService.delete(entity);
            QueryWrapper queryWrapperOa_Property_Disposal_Relation = new QueryWrapper();
            queryWrapperOa_Property_Disposal_Relation.lambda().eq(OaPropertyDisposalRelationEntity::getDisposalId, (Object)entity.getId());
            this.oa_Property_Disposal_RelationService.remove((Wrapper)queryWrapperOa_Property_Disposal_Relation);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u8d44\u4ea7\u5904\u7f6e\u8be6\u60c5.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u8d44\u4ea7\u5904\u7f6e\u8be6\u60c5.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List disposalImportList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, DisposalImportVO.class);
        if (CollectionUtil.isEmpty((Collection)disposalImportList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (disposalImportList.size() > 200) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e200\u6761");
        }
        List list = JsonUtil.getJsonToList((Object)disposalImportList, Object.class);
        Map<String, Object> map = this.oaPropertyDisposalService.importPreview(list, new DisposalImportVO());
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<DisposalImportReturnVO> ImportData(@RequestBody DisposalImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), DisposalImportVO.class);
        DisposalImportReturnVO result = this.oaPropertyDisposalService.importData(dataList);
        return ActionResult.success((Object)result);
    }
}

