/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.OaPropetyReturnDetailEntity;
import com.bringspring.oa.entity.OaPropetyReturnEntity;
import com.bringspring.oa.model.oapropetyreturn.OaPropetyReturnCrForm;
import com.bringspring.oa.model.oapropetyreturn.OaPropetyReturnDetailModel;
import com.bringspring.oa.model.oapropetyreturn.OaPropetyReturnInfoVO;
import com.bringspring.oa.model.oapropetyreturn.OaPropetyReturnListVO;
import com.bringspring.oa.model.oapropetyreturn.OaPropetyReturnPagination;
import com.bringspring.oa.model.oapropetyreturn.OaPropetyReturnUpForm;
import com.bringspring.oa.service.OaPropertyReturnDetailService;
import com.bringspring.oa.service.OaPropetyReturnService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u56fa\u5b9a\u8d44\u4ea7\u5f52\u8fd8\u5ba1\u6279\u8868"}, value="oa")
@RequestMapping(value={"/api/oa/oaPropetyReturn"})
public class OaPropetyReturnController {
    private static final Logger log = LoggerFactory.getLogger(OaPropetyReturnController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaPropetyReturnService oapropetyreturnService;
    @Autowired
    private OaPropertyReturnDetailService oaPropertyReturnDetailService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaPropetyReturnPagination oapropetyreturnPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        oapropetyreturnPagination.setUserId(userInfo.getUserId());
        oapropetyreturnPagination.setCompanyId(organizeId);
        List<OaPropetyReturnEntity> list = this.oapropetyreturnService.getList(oapropetyreturnPagination);
        for (OaPropetyReturnEntity oaPropetyReturnEntity : list) {
            oaPropetyReturnEntity.setApplyId(this.baseDataUtil.userSelectValue(oaPropetyReturnEntity.getApplyId()));
            oaPropetyReturnEntity.setApplyDepartment(this.baseDataUtil.comSelectValue(oaPropetyReturnEntity.getApplyDepartment(), "last"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaPropetyReturnListVO.class);
        for (OaPropetyReturnListVO oaPropetyReturnListVO : listVO) {
        }
        for (OaPropetyReturnListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oapropetyreturnPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaPropetyReturnCrForm oaPropetyReturnCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "514433235674205509";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaPropetyReturnCrForm.setApplyId(userInfo.getUserId());
        oaPropetyReturnCrForm.setApplyDepartment(StringUtils.isEmpty((String)userInfo.getDepartmentId()) ? userInfo.getOrganizeId() : userInfo.getDepartmentId());
        oaPropetyReturnCrForm.setApplyDate(DateUtil.getNow());
        oaPropetyReturnCrForm.setReturnCode(this.baseDataUtil.getBillNumber("returnPropertyCode", Boolean.valueOf(false)));
        OaPropetyReturnEntity entity = (OaPropetyReturnEntity)JsonUtil.getJsonToBean((Object)((Object)oaPropetyReturnCrForm), OaPropetyReturnEntity.class);
        entity.setId(mainId);
        entity.setCreatorTime(new Date());
        entity.setCreatorUserId(userInfo.getUserId());
        this.oapropetyreturnService.save(entity);
        List OaPropetyReturnDetailList = JsonUtil.getJsonToList(oaPropetyReturnCrForm.getOaPropetyReturnList(), OaPropetyReturnDetailEntity.class);
        for (OaPropetyReturnDetailEntity entitys : OaPropetyReturnDetailList) {
            entitys.setBorrowDetailId(entitys.getId());
            entitys.setId(RandomUtil.uuId());
            entitys.setReturnId(entity.getId());
            entitys.setCreatorTime(new Date());
            entitys.setCreatorUserId(userInfo.getUserId());
            entitys.setReturnStatus(this.baseDataUtil.getDictName(entitys.getReturnStatus(), ""));
            this.oaPropertyReturnDetailService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)oaPropetyReturnCrForm.getTaskId(), (String)flowEngineId, (String)oaPropetyReturnCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaPropetyReturnCrForm), (Integer)oaPropetyReturnCrForm.getStatus());
        if (oaPropetyReturnCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaPropetyReturnInfoVO> info(@PathVariable(value="id") String id) {
        OaPropetyReturnEntity entity = this.oapropetyreturnService.getInfo(id);
        OaPropetyReturnInfoVO vo = (OaPropetyReturnInfoVO)JsonUtil.getJsonToBean((Object)entity, OaPropetyReturnInfoVO.class);
        vo.setApplyId(this.baseDataUtil.userSelectValue(vo.getApplyId()));
        vo.setApplyDepartment(this.baseDataUtil.comSelectValue(vo.getApplyDepartment(), "last"));
        if (vo.getApplyDate() != null) {
            vo.setApplyDate(vo.getApplyDate());
        }
        List<OaPropetyReturnDetailEntity> OaPropetyReturnDetailList = this.oapropetyreturnService.GetOaPropetyReturnDetailList(id);
        for (OaPropetyReturnDetailEntity oaPropetyReturnDetailEntity : OaPropetyReturnDetailList) {
            oaPropetyReturnDetailEntity.setReturnStatus(this.baseDataUtil.getDictName(oaPropetyReturnDetailEntity.getReturnStatus(), ""));
        }
        vo.setOaPropetyReturnList(JsonUtil.getJsonToList(OaPropetyReturnDetailList, OaPropetyReturnDetailModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaPropetyReturnUpForm oaPropetyReturnUpForm) throws DataException, WorkFlowException {
        String flowEngineId = "514433235674205509";
        UserInfo userInfo = this.userProvider.get();
        OaPropetyReturnEntity entity = this.oapropetyreturnService.getInfo(id);
        if (entity != null) {
            oaPropetyReturnUpForm.setApplyDepartment(entity.getApplyDepartment());
            OaPropetyReturnEntity subentity = (OaPropetyReturnEntity)JsonUtil.getJsonToBean((Object)((Object)oaPropetyReturnUpForm), OaPropetyReturnEntity.class);
            subentity.setApplyId(entity.getApplyId());
            subentity.setApplyDate(entity.getApplyDate());
            subentity.setLastModifyTime(new Date());
            subentity.setLastModifyUserId(userInfo.getUserId());
            this.oapropetyreturnService.update(id, subentity);
            QueryWrapper OaPropetyReturnDetailqueryWrapper = new QueryWrapper();
            OaPropetyReturnDetailqueryWrapper.lambda().eq(OaPropetyReturnDetailEntity::getReturnId, (Object)entity.getId());
            this.oaPropertyReturnDetailService.remove((Wrapper)OaPropetyReturnDetailqueryWrapper);
            List OaPropetyReturnDetailList = JsonUtil.getJsonToList(oaPropetyReturnUpForm.getOaPropetyReturnList(), OaPropetyReturnDetailEntity.class);
            for (OaPropetyReturnDetailEntity entitys : OaPropetyReturnDetailList) {
                entitys.setBorrowDetailId(entitys.getId());
                entitys.setId(RandomUtil.uuId());
                entitys.setReturnId(entity.getId());
                entitys.setLastModifyTime(new Date());
                entitys.setLastModifyUserId(userInfo.getUserId());
                entitys.setReturnStatus(this.baseDataUtil.getDictName(entitys.getReturnStatus(), ""));
                this.oaPropertyReturnDetailService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)oaPropetyReturnUpForm.getTaskId(), (String)flowEngineId, (String)oaPropetyReturnUpForm.getTemplateId(), (String)id, (Object)((Object)oaPropetyReturnUpForm), (Integer)oaPropetyReturnUpForm.getStatus());
            if (oaPropetyReturnUpForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaPropetyReturnEntity entity = this.oapropetyreturnService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oapropetyreturnService.delete(entity);
            QueryWrapper queryWrapperOaPropetyReturnDetail = new QueryWrapper();
            queryWrapperOaPropetyReturnDetail.lambda().eq(OaPropetyReturnDetailEntity::getReturnId, (Object)entity.getId());
            this.oaPropertyReturnDetailService.remove((Wrapper)queryWrapperOaPropetyReturnDetail);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

