/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.OaRecordBorrowEntity;
import com.bringspring.oa.entity.OaRecordBorrowPrimaryEntity;
import com.bringspring.oa.entity.OaRecordEntity;
import com.bringspring.oa.entity.OaRecordSubitemEntity;
import com.bringspring.oa.mapper.OaRecordBorrowMapper;
import com.bringspring.oa.model.oaRecord.OaRecordPagination;
import com.bringspring.oa.model.oaRecordSubitem.OaRecordSubitemForm;
import com.bringspring.oa.model.oarecordborrow.OaRecordBorrowCrForm;
import com.bringspring.oa.model.oarecordborrow.OaRecordBorrowInitVo;
import com.bringspring.oa.model.oarecordborrow.OaRecordBorrowSubitemForm;
import com.bringspring.oa.model.oarecordborrow.OaReturnListVO;
import com.bringspring.oa.model.oarecordborrow.Page;
import com.bringspring.oa.model.oarecordborrow.RecordBorrowAlsoVo;
import com.bringspring.oa.service.OaRecordBorrowPrimaryService;
import com.bringspring.oa.service.OaRecordBorrowService;
import com.bringspring.oa.service.OaRecordService;
import com.bringspring.oa.service.OaRecordSubitemService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"oa_record_borrow"}, value="oa")
@RequestMapping(value={"/api/oa/oaRecordBorrow"})
public class OaRecordBorrowController {
    private static final Logger log = LoggerFactory.getLogger(OaRecordBorrowController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaRecordBorrowService oaRecordBorrowService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OaRecordService oaRecordService;
    @Autowired
    private OaRecordSubitemService oaRecordSubitemService;
    @Autowired
    private OaRecordBorrowPrimaryService oaRecordBorrowPrimaryService;
    @Autowired
    private OaRecordBorrowMapper oaRecordBorrowMapper;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaRecordPagination oaRecordPagination) throws IOException {
        List<OaRecordEntity> list = this.oaRecordService.getBorrowList(oaRecordPagination);
        List<String> ids = list.stream().map(OaRecordEntity::getId).collect(Collectors.toList());
        List<OaRecordSubitemEntity> subitemEntities = this.oaRecordSubitemService.getInfoStatsLis2(ids, oaRecordPagination);
        List listVO = JsonUtil.getJsonToList(subitemEntities, OaRecordSubitemForm.class);
        for (OaRecordSubitemForm vo : listVO) {
            vo.setSubitemType(this.baseDataUtil.getDictName(vo.getSubitemType(), "recordPattern"));
            vo.setSubitemStates(this.baseDataUtil.getDictName(vo.getSubitemStates(), "subitem"));
            QueryWrapper borrowQueryWrapper = new QueryWrapper();
            borrowQueryWrapper.lambda().eq(OaRecordBorrowEntity::getSubitemId, (Object)vo.getId());
            borrowQueryWrapper.lambda().eq(OaRecordBorrowEntity::getIsReturned, (Object)0);
            List oaRecordBorrowEntities = this.oaRecordBorrowMapper.selectList((Wrapper)borrowQueryWrapper);
            vo.setChangeNumber(vo.getNumber() - oaRecordBorrowEntities.size());
            vo.setIsBorrow(vo.getNumber() - oaRecordBorrowEntities.size() > 0 ? 0 : 1);
            OaRecordEntity info = this.oaRecordService.getInfo(vo.getRecordId());
            if (!ObjectUtil.isNotEmpty((Object)info)) continue;
            vo.setChoseType(this.baseDataUtil.getDictName(info.getChoseType(), "choseType"));
            vo.setRecordPosition(info.getRecordPosition());
            vo.setRecordName(info.getRecordName());
            vo.setFileCodeName(info.getFileCode() + "-" + info.getFileName());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaRecordPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListReturn"})
    public ActionResult getListReturn(@RequestBody OaRecordPagination oaRecordPagination) throws IOException {
        RecordBorrowAlsoVo vo2;
        ArrayList<OaReturnListVO> newFileList = new ArrayList<OaReturnListVO>();
        OaReturnListVO oaReturnListVO = new OaReturnListVO();
        List<RecordBorrowAlsoVo> infoAlso = this.oaRecordSubitemService.getInfoAlso(null, oaRecordPagination);
        for (RecordBorrowAlsoVo vo2 : infoAlso) {
            oaReturnListVO = (OaReturnListVO)JsonUtil.getJsonToBean((Object)vo2, OaReturnListVO.class);
            oaReturnListVO.setFileName(vo2.getRecordSubitemName());
            oaReturnListVO.setFileCode(vo2.getSubitemCode());
            OaRecordEntity info = this.oaRecordService.getInfo(vo2.getRecordId());
            if (ObjectUtil.isNotEmpty((Object)info)) {
                oaReturnListVO.setRecordName(info.getRecordName());
                oaReturnListVO.setRecordPosition(info.getRecordPosition());
                oaReturnListVO.setChoseType(this.baseDataUtil.getDictName(info.getChoseType(), "choseType"));
            }
            newFileList.add(oaReturnListVO);
        }
        Page pageList = this.oaRecordBorrowService.getPage(oaRecordPagination, newFileList, newFileList.size());
        vo2 = new PageListVO();
        vo2.setList(pageList.getPageDatas());
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)pageList, PaginationVO.class);
        vo2.setPagination(page);
        return ActionResult.success((Object)vo2);
    }

    @GetMapping(value={"/subitem/{ids}"})
    public ActionResult<List<OaRecordSubitemForm>> info(@PathVariable(value="ids") List<String> id) {
        List<OaRecordSubitemForm> addList = this.oaRecordSubitemService.getAddList(id);
        return ActionResult.success(addList);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaRecordBorrowCrForm oaRecordBorrowCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "550649855677062149";
        UserInfo userInfo = this.userProvider.get();
        oaRecordBorrowCrForm.setCreatorUserId(userInfo.getUserId());
        OaRecordBorrowEntity entity = (OaRecordBorrowEntity)JsonUtil.getJsonToBean((Object)((Object)oaRecordBorrowCrForm), OaRecordBorrowEntity.class);
        String mainId = RandomUtil.uuId();
        OaRecordBorrowPrimaryEntity oaRecordBorrowPrimary = (OaRecordBorrowPrimaryEntity)JsonUtil.getJsonToBean((Object)((Object)oaRecordBorrowCrForm), OaRecordBorrowPrimaryEntity.class);
        oaRecordBorrowPrimary.setId(mainId);
        this.oaRecordBorrowPrimaryService.save(oaRecordBorrowPrimary);
        this.oaRecordBorrowService.borrowAdd(mainId, oaRecordBorrowCrForm);
        FlowUtil.saveOrSubmit((String)oaRecordBorrowCrForm.getTaskId(), (String)flowEngineId, (String)oaRecordBorrowCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaRecordBorrowCrForm), (Integer)oaRecordBorrowCrForm.getStatus());
        if (oaRecordBorrowCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @GetMapping(value={"/also/{type}/{ids}"})
    public ActionResult getAlsoIds(@PathVariable(value="type") String type, @PathVariable(value="ids") List<String> id) throws Exception {
        Boolean state = this.oaRecordSubitemService.getAlsoIds(type, id);
        if (state.booleanValue()) {
            return ActionResult.success((String)"\u5f52\u8fd8\u6210\u529f");
        }
        return ActionResult.success((String)"\u5f52\u8fd8\u5931\u8d25");
    }

    @GetMapping(value={"/press/{ids}"})
    public ActionResult getPressIds(@PathVariable(value="ids") List<String> id) throws Exception {
        Boolean state = this.oaRecordSubitemService.getPressIds(id);
        if (state.booleanValue()) {
            return ActionResult.success((String)"\u50ac\u529e\u6210\u529f");
        }
        return ActionResult.success((String)"\u50ac\u529e\u5931\u8d25");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaRecordBorrowInitVo> info(@PathVariable(value="id") String id) {
        OaRecordBorrowPrimaryEntity entity = this.oaRecordBorrowPrimaryService.getInfo(id);
        OaRecordBorrowInitVo vo = (OaRecordBorrowInitVo)JsonUtil.getJsonToBean((Object)entity, OaRecordBorrowInitVo.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaRecordBorrowEntity::getPrimaryId, (Object)id);
        List list = this.oaRecordBorrowService.list((Wrapper)queryWrapper);
        ArrayList<OaRecordBorrowSubitemForm> listZi = new ArrayList<OaRecordBorrowSubitemForm>();
        if (!list.isEmpty()) {
            for (OaRecordBorrowEntity borrowEntity : list) {
                OaRecordBorrowSubitemForm form = (OaRecordBorrowSubitemForm)JsonUtil.getJsonToBean((Object)borrowEntity, OaRecordBorrowSubitemForm.class);
                form.setBorrowId(form.getId());
                form.setId(form.getSubitemId());
                QueryWrapper queryWrapperSubitem = new QueryWrapper();
                queryWrapperSubitem.lambda().eq(OaRecordSubitemEntity::getId, (Object)borrowEntity.getSubitemId());
                form.setRecordSubitemName(borrowEntity.getFileName());
                form.setSubitemCode(borrowEntity.getFileCode());
                listZi.add(form);
            }
            vo.setOaRecordItemList(listZi);
        }
        return ActionResult.success((Object)vo);
    }
}

