/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.model.oafile.FileImportReturnVO;
import com.bringspring.contract.model.oafile.FileImportVO;
import com.bringspring.oa.annotation.QrCodeModel;
import com.bringspring.oa.entity.OaRecordEntity;
import com.bringspring.oa.entity.OaRecordLogEntity;
import com.bringspring.oa.entity.OaRecordSubitemEntity;
import com.bringspring.oa.mapper.OaRecordLogMapper;
import com.bringspring.oa.model.oaRecord.OaRecordCrForm;
import com.bringspring.oa.model.oaRecord.OaRecordInfoEnter;
import com.bringspring.oa.model.oaRecord.OaRecordInfoVO;
import com.bringspring.oa.model.oaRecord.OaRecordListVO;
import com.bringspring.oa.model.oaRecord.OaRecordPagination;
import com.bringspring.oa.model.oaRecord.OaRecordPaginationExportModel;
import com.bringspring.oa.model.oaRecord.OaRecordUpForm;
import com.bringspring.oa.model.oaRecord.QrCodeTypeEnum;
import com.bringspring.oa.model.oaRecordSubitem.OaRecordSubitemForm;
import com.bringspring.oa.service.OaRecordService;
import com.bringspring.oa.service.OaRecordSubitemService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"oa_record"}, value="oa")
@RequestMapping(value={"/api/oa/oaRecord"})
public class OaRecordController {
    private static final Logger log = LoggerFactory.getLogger(OaRecordController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaRecordService oaRecordService;
    @Autowired
    private OaRecordLogMapper oaRecordLogMapper;
    @Autowired
    private OaRecordSubitemService oaRecordSubitemService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaRecordPagination oaRecordPagination) throws IOException {
        List<OaRecordEntity> list = this.oaRecordService.getList(oaRecordPagination);
        List listVO = JsonUtil.getJsonToList(list, OaRecordListVO.class);
        for (OaRecordListVO oaRecordVO : listVO) {
            oaRecordVO.setChoseType(this.baseDataUtil.getDictName(oaRecordVO.getChoseType(), "choseType"));
            oaRecordVO.setSecrecyLevel(this.baseDataUtil.getDictName(oaRecordVO.getSecrecyLevel(), "secrecyLevel"));
            oaRecordVO.setRecordStatus(this.baseDataUtil.getDictName(oaRecordVO.getRecordStatus(), "recordStatus"));
            oaRecordVO.setLastModifyUserName(this.baseDataUtil.userSelectValue(oaRecordVO.getLastModifyUserId()));
            oaRecordVO.setCompanyId(this.baseDataUtil.comSelectValues(oaRecordVO.getCompanyId()));
            QrCodeModel qrCodeModel = new QrCodeModel();
            qrCodeModel.setType(QrCodeTypeEnum.File_ASSETS.getType());
            qrCodeModel.setDesc(QrCodeTypeEnum.File_ASSETS.getDesc());
            qrCodeModel.setContent(oaRecordVO.getFileCode());
            oaRecordVO.setQrCodeModel(qrCodeModel);
            oaRecordVO.setRecordSubitemList(this.oaRecordService.getInfoLis(oaRecordPagination.getKeyword(), oaRecordVO.getId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaRecordPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getSingleList"})
    public ActionResult getSingleList(@RequestBody OaRecordPagination oaRecordPagination) throws IOException {
        List<OaRecordEntity> list = this.oaRecordService.getSingleList(oaRecordPagination);
        List listVO = JsonUtil.getJsonToList(list, OaRecordListVO.class);
        for (OaRecordListVO oaRecordVO : listVO) {
            oaRecordVO.setChoseType(this.baseDataUtil.getDictName(oaRecordVO.getChoseType(), "choseType"));
            oaRecordVO.setRecordStatus(this.baseDataUtil.getDictName(oaRecordVO.getRecordStatus(), "recordStatus"));
            oaRecordVO.setCompanyId(this.baseDataUtil.comSelectValues(oaRecordVO.getCompanyId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaRecordPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaRecordCrForm oaRecordCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OaRecordEntity entity = (OaRecordEntity)JsonUtil.getJsonToBean((Object)oaRecordCrForm, OaRecordEntity.class);
        entity.setId(mainId);
        this.oaRecordService.save(entity);
        this.oaRecordSubitemService.insert(mainId, oaRecordCrForm.getOaRecordItemList());
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaRecordPaginationExportModel oaRecordPaginationExportModel) throws IOException {
        OaRecordListVO vo;
        if (StringUtil.isEmpty((String)oaRecordPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaRecordPagination oaRecordPagination = (OaRecordPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaRecordPaginationExportModel), OaRecordPagination.class));
        List<OaRecordEntity> list = this.oaRecordService.getTypeList(oaRecordPagination, oaRecordPaginationExportModel.getDataType());
        for (OaRecordEntity entity : list) {
            entity.setChoseType(this.baseDataUtil.getDictName(entity.getChoseType(), "choseType"));
            entity.setSecrecyLevel(this.baseDataUtil.getDictName(entity.getSecrecyLevel(), "secrecyLevel"));
            entity.setRecordStatus(this.baseDataUtil.getDictName(entity.getRecordStatus(), "recordStatus"));
            entity.setCompanyId(this.baseDataUtil.comSelectValues(entity.getCompanyId()));
            entity.setDepartmentId(this.baseDataUtil.comSelectValues(entity.getDepartmentId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaRecordListVO.class);
        ArrayList<OaRecordListVO> newFileList = new ArrayList<OaRecordListVO>();
        for (OaRecordListVO oaRecordVO : listVO) {
            List<OaRecordSubitemForm> infoList = this.oaRecordSubitemService.getInfoList(oaRecordVO.getId());
            if (!infoList.isEmpty()) {
                for (OaRecordSubitemForm form : infoList) {
                    OaRecordListVO vo2 = (OaRecordListVO)JsonUtil.getJsonToBean((Object)oaRecordVO, OaRecordListVO.class);
                    vo2.setRecordSubitemName(form.getRecordSubitemName());
                    vo2.setSubitemCode(form.getSubitemCode());
                    vo2.setRemark(form.getRemark());
                    vo2.setSubitemType(this.baseDataUtil.getDictName(form.getSubitemType(), "recordPattern"));
                    newFileList.add(vo2);
                }
                continue;
            }
            vo = (OaRecordListVO)JsonUtil.getJsonToBean((Object)oaRecordVO, OaRecordListVO.class);
            newFileList.add(vo);
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(newFileList, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)oaRecordPaginationExportModel.getSelectKey()) ? oaRecordPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block36: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "recordName": {
                        entitys.add(new ExcelExportEntity("\u6863\u6848\u76d2\u7f16\u7801\u53ca\u540d\u79f0", (Object)"recordName"));
                        continue block36;
                    }
                    case "choseType": {
                        entitys.add(new ExcelExportEntity("\u6863\u6848\u7c7b\u578b", (Object)"choseType"));
                        continue block36;
                    }
                    case "fileCode": {
                        entitys.add(new ExcelExportEntity("\u6863\u6848\u7f16\u7801", (Object)"fileCode"));
                        continue block36;
                    }
                    case "fileName": {
                        entitys.add(new ExcelExportEntity("\u6863\u6848\u540d\u79f0", (Object)"fileName"));
                        continue block36;
                    }
                    case "recordStatus": {
                        entitys.add(new ExcelExportEntity("\u6863\u6848\u72b6\u6001 ", (Object)"recordStatus"));
                        continue block36;
                    }
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyId"));
                        continue block36;
                    }
                    case "recordSubitemName": {
                        entitys.add(new ExcelExportEntity("\u6863\u6848\u5b50\u9879\u540d\u79f0", (Object)"recordSubitemName"));
                        continue block36;
                    }
                    case "subitemCode": {
                        entitys.add(new ExcelExportEntity("\u6863\u6848\u5b50\u9879\u7f16\u7801", (Object)"subitemCode"));
                        continue block36;
                    }
                    case "subitemType": {
                        entitys.add(new ExcelExportEntity("\u6863\u6848\u5b50\u9879\u5f62\u6001", (Object)"subitemType"));
                        continue block36;
                    }
                    case "number": {
                        entitys.add(new ExcelExportEntity("\u4efd\u6570", (Object)"number"));
                        continue block36;
                    }
                    case "pages": {
                        entitys.add(new ExcelExportEntity("\u9875\u6570", (Object)"pages"));
                        continue block36;
                    }
                    case "remark": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"remark"));
                        continue block36;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaRecordInfoVO> info(@PathVariable(value="id") String id) {
        OaRecordEntity entity = this.oaRecordService.getInfo(id);
        OaRecordInfoVO vo = (OaRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, OaRecordInfoVO.class);
        vo.setOaRecordItemList(this.oaRecordSubitemService.getInfoList(id));
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/oaRecordEnter"})
    public ActionResult<OaRecordInfoVO> getInfoEnter(@RequestBody OaRecordInfoEnter oaRecordInfoEnter) {
        OaRecordEntity entity = this.oaRecordService.getInfo(oaRecordInfoEnter.getId());
        OaRecordInfoVO vo = (OaRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, OaRecordInfoVO.class);
        vo.setOaRecordItemList(this.oaRecordSubitemService.getInfoEnterList(oaRecordInfoEnter.getId(), oaRecordInfoEnter.getSubitemIds()));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaRecordInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OaRecordEntity entity = this.oaRecordService.getInfo(id);
        OaRecordInfoVO vo = (OaRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, OaRecordInfoVO.class);
        OaRecordInfoVO voDetail = this.oaRecordService.getDetailInfo(id, vo);
        QrCodeModel qrCodeModel = new QrCodeModel();
        qrCodeModel.setType(QrCodeTypeEnum.File_ASSETS.getType());
        qrCodeModel.setDesc(QrCodeTypeEnum.File_ASSETS.getDesc());
        qrCodeModel.setContent(vo.getFileCode());
        vo.setQrCodeModel(qrCodeModel);
        return ActionResult.success((Object)voDetail);
    }

    @PostMapping(value={"/scanning"})
    public ActionResult<OaRecordInfoVO> scanningInfo(@RequestBody OaRecordPagination oaRecordPagination) {
        if (StringUtils.isNull((Object)oaRecordPagination.getFileCode())) {
            return ActionResult.fail((String)"\u6863\u6848\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        OaRecordEntity entity = this.oaRecordService.scanningInfo(oaRecordPagination);
        if (ObjectUtil.isNotEmpty((Object)entity)) {
            OaRecordInfoVO vo = (OaRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, OaRecordInfoVO.class);
            OaRecordInfoVO voDetail = this.oaRecordService.getRecirdInfo(oaRecordPagination, vo);
            return ActionResult.success((Object)voDetail);
        }
        return ActionResult.fail((String)"\u6863\u6848\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaRecordUpForm oaRecordUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OaRecordEntity entity = this.oaRecordService.getInfo(id);
        if (ObjectUtil.isNotEmpty((Object)entity)) {
            OaRecordEntity subentity = (OaRecordEntity)JsonUtil.getJsonToBean((Object)oaRecordUpForm, OaRecordEntity.class);
            this.oaRecordService.oaRecordLodAdd(entity, subentity);
            OaRecordEntity subentityUpdate = (OaRecordEntity)JsonUtil.getJsonToBean((Object)oaRecordUpForm, OaRecordEntity.class);
            this.oaRecordService.update(id, subentityUpdate);
            this.oaRecordSubitemService.delectAll(id);
            this.oaRecordSubitemService.insert(id, oaRecordUpForm.getOaRecordItemList());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaRecordEntity entity = this.oaRecordService.getInfo(id);
        if (entity != null) {
            this.oaRecordService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/recordStatus/{type}/{id}"})
    public ActionResult recordStatus(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        OaRecordEntity info = this.oaRecordService.getInfo(id);
        OaRecordLogEntity oaRecordLogEntity = new OaRecordLogEntity();
        oaRecordLogEntity.setFormer(this.baseDataUtil.getDictName(info.getRecordStatus(), "recordStatus"));
        String mainId = RandomUtil.uuId();
        oaRecordLogEntity.setId(mainId);
        oaRecordLogEntity.setRecordId(id);
        oaRecordLogEntity.setLogType("\u6863\u6848\u72b6\u6001\u53d8\u66f4");
        oaRecordLogEntity.setChangeContent(this.baseDataUtil.getDictName(type, "recordStatus"));
        this.oaRecordLogMapper.insert(oaRecordLogEntity);
        info.setRecordStatus(type);
        this.oaRecordService.update(id, info);
        List<OaRecordSubitemForm> subitemList = this.oaRecordSubitemService.getInfoList(id);
        if (!subitemList.isEmpty()) {
            for (OaRecordSubitemForm form : subitemList) {
                OaRecordSubitemEntity subentity = new OaRecordSubitemEntity();
                subentity.setSubitemStates(type);
                this.oaRecordSubitemService.update(form.getId(), subentity);
            }
        }
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<FileImportReturnVO> ImportData(@RequestBody FileImportVO data) {
        List dataList = JsonUtil.getJsonToList((Object)data.getList(), FileImportVO.class);
        FileImportReturnVO result = this.oaRecordService.importData(dataList);
        return ActionResult.success((Object)result);
    }
}

