/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oa.entity.OaRecordEntity;
import com.bringspring.oa.entity.OaRecordSubitemEntity;
import com.bringspring.oa.mapper.OaRecordSubitemMapper;
import com.bringspring.oa.model.oaRecord.OaRecordInfoEnter;
import com.bringspring.oa.model.oaRecord.OaRecordInfoVO;
import com.bringspring.oa.model.oaRecord.RecordStatusRemarkVo;
import com.bringspring.oa.model.oaRecordSubitem.OaRecordSubitemForm;
import com.bringspring.oa.model.oaRecordSubitem.OaRecordSubitemListVO;
import com.bringspring.oa.model.oaRecordSubitem.OaRecordSubitemPagination;
import com.bringspring.oa.service.OaRecordSubitemService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"oa_record_subitem"}, value="oa")
@RequestMapping(value={"/api/oa/OaRecordSubitem"})
public class OaRecordSubitemController {
    private static final Logger log = LoggerFactory.getLogger(OaRecordSubitemController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaRecordSubitemService oaRecordSubitemService;
    @Autowired
    private OaRecordSubitemMapper oaRecordSubitemMapper;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaRecordSubitemPagination oaRecordSubitemPagination) throws IOException {
        List<OaRecordSubitemEntity> list = this.oaRecordSubitemService.getList(oaRecordSubitemPagination);
        List<String> stringStream = list.stream().map(entity -> entity.getBusinessId()).collect(Collectors.toList());
        List subitemEntities = new ArrayList();
        if (CollectionUtil.isNotEmpty(stringStream)) {
            List<OaRecordSubitemEntity> listBy = this.oaRecordSubitemMapper.getListBy(stringStream);
            List groupingId = listBy.stream().map(entity -> entity.getId()).collect(Collectors.toList());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(OaRecordSubitemEntity::getId, (Collection)groupingId);
            queryWrapper.lambda().orderByDesc(OaRecordSubitemEntity::getCreatorTime);
            subitemEntities = this.oaRecordSubitemMapper.selectList((Wrapper)queryWrapper);
        }
        List listVO = JsonUtil.getJsonToList(subitemEntities, OaRecordSubitemListVO.class);
        for (OaRecordSubitemListVO oaRecordSubitemVO : listVO) {
            oaRecordSubitemVO.setSubitemType(this.baseDataUtil.getDictName(oaRecordSubitemVO.getSubitemType(), "recordPattern"));
            oaRecordSubitemVO.setSubitemStates(this.baseDataUtil.getDictName(oaRecordSubitemVO.getSubitemStates(), "subitem"));
            oaRecordSubitemVO.setBusinessType(this.baseDataUtil.getDictName(oaRecordSubitemVO.getBusinessType(), "dataSources"));
            oaRecordSubitemVO.setCreatorUserId(this.baseDataUtil.userSelectValue(oaRecordSubitemVO.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaRecordSubitemPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/oaRecordEnterAdd"})
    public ActionResult<OaRecordInfoVO> getInfoRecordEnterAdd(@RequestBody OaRecordInfoEnter oaRecordInfoEnter) {
        OaRecordEntity entity = new OaRecordEntity();
        OaRecordInfoVO vo = (OaRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, OaRecordInfoVO.class);
        vo.setOaRecordItemList(this.oaRecordSubitemService.getInfoRecordEnterAdd(oaRecordInfoEnter));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaRecordSubitemForm> info(@PathVariable(value="id") String id) {
        OaRecordSubitemEntity entity = this.oaRecordSubitemService.getInfo(id);
        OaRecordSubitemForm vo = (OaRecordSubitemForm)JsonUtil.getJsonToBean((Object)entity, OaRecordSubitemForm.class);
        vo.setSubitemType(this.baseDataUtil.getDictName(vo.getSubitemType(), "recordPattern"));
        vo.setSubitemStates(this.baseDataUtil.getDictName(vo.getSubitemStates(), "subitem"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaRecordSubitemForm oaRecordUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OaRecordSubitemEntity entity = this.oaRecordSubitemService.getInfo(id);
        if (entity != null) {
            OaRecordSubitemEntity subentity = (OaRecordSubitemEntity)JsonUtil.getJsonToBean((Object)oaRecordUpForm, OaRecordSubitemEntity.class);
            subentity.setId(id);
            this.oaRecordSubitemService.updateById(subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/recordStatus/{type}/{id}"})
    public ActionResult recordStatus(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        OaRecordSubitemEntity info = this.oaRecordSubitemService.getInfo(id);
        info.setSubitemStates(type);
        this.oaRecordSubitemService.updateById(info);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @PostMapping(value={"/recordStatusRemark"})
    public ActionResult recordStatusRemark(@RequestBody RecordStatusRemarkVo vo) {
        OaRecordSubitemEntity info = this.oaRecordSubitemService.getInfo(vo.getId());
        info.setSubitemStates(vo.getType());
        info.setNoRemark(vo.getNoRemark());
        this.oaRecordSubitemService.updateById(info);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }
}

