/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.oa.entity.OaRuleRegulationsFileEntity;
import com.bringspring.oa.entity.OaRuleRegulationsFileHistoryEntity;
import com.bringspring.oa.entity.OaRuleRegulationsFileRelationEntity;
import com.bringspring.oa.model.oaruleregulations.OaRuleRegulationsFileCrForm;
import com.bringspring.oa.model.oaruleregulations.OaRuleRegulationsFileHistoryCrForm;
import com.bringspring.oa.model.oaruleregulations.OaRuleRegulationsFileHistoryInfoVO;
import com.bringspring.oa.model.oaruleregulations.OaRuleRegulationsFileInfoVO;
import com.bringspring.oa.model.oaruleregulations.OaRuleRegulationsFileListVO;
import com.bringspring.oa.model.oaruleregulations.OaRuleRegulationsFilePagination;
import com.bringspring.oa.model.oaruleregulations.OaRuleRegulationsFileUpForm;
import com.bringspring.oa.service.OaRuleRegulationsFileHistoryService;
import com.bringspring.oa.service.OaRuleRegulationsFileRelationService;
import com.bringspring.oa.service.OaRuleRegulationsFileService;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u89c4\u7ae0\u5236\u5ea6"}, value="oa")
@RequestMapping(value={"/api/oa/OaRuleRegulationsFile"})
public class OaRuleRegulationsFileController {
    private static final Logger log = LoggerFactory.getLogger(OaRuleRegulationsFileController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaRuleRegulationsFileService oaRuleRegulationsFileService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private OaRuleRegulationsFileRelationService oaRuleRegulationsFileRelationService;
    @Autowired
    private OaRuleRegulationsFileHistoryService oaRuleRegulationsFileHistoryService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaRuleRegulationsFilePagination OaRuleRegulationsFilePagination2) throws IOException {
        List<OaRuleRegulationsFileEntity> list = this.oaRuleRegulationsFileService.getList(OaRuleRegulationsFilePagination2);
        UserInfo userInfo = this.userProvider.get();
        List listVO = JsonUtil.getJsonToList(list, OaRuleRegulationsFileListVO.class);
        List organizeList = this.organizeService.getOrgRedisList();
        for (OaRuleRegulationsFileListVO entity : listVO) {
            DictionaryTypeEntity typeTemp;
            entity.setFileType(this.baseDataUtil.getDictName(entity.getFileType(), entity.getRuleType()));
            if (StringUtils.isNotEmpty((String)entity.getRuleType()) && (typeTemp = this.dictionaryTypeService.getInfo(entity.getRuleType())) != null) {
                entity.setRuleType(typeTemp.getFullName());
            }
            entity.setFilePath(this.baseDataUtil.getFileNameInJson(entity.getFilePath()));
            entity.setCreatorUserName(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            List<String> companyList = this.oaRuleRegulationsFileService.strToList(entity.getCompanyName());
            if (entity.getLastModifyTime() == null) {
                entity.setLastModifyTime(entity.getCreatorTime());
            }
            if (entity.getCreatorUserId().equals(userInfo.getUserId())) {
                entity.setUpdateFlag(true);
            }
            if (companyList.isEmpty()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            block1: for (String s : companyList) {
                if (organizeList == null) continue;
                for (OrganizeEntity organize : organizeList) {
                    if (!s.equals(organize.getId())) continue;
                    stringBuilder.append(organize.getFullName() + ",");
                    continue block1;
                }
            }
            if (stringBuilder == null) continue;
            entity.setCompanyName(stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)OaRuleRegulationsFilePagination2), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaRuleRegulationsFileCrForm oaRuleRegulationsFileCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaRuleRegulationsFileCrForm.setCreatorUserId(userInfo.getUserId());
        oaRuleRegulationsFileCrForm.setCreatorTime(DateUtil.getNow());
        OaRuleRegulationsFileEntity entity = (OaRuleRegulationsFileEntity)JsonUtil.getJsonToBean((Object)oaRuleRegulationsFileCrForm, OaRuleRegulationsFileEntity.class);
        entity.setId(mainId);
        this.oaRuleRegulationsFileService.save(entity);
        JSONArray companyNameList = JSONArray.parseArray((String)oaRuleRegulationsFileCrForm.getCompanyName());
        for (Object temp : companyNameList) {
            OaRuleRegulationsFileRelationEntity oaRuleRegulationsFileRelationEntity = new OaRuleRegulationsFileRelationEntity();
            oaRuleRegulationsFileRelationEntity.setParentId(mainId);
            oaRuleRegulationsFileRelationEntity.setCompanyName(temp.toString());
            this.oaRuleRegulationsFileRelationService.save(oaRuleRegulationsFileRelationEntity);
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaRuleRegulationsFileInfoVO> info(@PathVariable(value="id") String id) {
        OaRuleRegulationsFileEntity entity = this.oaRuleRegulationsFileService.getInfo(id);
        OaRuleRegulationsFileInfoVO vo = (OaRuleRegulationsFileInfoVO)JsonUtil.getJsonToBean((Object)entity, OaRuleRegulationsFileInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaRuleRegulationsFileInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OaRuleRegulationsFileEntity entity = this.oaRuleRegulationsFileService.getInfo(id);
        OaRuleRegulationsFileInfoVO vo = (OaRuleRegulationsFileInfoVO)JsonUtil.getJsonToBean((Object)entity, OaRuleRegulationsFileInfoVO.class);
        vo.setFileType(this.dictionaryDataService.getInfo(vo.getFileType()).getFullName());
        vo.setFilePath(this.baseDataUtil.getFileNameInJson(vo.getFilePath()));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        List<String> companyList = this.oaRuleRegulationsFileService.strToList(entity.getCompanyName());
        if (vo.getLastModifyTime() == null) {
            vo.setLastModifyTime(vo.getCreatorTime());
        }
        if (!companyList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String s : companyList) {
                OrganizeEntity info = this.organizeService.getInfo(s);
                if (info == null) continue;
                stringBuilder.append(info.getFullName() + ",");
            }
            vo.setCompanyName(stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1));
        }
        List<OaRuleRegulationsFileHistoryEntity> historyList = this.oaRuleRegulationsFileHistoryService.getListByParentId(id);
        List historyInfoVOList = JsonUtil.getJsonToList(historyList, OaRuleRegulationsFileHistoryInfoVO.class);
        for (OaRuleRegulationsFileHistoryInfoVO o : historyInfoVOList) {
            o.setFilePath(this.baseDataUtil.getFileNameInJson(o.getFilePath()));
            o.setFileType(this.baseDataUtil.getDictName(o.getFileType()));
        }
        vo.setOaRuleRegulationsFileHistoryInfoVOList(historyInfoVOList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaRuleRegulationsFileUpForm OaRuleRegulationsFileUpForm2) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OaRuleRegulationsFileEntity entity = this.oaRuleRegulationsFileService.getInfo(id);
        if (entity != null) {
            OaRuleRegulationsFileEntity subentity = (OaRuleRegulationsFileEntity)JsonUtil.getJsonToBean((Object)OaRuleRegulationsFileUpForm2, OaRuleRegulationsFileEntity.class);
            subentity.setLastModifyUserId(userInfo.getUserId());
            subentity.setLastModifyTime(new Date());
            this.oaRuleRegulationsFileService.update(id, subentity);
            this.oaRuleRegulationsFileRelationService.deleteByParentId(id);
            JSONArray companyNameList = JSONArray.parseArray((String)OaRuleRegulationsFileUpForm2.getCompanyName());
            for (Object temp : companyNameList) {
                OaRuleRegulationsFileRelationEntity oaRuleRegulationsFileRelationEntity = new OaRuleRegulationsFileRelationEntity();
                oaRuleRegulationsFileRelationEntity.setParentId(id);
                oaRuleRegulationsFileRelationEntity.setCompanyName(temp.toString());
                this.oaRuleRegulationsFileRelationService.save(oaRuleRegulationsFileRelationEntity);
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/updateVersion/{id}"})
    @DSTransactional
    public ActionResult updateVersion(@PathVariable(value="id") String id, @RequestBody @Valid OaRuleRegulationsFileHistoryCrForm oaRuleRegulationsFileHistoryCrForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OaRuleRegulationsFileEntity entity = this.oaRuleRegulationsFileService.getInfo(id);
        if (entity != null) {
            OaRuleRegulationsFileEntity subentity = (OaRuleRegulationsFileEntity)JsonUtil.getJsonToBean((Object)oaRuleRegulationsFileHistoryCrForm, OaRuleRegulationsFileEntity.class);
            subentity.setLastModifyUserId(userInfo.getUserId());
            subentity.setLastModifyTime(new Date());
            this.oaRuleRegulationsFileService.update(id, subentity);
            this.oaRuleRegulationsFileRelationService.deleteByParentId(id);
            JSONArray companyNameList = JSONArray.parseArray((String)oaRuleRegulationsFileHistoryCrForm.getCompanyName());
            for (Object temp : companyNameList) {
                OaRuleRegulationsFileRelationEntity oaRuleRegulationsFileRelationEntity = new OaRuleRegulationsFileRelationEntity();
                oaRuleRegulationsFileRelationEntity.setParentId(id);
                oaRuleRegulationsFileRelationEntity.setCompanyName(temp.toString());
                this.oaRuleRegulationsFileRelationService.save(oaRuleRegulationsFileRelationEntity);
            }
            OaRuleRegulationsFileHistoryEntity saveEntity = (OaRuleRegulationsFileHistoryEntity)JsonUtil.getJsonToBean((Object)entity, OaRuleRegulationsFileHistoryEntity.class);
            saveEntity.setParentId(id);
            saveEntity.setId(RandomUtil.uuId());
            this.oaRuleRegulationsFileHistoryService.save(saveEntity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaRuleRegulationsFileEntity entity = this.oaRuleRegulationsFileService.getInfo(id);
        if (entity != null) {
            this.oaRuleRegulationsFileService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/downLoad/{id}"})
    @DSTransactional
    public ActionResult downLoad(@PathVariable(value="id") String id) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OaRuleRegulationsFileEntity entity = this.oaRuleRegulationsFileService.getInfo(id);
        return null;
    }
}

