/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.model.rkcontractprocure.OaContractInternalTransactionInfo;
import com.bringspring.contract.service.OaContractInternalCrmService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaSaleEnterProjectDetailEntity;
import com.bringspring.oa.entity.OaSaleEnterProjectEntity;
import com.bringspring.oa.entity.OaSaleInvoiceDetailEntity;
import com.bringspring.oa.entity.OaSaleInvoiceEntity;
import com.bringspring.oa.entity.OaSaleInvoiceMulEntity;
import com.bringspring.oa.entity.OaSaleInvoiceProjectEntity;
import com.bringspring.oa.entity.OaSaleInvoiceProjectReturnEntity;
import com.bringspring.oa.model.oaattachment.OaAttachmentCrForm;
import com.bringspring.oa.model.oasaleinvoice.EnterInvoiceModel;
import com.bringspring.oa.model.oasaleinvoice.OaSaleInvoiceCrForm;
import com.bringspring.oa.model.oasaleinvoice.OaSaleInvoiceInfoVO;
import com.bringspring.oa.model.oasaleinvoice.OaSaleInvoiceListVO;
import com.bringspring.oa.model.oasaleinvoice.OaSaleInvoicePagination;
import com.bringspring.oa.model.oasaleinvoice.OaSaleInvoicePaginationExportModel;
import com.bringspring.oa.model.oasaleinvoice.OaSaleInvoiceUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaSaleEnterProjectDetailService;
import com.bringspring.oa.service.OaSaleEnterProjectService;
import com.bringspring.oa.service.OaSaleInvoiceDetailService;
import com.bringspring.oa.service.OaSaleInvoiceMulService;
import com.bringspring.oa.service.OaSaleInvoiceProjectReturnService;
import com.bringspring.oa.service.OaSaleInvoiceProjectService;
import com.bringspring.oa.service.OaSaleInvoiceService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9500\u552e\u53d1\u7968\u7533\u8bf7"}, value="oa")
@RequestMapping(value={"/api/oa/OaSaleInvoice"})
public class OaSaleInvoiceController {
    private static final Logger log = LoggerFactory.getLogger(OaSaleInvoiceController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaSaleInvoiceService oaSaleInvoiceService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private OaSaleInvoiceProjectService oaSaleInvoiceProjectService;
    @Autowired
    private OaSaleInvoiceDetailService oaSaleInvoiceDetailService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private OaSaleEnterProjectDetailService oaSaleEnterProjectDetailService;
    @Autowired
    private OaSaleEnterProjectService oaSaleEnterProjectService;
    @Autowired
    private OaSaleInvoiceProjectReturnService oaSaleInvoiceProjectReturnService;
    @Autowired
    private RkContractReturnPlanService rkContractReturnPlanService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private OaSaleInvoiceMulService oaSaleInvoiceMulService;
    @Autowired
    private OaContractInternalCrmService oaContractInternalCrmService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaSaleInvoicePagination oaSaleInvoicePagination) throws IOException {
        List<OaSaleInvoiceEntity> list = this.oaSaleInvoiceService.getList(oaSaleInvoicePagination);
        for (OaSaleInvoiceEntity iterator : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, OaSaleInvoiceListVO.class);
        for (OaSaleInvoiceListVO oaSaleInvoiceVO : listVO) {
            List<OaSaleInvoiceProjectEntity> saleInvoiceProjectList;
            RkContractEntity contractInfo;
            BigDecimal actualInvoiceAmount;
            String applyInvoiceAmountStr;
            oaSaleInvoiceVO.setTaxRateId(oaSaleInvoiceVO.getTaxRate());
            oaSaleInvoiceVO.setInvoiceTypeId(oaSaleInvoiceVO.getInvoiceType());
            oaSaleInvoiceVO.setTaxRate(this.baseDataUtil.getDictName(oaSaleInvoiceVO.getTaxRateId(), "contractRate"));
            oaSaleInvoiceVO.setInvoiceType(this.baseDataUtil.getDictName(oaSaleInvoiceVO.getInvoiceTypeId(), "invoiceRegister"));
            oaSaleInvoiceVO.setPaymentType(this.baseDataUtil.getDictName(oaSaleInvoiceVO.getPaymentType(), "paymentType"));
            if (ObjectUtil.isEmpty((Object)oaSaleInvoiceVO.getActualInvoiceAmount())) {
                oaSaleInvoiceVO.setActualInvoiceAmount("0.00");
            }
            BigDecimal applyInvoiceAmount = (applyInvoiceAmountStr = oaSaleInvoiceVO.getApplyInvoiceAmount()) != null ? new BigDecimal(applyInvoiceAmountStr) : BigDecimal.ZERO;
            String actualInvoiceAmountStr = oaSaleInvoiceVO.getActualInvoiceAmount();
            BigDecimal bigDecimal = actualInvoiceAmount = actualInvoiceAmountStr != null ? new BigDecimal(actualInvoiceAmountStr) : BigDecimal.ZERO;
            if (actualInvoiceAmount.compareTo(applyInvoiceAmount) >= 0) {
                oaSaleInvoiceVO.setEnableMark(6);
            }
            if (ObjectUtil.isNotEmpty((Object)(contractInfo = this.rkContractService.getInfo(oaSaleInvoiceVO.getContractId())))) {
                oaSaleInvoiceVO.setContractName(contractInfo.getContractName());
                oaSaleInvoiceVO.setContractCode(contractInfo.getContractCode());
                contractInfo.setCustomerName(ObjectUtil.isEmpty((Object)contractInfo.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)contractInfo.getCustomerId()))).getName());
                if (!ObjectUtil.isEmpty((Object)contractInfo.getIsAgent()) && contractInfo.getIsAgent().equals(1)) {
                    if (ObjectUtil.isNotEmpty((Object)contractInfo.getAgentId())) {
                        oaSaleInvoiceVO.setAgentName(((RkAgentEntity)this.rkAgentService.getById((Serializable)((Object)contractInfo.getAgentId()))).getName());
                    }
                } else {
                    oaSaleInvoiceVO.setAgentName(contractInfo.getCustomerName());
                }
                oaSaleInvoiceVO.setSalerName(contractInfo.getSalerName());
                oaSaleInvoiceVO.setContractAmount(contractInfo.getContractAmount());
                oaSaleInvoiceVO.setInvoicePerson(this.baseDataUtil.userSelectValue(oaSaleInvoiceVO.getCreatorUserId()));
                oaSaleInvoiceVO.setInvoiceDate(oaSaleInvoiceVO.getCreatorTime());
            }
            if (!CollectionUtil.isNotEmpty(saleInvoiceProjectList = this.oaSaleInvoiceProjectService.listByInvoiceId(oaSaleInvoiceVO.getId()))) continue;
            oaSaleInvoiceVO.setProjectList(saleInvoiceProjectList);
            String projectName = saleInvoiceProjectList.stream().map(OaSaleInvoiceProjectEntity::getProjectName).collect(Collectors.joining(","));
            oaSaleInvoiceVO.setProjectName(projectName);
            String projectCode = saleInvoiceProjectList.stream().map(OaSaleInvoiceProjectEntity::getProjectCode).collect(Collectors.joining(","));
            oaSaleInvoiceVO.setProjectCode(projectCode);
        }
        for (OaSaleInvoiceListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                if (!ObjectUtil.isNotEmpty((Object)vo.getEnableMark()) || vo.getEnableMark() != 6 && vo.getEnableMark() != -2) continue;
                vo.setFlowState(vo.getEnableMark());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaSaleInvoicePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaSaleInvoiceCrForm oaSaleInvoiceCrForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            Map temp;
            String flowEngineId = "519786783420993669";
            UserInfo userInfo = this.userProvider.get();
            String organizeId = userInfo.getOrganizeId();
            oaSaleInvoiceCrForm.setCreatorCompanyId(organizeId);
            String mainId = RandomUtil.uuId();
            OaSaleInvoiceEntity entity = (OaSaleInvoiceEntity)JsonUtil.getJsonToBean((Object)((Object)oaSaleInvoiceCrForm), OaSaleInvoiceEntity.class);
            entity.setId(mainId);
            entity.setCreatorTime(new Date());
            entity.setCreatorUserId(userInfo.getUserId());
            entity.setTaxRateName(this.baseDataUtil.getDictName(entity.getTaxRate(), "contractRate"));
            entity.setInvoiceTypeName(this.baseDataUtil.getDictName(entity.getInvoiceType(), "invoiceRegister"));
            entity.setPaymentTypeName(this.baseDataUtil.getDictName(entity.getPaymentType(), "paymentType"));
            entity.setCustomerQualificationName(this.baseDataUtil.getDictName(entity.getCustomerQualification(), "customerQualification"));
            RkContractEntity contractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)oaSaleInvoiceCrForm.getContractId()));
            UserEntity sealer = this.serviceUtil.getUserInfo(contractEntity.getSalerId());
            if (ObjectUtil.isNotEmpty((Object)sealer) && ObjectUtil.isNotEmpty((Object)sealer.getManagerId())) {
                entity.setProjectSealer(sealer.getManagerId());
                entity.setProjectSealerName(this.baseDataUtil.userSelectValue(entity.getProjectSealer()));
            }
            this.oaSaleInvoiceService.save(entity);
            List<OaSaleInvoiceProjectEntity> projectList = oaSaleInvoiceCrForm.getProjectList();
            if (CollectionUtil.isNotEmpty(projectList)) {
                projectList.stream().forEach(project -> {
                    project.setId(RandomUtil.uuId());
                    project.setCompanyId(userInfo.getOrganizeId());
                    project.setInvoiceId(entity.getId());
                    project.setPaymentTypeName(this.baseDataUtil.getDictName(project.getPaymentType(), "paymentType"));
                    project.setCreatorUserId(userInfo.getUserId());
                    project.setCreatorTime(new Date());
                    List<OaSaleInvoiceProjectReturnEntity> returnPlanList = project.getReturnPlanList();
                    if (CollectionUtil.isNotEmpty(returnPlanList)) {
                        returnPlanList.stream().forEach(plan -> {
                            plan.setReturnPlanId(plan.getId());
                            plan.setId(RandomUtil.uuId());
                            plan.setCompanyId(userInfo.getOrganizeId());
                            plan.setInvoiceId(mainId);
                            plan.setCreatorTime(new Date());
                            plan.setCreatorUserId(userInfo.getUserId());
                            if (ObjectUtil.isNotEmpty((Object)plan.getReturnPlanId()) && oaSaleInvoiceCrForm.getEnableMark().equals("1")) {
                                RkContractReturnPlanEntity returnPlanEntity = (RkContractReturnPlanEntity)this.rkContractReturnPlanService.getById((Serializable)((Object)plan.getReturnPlanId()));
                                returnPlanEntity.setFreezeInvoicingAmount(returnPlanEntity.getFreezeInvoicingAmount().add(plan.getFreezeInvoicingAmount()));
                                returnPlanEntity.setRemainingInvoicedAmount(returnPlanEntity.getRemainingInvoicedAmount().subtract(plan.getFreezeInvoicingAmount()));
                                this.rkContractReturnPlanService.updateById((Object)returnPlanEntity);
                            }
                        });
                        this.oaSaleInvoiceProjectReturnService.saveBatch(returnPlanList);
                    }
                });
            }
            this.oaSaleInvoiceProjectService.saveBatch(projectList);
            List<OaSaleInvoiceDetailEntity> invoiceDetailList = oaSaleInvoiceCrForm.getInvoiceDetailList();
            if (CollectionUtil.isNotEmpty(invoiceDetailList)) {
                invoiceDetailList.stream().forEach(detail -> {
                    detail.setId(RandomUtil.uuId());
                    detail.setCompanyId(userInfo.getOrganizeId());
                    detail.setInvoiceId(entity.getId());
                    detail.setInvoiceTaxName(this.baseDataUtil.getDictName(detail.getInvoiceTax(), "contractRate"));
                    detail.setCreatorUserId(userInfo.getUserId());
                    detail.setCreatorTime(new Date());
                });
            }
            this.oaSaleInvoiceDetailService.saveBatch(invoiceDetailList);
            List<OaAttachmentCrForm> attachmentList = oaSaleInvoiceCrForm.getAttachmentList();
            attachmentList.stream().forEach(attach -> {
                attach.setContractId(mainId);
                attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(attachmentEntityList);
            if (ObjectUtil.isNotEmpty((Object)contractEntity)) {
                oaSaleInvoiceCrForm.setContractName(contractEntity.getContractName());
            }
            oaSaleInvoiceCrForm.setProjectSealer(entity.getProjectSealer());
            List<OaSaleInvoiceMulEntity> mulList = oaSaleInvoiceCrForm.getOaSaleInvoiceMulList();
            if (CollectionUtil.isNotEmpty(mulList)) {
                mulList.stream().forEach(a -> {
                    a.setParentId(mainId);
                    a.setContractId(oaSaleInvoiceCrForm.getContractId());
                    a.setProjectId(oaSaleInvoiceCrForm.getProjectId());
                });
                this.oaSaleInvoiceMulService.saveBatch(mulList);
            }
            oaSaleInvoiceCrForm.setSalerCompanyId(this.userService.getUserCompany(contractEntity.getSalerId()));
            if (StringUtils.isNotEmpty((String)contractEntity.getInternalContractId()) && ObjectUtil.isNotEmpty((Object)(temp = this.oaContractInternalCrmService.getInfoById(contractEntity.getInternalContractId())))) {
                OaContractInternalTransactionInfo oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean((Object)temp, OaContractInternalTransactionInfo.class);
                oaSaleInvoiceCrForm.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
            }
            oaSaleInvoiceCrForm.setPartyB(contractEntity.getPartyB());
            oaSaleInvoiceCrForm.setPartyBName(this.baseDataUtil.getDictName(contractEntity.getPartyB(), "ContractInternalTransactionSignSubject"));
            oaSaleInvoiceCrForm.setIsInternalContract(contractEntity.getIsInternalContract());
            oaSaleInvoiceCrForm.setInternalContractId(contractEntity.getInternalContractId());
            oaSaleInvoiceCrForm.setInternalContractRemarks(contractEntity.getInternalContractRemarks());
            oaSaleInvoiceCrForm.setIsTrustSettlement(contractEntity.getIsTrustSettlement());
            FlowUtil.saveOrSubmit((String)oaSaleInvoiceCrForm.getTaskId(), (String)flowEngineId, (String)oaSaleInvoiceCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaSaleInvoiceCrForm), (Integer)oaSaleInvoiceCrForm.getStatus(), (String)oaSaleInvoiceCrForm.getContractName());
            if (oaSaleInvoiceCrForm.getStatus() == 0) {
                return ActionResult.success((String)CrmReminderEnum.TS.getType());
            }
            return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping(value={"enter"})
    @DSTransactional
    public ActionResult enterInvoice(@RequestBody @Valid EnterInvoiceModel enterInvoiceModel) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            enterInvoiceModel.setCompanyId(userInfo.getOrganizeId());
            HashMap map = this.oaSaleInvoiceService.enterInvoice(enterInvoiceModel);
            if (ObjectUtil.isEmpty(map.get("error"))) {
                return ActionResult.success((String)"\u5f55\u5165\u6210\u529f");
            }
            return ActionResult.fail((String)map.get("error").toString());
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaSaleInvoiceInfoVO> info(@PathVariable(value="id") String id) {
        Map temp;
        OaSaleInvoiceEntity entity = this.oaSaleInvoiceService.getInfo(id);
        OaSaleInvoiceInfoVO vo = (OaSaleInvoiceInfoVO)JsonUtil.getJsonToBean((Object)entity, OaSaleInvoiceInfoVO.class);
        RkContractEntity contractInfo = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)vo.getContractId()));
        vo.setContractCode(contractInfo.getContractCode());
        vo.setContractName(contractInfo.getContractName());
        vo.setContractAmount(vo.getContractAmount());
        vo.setAgentName(vo.getAgentName());
        vo.setSalerName(vo.getSalerName());
        vo.setCustomerName(vo.getCustomerName());
        vo.setContractTypeDesc(vo.getContractTypeDesc());
        List<OaSaleInvoiceProjectEntity> projectList = this.oaSaleInvoiceProjectService.listByInvoiceId(id);
        projectList.stream().forEach(project -> {
            project.setProId(project.getProjectId());
            List<OaSaleInvoiceProjectReturnEntity> projectReturnPlanList = this.oaSaleInvoiceProjectReturnService.listByProjectId(project.getProjectId(), id);
            projectReturnPlanList.stream().forEach(plan -> {
                if (ObjectUtil.isNotEmpty((Object)plan.getReturnPlanId())) {
                    RkContractReturnPlanEntity returnPlanEntity = (RkContractReturnPlanEntity)this.rkContractReturnPlanService.getById((Serializable)((Object)plan.getReturnPlanId()));
                    plan.setPlanCode(returnPlanEntity.getPlanCode());
                    plan.setReceivableAmount(returnPlanEntity.getReceivableAmount());
                    if (ObjectUtil.isNotEmpty((Object)returnPlanEntity.getProjectId())) {
                        RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)returnPlanEntity.getProjectId()));
                        plan.setProjectCode(projectEntity.getProjectCode());
                        plan.setProjectName(projectEntity.getProjectName());
                    }
                }
            });
            project.setReturnPlanList(projectReturnPlanList);
        });
        vo.setProjectList(projectList);
        List<OaSaleInvoiceDetailEntity> invoiceDetailList = this.oaSaleInvoiceDetailService.listByInvoiceId(id);
        vo.setInvoiceDetailList(invoiceDetailList);
        vo.setSalerCompanyId(this.userService.getUserCompany(contractInfo.getSalerId()));
        List<OaSaleInvoiceMulEntity> mulList = this.oaSaleInvoiceMulService.getListByParentId(id);
        vo.setOaSaleInvoiceMulList(mulList);
        vo.setIsTrustSettlement(contractInfo.getIsTrustSettlement());
        if (StringUtils.isNotEmpty((String)contractInfo.getInternalContractId()) && ObjectUtil.isNotEmpty((Object)(temp = this.oaContractInternalCrmService.getInfoById(contractInfo.getInternalContractId())))) {
            OaContractInternalTransactionInfo oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean((Object)temp, OaContractInternalTransactionInfo.class);
            vo.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
        }
        vo.setIsInternalContract(contractInfo.getIsInternalContract());
        vo.setInternalContractId(contractInfo.getInternalContractId());
        vo.setInternalContractRemarks(contractInfo.getInternalContractRemarks());
        vo.setIsTrustSettlement(contractInfo.getIsTrustSettlement());
        vo.setPartyB(contractInfo.getPartyB());
        vo.setPartyBName(this.baseDataUtil.getDictName(contractInfo.getPartyB(), "ContractInternalTransactionSignSubject"));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getDetailByInvoiceId/{invoiceId}"})
    public ActionResult getDetailByInvoiceId(@PathVariable(value="invoiceId") String invoiceId) {
        List<OaSaleEnterProjectDetailEntity> enterInvoiceList = this.oaSaleEnterProjectDetailService.listByInvoiceId(invoiceId);
        enterInvoiceList.stream().forEach(detail -> {
            RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)detail.getProjectId()));
            if (ObjectUtil.isNotEmpty((Object)byId)) {
                detail.setProjectName(byId.getProjectName());
            }
        });
        return ActionResult.success(enterInvoiceList);
    }

    @GetMapping(value={"/getInfoByInvoiceId/{invoiceId}"})
    public ActionResult getInfoByInvoiceId(@PathVariable(value="invoiceId") String invoiceId) {
        List<OaSaleEnterProjectEntity> projectList = this.oaSaleEnterProjectService.listByInvoiceId(invoiceId);
        projectList.stream().forEach(project -> {
            project.setApplyInvoiceAmount(BigDecimal.ZERO);
            RkContractProjectEntity projectInfo = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)project.getProjectId()));
            project.setProjectName(projectInfo.getProjectName());
            project.setProjectAmount(projectInfo.getProjectAmount());
            project.setProjectCode(projectInfo.getProjectCode());
        });
        return ActionResult.success(projectList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaSaleInvoiceUpForm oaSaleInvoiceUpForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String flowEngineId = "519786783420993669";
            UserInfo userInfo = this.userProvider.get();
            OaSaleInvoiceEntity entity = this.oaSaleInvoiceService.getInfo(id);
            if (entity != null) {
                Map temp;
                OaSaleInvoiceEntity subentity = (OaSaleInvoiceEntity)JsonUtil.getJsonToBean((Object)((Object)oaSaleInvoiceUpForm), OaSaleInvoiceEntity.class);
                this.oaSaleInvoiceService.updateForm(id, oaSaleInvoiceUpForm);
                RkContractEntity contractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)oaSaleInvoiceUpForm.getContractId()));
                if (ObjectUtil.isNotEmpty((Object)contractEntity)) {
                    oaSaleInvoiceUpForm.setContractName(contractEntity.getContractName());
                }
                this.oaSaleInvoiceMulService.deleteByParentId(id);
                List<OaSaleInvoiceMulEntity> mulList = oaSaleInvoiceUpForm.getOaSaleInvoiceMulList();
                if (CollectionUtil.isNotEmpty(mulList)) {
                    mulList.stream().forEach(a -> {
                        a.setParentId(id);
                        a.setContractId(oaSaleInvoiceUpForm.getContractId());
                        a.setProjectId(oaSaleInvoiceUpForm.getProjectId());
                    });
                    this.oaSaleInvoiceMulService.saveBatch(mulList);
                }
                oaSaleInvoiceUpForm.setSalerCompanyId(this.userService.getUserCompany(contractEntity.getSalerId()));
                if (StringUtils.isNotEmpty((String)contractEntity.getInternalContractId()) && ObjectUtil.isNotEmpty((Object)(temp = this.oaContractInternalCrmService.getInfoById(contractEntity.getInternalContractId())))) {
                    OaContractInternalTransactionInfo oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean((Object)temp, OaContractInternalTransactionInfo.class);
                    oaSaleInvoiceUpForm.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
                }
                oaSaleInvoiceUpForm.setPartyB(contractEntity.getPartyB());
                oaSaleInvoiceUpForm.setIsInternalContract(contractEntity.getIsInternalContract());
                oaSaleInvoiceUpForm.setInternalContractId(contractEntity.getInternalContractId());
                oaSaleInvoiceUpForm.setInternalContractRemarks(contractEntity.getInternalContractRemarks());
                oaSaleInvoiceUpForm.setIsTrustSettlement(contractEntity.getIsTrustSettlement());
                oaSaleInvoiceUpForm.setPartyBName(this.baseDataUtil.getDictName(contractEntity.getPartyB(), "ContractInternalTransactionSignSubject"));
                oaSaleInvoiceUpForm.setProjectSealer(entity.getProjectSealer());
                oaSaleInvoiceUpForm.setCreatorCompanyId(userInfo.getOrganizeId());
                FlowUtil.saveOrSubmit((String)oaSaleInvoiceUpForm.getTaskId(), (String)flowEngineId, (String)oaSaleInvoiceUpForm.getTemplateId(), (String)id, (Object)((Object)oaSaleInvoiceUpForm), (Integer)oaSaleInvoiceUpForm.getStatus(), (String)oaSaleInvoiceUpForm.getContractName());
                if (oaSaleInvoiceUpForm.getStatus() == 0) {
                    return ActionResult.success((String)CrmReminderEnum.TS.getType());
                }
                return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaSaleInvoiceEntity entity = this.oaSaleInvoiceService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaSaleInvoiceService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaSaleInvoicePaginationExportModel oaSaleInvoicePaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)oaSaleInvoicePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaSaleInvoicePagination oaSaleInvoicePagination = (OaSaleInvoicePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaSaleInvoicePaginationExportModel), OaSaleInvoicePagination.class));
        List<OaSaleInvoiceEntity> list = this.oaSaleInvoiceService.getTypeList(oaSaleInvoicePagination, oaSaleInvoicePaginationExportModel.getDataType());
        for (OaSaleInvoiceEntity oaSaleInvoiceEntity : list) {
            oaSaleInvoiceEntity.setTaxRate(this.baseDataUtil.getDictName(oaSaleInvoiceEntity.getTaxRate(), "contractRate"));
            oaSaleInvoiceEntity.setInvoiceType(this.baseDataUtil.getDictName(oaSaleInvoiceEntity.getInvoiceType(), "invoiceRegister"));
            oaSaleInvoiceEntity.setPaymentType(this.baseDataUtil.getDictName(oaSaleInvoiceEntity.getPaymentType(), "paymentType"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaSaleInvoiceListVO.class);
        for (OaSaleInvoiceListVO oaSaleInvoiceListVO : listVO) {
            List<OaSaleInvoiceProjectEntity> saleInvoiceProjectList;
            RkContractEntity contractInfo;
            if (ObjectUtil.isEmpty((Object)oaSaleInvoiceListVO.getActualInvoiceAmount())) {
                oaSaleInvoiceListVO.setActualInvoiceAmount("0.00");
            }
            if (ObjectUtil.isNotEmpty((Object)(contractInfo = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)oaSaleInvoiceListVO.getContractId()))))) {
                oaSaleInvoiceListVO.setContractName(contractInfo.getContractName());
                oaSaleInvoiceListVO.setContractCode(contractInfo.getContractCode());
            }
            if (!CollectionUtil.isNotEmpty(saleInvoiceProjectList = this.oaSaleInvoiceProjectService.listByInvoiceId(oaSaleInvoiceListVO.getId()))) continue;
            oaSaleInvoiceListVO.setProjectList(saleInvoiceProjectList);
            String projectName = saleInvoiceProjectList.stream().map(OaSaleInvoiceProjectEntity::getProjectName).collect(Collectors.joining(","));
            oaSaleInvoiceListVO.setProjectName(projectName);
            String projectCode = saleInvoiceProjectList.stream().map(OaSaleInvoiceProjectEntity::getProjectCode).collect(Collectors.joining(","));
            oaSaleInvoiceListVO.setProjectCode(projectCode);
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)oaSaleInvoicePaginationExportModel.getSelectKey()) ? oaSaleInvoicePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block30: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block30;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block30;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block30;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode"));
                        continue block30;
                    }
                    case "applyInvoiceAmount": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u5f00\u7968\u91d1\u989d", (Object)"applyInvoiceAmount"));
                        continue block30;
                    }
                    case "actualInvoiceAmount": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u5f00\u7968\u91d1\u989d", (Object)"actualInvoiceAmount"));
                        continue block30;
                    }
                    case "taxRate": {
                        entitys.add(new ExcelExportEntity("\u7a0e\u7387", (Object)"taxRate"));
                        continue block30;
                    }
                    case "invoiceType": {
                        entitys.add(new ExcelExportEntity("\u53d1\u7968\u7c7b\u578b", (Object)"invoiceType"));
                        continue block30;
                    }
                    case "applyInvoiceDate": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u5f00\u7968\u9884\u8ba1\u56de\u6b3e\u65e5\u671f", (Object)"applyInvoiceDate"));
                        continue block30;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u9500\u552e\u53d1\u7968\u53f0\u8d26" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

