/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.PinYinUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.oa.entity.OaSealCompanyEntity;
import com.bringspring.oa.model.oasealcompany.OaSealCompanyCrForm;
import com.bringspring.oa.model.oasealcompany.OaSealCompanyInfoVO;
import com.bringspring.oa.model.oasealcompany.OaSealCompanyListVO;
import com.bringspring.oa.model.oasealcompany.OaSealCompanyPagination;
import com.bringspring.oa.model.oasealcompany.OaSealCompanyPaginationExportModel;
import com.bringspring.oa.model.oasealcompany.OaSealCompanyUpForm;
import com.bringspring.oa.service.OaSealCompanyService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5370\u7ae0\u7684\u516c\u53f8\u6863\u6848"}, value="oa")
@RequestMapping(value={"/api/oa/OaSealCompany"})
public class OaSealCompanyController {
    private static final Logger log = LoggerFactory.getLogger(OaSealCompanyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaSealCompanyService oaSealCompanyService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaSealCompanyPagination oaSealCompanyPagination) throws IOException {
        List<OaSealCompanyEntity> list = this.oaSealCompanyService.getList(oaSealCompanyPagination);
        for (OaSealCompanyEntity oaSealCompanyEntity : list) {
            oaSealCompanyEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaSealCompanyEntity.getCreatorUserId()));
            oaSealCompanyEntity.setDeptId(this.baseDataUtil.comSelectValue(oaSealCompanyEntity.getDeptId(), "last"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaSealCompanyListVO.class);
        for (OaSealCompanyListVO oaSealCompanyVO : listVO) {
            oaSealCompanyVO.setEnabledMark(this.baseDataUtil.switchSelectValue(oaSealCompanyVO.getEnabledMark(), "\u5f00", "\u5173"));
            oaSealCompanyVO.setUseDept(this.baseDataUtil.comSelectValues(oaSealCompanyVO.getUseDept()));
            oaSealCompanyVO.setSealManagerId(this.baseDataUtil.userSelectValue(oaSealCompanyVO.getSealManagerId()));
            oaSealCompanyVO.setLeaderId(this.baseDataUtil.userSelectValue(oaSealCompanyVO.getLeaderId()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaSealCompanyPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getListForForm"})
    public ActionResult listForForm(@RequestBody OaSealCompanyPagination oaSealCompanyPagination) throws IOException {
        List<OaSealCompanyEntity> list = this.oaSealCompanyService.getListForForm(oaSealCompanyPagination);
        for (OaSealCompanyEntity entity : list) {
            entity.setCreatorUserId(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            entity.setDeptId(this.baseDataUtil.comSelectValue(entity.getDeptId(), "last"));
        }
        if (StrUtil.isEmpty((CharSequence)oaSealCompanyPagination.getTemplateCompanyId())) {
            oaSealCompanyPagination.setTemplateCompanyId(this.userProvider.get().getDepartmentId());
        }
        OrganizeEntity organize = this.organizeService.getInfo(oaSealCompanyPagination.getTemplateCompanyId());
        List treeIds = JsonUtil.getJsonToList((Object)organize.getOrganizeIdTree().split(","), String.class);
        List listVO = JsonUtil.getJsonToList(list, OaSealCompanyListVO.class);
        block1: for (OaSealCompanyListVO oaSealCompanyVO : listVO) {
            oaSealCompanyVO.setEnabledMark(this.baseDataUtil.switchSelectValue(oaSealCompanyVO.getEnabledMark(), "\u5f00", "\u5173"));
            oaSealCompanyVO.setCanChoose(false);
            if (!StrUtil.equals((CharSequence)oaSealCompanyVO.getEnabledMark(), (CharSequence)"\u5f00")) continue;
            if (StringUtils.isNotEmpty((String)oaSealCompanyVO.getUseDept())) {
                String useDept = oaSealCompanyVO.getUseDept().replaceAll("[\\[\\]\"]", "");
                String[] userDeptArr = useDept.split(",");
                String lastDept = userDeptArr[userDeptArr.length - 1];
                OrganizeEntity o = this.organizeService.getInfo(lastDept);
                if (o.getCategory().equals("company")) {
                    if (ObjectUtil.isNotEmpty((Object)organize)) {
                        for (int i = treeIds.size(); i > 1; --i) {
                            List temp = treeIds.subList(0, i);
                            if (!useDept.contains(temp.stream().collect(Collectors.joining(",")))) continue;
                            oaSealCompanyVO.setCanChoose(true);
                            continue block1;
                        }
                        continue;
                    }
                    if (!oaSealCompanyVO.getCompanyId().equals(this.userProvider.get().getOrganizeId())) continue;
                    oaSealCompanyVO.setCanChoose(true);
                    continue;
                }
                if (!o.getId().equals(organize.getId())) continue;
                oaSealCompanyVO.setCanChoose(true);
                continue;
            }
            if (!oaSealCompanyVO.getCompanyId().equals(this.userProvider.get().getOrganizeId())) continue;
            oaSealCompanyVO.setCanChoose(true);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaSealCompanyPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OaSealCompanyCrForm oaSealCompanyCrForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        oaSealCompanyCrForm.setCreatorTime(DateUtil.now());
        oaSealCompanyCrForm.setCreatorUserId(userInfo.getUserId());
        oaSealCompanyCrForm.setDeptId(userInfo.getDepartmentId());
        if (StringUtils.isEmpty((String)oaSealCompanyCrForm.getEncode())) {
            oaSealCompanyCrForm.setEncode(PinYinUtil.getFirstSpell((String)oaSealCompanyCrForm.getCompanyName()).toUpperCase());
        }
        this.oaSealCompanyService.create(oaSealCompanyCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaSealCompanyPaginationExportModel oaSealCompanyPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaSealCompanyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaSealCompanyPagination oaSealCompanyPagination = (OaSealCompanyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaSealCompanyPaginationExportModel), OaSealCompanyPagination.class));
        List<OaSealCompanyEntity> list = this.oaSealCompanyService.getTypeList(oaSealCompanyPagination, oaSealCompanyPaginationExportModel.getDataType());
        for (OaSealCompanyEntity oaSealCompanyEntity : list) {
            oaSealCompanyEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaSealCompanyEntity.getCreatorUserId()));
            oaSealCompanyEntity.setDeptId(this.baseDataUtil.comSelectValue(oaSealCompanyEntity.getDeptId(), "last"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaSealCompanyListVO.class);
        for (OaSealCompanyListVO oaSealCompanyVO : listVO) {
            oaSealCompanyVO.setEnabledMark(this.baseDataUtil.switchSelectValue(oaSealCompanyVO.getEnabledMark(), "\u5f00", "\u5173"));
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaSealCompanyPaginationExportModel.getSelectKey()) ? oaSealCompanyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block38: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block38;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block38;
                    }
                    case "deptId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u90e8\u95e8", (Object)"deptId"));
                        continue block38;
                    }
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u5370\u7ae0\u516c\u53f8\u540d\u79f0", (Object)"companyName"));
                        continue block38;
                    }
                    case "encode": {
                        entitys.add(new ExcelExportEntity("\u5370\u7ae0\u516c\u53f8\u7f16\u7801", (Object)"encode"));
                        continue block38;
                    }
                    case "companyNameAs": {
                        entitys.add(new ExcelExportEntity("\u5370\u7ae0\u516c\u53f8\u7b80\u79f0", (Object)"companyNameAs"));
                        continue block38;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block38;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u6807\u5fd7", (Object)"enabledMark"));
                        continue block38;
                    }
                    case "sortCode": {
                        entitys.add(new ExcelExportEntity("\u6392\u5e8f\u7801", (Object)"sortCode"));
                        continue block38;
                    }
                    case "sealManagerId": {
                        entitys.add(new ExcelExportEntity("\u5370\u7ae0\u7ba1\u7406\u4eba\u5458", (Object)"sealManagerId"));
                        continue block38;
                    }
                    case "leaderId": {
                        entitys.add(new ExcelExportEntity("\u5206\u7ba1\u9886\u5bfc", (Object)"leaderId"));
                        continue block38;
                    }
                    case "accountId": {
                        entitys.add(new ExcelExportEntity("\u8d22\u52a1\u4f1a\u8ba1", (Object)"accountId"));
                        continue block38;
                    }
                    case "chequeId": {
                        entitys.add(new ExcelExportEntity("\u8d22\u52a1\u51fa\u7eb3\u4eba\u5458", (Object)"chequeId"));
                        continue block38;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaSealCompanyInfoVO> info(@PathVariable(value="id") String id) {
        OaSealCompanyEntity entity = this.oaSealCompanyService.getInfo(id);
        OaSealCompanyInfoVO vo = (OaSealCompanyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaSealCompanyInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLeader(this.baseDataUtil.userSelectValue(vo.getLeaderId()));
        vo.setCashier(this.baseDataUtil.userSelectValue(vo.getCashierId()));
        vo.setAccount(this.baseDataUtil.userSelectValue(vo.getAccountId()));
        vo.setSealManager(this.baseDataUtil.userSelectValue(vo.getSealManagerId()));
        vo.setDeptId(this.baseDataUtil.comSelectValue(vo.getDeptId(), "last"));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaSealCompanyInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OaSealCompanyEntity entity = this.oaSealCompanyService.getInfo(id);
        OaSealCompanyInfoVO vo = (OaSealCompanyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaSealCompanyInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setDeptId(this.baseDataUtil.comSelectValue(vo.getDeptId(), "last"));
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "\u5f00", "\u5173"));
        vo.setUseDept(this.baseDataUtil.comSelectValues(vo.getUseDept()));
        vo.setLeader(this.baseDataUtil.userSelectValue(vo.getLeaderId()));
        vo.setCashier(this.baseDataUtil.userSelectValue(vo.getCashierId()));
        vo.setAccount(this.baseDataUtil.userSelectValue(vo.getAccountId()));
        vo.setSealManager(this.baseDataUtil.userSelectValue(vo.getSealManagerId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaSealCompanyUpForm oaSealCompanyUpForm) throws DataException {
        if (StringUtils.isEmpty((String)oaSealCompanyUpForm.getEncode())) {
            oaSealCompanyUpForm.setEncode(PinYinUtil.getFirstSpell((String)oaSealCompanyUpForm.getCompanyName()).toUpperCase());
        }
        this.oaSealCompanyService.update(id, oaSealCompanyUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaSealCompanyEntity entity = this.oaSealCompanyService.getInfo(id);
        if (entity != null) {
            this.oaSealCompanyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

