/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.oa.annotation.OaSealExecuteEnum;
import com.bringspring.oa.entity.OaSealExecuteEntity;
import com.bringspring.oa.entity.OaSealNeedDoneEntity;
import com.bringspring.oa.entity.OaSealNeedDoneTypeEntity;
import com.bringspring.oa.entity.OacdsealapplicationEntity;
import com.bringspring.oa.model.oaRecordSubitem.OaRecordSubitemCrForm;
import com.bringspring.oa.model.oacdsealapplication.OaSealExecuteCrForm;
import com.bringspring.oa.model.oacdsealapplication.OaSealExecuteInfoVO;
import com.bringspring.oa.model.oasealneeddone.OaSealNeedDoneCrForm;
import com.bringspring.oa.model.oasealneeddone.OaSealNeedDoneInfoVO;
import com.bringspring.oa.model.oasealneeddone.OaSealNeedDoneListVO;
import com.bringspring.oa.model.oasealneeddone.OaSealNeedDonePagination;
import com.bringspring.oa.model.oasealneeddone.OaSealNeedDonePaginationExportModel;
import com.bringspring.oa.model.oasealneeddone.OaSealNeedDoneUpForm;
import com.bringspring.oa.service.OaCdSealApplicationService;
import com.bringspring.oa.service.OaRecordSubitemService;
import com.bringspring.oa.service.OaSealExecuteService;
import com.bringspring.oa.service.OaSealNeedDoneService;
import com.bringspring.oa.service.OaSealNeedDoneTypeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7ae0\u8bc1\u6267\u884c"}, value="oa")
@RequestMapping(value={"/api/oa/OaSealNeedDone"})
public class OaSealNeedDoneController {
    private static final Logger log = LoggerFactory.getLogger(OaSealNeedDoneController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaSealNeedDoneService oaSealNeedDoneService;
    @Autowired
    private OaSealNeedDoneTypeService oaSealNeedDoneTypeService;
    @Autowired
    private OaSealExecuteService oaSealExecuteService;
    @Autowired
    private OaRecordSubitemService oaRecordSubitemService;
    @Autowired
    private OaCdSealApplicationService oaCdSealApplicationService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaSealNeedDonePagination oaSealNeedDonePagination) throws IOException {
        List<OaSealNeedDoneEntity> list = this.oaSealNeedDoneService.getList(oaSealNeedDonePagination);
        List listVO = JsonUtil.getJsonToList(list, OaSealNeedDoneListVO.class);
        for (OaSealNeedDoneListVO oaSealNeedDoneVO : listVO) {
            OacdsealapplicationEntity seal;
            List<OaSealNeedDoneTypeEntity> typeList = this.oaSealNeedDoneTypeService.getListByParentId(oaSealNeedDoneVO.getParentId());
            oaSealNeedDoneVO.setOaSealNeedDoneTypeEntityList(typeList);
            oaSealNeedDoneVO.setParentTypeName(OaSealExecuteEnum.getNameByCode(oaSealNeedDoneVO.getParentType()));
            if (!StrUtil.isEmpty((CharSequence)oaSealNeedDoneVO.getFormId()) || !StrUtil.equals((CharSequence)oaSealNeedDoneVO.getParentType(), (CharSequence)"Oacdsealapplication") || !ObjectUtil.isNotEmpty((Object)(seal = this.oaCdSealApplicationService.getInfo(oaSealNeedDoneVO.getParentId())))) continue;
            oaSealNeedDoneVO.setFormId(seal.getFormid());
            OaSealNeedDoneEntity jsonToBean = (OaSealNeedDoneEntity)JsonUtil.getJsonToBean((Object)oaSealNeedDoneVO, OaSealNeedDoneEntity.class);
            this.oaSealNeedDoneService.updateById(jsonToBean);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaSealNeedDonePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OaSealNeedDoneCrForm oaSealNeedDoneCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OaSealNeedDoneEntity entity = (OaSealNeedDoneEntity)JsonUtil.getJsonToBean((Object)oaSealNeedDoneCrForm, OaSealNeedDoneEntity.class);
        entity.setId(mainId);
        this.oaSealNeedDoneService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaSealNeedDonePaginationExportModel oaSealNeedDonePaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaSealNeedDonePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaSealNeedDonePagination oaSealNeedDonePagination = (OaSealNeedDonePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaSealNeedDonePaginationExportModel), OaSealNeedDonePagination.class));
        List<OaSealNeedDoneEntity> list = this.oaSealNeedDoneService.getTypeList(oaSealNeedDonePagination, oaSealNeedDonePaginationExportModel.getDataType());
        for (OaSealNeedDoneEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, OaSealNeedDoneListVO.class);
        for (OaSealNeedDoneListVO oaSealNeedDoneListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaSealNeedDonePaginationExportModel.getSelectKey()) ? oaSealNeedDonePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block14: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "formId": {
                        entitys.add(new ExcelExportEntity("\u5355\u636e\u7f16\u7801", (Object)"formId"));
                        continue block14;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaSealNeedDoneInfoVO> info(@PathVariable(value="id") String id) {
        OaSealNeedDoneEntity entity = this.oaSealNeedDoneService.getInfo(id);
        OaSealNeedDoneInfoVO vo = (OaSealNeedDoneInfoVO)JsonUtil.getJsonToBean((Object)entity, OaSealNeedDoneInfoVO.class);
        List<OaSealNeedDoneTypeEntity> list = this.oaSealNeedDoneTypeService.getListByParentId(id);
        vo.setOaSealNeedDoneTypeEntityList(list);
        List<OaSealExecuteEntity> executeList = this.oaSealExecuteService.getList(vo.getParentId(), vo.getParentType());
        List executeInfoVOList = JsonUtil.getJsonToList(executeList, OaSealExecuteInfoVO.class);
        for (OaSealExecuteInfoVO v : executeInfoVOList) {
            v.setCreatorUserId(this.baseDataUtil.userSelectValues(v.getCreatorUserId()));
            v.setSealType(this.baseDataUtil.getDictName(v.getSealType(), "sealTypeOptions"));
        }
        vo.setOaSealExecuteList(executeInfoVOList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaSealNeedDoneInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OaSealNeedDoneEntity entity = this.oaSealNeedDoneService.getInfo(id);
        OaSealNeedDoneInfoVO vo = (OaSealNeedDoneInfoVO)JsonUtil.getJsonToBean((Object)entity, OaSealNeedDoneInfoVO.class);
        List<OaSealNeedDoneTypeEntity> list = this.oaSealNeedDoneTypeService.getListByParentId(id);
        vo.setOaSealNeedDoneTypeEntityList(list);
        List<OaSealExecuteEntity> executeList = this.oaSealExecuteService.getList(vo.getParentId(), vo.getParentType());
        List executeInfoVOList = JsonUtil.getJsonToList(executeList, OaSealExecuteInfoVO.class);
        for (OaSealExecuteInfoVO v : executeInfoVOList) {
            v.setCreatorUserId(this.baseDataUtil.userSelectValues(v.getCreatorUserId()));
            v.setSealType(this.baseDataUtil.getDictName(v.getSealType(), "sealCertificatesType"));
        }
        vo.setOaSealExecuteList(executeInfoVOList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaSealNeedDoneUpForm oaSealNeedDoneUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OaSealNeedDoneEntity entity = this.oaSealNeedDoneService.getInfo(id);
        if (entity != null) {
            OaSealNeedDoneEntity subentity = (OaSealNeedDoneEntity)JsonUtil.getJsonToBean((Object)oaSealNeedDoneUpForm, OaSealNeedDoneEntity.class);
            String applyType = subentity.getApplyType();
            if (StringUtils.isNotEmpty((String)applyType)) {
                String[] applyTypes = applyType.replaceAll("[\\[\\]\"]", "").split(",");
                List<String> applyTypeList = Arrays.asList(applyTypes);
                boolean f = this.oaSealNeedDoneTypeService.updateByParentIdAndType(id, applyTypeList);
                if (!f) {
                    return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25");
                }
            } else {
                return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u76d6\u7ae0\u7c7b\u578b\u5fc5\u9009");
            }
            entity.setUseEnabledMark("1");
            this.oaSealNeedDoneService.update(id, entity);
            OaSealExecuteCrForm oaSealExecuteCrForm = new OaSealExecuteCrForm();
            oaSealExecuteCrForm.setSealType(subentity.getApplyType());
            oaSealExecuteCrForm.setCreatorTime(DateUtil.getNow());
            oaSealExecuteCrForm.setCreatorUserId(userInfo.getUserId());
            oaSealExecuteCrForm.setDescription(subentity.getApplyDetail());
            OaSealExecuteEntity oaSealExecuteEntity = (OaSealExecuteEntity)JsonUtil.getJsonToBean((Object)oaSealExecuteCrForm, OaSealExecuteEntity.class);
            oaSealExecuteEntity.setParentId(entity.getParentId());
            oaSealExecuteEntity.setParentType(entity.getParentType());
            this.oaSealExecuteService.save(oaSealExecuteEntity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaSealNeedDoneEntity entity = this.oaSealNeedDoneService.getInfo(id);
        if (entity != null) {
            this.oaSealNeedDoneService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Transactional
    @PostMapping(value={"/sendInfoToFile/{id}"})
    public ActionResult<OaSealNeedDoneInfoVO> sendInfoToFile(@PathVariable(value="id") String id) {
        OaSealNeedDoneEntity entity = this.oaSealNeedDoneService.getInfo(id);
        if (OaSealExecuteEnum.SEAL_APPLICATION.getCode().equals(entity.getParentType()) || OaSealExecuteEnum.FMS_SEAL.getCode().equals(entity.getParentType())) {
            OaRecordSubitemCrForm oaRecordSubitemCrForm = this.getOaRecordSubitemCrForm(entity);
            this.oaRecordSubitemService.businessRecordSonAdd(oaRecordSubitemCrForm);
            this.saveSealExecuteLog(entity, OaSealExecuteEnum.BACK_FILE.getName());
        }
        return ActionResult.success((String)"\u5f52\u6863\u64cd\u4f5c\u6210\u529f");
    }

    private void saveSealExecuteLog(OaSealNeedDoneEntity entity, String description) {
        UserInfo userInfo = this.userProvider.get();
        OaSealExecuteCrForm oaSealExecuteCrForm = new OaSealExecuteCrForm();
        oaSealExecuteCrForm.setSealType(entity.getApplyType());
        oaSealExecuteCrForm.setCreatorTime(DateUtil.getNow());
        oaSealExecuteCrForm.setCreatorUserId(userInfo.getUserId());
        oaSealExecuteCrForm.setDescription(description);
        OaSealExecuteEntity oaSealExecuteEntity = (OaSealExecuteEntity)JsonUtil.getJsonToBean((Object)oaSealExecuteCrForm, OaSealExecuteEntity.class);
        oaSealExecuteEntity.setParentId(entity.getParentId());
        oaSealExecuteEntity.setParentType(entity.getParentType());
        this.oaSealExecuteService.save(oaSealExecuteEntity);
    }

    @NotNull
    private OaRecordSubitemCrForm getOaRecordSubitemCrForm(OaSealNeedDoneEntity entity) {
        OaRecordSubitemCrForm oaRecordSubitemCrForm = new OaRecordSubitemCrForm();
        oaRecordSubitemCrForm.setRemark("\u5173\u8054\u7c7b\u578b\uff1a\u5370\u7ae0\u8bc1\u4ef6   " + entity.getApplyTitle());
        oaRecordSubitemCrForm.setBusinessId(entity.getParentId());
        oaRecordSubitemCrForm.setBusinessType("seal");
        oaRecordSubitemCrForm.setRecordSubitemName(entity.getApplyTitle());
        oaRecordSubitemCrForm.setSubitemType(entity.getApplyForm().equals("1") ? "paper" : (entity.getApplyForm().equals("2") ? "copy" : "Electronic version"));
        oaRecordSubitemCrForm.setNumber(1);
        oaRecordSubitemCrForm.setPages(1);
        oaRecordSubitemCrForm.setAccessory(entity.getApplyUploads());
        oaRecordSubitemCrForm.setCreatorUserId(entity.getCreatorUserId());
        return oaRecordSubitemCrForm;
    }
}

