/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.Crm_FileEntity;
import com.bringspring.oa.entity.OaTradeDetailEntity;
import com.bringspring.oa.entity.OaTradeEntity;
import com.bringspring.oa.model.oa_trade.CrmFileListVO;
import com.bringspring.oa.model.oa_trade.CrmFileModel;
import com.bringspring.oa.model.oatrade.OaTradeCrForm;
import com.bringspring.oa.model.oatrade.OaTradeDetailModel;
import com.bringspring.oa.model.oatrade.OaTradeInfoVO;
import com.bringspring.oa.model.oatrade.OaTradeListVO;
import com.bringspring.oa.model.oatrade.OaTradePagination;
import com.bringspring.oa.model.oatrade.OaTradeUpForm;
import com.bringspring.oa.service.Crm_fileService;
import com.bringspring.oa.service.OaTradeDetailService;
import com.bringspring.oa.service.OaTradeService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5de5\u4f1a\u7ec4\u7ec7\u4e8b\u9879\u5ba1\u6279"}, value="crm")
@RequestMapping(value={"/api/crm/OaTrade"})
public class OaTradeController {
    private static final Logger log = LoggerFactory.getLogger(OaTradeController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaTradeService oaTradeService;
    @Autowired
    private Crm_fileService crm_fileService;
    @Autowired
    private OaTradeDetailService oaTradeDetailService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaTradePagination oaTradePagination) throws IOException {
        List<OaTradeEntity> list = this.oaTradeService.getList(oaTradePagination);
        for (OaTradeEntity oaTradeEntity : list) {
            oaTradeEntity.setType(this.baseDataUtil.getDictName(oaTradeEntity.getType(), "499191314865202373"));
            oaTradeEntity.setDivision(this.baseDataUtil.getDictName(oaTradeEntity.getDivision(), "499192892166776005"));
            oaTradeEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaTradeEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaTradeListVO.class);
        for (OaTradeListVO oaTradeVO : listVO) {
            Crm_FileEntity crm_fileEntity = this.oaTradeService.getCrm_file(oaTradeVO.getId());
            if (!ObjectUtil.isNotEmpty((Object)crm_fileEntity)) continue;
            crm_fileEntity.setFileUrl(this.baseDataUtil.getFileNameInJson(crm_fileEntity.getFileUrl()));
            oaTradeVO.setCrm_file((CrmFileListVO)JsonUtil.getJsonToBean((Object)crm_fileEntity, CrmFileListVO.class));
        }
        for (OaTradeListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaTradePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/listNoPage"})
    public ActionResult listNoPage(@RequestBody OaTradePagination oaTradePagination) throws IOException {
        List<OaTradeEntity> list = this.oaTradeService.getTypeList(oaTradePagination, null);
        for (OaTradeEntity oaTradeEntity : list) {
            oaTradeEntity.setType(this.baseDataUtil.getDictName(oaTradeEntity.getType(), "499191314865202373"));
            oaTradeEntity.setDivision(this.baseDataUtil.getDictName(oaTradeEntity.getDivision(), "499192892166776005"));
            oaTradeEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaTradeEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaTradeListVO.class);
        for (OaTradeListVO oaTradeVO : listVO) {
            Crm_FileEntity crm_fileEntity = this.oaTradeService.getCrm_file(oaTradeVO.getId());
            if (!ObjectUtil.isNotEmpty((Object)crm_fileEntity)) continue;
            crm_fileEntity.setFileUrl(this.baseDataUtil.getFileNameInJson(crm_fileEntity.getFileUrl()));
            oaTradeVO.setCrm_file((CrmFileListVO)JsonUtil.getJsonToBean((Object)crm_fileEntity, CrmFileListVO.class));
        }
        ArrayList<OaTradeListVO> arrayList = new ArrayList<OaTradeListVO>();
        for (OaTradeListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
            arrayList.add(vo);
        }
        listVO.removeAll(arrayList);
        return ActionResult.success((Object)listVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaTradeCrForm oaTradeCrForm = (OaTradeCrForm)((Object)JsonUtil.getJsonToBean(crData, OaTradeCrForm.class));
        String flowEngineId = "499188628925195461";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaTradeCrForm.setCreator_time(DateUtil.getNow());
        oaTradeCrForm.setCode(this.baseDataUtil.getBillNumber("Trade", Boolean.valueOf(false)));
        oaTradeCrForm.setCreator_user_id(userInfo.getUserId());
        OaTradeEntity entity = (OaTradeEntity)JsonUtil.getJsonToBean((Object)((Object)oaTradeCrForm), OaTradeEntity.class);
        entity.setId(mainId);
        this.oaTradeService.save(entity);
        if (ObjectUtil.isNotEmpty((Object)oaTradeCrForm.getCrm_file())) {
            Crm_FileEntity crm_fileentity = (Crm_FileEntity)JsonUtil.getJsonToBean((Object)oaTradeCrForm.getCrm_file(), Crm_FileEntity.class);
            crm_fileentity.setSourceId(entity.getId());
            crm_fileentity.setId(mainId);
            this.crm_fileService.save(crm_fileentity);
        }
        if (ObjectUtil.isNotEmpty(oaTradeCrForm.getLoadList())) {
            List detailList = JsonUtil.getJsonToList(oaTradeCrForm.getLoadList(), OaTradeDetailEntity.class);
            for (OaTradeDetailEntity entitys : detailList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setParentId(mainId);
            }
            this.oaTradeDetailService.saveBatch(detailList);
        }
        FlowUtil.saveOrSubmit((String)oaTradeCrForm.getTaskId(), (String)flowEngineId, (String)oaTradeCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaTradeCrForm), (Integer)oaTradeCrForm.getStatus(), (String)oaTradeCrForm.getTheme());
        if (oaTradeCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaTradeInfoVO> info(@PathVariable(value="id") String id) {
        OaTradeEntity listByCode;
        OaTradeEntity entity = this.oaTradeService.getInfo(id);
        OaTradeInfoVO vo = (OaTradeInfoVO)JsonUtil.getJsonToBean((Object)entity, OaTradeInfoVO.class);
        if (vo.getCreator_time() != null) {
            vo.setCreator_time(vo.getCreator_time());
        }
        vo.setCreator_user_id(this.baseDataUtil.userSelectValue(vo.getCreator_user_id()));
        vo.setTypeName(this.baseDataUtil.getDictName(entity.getType(), "499191314865202373"));
        vo.setDivisionName(this.baseDataUtil.getDictName(entity.getDivision(), "499192892166776005"));
        vo.setCreatorUserName(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
        if (StringUtils.isNotEmpty((String)vo.getTradeId()) && (listByCode = this.oaTradeService.getListByCode(vo.getTradeId())) != null) {
            vo.setSubmitTheme(listByCode.getTheme());
            vo.setSubmitLoanAmount(listByCode.getLoanAmount());
        }
        QueryWrapper queryWrapperCrm_file = new QueryWrapper();
        queryWrapperCrm_file.lambda().eq(Crm_FileEntity::getSourceId, (Object)entity.getId());
        Crm_FileEntity crm_fileEntity = (Crm_FileEntity)this.crm_fileService.getOne((Wrapper)queryWrapperCrm_file);
        vo.setCrm_file((CrmFileModel)JsonUtil.getJsonToBean((Object)crm_fileEntity, CrmFileModel.class));
        vo.setLoadList(JsonUtil.getJsonToList(this.oaTradeService.getLoadList(id), OaTradeDetailModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaTradeUpForm oaTradeUpForm = (OaTradeUpForm)((Object)JsonUtil.getJsonToBean(upData, OaTradeUpForm.class));
        String flowEngineId = "499188628925195461";
        UserInfo userInfo = this.userProvider.get();
        OaTradeEntity entity = this.oaTradeService.getInfo(id);
        if (entity != null) {
            OaTradeEntity subentity = (OaTradeEntity)JsonUtil.getJsonToBean((Object)((Object)oaTradeUpForm), OaTradeEntity.class);
            subentity.setCreatorTime(entity.getCreatorTime());
            subentity.setCreatorUserId(entity.getCreatorUserId());
            this.oaTradeService.update(id, subentity);
            if (ObjectUtil.isNotEmpty((Object)oaTradeUpForm.getCrm_file())) {
                QueryWrapper queryWrapperCrm_file = new QueryWrapper();
                queryWrapperCrm_file.lambda().eq(Crm_FileEntity::getSourceId, (Object)entity.getId());
                Crm_FileEntity crm_fileOneEntity = (Crm_FileEntity)this.crm_fileService.getOne((Wrapper)queryWrapperCrm_file);
                Crm_FileEntity crm_fileentity = (Crm_FileEntity)JsonUtil.getJsonToBean((Object)oaTradeUpForm.getCrm_file(), Crm_FileEntity.class);
                crm_fileentity.setId(crm_fileOneEntity.getId());
                crm_fileentity.setSourceId(entity.getId());
                this.crm_fileService.updateById(crm_fileentity);
            }
            this.oaTradeDetailService.removeByParentId(id);
            if (ObjectUtil.isNotEmpty(oaTradeUpForm.getLoadList())) {
                List detailList = JsonUtil.getJsonToList(oaTradeUpForm.getLoadList(), OaTradeDetailEntity.class);
                for (OaTradeDetailEntity entitys : detailList) {
                    entitys.setId(RandomUtil.uuId());
                    entitys.setParentId(id);
                }
                this.oaTradeDetailService.saveBatch(detailList);
            }
            FlowUtil.saveOrSubmit((String)oaTradeUpForm.getTaskId(), (String)flowEngineId, (String)oaTradeUpForm.getTemplateId(), (String)id, (Object)((Object)oaTradeUpForm), (Integer)oaTradeUpForm.getStatus(), (String)oaTradeUpForm.getTheme());
            if (oaTradeUpForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaTradeEntity entity = this.oaTradeService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaTradeService.delete(entity);
            QueryWrapper queryWrapperCrm_file = new QueryWrapper();
            queryWrapperCrm_file.lambda().eq(Crm_FileEntity::getSourceId, (Object)entity.getId());
            this.crm_fileService.remove((Wrapper)queryWrapperCrm_file);
            this.oaTradeDetailService.removeByParentId(id);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

