/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.meeting.utils.ObjectComparator;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.OaWorkitemEntity;
import com.bringspring.oa.model.oaworkitem.OaWorkitemCrForm;
import com.bringspring.oa.model.oaworkitem.OaWorkitemInfoVO;
import com.bringspring.oa.model.oaworkitem.OaWorkitemListVO;
import com.bringspring.oa.model.oaworkitem.OaWorkitemPagination;
import com.bringspring.oa.model.oaworkitem.OaWorkitemPaginationExportModel;
import com.bringspring.oa.model.oaworkitem.OaWorkitemUpForm;
import com.bringspring.oa.service.OaWorkitemService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workitem.service.CrmWorkitemService;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5de5\u4f5c\u9879"}, value="oa")
@RequestMapping(value={"/api/oa/OaWorkitem"})
public class OaWorkitemController {
    private static final Logger log = LoggerFactory.getLogger(OaWorkitemController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaWorkitemService oaWorkitemService;
    @Autowired
    private CrmWorkitemService crmWorkitemService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaWorkitemPagination oaWorkitemPagination) throws IOException {
        List<OaWorkitemEntity> list = this.oaWorkitemService.getList(oaWorkitemPagination);
        for (OaWorkitemEntity oaWorkitemEntity : list) {
            oaWorkitemEntity.setProposeUserId(this.baseDataUtil.userSelectValues(oaWorkitemEntity.getProposeUserId()));
            oaWorkitemEntity.setProposeUserDepartment(this.baseDataUtil.comSelectValues(oaWorkitemEntity.getProposeUserDepartment()));
            oaWorkitemEntity.setPersonInCharge(this.baseDataUtil.userSelectValues(oaWorkitemEntity.getPersonInCharge()));
            oaWorkitemEntity.setCoordinateUserId(this.baseDataUtil.userSelectValues(oaWorkitemEntity.getCoordinateUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaWorkitemListVO.class);
        for (OaWorkitemListVO oaWorkitemListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaWorkitemPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @RepeatSubmit(interval=8000)
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        List jumpList;
        OaWorkitemCrForm oaWorkitemCrForm = (OaWorkitemCrForm)((Object)JsonUtil.getJsonToBean(crData, OaWorkitemCrForm.class));
        String flowEngineId = "558616261852934725";
        if (StringUtils.isNotEmpty((String)oaWorkitemCrForm.getFlowId())) {
            flowEngineId = oaWorkitemCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OaWorkitemEntity entity = (OaWorkitemEntity)JsonUtil.getJsonToBean((Object)((Object)oaWorkitemCrForm), OaWorkitemEntity.class);
        entity.setId(mainId);
        entity.setParentId(StrUtil.isBlank((CharSequence)entity.getParentId()) ? "-1" : entity.getParentId());
        if (!StrUtil.isBlank((CharSequence)entity.getJumpQueue()) && entity.getJumpQueue().equals("1") && (jumpList = this.crmWorkitemService.getJumpList(entity.getPersonInCharge())).size() > 0) {
            return ActionResult.success((String)"duplication");
        }
        this.oaWorkitemService.save(entity);
        FlowUtil.saveOrSubmit((String)oaWorkitemCrForm.getTaskId(), (String)flowEngineId, (String)oaWorkitemCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaWorkitemCrForm), (Integer)oaWorkitemCrForm.getStatus(), (String)oaWorkitemCrForm.getName());
        if (oaWorkitemCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaWorkitemUpForm oaWorkitemUpForm = (OaWorkitemUpForm)((Object)JsonUtil.getJsonToBean(upData, OaWorkitemUpForm.class));
        String flowEngineId = "558616261852934725";
        if (StringUtils.isNotEmpty((String)oaWorkitemUpForm.getFlowId())) {
            flowEngineId = oaWorkitemUpForm.getFlowId();
        }
        UserInfo userInfo = this.userProvider.get();
        OaWorkitemEntity entity = this.oaWorkitemService.getInfo(id);
        if (entity != null) {
            OaWorkitemEntity subentity = (OaWorkitemEntity)JsonUtil.getJsonToBean((Object)((Object)oaWorkitemUpForm), OaWorkitemEntity.class);
            Map compare = ObjectComparator.compare((Object)entity, (Object)subentity);
            ArrayList keyList = new ArrayList();
            if (ObjectUtil.isNotEmpty((Object)compare)) {
                compare.keySet().stream().forEach(key -> keyList.add(key));
            }
            if (keyList.contains("jumpQueue") && !entity.getJumpQueue().equals("1") && !StrUtil.isBlank((CharSequence)subentity.getJumpQueue()) && subentity.getJumpQueue().equals("1")) {
                List jumpList = this.crmWorkitemService.getJumpList(entity.getPersonInCharge());
                jumpList.remove(entity);
                if (jumpList.size() > 0) {
                    return ActionResult.success((String)"duplication");
                }
            }
            this.oaWorkitemService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)oaWorkitemUpForm.getTaskId(), (String)flowEngineId, (String)oaWorkitemUpForm.getTemplateId(), (String)id, (Object)((Object)oaWorkitemUpForm), (Integer)oaWorkitemUpForm.getStatus(), (String)oaWorkitemUpForm.getName());
            if (oaWorkitemUpForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaWorkitemPaginationExportModel oaWorkitemPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)oaWorkitemPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaWorkitemPagination oaWorkitemPagination = (OaWorkitemPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaWorkitemPaginationExportModel), OaWorkitemPagination.class));
        List<OaWorkitemEntity> list = this.oaWorkitemService.getTypeList(oaWorkitemPagination, oaWorkitemPaginationExportModel.getDataType());
        for (OaWorkitemEntity oaWorkitemEntity : list) {
            oaWorkitemEntity.setProposeUserId(this.baseDataUtil.userSelectValues(oaWorkitemEntity.getProposeUserId()));
            oaWorkitemEntity.setProposeUserDepartment(this.baseDataUtil.comSelectValues(oaWorkitemEntity.getProposeUserDepartment()));
            oaWorkitemEntity.setPersonInCharge(this.baseDataUtil.userSelectValues(oaWorkitemEntity.getPersonInCharge()));
            oaWorkitemEntity.setCoordinateUserId(this.baseDataUtil.userSelectValues(oaWorkitemEntity.getCoordinateUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaWorkitemListVO.class);
        for (OaWorkitemListVO oaWorkitemListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)oaWorkitemPaginationExportModel.getSelectKey()) ? oaWorkitemPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block58: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "parentId": {
                        entitys.add(new ExcelExportEntity("\u4e0a\u7ea7\u5de5\u4f5c\u9879ID", (Object)"parentId"));
                        continue block58;
                    }
                    case "productId": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1ID", (Object)"productId"));
                        continue block58;
                    }
                    case "projectId": {
                        entitys.add(new ExcelExportEntity("\u9879\u76eeid", (Object)"projectId"));
                        continue block58;
                    }
                    case "moduleId": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u6a21\u5757id", (Object)"moduleId"));
                        continue block58;
                    }
                    case "type": {
                        entitys.add(new ExcelExportEntity("\u7c7b\u578b", (Object)"type"));
                        continue block58;
                    }
                    case "bugCategory": {
                        entitys.add(new ExcelExportEntity("\u7f3a\u9677\u5206\u7c7b", (Object)"bugCategory"));
                        continue block58;
                    }
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u4efb\u52a1\u540d\u79f0", (Object)"name"));
                        continue block58;
                    }
                    case "source": {
                        entitys.add(new ExcelExportEntity("\u6765\u6e90", (Object)"source"));
                        continue block58;
                    }
                    case "proposeUserId": {
                        entitys.add(new ExcelExportEntity("\u63d0\u51fa\u4eba", (Object)"proposeUserId"));
                        continue block58;
                    }
                    case "proposeUserDepartment": {
                        entitys.add(new ExcelExportEntity("\u63d0\u51fa\u4eba\u90e8\u95e8", (Object)"proposeUserDepartment"));
                        continue block58;
                    }
                    case "startDate": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u5f00\u59cb", (Object)"startDate"));
                        continue block58;
                    }
                    case "endDate": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u5b8c\u6210", (Object)"endDate"));
                        continue block58;
                    }
                    case "workHours": {
                        entitys.add(new ExcelExportEntity("\u9884\u4f30\u5de5\u65f6", (Object)"workHours"));
                        continue block58;
                    }
                    case "actualStartDate": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4", (Object)"actualStartDate"));
                        continue block58;
                    }
                    case "actualEndDate": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4", (Object)"actualEndDate"));
                        continue block58;
                    }
                    case "overdueTime": {
                        entitys.add(new ExcelExportEntity("\u903e\u671f\u65f6\u95f4(\u5929)", (Object)"overdueTime"));
                        continue block58;
                    }
                    case "priority": {
                        entitys.add(new ExcelExportEntity("\u4f18\u5148\u7ea7", (Object)"priority"));
                        continue block58;
                    }
                    case "personInCharge": {
                        entitys.add(new ExcelExportEntity("\u8d1f\u8d23\u4eba", (Object)"personInCharge"));
                        continue block58;
                    }
                    case "coordinateUserId": {
                        entitys.add(new ExcelExportEntity("\u914d\u5408\u4eba", (Object)"coordinateUserId"));
                        continue block58;
                    }
                    case "evaluateGrade": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u4ef7\u7b49\u7ea7", (Object)"evaluateGrade"));
                        continue block58;
                    }
                    case "evaluateDescription": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u4ef7\u63cf\u8ff0", (Object)"evaluateDescription"));
                        continue block58;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001\u6807\u5fd7", (Object)"enabledMark"));
                        continue block58;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u4efb\u52a1\u63cf\u8ff0", (Object)"description"));
                        continue block58;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaWorkitemInfoVO> info(@PathVariable(value="id") String id) {
        OaWorkitemEntity entity = this.oaWorkitemService.getInfo(id);
        OaWorkitemInfoVO vo = (OaWorkitemInfoVO)JsonUtil.getJsonToBean((Object)entity, OaWorkitemInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaWorkitemEntity entity = this.oaWorkitemService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaWorkitemService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

