/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.oa.entity.OaCancelOrdersDetailEntity;
import com.bringspring.oa.entity.OaCancelOrdersEntity;
import com.bringspring.oa.entity.OaConsumingApplyEntity;
import com.bringspring.oa.model.oacancelorders.OaCancelOrdersCrForm;
import com.bringspring.oa.model.oacancelorders.OaCancelOrdersInfoVO;
import com.bringspring.oa.model.oacancelorders.OaCancelOrdersListVO;
import com.bringspring.oa.model.oacancelorders.OaCancelOrdersPagination;
import com.bringspring.oa.model.oacancelorders.OaCancelOrdersUpForm;
import com.bringspring.oa.model.oacancelorders.OacancelOrdersDetailModel;
import com.bringspring.oa.service.OaCancelOrdersDetailService;
import com.bringspring.oa.service.OaCancelOrdersService;
import com.bringspring.oa.service.OaConsumingApplyService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9000\u8d27\u6d41\u7a0b\u8bb0\u5f55\u8868"}, value="oa")
@RequestMapping(value={"/api/oa/Oacancelorders"})
public class OacancelordersController {
    private static final Logger log = LoggerFactory.getLogger(OacancelordersController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaCancelOrdersService oacancelordersService;
    @Autowired
    private OaCancelOrdersDetailService oaCancelOrdersDetailService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private OaConsumingApplyService oaConsumingApplyService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaCancelOrdersPagination oacancelordersPagination) throws IOException {
        List<OaCancelOrdersEntity> list = this.oacancelordersService.getList(oacancelordersPagination);
        for (OaCancelOrdersEntity oaCancelOrdersEntity : list) {
            oaCancelOrdersEntity.setApplyUserId(this.baseDataUtil.userSelectValues(oaCancelOrdersEntity.getApplyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaCancelOrdersListVO.class);
        for (OaCancelOrdersListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity;
            OaConsumingApplyEntity applyEntity;
            RkContractProjectEntity projectEntity;
            if (!StrUtil.isBlank((CharSequence)vo.getProjectId()) && ObjectUtil.isNotEmpty((Object)(projectEntity = this.rkContractProjectService.getInfo(vo.getProjectId())))) {
                vo.setProjectId(projectEntity.getProjectName());
            }
            if (!StrUtil.isBlank((CharSequence)vo.getConsumingId()) && ObjectUtil.isNotEmpty((Object)(applyEntity = this.oaConsumingApplyService.getInfo(vo.getConsumingId())))) {
                vo.setConsumingId(applyEntity.getDescription());
            }
            if ((flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus})) != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oacancelordersPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaCancelOrdersCrForm oacancelordersCrForm = (OaCancelOrdersCrForm)((Object)JsonUtil.getJsonToBean(crData, OaCancelOrdersCrForm.class));
        String flowEngineId = "578925768243953733";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OaCancelOrdersEntity entity = (OaCancelOrdersEntity)JsonUtil.getJsonToBean((Object)((Object)oacancelordersCrForm), OaCancelOrdersEntity.class);
        entity.setId(mainId);
        this.oacancelordersService.save(entity);
        List OaCancelOrdersDetailList = JsonUtil.getJsonToList(oacancelordersCrForm.getCancelOrdersDetailList(), OaCancelOrdersDetailEntity.class);
        for (OaCancelOrdersDetailEntity entitys : OaCancelOrdersDetailList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setCancelOrdersId(entity.getId());
            this.oaCancelOrdersDetailService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)oacancelordersCrForm.getTaskId(), (String)flowEngineId, (String)oacancelordersCrForm.getTemplateId(), (String)mainId, (Object)((Object)oacancelordersCrForm), (Integer)oacancelordersCrForm.getStatus());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaCancelOrdersInfoVO> info(@PathVariable(value="id") String id) {
        RkContractProjectEntity projectEntity;
        OaConsumingApplyEntity applyEntity;
        OaCancelOrdersEntity entity = this.oacancelordersService.getInfo(id);
        OaCancelOrdersInfoVO vo = (OaCancelOrdersInfoVO)JsonUtil.getJsonToBean((Object)entity, OaCancelOrdersInfoVO.class);
        vo.setApplyUserName(this.baseDataUtil.userSelectValue(vo.getApplyUserId()));
        if (!StrUtil.isBlank((CharSequence)vo.getConsumingId()) && ObjectUtil.isNotEmpty((Object)(applyEntity = this.oaConsumingApplyService.getInfo(vo.getConsumingId())))) {
            vo.setConsumingName(applyEntity.getDescription());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getProjectId()) && ObjectUtil.isNotEmpty((Object)(projectEntity = this.rkContractProjectService.getInfo(vo.getProjectId())))) {
            vo.setProjectName(projectEntity.getProjectName());
            vo.setProjectCode(projectEntity.getProjectCode());
            vo.setSaleManager(projectEntity.getSalerName());
            vo.setApplyPerson(this.baseDataUtil.userSelectValues(projectEntity.getProjectHeader()));
        }
        List<OaCancelOrdersDetailEntity> OaCancelOrdersDetailList = this.oacancelordersService.GetOaCancelOrdersDetailList(id);
        vo.setOacancelordersList(JsonUtil.getJsonToList(OaCancelOrdersDetailList, OacancelOrdersDetailModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaCancelOrdersUpForm oacancelordersUpForm = (OaCancelOrdersUpForm)((Object)JsonUtil.getJsonToBean(upData, OaCancelOrdersUpForm.class));
        String flowEngineId = "578925768243953733";
        UserInfo userInfo = this.userProvider.get();
        OaCancelOrdersEntity entity = this.oacancelordersService.getInfo(id);
        if (entity != null) {
            OaCancelOrdersEntity subentity = (OaCancelOrdersEntity)JsonUtil.getJsonToBean((Object)((Object)oacancelordersUpForm), OaCancelOrdersEntity.class);
            this.oacancelordersService.update(id, subentity);
            QueryWrapper OaCancelOrdersDetailqueryWrapper = new QueryWrapper();
            OaCancelOrdersDetailqueryWrapper.lambda().eq(OaCancelOrdersDetailEntity::getCancelOrdersId, (Object)entity.getId());
            this.oaCancelOrdersDetailService.remove((Wrapper)OaCancelOrdersDetailqueryWrapper);
            List OaCancelOrdersDetailList = JsonUtil.getJsonToList(oacancelordersUpForm.getCancelOrdersDetailList(), OaCancelOrdersDetailEntity.class);
            for (OaCancelOrdersDetailEntity entitys : OaCancelOrdersDetailList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setCancelOrdersId(entity.getId());
                this.oaCancelOrdersDetailService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)oacancelordersUpForm.getTaskId(), (String)flowEngineId, (String)oacancelordersUpForm.getTemplateId(), (String)id, (Object)((Object)oacancelordersUpForm), (Integer)oacancelordersUpForm.getStatus());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaCancelOrdersEntity entity = this.oacancelordersService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oacancelordersService.delete(entity);
            QueryWrapper queryWrapperOaCancelOrdersDetail = new QueryWrapper();
            queryWrapperOaCancelOrdersDetail.lambda().eq(OaCancelOrdersDetailEntity::getCancelOrdersId, (Object)entity.getId());
            this.oaCancelOrdersDetailService.remove((Wrapper)queryWrapperOaCancelOrdersDetail);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/returnGoods/{id}"})
    @DSTransactional
    public ActionResult returnGoods(@PathVariable(value="id") String id, @RequestBody @Valid OaCancelOrdersInfoVO oaCancelOrdersInfoVO) throws DataException, WorkFlowException {
        this.oacancelordersService.returnGoodsOperate(oaCancelOrdersInfoVO);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }
}

