/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.model.rkcontractpayment.ContractPaymentImportReturnVO;
import com.bringspring.contract.model.rkcontractpayment.ContractPaymentImportVO;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentPagination;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.DictEncodeEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.oa.entity.OaContractPaymentApplyEntity;
import com.bringspring.oa.mapper.OaContractPaymentApplyMapper;
import com.bringspring.oa.service.OaContractPaymentApplyService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaContractPaymentApplyServiceImpl
extends ServiceImpl<OaContractPaymentApplyMapper, OaContractPaymentApplyEntity>
implements OaContractPaymentApplyService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private RkContractService contractService;

    @Override
    public List<OaContractPaymentApplyEntity> getList(RkContractPaymentPagination rkContractPaymentPagination) {
        Object rkContractPaymentObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractPaymentNum = 0;
        QueryWrapper rkContractPaymentQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractPaymentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractPaymentQueryWrapper, rkContractPaymentPagination.getMenuId(), "rkContractPayment"));
            if (ObjectUtil.isEmpty((Object)rkContractPaymentObj)) {
                return new ArrayList<OaContractPaymentApplyEntity>();
            }
            rkContractPaymentQueryWrapper = (QueryWrapper)rkContractPaymentObj;
            ++rkContractPaymentNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractPaymentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractPaymentQueryWrapper, rkContractPaymentPagination.getMenuId(), "rkContractPayment"));
            if (ObjectUtil.isEmpty((Object)rkContractPaymentObj)) {
                return new ArrayList<OaContractPaymentApplyEntity>();
            }
            rkContractPaymentQueryWrapper = (QueryWrapper)rkContractPaymentObj;
            ++rkContractPaymentNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPaymentPagination.getContractId())) {
            ++rkContractPaymentNum;
            rkContractPaymentQueryWrapper.lambda().like(OaContractPaymentApplyEntity::getContractId, (Object)rkContractPaymentPagination.getContractId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPaymentPagination.getPaymentName())) {
            ++rkContractPaymentNum;
            rkContractPaymentQueryWrapper.lambda().like(OaContractPaymentApplyEntity::getPaymentName, (Object)rkContractPaymentPagination.getPaymentName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPaymentPagination.getPaymentRatio())) {
            ++rkContractPaymentNum;
            rkContractPaymentQueryWrapper.lambda().like(OaContractPaymentApplyEntity::getPaymentRatio, (Object)rkContractPaymentPagination.getPaymentRatio());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPaymentPagination.getPaymentType())) {
            ++rkContractPaymentNum;
            rkContractPaymentQueryWrapper.lambda().like(OaContractPaymentApplyEntity::getPaymentType, (Object)rkContractPaymentPagination.getPaymentType());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPaymentPagination.getPlanId())) {
            ++rkContractPaymentNum;
            rkContractPaymentQueryWrapper.lambda().like(OaContractPaymentApplyEntity::getPlanId, (Object)rkContractPaymentPagination.getPlanId());
        }
        if (AllIdList.size() > 0) {
            rkContractPaymentQueryWrapper.lambda().in(OaContractPaymentApplyEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractPaymentPagination.getSidx())) {
            rkContractPaymentQueryWrapper.lambda().orderByDesc(OaContractPaymentApplyEntity::getId);
        } else {
            try {
                String sidx = rkContractPaymentPagination.getSidx();
                OaContractPaymentApplyEntity OaContractPaymentApplyEntity2 = new OaContractPaymentApplyEntity();
                Field declaredField = OaContractPaymentApplyEntity2.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractPaymentQueryWrapper = "asc".equals(rkContractPaymentPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractPaymentQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractPaymentQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkContractPaymentPagination.getCurrentPage(), rkContractPaymentPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkContractPaymentQueryWrapper);
            return rkContractPaymentPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkContractPaymentPagination.setData(list, (long)list.size());
    }

    @Override
    public List<OaContractPaymentApplyEntity> getTypeList(RkContractPaymentPagination rkContractPaymentPagination, String dataType) {
        Object rkContractPaymentObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractPaymentNum = 0;
        QueryWrapper rkContractPaymentQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractPaymentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractPaymentQueryWrapper, rkContractPaymentPagination.getMenuId(), "rkContractPayment"));
            if (ObjectUtil.isEmpty((Object)rkContractPaymentObj)) {
                return new ArrayList<OaContractPaymentApplyEntity>();
            }
            rkContractPaymentQueryWrapper = (QueryWrapper)rkContractPaymentObj;
            ++rkContractPaymentNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractPaymentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractPaymentQueryWrapper, rkContractPaymentPagination.getMenuId(), "rkContractPayment"));
            if (ObjectUtil.isEmpty((Object)rkContractPaymentObj)) {
                return new ArrayList<OaContractPaymentApplyEntity>();
            }
            rkContractPaymentQueryWrapper = (QueryWrapper)rkContractPaymentObj;
            ++rkContractPaymentNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPaymentPagination.getContractId())) {
            ++rkContractPaymentNum;
            rkContractPaymentQueryWrapper.lambda().like(OaContractPaymentApplyEntity::getContractId, (Object)rkContractPaymentPagination.getContractId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPaymentPagination.getPaymentName())) {
            ++rkContractPaymentNum;
            rkContractPaymentQueryWrapper.lambda().like(OaContractPaymentApplyEntity::getPaymentName, (Object)rkContractPaymentPagination.getPaymentName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPaymentPagination.getPaymentRatio())) {
            ++rkContractPaymentNum;
            rkContractPaymentQueryWrapper.lambda().like(OaContractPaymentApplyEntity::getPaymentRatio, (Object)rkContractPaymentPagination.getPaymentRatio());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPaymentPagination.getPaymentType())) {
            ++rkContractPaymentNum;
            rkContractPaymentQueryWrapper.lambda().like(OaContractPaymentApplyEntity::getPaymentType, (Object)rkContractPaymentPagination.getPaymentType());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPaymentPagination.getPlanId())) {
            ++rkContractPaymentNum;
            rkContractPaymentQueryWrapper.lambda().like(OaContractPaymentApplyEntity::getPlanId, (Object)rkContractPaymentPagination.getPlanId());
        }
        if (AllIdList.size() > 0) {
            rkContractPaymentQueryWrapper.lambda().in(OaContractPaymentApplyEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractPaymentPagination.getSidx())) {
            rkContractPaymentQueryWrapper.lambda().orderByDesc(OaContractPaymentApplyEntity::getId);
        } else {
            try {
                String sidx = rkContractPaymentPagination.getSidx();
                OaContractPaymentApplyEntity OaContractPaymentApplyEntity2 = new OaContractPaymentApplyEntity();
                Field declaredField = OaContractPaymentApplyEntity2.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractPaymentQueryWrapper = "asc".equals(rkContractPaymentPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractPaymentQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractPaymentQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkContractPaymentPagination.getCurrentPage(), rkContractPaymentPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkContractPaymentQueryWrapper);
                return rkContractPaymentPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkContractPaymentPagination.setData(list, (long)list.size());
        }
        return this.list((Wrapper)rkContractPaymentQueryWrapper);
    }

    @Override
    public OaContractPaymentApplyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaContractPaymentApplyEntity::getId, (Object)id);
        return (OaContractPaymentApplyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OaContractPaymentApplyEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OaContractPaymentApplyEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(OaContractPaymentApplyEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void deleteByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaContractPaymentApplyEntity::getContractId, (Object)contractId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<OaContractPaymentApplyEntity> getListByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaContractPaymentApplyEntity::getContractId, (Object)contractId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OaContractPaymentApplyEntity> getListByProcureId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaContractPaymentApplyEntity::getProcureId, (Object)id);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OaContractPaymentApplyEntity> getListByContractIdNotPlan(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OaContractPaymentApplyEntity::getContractId, (Object)contractId)).isNull(OaContractPaymentApplyEntity::getPlanId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> importPreview(List<Object> paymentImportVOList, Object o) {
        int i;
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        for (i = 0; i < paymentImportVOList.size(); ++i) {
            Map dataRowMap = new HashMap();
            Object model = paymentImportVOList.get(i);
            dataRowMap = (Map)JsonUtil.getJsonToBean((Object)model, Map.class);
            dataRow.add(dataRowMap);
        }
        for (i = 1; i <= paymentImportVOList.size(); ++i) {
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("AllowDBNull", true);
            columnsMap.put("AutoIncrement", false);
            columnsMap.put("AutoIncrementSeed", 0);
            columnsMap.put("AutoIncrementStep", 1);
            columnsMap.put("Caption", this.getColumns(o, i));
            columnsMap.put("ColumnMapping", 1);
            columnsMap.put("ColumnName", this.getColumns(o, i));
            columnsMap.put("Container", null);
            columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
            columnsMap.put("DateTimeMode", 3);
            columnsMap.put("DefaultValue", null);
            columnsMap.put("DesignMode", false);
            columnsMap.put("Expression", "");
            columnsMap.put("ExtendedProperties", "");
            columnsMap.put("MaxLength", -1);
            columnsMap.put("Namespace", "");
            columnsMap.put("Ordinal", 0);
            columnsMap.put("Prefix", "");
            columnsMap.put("ReadOnly", false);
            columnsMap.put("Site", null);
            columnsMap.put("Table", paymentImportVOList);
            columnsMap.put("Unique", false);
            columns.add(columnsMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Object o, Integer key) {
        Map declaredFieldsInfo = MapUtil.newHashMap();
        try {
            declaredFieldsInfo = ReflectionUtil.getDeclaredFieldsInfo2((Object)o, (Map)MapUtil.newHashMap());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int i = 1;
        for (String s : declaredFieldsInfo.keySet()) {
            map.put(i, s);
            ++i;
        }
        return (String)map.get(key);
    }

    @Override
    public ContractPaymentImportReturnVO importData(List<ContractPaymentImportVO> dataList) {
        UserInfo userInfo = this.userProvider.get();
        List errorMsgList = CollectionUtil.list((boolean)false);
        String organizeId = userInfo.getOrganizeId();
        HashMap dictMap = MapUtil.newHashMap();
        List allToList = DictEncodeEnum.getAllToList();
        allToList.stream().forEach(dictEncodeEnum -> {
            String encode = dictEncodeEnum.getEncode();
            DictionaryTypeEntity typeEntityList = this.dictionaryTypeService.getInfoByEnCode(encode);
            String dictionaryTypeId = typeEntityList.getId();
            List data = this.dictionaryDataService.getList(dictionaryTypeId, Boolean.valueOf(true));
            if (StrUtil.equals((CharSequence)encode, (CharSequence)DictEncodeEnum.ENABLEMARK_DICT.getEncode())) {
                Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getEnCode));
                dictMap.put(encode, collect);
            } else {
                Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getId));
                dictMap.put(encode, collect);
            }
        });
        List errorList = CollectionUtil.list((boolean)false);
        List successList = CollectionUtil.list((boolean)false);
        List contractEntities = CollectionUtil.list((boolean)false);
        for (ContractPaymentImportVO importVO : dataList) {
            if (StrUtil.isEmpty((CharSequence)importVO.getContractName()) && StrUtil.isEmpty((CharSequence)importVO.getContractCode())) {
                importVO.setErrMsg("\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u5fc5\u987b\u586b\u4e00\u4e2a");
                errorMsgList.add(importVO.getErrMsg());
            }
            String contractId = "";
            if (StrUtil.isNotEmpty((CharSequence)importVO.getContractCode()) && StrUtil.isNotEmpty((CharSequence)importVO.getContractName())) {
                List listByCodeAndName = this.contractService.getListByCodeAndName(importVO.getContractCode(), importVO.getContractName());
                boolean isError = false;
                if (CollectionUtil.isEmpty((Collection)listByCodeAndName)) {
                    importVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u672a\u67e5\u8be2\u5230\u5408\u540c\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(importVO.getErrMsg());
                    isError = true;
                }
                if (listByCodeAndName.size() > 1) {
                    importVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(importVO.getErrMsg());
                    isError = true;
                }
                if (!isError) {
                    contractId = ((RkContractEntity)listByCodeAndName.get(0)).getId();
                }
            } else {
                if (StrUtil.isNotEmpty((CharSequence)importVO.getContractCode())) {
                    List listByCode = this.contractService.getListByCode(importVO.getContractCode(), organizeId);
                    if (CollectionUtil.isNotEmpty((Collection)listByCode) && listByCode.size() > 1) {
                        importVO.setErrMsg("\u5408\u540c\u7f16\u7801\u91cd\u590d");
                        errorMsgList.add(importVO.getErrMsg());
                    }
                    if (CollectionUtil.isNotEmpty((Collection)listByCode)) {
                        contractId = ((RkContractEntity)listByCode.get(0)).getId();
                    }
                }
                if (StrUtil.isNotEmpty((CharSequence)importVO.getContractName())) {
                    List listByName = this.contractService.getListByNameAndCompanyId(importVO.getContractName(), organizeId);
                    if (CollectionUtil.isNotEmpty((Collection)listByName) && listByName.size() > 1) {
                        if (StrUtil.isEmpty((CharSequence)contractId)) {
                            importVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u67e5\u8be2\u5230\u591a\u4e2a\u5408\u540c\uff0c\u8bf7\u6839\u636e\u5408\u540c\u7f16\u53f7\u4e0a\u4f20");
                            errorMsgList.add(importVO.getErrMsg());
                        } else {
                            String finalContractId = contractId;
                            List collect = listByName.stream().filter(x -> StrUtil.equals((CharSequence)x.getId(), (CharSequence)finalContractId)).collect(Collectors.toList());
                            if (CollectionUtil.isEmpty(collect)) {
                                importVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u67e5\u8be2\u5230\u7684\u5408\u540c\u4e0d\u4e00\u6837\uff0c\u8bf7\u786e\u8ba4");
                                errorMsgList.add(importVO.getErrMsg());
                            }
                        }
                    }
                    if (CollectionUtil.isNotEmpty((Collection)listByName)) {
                        String id = ((RkContractEntity)listByName.get(0)).getId();
                        if (StrUtil.isNotEmpty((CharSequence)contractId)) {
                            if (!StrUtil.equals((CharSequence)id, (CharSequence)contractId)) {
                                importVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u67e5\u8be2\u5230\u7684\u5408\u540c\u4e0d\u4e00\u6837\uff0c\u8bf7\u786e\u8ba4");
                                errorMsgList.add(importVO.getErrMsg());
                            }
                        } else {
                            contractId = id;
                        }
                    }
                }
            }
            if (StrUtil.isEmpty((CharSequence)contractId)) {
                importVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u672a\u67e5\u8be2\u5230\u5408\u540c\uff0c\u8bf7\u786e\u8ba4");
                errorMsgList.add(importVO.getErrMsg());
            }
            if (StrUtil.isNotEmpty((CharSequence)importVO.getPaymentName())) {
                Map stringStringMap = (Map)dictMap.get(DictEncodeEnum.PAYMENT_TYPE_DICT.getEncode());
                String s = (String)stringStringMap.get(importVO.getPaymentName());
                if (StrUtil.isEmpty((CharSequence)s)) {
                    importVO.setErrMsg("\u6b3e\u9879\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u6570\u636e\u5b57\u5178\u7ef4\u62a4");
                    errorMsgList.add(importVO.getErrMsg());
                } else {
                    importVO.setPaymentType(s);
                }
            } else {
                importVO.setErrMsg("\u8bf7\u9009\u62e9\u6b3e\u9879\u7c7b\u578b");
                errorMsgList.add(importVO.getErrMsg());
            }
            if (StrUtil.isEmpty((CharSequence)importVO.getReceivableAmount())) {
                importVO.setErrMsg("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(importVO.getErrMsg());
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                importVO.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                importVO.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(importVO);
                continue;
            }
            OaContractPaymentApplyEntity jsonToBean = (OaContractPaymentApplyEntity)JsonUtil.getJsonToBean((Object)importVO, OaContractPaymentApplyEntity.class);
            jsonToBean.setContractId(contractId);
            jsonToBean.setId(RandomUtil.uuId());
            HashMap map = this.savePyament(jsonToBean);
            if (!ObjectUtil.isEmpty(map.get("error"))) {
                importVO.setErrMsg(map.get("error").toString());
                errorMsgList.add(importVO.getErrMsg());
                errorList.add(importVO);
                continue;
            }
            successList.add(jsonToBean);
        }
        ContractPaymentImportReturnVO vo = new ContractPaymentImportReturnVO();
        vo.setSnum(successList.size());
        vo.setFnum(errorList.size());
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, ContractPaymentImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    @DSTransactional
    public HashMap savePyament(OaContractPaymentApplyEntity entity) {
        BigDecimal add;
        HashMap<String, String> map = new HashMap<String, String>();
        List<OaContractPaymentApplyEntity> listByContractId = this.getListByContractId(entity.getContractId());
        RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)entity.getContractId()));
        if (ObjectUtil.isEmpty((Object)byId.getContractAmount())) {
            map.put("error", "\u5408\u540c\u672a\u5f55\u5165\u5408\u540c\u989d");
            return map;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        if (CollectionUtil.isNotEmpty(listByContractId)) {
            bigDecimal = listByContractId.stream().map(OaContractPaymentApplyEntity::getReceivableAmount).reduce(BigDecimal::add).get();
        }
        if ((add = MathUtils.add((BigDecimal)entity.getReceivableAmount(), (BigDecimal)bigDecimal)).compareTo(byId.getContractAmount()) == 1) {
            map.put("error", "\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u8d85\u8fc7\u5408\u540c\u989d");
            return map;
        }
        BigDecimal divide = MathUtils.divide((BigDecimal)MathUtils.multiply((BigDecimal)entity.getReceivableAmount(), (BigDecimal)new BigDecimal(100)), (BigDecimal)byId.getContractAmount(), (int)2);
        entity.setPaymentRatio(divide);
        this.save(entity);
        listByContractId.add(entity);
        StringBuffer payment = new StringBuffer();
        StringBuffer remark = new StringBuffer();
        listByContractId.stream().forEach(paymentEntity -> {
            payment.append(paymentEntity.getPaymentName() + " " + paymentEntity.getPaymentRatio() + "%,");
            remark.append("|" + paymentEntity.getPaymentName() + " \u6bd4\u4f8b:" + paymentEntity.getPaymentRatio() + "%,\u91d1\u989d:" + paymentEntity.getReceivableAmount() + "\u5143");
            if (StrUtil.isNotEmpty((CharSequence)paymentEntity.getPaymentCondition())) {
                remark.append(",\u4ed8\u6b3e\u6761\u4ef6:" + paymentEntity.getPaymentCondition());
            }
        });
        byId.setPaymentMethod(payment.toString());
        byId.setPaymentDescription(remark.toString());
        this.contractService.update(byId.getId(), byId);
        return map;
    }
}

