/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractSettlementEntity;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractSettlementService;
import com.bringspring.oa.entity.OaFeeStatementEntity;
import com.bringspring.oa.entity.OaFeeStatementRecordEntity;
import com.bringspring.oa.entity.OaFeeStatementTypeEntity;
import com.bringspring.oa.mapper.OaFeeStatementMapper;
import com.bringspring.oa.model.oafeestatement.OaFeeStatementCrForm;
import com.bringspring.oa.model.oafeestatement.OaFeeStatementPagination;
import com.bringspring.oa.model.oafeestatement.OaFeeStatementUpForm;
import com.bringspring.oa.service.OaFeeStatementRecordService;
import com.bringspring.oa.service.OaFeeStatementService;
import com.bringspring.oa.service.OaFeeStatementTypeService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaFeeStatementServiceImpl
extends ServiceImpl<OaFeeStatementMapper, OaFeeStatementEntity>
implements OaFeeStatementService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OaFeeStatementRecordService oaFeeStatementRecordService;
    @Autowired
    private OaFeeStatementTypeService oaFeeStatementTypeService;
    @Autowired
    private RkContractSettlementService rkContractSettlementService;
    @Autowired
    private RkContractService rkContractService;

    @Override
    public List<OaFeeStatementEntity> getList(OaFeeStatementPagination oaFeeStatementPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaFeeStatementNum = 0;
        QueryWrapper oaFeeStatementQueryWrapper = new QueryWrapper();
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object oacdsealapplicationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaFeeStatementQueryWrapper, oaFeeStatementPagination.getMenuId(), "oa_fee_statement"));
            if (ObjectUtil.isEmpty((Object)oacdsealapplicationObj)) {
                return new ArrayList<OaFeeStatementEntity>();
            }
            oaFeeStatementQueryWrapper = (QueryWrapper)oacdsealapplicationObj;
            ++oaFeeStatementNum;
        }
        if (StringUtils.isNotEmpty((String)oaFeeStatementPagination.getCustomer())) {
            ++oaFeeStatementNum;
            oaFeeStatementQueryWrapper.lambda().eq(OaFeeStatementEntity::getCustomer, (Object)oaFeeStatementPagination.getCustomer());
        }
        if (StringUtils.isNotEmpty((String)oaFeeStatementPagination.getBCompany())) {
            ++oaFeeStatementNum;
            oaFeeStatementQueryWrapper.lambda().eq(OaFeeStatementEntity::getBCompany, (Object)oaFeeStatementPagination.getBCompany());
        }
        if (StringUtils.isNotEmpty((String)oaFeeStatementPagination.getStatementType())) {
            ++oaFeeStatementNum;
            oaFeeStatementQueryWrapper.lambda().eq(OaFeeStatementEntity::getStatementType, (Object)oaFeeStatementPagination.getStatementType());
        }
        if (ObjectUtil.isNotEmpty(oaFeeStatementPagination.getCompanyIdList())) {
            ++oaFeeStatementNum;
            oaFeeStatementQueryWrapper.lambda().in(OaFeeStatementEntity::getContractCompanyId, oaFeeStatementPagination.getCompanyIdList());
        }
        if (ObjectUtil.isNotEmpty(oaFeeStatementPagination.getSalerCompanyIdList())) {
            oaFeeStatementQueryWrapper.lambda().in(OaFeeStatementEntity::getCompanyId, oaFeeStatementPagination.getSalerCompanyIdList());
        }
        if (ObjectUtil.isNotEmpty(oaFeeStatementPagination.getCreateTime())) {
            oaFeeStatementQueryWrapper.lambda().between(OaFeeStatementEntity::getCreatorTime, (Object)oaFeeStatementPagination.getCreateTime().get(0), (Object)oaFeeStatementPagination.getCreateTime().get(1));
        }
        if (AllIdList.size() > 0) {
            oaFeeStatementQueryWrapper.lambda().in(OaFeeStatementEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaFeeStatementPagination.getSidx())) {
            oaFeeStatementQueryWrapper.lambda().orderByDesc(OaFeeStatementEntity::getCreatorTime);
        } else {
            try {
                String sidx = oaFeeStatementPagination.getSidx();
                OaFeeStatementEntity oaFeeStatementEntity = new OaFeeStatementEntity();
                Field declaredField = oaFeeStatementEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaFeeStatementQueryWrapper = "asc".equals(oaFeeStatementPagination.getSort().toLowerCase()) ? (QueryWrapper)oaFeeStatementQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaFeeStatementQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(oaFeeStatementPagination.getCurrentPage(), oaFeeStatementPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)oaFeeStatementQueryWrapper);
            return oaFeeStatementPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return oaFeeStatementPagination.setData(list, list.size());
    }

    @Override
    public List<OaFeeStatementEntity> getTypeList(OaFeeStatementPagination oaFeeStatementPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaFeeStatementNum = 0;
        QueryWrapper oaFeeStatementQueryWrapper = new QueryWrapper();
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object oacdsealapplicationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaFeeStatementQueryWrapper, oaFeeStatementPagination.getMenuId(), "oa_fee_statement"));
            if (ObjectUtil.isEmpty((Object)oacdsealapplicationObj)) {
                return new ArrayList<OaFeeStatementEntity>();
            }
            oaFeeStatementQueryWrapper = (QueryWrapper)oacdsealapplicationObj;
            ++oaFeeStatementNum;
        }
        if (StringUtils.isNotEmpty((String)oaFeeStatementPagination.getCustomer())) {
            ++oaFeeStatementNum;
            oaFeeStatementQueryWrapper.lambda().eq(OaFeeStatementEntity::getCustomer, (Object)oaFeeStatementPagination.getCustomer());
        }
        if (StringUtils.isNotEmpty((String)oaFeeStatementPagination.getBCompany())) {
            ++oaFeeStatementNum;
            oaFeeStatementQueryWrapper.lambda().eq(OaFeeStatementEntity::getBCompany, (Object)oaFeeStatementPagination.getBCompany());
        }
        if (StringUtils.isNotEmpty((String)oaFeeStatementPagination.getStatementType())) {
            ++oaFeeStatementNum;
            oaFeeStatementQueryWrapper.lambda().eq(OaFeeStatementEntity::getStatementType, (Object)oaFeeStatementPagination.getStatementType());
        }
        if (ObjectUtil.isNotEmpty(oaFeeStatementPagination.getCompanyIdList())) {
            ++oaFeeStatementNum;
            oaFeeStatementQueryWrapper.lambda().in(OaFeeStatementEntity::getContractCompanyId, oaFeeStatementPagination.getCompanyIdList());
        }
        if (ObjectUtil.isNotEmpty(oaFeeStatementPagination.getSalerCompanyIdList())) {
            oaFeeStatementQueryWrapper.lambda().in(OaFeeStatementEntity::getCompanyId, oaFeeStatementPagination.getSalerCompanyIdList());
        }
        if (ObjectUtil.isNotEmpty(oaFeeStatementPagination.getCreateTime())) {
            oaFeeStatementQueryWrapper.lambda().between(OaFeeStatementEntity::getCreatorTime, (Object)oaFeeStatementPagination.getCreateTime().get(0), (Object)oaFeeStatementPagination.getCreateTime().get(1));
        }
        if (AllIdList.size() > 0) {
            oaFeeStatementQueryWrapper.lambda().in(OaFeeStatementEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaFeeStatementPagination.getSidx())) {
            oaFeeStatementQueryWrapper.lambda().orderByDesc(OaFeeStatementEntity::getCreatorTime);
        } else {
            try {
                String sidx = oaFeeStatementPagination.getSidx();
                OaFeeStatementEntity oaFeeStatementEntity = new OaFeeStatementEntity();
                Field declaredField = oaFeeStatementEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaFeeStatementQueryWrapper = "asc".equals(oaFeeStatementPagination.getSort().toLowerCase()) ? (QueryWrapper)oaFeeStatementQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaFeeStatementQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(oaFeeStatementPagination.getCurrentPage(), oaFeeStatementPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)oaFeeStatementQueryWrapper);
                return oaFeeStatementPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return oaFeeStatementPagination.setData(list, list.size());
        }
        return this.list((Wrapper)oaFeeStatementQueryWrapper);
    }

    @Override
    public OaFeeStatementEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaFeeStatementEntity::getId, (Object)id);
        return (OaFeeStatementEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OaFeeStatementEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OaFeeStatementEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void saveSettlementRecord(String id, OaFeeStatementCrForm oaFeeStatementCrForm) {
        UserInfo userInfo = this.userProvider.get();
        List<OaFeeStatementRecordEntity> recordList = oaFeeStatementCrForm.getRecordList();
        recordList.stream().forEach(record -> {
            if (ObjectUtil.isEmpty((Object)record.getContractId())) {
                record.setContractId(record.getId());
                RkContractEntity rkContractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)record.getContractId()));
                record.setContractCompanyId(rkContractEntity.getCompanyId());
            }
            record.setId(RandomUtil.uuId());
            record.setStatementId(id);
            if (ObjectUtil.isEmpty((Object)record.getCurrentSettlementRate())) {
                record.setCurrentSettlementRate(record.getSumReturnRate());
            }
            record.setCreatorUserId(userInfo.getUserId());
            record.setCreatorTime(new Date());
        });
        this.oaFeeStatementRecordService.saveBatch(recordList);
        List<OaFeeStatementTypeEntity> serviceFeelList = oaFeeStatementCrForm.getServiceFeelList();
        serviceFeelList.stream().forEach(serviceFeel -> {
            serviceFeel.setContractId(serviceFeel.getId());
            serviceFeel.setId(RandomUtil.uuId());
            serviceFeel.setStatementId(id);
            serviceFeel.setChoseType("serviceFee");
            serviceFeel.setCreatorUserId(userInfo.getUserId());
            serviceFeel.setCreatorTime(new Date());
        });
        this.oaFeeStatementTypeService.saveBatch(serviceFeelList);
        List<OaFeeStatementTypeEntity> returnPaymentList = oaFeeStatementCrForm.getReturnPaymentList();
        returnPaymentList.stream().forEach(returnPayment -> {
            returnPayment.setId(RandomUtil.uuId());
            returnPayment.setStatementId(id);
            returnPayment.setChoseType("returnPayment");
            returnPayment.setCreatorUserId(userInfo.getUserId());
            returnPayment.setCreatorTime(new Date());
        });
        this.oaFeeStatementTypeService.saveBatch(returnPaymentList);
    }

    @Override
    public void updateSettlementRecord(String id, OaFeeStatementUpForm oaFeeStatementUpForm) {
        this.oaFeeStatementRecordService.deleteByStatementId(id);
        UserInfo userInfo = this.userProvider.get();
        List<OaFeeStatementRecordEntity> recordList = oaFeeStatementUpForm.getRecordList();
        recordList.stream().forEach(record -> {
            if (ObjectUtil.isEmpty((Object)record.getContractId())) {
                record.setContractId(record.getId());
            }
            record.setId(RandomUtil.uuId());
            record.setStatementId(id);
            if (ObjectUtil.isEmpty((Object)record.getCurrentSettlementRate())) {
                record.setCurrentSettlementRate(record.getSumReturnRate());
            }
            record.setCreatorUserId(userInfo.getUserId());
            record.setCreatorTime(new Date());
        });
        this.oaFeeStatementRecordService.saveBatch(recordList);
        this.oaFeeStatementTypeService.deleteByStatementId(id, "serviceFee");
        List<OaFeeStatementTypeEntity> serviceFeelList = oaFeeStatementUpForm.getServiceFeelList();
        serviceFeelList.stream().forEach(serviceFeel -> {
            serviceFeel.setContractId(serviceFeel.getId());
            serviceFeel.setId(RandomUtil.uuId());
            serviceFeel.setStatementId(id);
            serviceFeel.setChoseType("serviceFee");
            serviceFeel.setCreatorUserId(userInfo.getUserId());
            serviceFeel.setCreatorTime(new Date());
        });
        this.oaFeeStatementTypeService.saveBatch(serviceFeelList);
        this.oaFeeStatementTypeService.deleteByStatementId(id, "returnPayment");
        List<OaFeeStatementTypeEntity> returnPaymentList = oaFeeStatementUpForm.getReturnPaymentList();
        returnPaymentList.stream().forEach(returnPayment -> {
            returnPayment.setId(RandomUtil.uuId());
            returnPayment.setStatementId(id);
            returnPayment.setChoseType("returnPayment");
            returnPayment.setCreatorUserId(userInfo.getUserId());
            returnPayment.setCreatorTime(new Date());
        });
        this.oaFeeStatementTypeService.saveBatch(returnPaymentList);
    }

    @Override
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        OaFeeStatementEntity entity = this.getInfo(id);
        entity.setEnableMark(String.valueOf(enableMark));
        if (enableMark == 1) {
            List<OaFeeStatementRecordEntity> recordList = this.oaFeeStatementRecordService.getInfoByStatementId(id);
            recordList.stream().forEach(record -> {
                RkContractEntity contractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)record.getContractId()));
                RkContractSettlementEntity infoByContractId = this.rkContractSettlementService.getInfoByContractId(record.getContractId());
                if (ObjectUtil.isEmpty((Object)infoByContractId)) {
                    RkContractSettlementEntity settlementEntity = (RkContractSettlementEntity)JsonUtil.getJsonToBean((Object)record, RkContractSettlementEntity.class);
                    if (ObjectUtil.isEmpty((Object)settlementEntity.getSettlementCount())) {
                        if (ObjectUtil.isNotEmpty((Object)settlementEntity.getThisBaseAmount())) {
                            settlementEntity.setSettlementInAmount(settlementEntity.getThisBaseAmount());
                            if (ObjectUtil.isNotEmpty((Object)settlementEntity.getSettlementInAmount()) && ObjectUtil.isNotEmpty((Object)settlementEntity.getNotSettlementAmount())) {
                                settlementEntity.setNotSettlementAmount(settlementEntity.getNotSettlementAmount().subtract(settlementEntity.getSettlementInAmount()));
                            }
                        }
                        if (ObjectUtil.isNotEmpty((Object)settlementEntity.getReturnSettlementAmount())) {
                            int count = 0;
                            settlementEntity.setSettlementCount(Integer.valueOf(count + 1));
                            settlementEntity.setReturnSettlementInAmount(record.getReturnSettlementAmount());
                            if (settlementEntity.getCurrentSettlementRate().compareTo(BigDecimal.valueOf(100L)) == 0) {
                                settlementEntity.setSettlementCondition(BigDecimal.valueOf(1L));
                            } else {
                                settlementEntity.setSettlementCondition(BigDecimal.valueOf(0.9));
                            }
                        }
                        this.rkContractSettlementService.save((Object)settlementEntity);
                    }
                    if (ObjectUtil.isNotEmpty((Object)settlementEntity.getSettlementInAmount())) {
                        contractEntity.setSettlementStatus("settlement");
                    }
                    if (ObjectUtil.isNotEmpty((Object)settlementEntity.getReturnSettlementInAmount())) {
                        contractEntity.setReturnSettlementStatus("inSettlement");
                    }
                    this.rkContractService.updateById((Object)contractEntity);
                } else if (ObjectUtil.isNotEmpty((Object)infoByContractId)) {
                    if (ObjectUtil.isEmpty((Object)infoByContractId.getThisBaseAmount()) && ObjectUtil.isEmpty((Object)infoByContractId.getReturnSettlementAmount())) {
                        infoByContractId = (RkContractSettlementEntity)JsonUtil.getJsonToBean((Object)record, RkContractSettlementEntity.class);
                    }
                    infoByContractId.setSettlementInAmount(ObjectUtil.isNotEmpty((Object)infoByContractId.getSettlementInAmount()) ? infoByContractId.getSettlementInAmount().add(record.getThisBaseAmount()) : record.getThisBaseAmount());
                    if (ObjectUtil.isNotEmpty((Object)infoByContractId.getNotSettlementAmount())) {
                        infoByContractId.setNotSettlementAmount(infoByContractId.getNotSettlementAmount().subtract(record.getThisBaseAmount()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)infoByContractId.getReturnSettlementAmount())) {
                        infoByContractId.setReturnSettlementAmount(infoByContractId.getReturnSettlementAmount().add(record.getReturnSettlementAmount()));
                    }
                    infoByContractId.setReturnSettlementInAmount(ObjectUtil.isNotEmpty((Object)infoByContractId.getReturnSettlementInAmount()) ? infoByContractId.getReturnSettlementInAmount().add(record.getReturnSettlementAmount()) : record.getReturnSettlementAmount());
                    if (ObjectUtil.isNotEmpty((Object)infoByContractId.getReturnSettlementAmount())) {
                        int count = infoByContractId.getSettlementCount();
                        infoByContractId.setSettlementCount(Integer.valueOf(count + 1));
                    }
                    if (ObjectUtil.isNotEmpty((Object)contractEntity.getReturnSettlementStatus())) {
                        if (contractEntity.getReturnSettlementStatus().equals("partSettled")) {
                            infoByContractId.setSettlementCondition(BigDecimal.valueOf(0.1));
                        } else if (contractEntity.getReturnSettlementStatus().equals("notSettled") && ObjectUtil.isNotEmpty((Object)infoByContractId.getReturnSettlementInAmount())) {
                            if (infoByContractId.getCurrentSettlementRate().compareTo(BigDecimal.valueOf(100L)) == 0) {
                                infoByContractId.setSettlementCondition(BigDecimal.valueOf(1L));
                            } else {
                                infoByContractId.setSettlementCondition(BigDecimal.valueOf(0.9));
                            }
                        }
                    }
                    this.rkContractSettlementService.updateById((Object)infoByContractId);
                    if (ObjectUtil.isNotEmpty((Object)infoByContractId.getSettlementInAmount())) {
                        contractEntity.setSettlementStatus("settlement");
                    }
                    if (ObjectUtil.isNotEmpty((Object)infoByContractId.getReturnSettlementInAmount())) {
                        contractEntity.setReturnSettlementStatus("inSettlement");
                    }
                    this.rkContractService.updateById((Object)contractEntity);
                }
            });
        } else if (enableMark == 5 && model.getRejectAgreeStep().equals("0") || enableMark == 3) {
            List<OaFeeStatementRecordEntity> recordList = this.oaFeeStatementRecordService.getInfoByStatementId(id);
            recordList.stream().forEach(record -> {
                RkContractSettlementEntity infoByContractId = this.rkContractSettlementService.getInfoByContractId(record.getContractId());
                if (ObjectUtil.isNotEmpty((Object)infoByContractId)) {
                    if (ObjectUtil.isNotEmpty((Object)infoByContractId.getSettlementInAmount())) {
                        infoByContractId.setSettlementInAmount(infoByContractId.getSettlementInAmount().subtract(record.getThisBaseAmount()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)infoByContractId.getThisBaseAmount())) {
                        infoByContractId.setNotSettlementAmount(infoByContractId.getNotSettlementAmount().add(record.getThisBaseAmount()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)infoByContractId.getSettlementCount())) {
                        infoByContractId.setSettlementCount(Integer.valueOf(infoByContractId.getSettlementCount() - 1));
                    }
                    if (ObjectUtil.isNotEmpty((Object)infoByContractId.getReturnSettlementInAmount())) {
                        infoByContractId.setReturnSettlementInAmount(infoByContractId.getReturnSettlementInAmount().subtract(record.getReturnSettlementAmount()));
                    }
                    RkContractEntity contractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)record.getContractId()));
                    if (ObjectUtil.isNotEmpty((Object)infoByContractId.getThisBaseAmount())) {
                        contractEntity.setSettlementStatus("notSettled");
                    }
                    if (ObjectUtil.isNotEmpty((Object)infoByContractId.getReturnSettlementAmount())) {
                        contractEntity.setReturnSettlementStatus("notSettled");
                    }
                    this.rkContractService.updateById((Object)contractEntity);
                    this.rkContractSettlementService.updateById((Object)infoByContractId);
                }
            });
        } else if (enableMark == 2) {
            List<OaFeeStatementRecordEntity> recordList = this.oaFeeStatementRecordService.getInfoByStatementId(id);
            recordList.stream().forEach(record -> {
                RkContractSettlementEntity infoByContractId;
                RkContractEntity contractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)record.getContractId()));
                infoByContractId.setSettlementAmount(ObjectUtil.isNotEmpty((Object)(infoByContractId = this.rkContractSettlementService.getInfoByContractId(record.getContractId())).getSettlementAmount()) ? infoByContractId.getSettlementAmount().add(record.getThisBaseAmount()) : record.getThisBaseAmount());
                if (ObjectUtil.isNotEmpty((Object)infoByContractId.getSettlementInAmount())) {
                    infoByContractId.setSettlementInAmount(infoByContractId.getSettlementInAmount().subtract(record.getThisBaseAmount()));
                }
                if (ObjectUtil.isNotEmpty((Object)infoByContractId.getReturnSettlementInAmount())) {
                    infoByContractId.setReturnSettlementInAmount(infoByContractId.getReturnSettlementInAmount().subtract(record.getReturnSettlementAmount()));
                }
                infoByContractId.setSumSettlementAmount(ObjectUtil.isNotEmpty((Object)infoByContractId.getSumSettlementAmount()) ? infoByContractId.getSumSettlementAmount().add(record.getReturnSettlementAmount()) : record.getReturnSettlementAmount());
                infoByContractId.setNewSettlementDate(new Date());
                if (ObjectUtil.isNotEmpty((Object)infoByContractId.getSettlementAmount())) {
                    contractEntity.setSettlementStatus("settled");
                }
                if (ObjectUtil.isNotEmpty((Object)infoByContractId.getSettlementCount())) {
                    if (infoByContractId.getSettlementCount() == 1) {
                        if (infoByContractId.getCurrentSettlementRate().compareTo(BigDecimal.valueOf(100L)) == 0) {
                            contractEntity.setReturnSettlementStatus("settled");
                        } else {
                            contractEntity.setReturnSettlementStatus("partSettled");
                        }
                    } else if (infoByContractId.getSettlementCount() > 1) {
                        contractEntity.setReturnSettlementStatus("settled");
                    }
                }
                this.rkContractService.updateById((Object)contractEntity);
                this.rkContractSettlementService.updateById((Object)infoByContractId);
            });
        }
        return this.updateById(entity);
    }

    @Override
    public void delete(OaFeeStatementEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

