/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProductEntity;
import com.bringspring.contract.entity.SaleFrameworkAgreementEntity;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentListVO;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.SaleFrameworkAgreementService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.FrameworkAgreementStatusEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaContractPaymentApplyEntity;
import com.bringspring.oa.entity.OaContractProductApplyEntity;
import com.bringspring.oa.entity.OaFrameworkAgreementApplyEntity;
import com.bringspring.oa.mapper.OaFrameworkAgreementApplyMapper;
import com.bringspring.oa.model.oaframeworkagreementapply.OaFrameworkAgreementApplyCrForm;
import com.bringspring.oa.model.oaframeworkagreementapply.OaFrameworkAgreementApplyInfoVO;
import com.bringspring.oa.model.oaframeworkagreementapply.OaFrameworkAgreementApplyPagination;
import com.bringspring.oa.model.oaframeworkagreementapply.OaFrameworkAgreementApplyUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaContractPaymentApplyService;
import com.bringspring.oa.service.OaContractProductApplyService;
import com.bringspring.oa.service.OaFrameworkAgreementApplyService;
import com.bringspring.quotation.entity.SaleQuotationEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitEntity;
import com.bringspring.quotation.service.SaleQuotationProfitService;
import com.bringspring.quotation.service.SaleQuotationService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.BillCustomizeUtils;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.util.FlowUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaFrameworkAgreementApplyServiceImpl
extends ServiceImpl<OaFrameworkAgreementApplyMapper, OaFrameworkAgreementApplyEntity>
implements OaFrameworkAgreementApplyService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OaContractPaymentApplyService oaContractPaymentApplyService;
    @Autowired
    private OaContractProductApplyService oaContractProductApplyService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private SaleQuotationService saleQuotationService;
    @Autowired
    private SaleQuotationProfitService saleQuotationProfitService;
    @Autowired
    private SaleFrameworkAgreementService saleFrameworkAgreementService;
    @Autowired
    private RkContractProductService rkContractProductService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private RkContractPaymentService rkContractPaymentService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;

    @Override
    public List<OaFrameworkAgreementApplyEntity> getList(OaFrameworkAgreementApplyPagination oaFrameworkAgreementApplyPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaFrameworkAgreementApplyNum = 0;
        QueryWrapper oaFrameworkAgreementApplyQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)oaFrameworkAgreementApplyPagination.getContractName())) {
            ++oaFrameworkAgreementApplyNum;
            oaFrameworkAgreementApplyQueryWrapper.lambda().like(OaFrameworkAgreementApplyEntity::getContractName, (Object)oaFrameworkAgreementApplyPagination.getContractName());
        }
        if (StringUtils.isNotEmpty((String)oaFrameworkAgreementApplyPagination.getContractCode())) {
            ++oaFrameworkAgreementApplyNum;
            oaFrameworkAgreementApplyQueryWrapper.lambda().like(OaFrameworkAgreementApplyEntity::getContractCode, (Object)oaFrameworkAgreementApplyPagination.getContractCode());
        }
        if (AllIdList.size() > 0) {
            oaFrameworkAgreementApplyQueryWrapper.lambda().in(OaFrameworkAgreementApplyEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaFrameworkAgreementApplyPagination.getSidx())) {
            oaFrameworkAgreementApplyQueryWrapper.lambda().orderByDesc(OaFrameworkAgreementApplyEntity::getId);
        } else {
            try {
                String sidx = oaFrameworkAgreementApplyPagination.getSidx();
                OaFrameworkAgreementApplyEntity oaFrameworkAgreementApplyEntity = new OaFrameworkAgreementApplyEntity();
                Field declaredField = oaFrameworkAgreementApplyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaFrameworkAgreementApplyQueryWrapper = "asc".equals(oaFrameworkAgreementApplyPagination.getSort().toLowerCase()) ? (QueryWrapper)oaFrameworkAgreementApplyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaFrameworkAgreementApplyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(oaFrameworkAgreementApplyPagination.getCurrentPage(), oaFrameworkAgreementApplyPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)oaFrameworkAgreementApplyQueryWrapper);
            return oaFrameworkAgreementApplyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return oaFrameworkAgreementApplyPagination.setData(list, list.size());
    }

    @Override
    public List<OaFrameworkAgreementApplyEntity> getTypeList(OaFrameworkAgreementApplyPagination oaFrameworkAgreementApplyPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaFrameworkAgreementApplyNum = 0;
        QueryWrapper oaFrameworkAgreementApplyQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)oaFrameworkAgreementApplyPagination.getContractName())) {
            ++oaFrameworkAgreementApplyNum;
            oaFrameworkAgreementApplyQueryWrapper.lambda().like(OaFrameworkAgreementApplyEntity::getContractName, (Object)oaFrameworkAgreementApplyPagination.getContractName());
        }
        if (StringUtils.isNotEmpty((String)oaFrameworkAgreementApplyPagination.getContractCode())) {
            ++oaFrameworkAgreementApplyNum;
            oaFrameworkAgreementApplyQueryWrapper.lambda().like(OaFrameworkAgreementApplyEntity::getContractCode, (Object)oaFrameworkAgreementApplyPagination.getContractCode());
        }
        if (AllIdList.size() > 0) {
            oaFrameworkAgreementApplyQueryWrapper.lambda().in(OaFrameworkAgreementApplyEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaFrameworkAgreementApplyPagination.getSidx())) {
            oaFrameworkAgreementApplyQueryWrapper.lambda().orderByDesc(OaFrameworkAgreementApplyEntity::getId);
        } else {
            try {
                String sidx = oaFrameworkAgreementApplyPagination.getSidx();
                OaFrameworkAgreementApplyEntity oaFrameworkAgreementApplyEntity = new OaFrameworkAgreementApplyEntity();
                Field declaredField = oaFrameworkAgreementApplyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaFrameworkAgreementApplyQueryWrapper = "asc".equals(oaFrameworkAgreementApplyPagination.getSort().toLowerCase()) ? (QueryWrapper)oaFrameworkAgreementApplyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaFrameworkAgreementApplyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(oaFrameworkAgreementApplyPagination.getCurrentPage(), oaFrameworkAgreementApplyPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)oaFrameworkAgreementApplyQueryWrapper);
                return oaFrameworkAgreementApplyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return oaFrameworkAgreementApplyPagination.setData(list, list.size());
        }
        return this.list((Wrapper)oaFrameworkAgreementApplyQueryWrapper);
    }

    @Override
    public OaFrameworkAgreementApplyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaFrameworkAgreementApplyEntity::getId, (Object)id);
        return (OaFrameworkAgreementApplyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OaFrameworkAgreementApplyEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OaFrameworkAgreementApplyEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(OaFrameworkAgreementApplyEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void insertInfo(OaFrameworkAgreementApplyCrForm oaFrameworkAgreementApplyCrForm) throws DataException {
        List<OaAttachmentEntity> attachmentList;
        List list;
        UserEntity userEntity;
        String mainId = RandomUtil.uuId();
        oaFrameworkAgreementApplyCrForm.setId(mainId);
        OaFrameworkAgreementApplyEntity entity = (OaFrameworkAgreementApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaFrameworkAgreementApplyCrForm), OaFrameworkAgreementApplyEntity.class);
        UserInfo userInfo = this.userProvider.get();
        entity.setCreatorCompanyId(userInfo.getOrganizeId());
        entity.setCreatorDeptId(userInfo.getDepartmentId());
        if (StrUtil.isNotEmpty((CharSequence)entity.getSalesId()) && null != (userEntity = this.userService.getInfo(entity.getSalesId()))) {
            OrganizeEntity organizeEntity = this.organizeService.getInfo(userEntity.getOrganizeId());
            entity.setSalerCompanyId(null != organizeEntity ? organizeEntity.getOrganizeId() : "");
        }
        if (StringUtils.isEmpty((String)oaFrameworkAgreementApplyCrForm.getContractCode()) && oaFrameworkAgreementApplyCrForm.getStatus() != 0 && null != oaFrameworkAgreementApplyCrForm.getAutoContractCode() && oaFrameworkAgreementApplyCrForm.getAutoContractCode().booleanValue() && "9".equals(entity.getCompanyId())) {
            entity.setContractCode(BillCustomizeUtils.getMJContractBill());
        }
        if (StringUtils.isNotEmpty((String)oaFrameworkAgreementApplyCrForm.getCustomerAddress())) {
            List addressList = JSON.parseArray((String)oaFrameworkAgreementApplyCrForm.getCustomerAddress(), String.class);
            if (!addressList.isEmpty()) {
                entity.setCustomerRegion((String)addressList.get(0));
                entity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
            }
            if (addressList.size() > 1) {
                entity.setCustomerProv((String)addressList.get(1));
                entity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
            }
            if (addressList.size() > 2) {
                entity.setCustomerCity((String)addressList.get(2));
                entity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
            }
        }
        if (!ObjectUtil.isEmpty((Object)oaFrameworkAgreementApplyCrForm.getSalesId())) {
            entity.setSalesName(this.baseDataUtil.userSelectValue(entity.getSalesId()));
        }
        if (StringUtils.isNotEmpty((String)oaFrameworkAgreementApplyCrForm.getDepartmentTree()) && !(list = JSON.parseArray((String)oaFrameworkAgreementApplyCrForm.getDepartmentTree(), String.class)).isEmpty()) {
            entity.setDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getDepartmentTree()));
            entity.setSalesDepartmentOne((String)list.get(0));
            entity.setSalesDepartmentOneName(this.baseDataUtil.comSelectValues(entity.getSalesDepartmentOne()));
            entity.setSalesDepartment((String)list.get(list.size() - 1));
            entity.setSalesDepartmentName(this.baseDataUtil.comSelectValues(entity.getSalesDepartment()));
        }
        if (StringUtils.isNotEmpty((String)entity.getRegion())) {
            entity.setRegionName(this.baseDataUtil.provinceData(entity.getRegion()));
        }
        BeanUtils.copyProperties((Object)entity, (Object)((Object)oaFrameworkAgreementApplyCrForm));
        this.save(entity);
        List<OaContractPaymentApplyEntity> paymentList = oaFrameworkAgreementApplyCrForm.getPaymentList();
        paymentList.stream().forEach(payment -> {
            payment.setContractId(entity.getId());
            payment.setId(RandomUtil.uuId());
            if (!ObjectUtil.isEmpty((Object)entity.getContractAmount()) && !ObjectUtil.isEmpty((Object)payment.getPaymentRatio())) {
                String multiply = MathUtils.multiply((String)(entity.getContractAmount() + ""), (String)(payment.getPaymentRatio() + ""));
                String divide = MathUtils.divide((String)multiply, (String)"100", (int)2);
                payment.setReceivableAmount(MathUtils.toBigDecimal((Object)divide));
            }
        });
        this.oaContractPaymentApplyService.saveBatch(paymentList);
        List<OaContractProductApplyEntity> productList = oaFrameworkAgreementApplyCrForm.getProductList();
        if (CollectionUtil.isNotEmpty(productList)) {
            productList.stream().forEach(product -> product.setContractId(entity.getId()));
            List productEntityList = JsonUtil.getJsonToList(productList, OaContractProductApplyEntity.class);
            this.oaContractProductApplyService.saveBatch(productEntityList);
        }
        if (CollectionUtil.isNotEmpty(attachmentList = oaFrameworkAgreementApplyCrForm.getAttachmentList())) {
            attachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setContractId(entity.getId());
                attach.setObjId(entity.getId());
                attach.setFileType(AttachmentTypeEnum.FRAMEWORK_AGREEMENT.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(attachmentEntityList);
        }
        SaleFrameworkAgreementEntity framework = (SaleFrameworkAgreementEntity)JsonUtil.getJsonToBean((Object)entity, SaleFrameworkAgreementEntity.class);
        framework.setEnabledMark(Integer.valueOf(1));
        if (oaFrameworkAgreementApplyCrForm.getStatus() == 0) {
            framework.setStatus(FrameworkAgreementStatusEnum.DRAFT.getStatus());
        } else {
            framework.setStatus(FrameworkAgreementStatusEnum.AUDIT.getStatus());
        }
        this.saleFrameworkAgreementService.save((Object)framework);
        List rkContractPaymentList = JsonUtil.getJsonToList(paymentList, RkContractPaymentEntity.class);
        this.rkContractPaymentService.saveBatch((Collection)rkContractPaymentList);
        List rkContractProductList = JsonUtil.getJsonToList(productList, RkContractProductEntity.class);
        this.rkContractProductService.saveBatch((Collection)rkContractProductList);
        List rkAttachmentList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
        this.rkAttachmentService.saveBatch((Collection)rkAttachmentList);
    }

    @Override
    public void editInfo(OaFrameworkAgreementApplyUpForm oaFrameworkAgreementApplyUpForm) throws DataException {
        OaFrameworkAgreementApplyEntity entity = (OaFrameworkAgreementApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaFrameworkAgreementApplyUpForm), OaFrameworkAgreementApplyEntity.class);
        if (StringUtils.isEmpty((String)oaFrameworkAgreementApplyUpForm.getContractCode()) && oaFrameworkAgreementApplyUpForm.getStatus() != 0 && null != oaFrameworkAgreementApplyUpForm.getAutoContractCode() && oaFrameworkAgreementApplyUpForm.getAutoContractCode().booleanValue() && "9".equals(entity.getCompanyId())) {
            entity.setContractCode(BillCustomizeUtils.getMJContractBill());
        }
        if (StringUtils.isNotEmpty((String)oaFrameworkAgreementApplyUpForm.getCustomerAddress())) {
            List addressList = JSON.parseArray((String)oaFrameworkAgreementApplyUpForm.getCustomerAddress(), String.class);
            if (!addressList.isEmpty()) {
                entity.setCustomerRegion((String)addressList.get(0));
                entity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
            }
            if (addressList.size() > 1) {
                entity.setCustomerProv((String)addressList.get(1));
                entity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
            }
            if (addressList.size() > 2) {
                entity.setCustomerCity((String)addressList.get(2));
                entity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
            }
        } else {
            entity.setCustomerRegion("");
            entity.setCustomerRegionName("");
            entity.setCustomerProv("");
            entity.setCustomerProvName("");
            entity.setCustomerCity("");
            entity.setCustomerCityName("");
        }
        if (!ObjectUtil.isEmpty((Object)entity.getSalesId())) {
            entity.setSalesName(this.baseDataUtil.userSelectValue(entity.getSalesId()));
        }
        if (StringUtils.isNotEmpty((String)oaFrameworkAgreementApplyUpForm.getDepartmentTree())) {
            List list = JSON.parseArray((String)oaFrameworkAgreementApplyUpForm.getDepartmentTree(), String.class);
            if (!list.isEmpty()) {
                entity.setDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getDepartmentTree()));
                entity.setSalesDepartmentOne((String)list.get(0));
                entity.setSalesDepartmentOneName(this.baseDataUtil.comSelectValues(entity.getSalesDepartmentOne()));
                entity.setSalesDepartment((String)list.get(list.size() - 1));
                entity.setSalesDepartmentName(this.baseDataUtil.comSelectValues(entity.getSalesDepartment()));
            }
        } else {
            entity.setDepartmentTreeName("");
            entity.setSalesDepartmentOne("");
            entity.setSalesDepartmentOneName("");
            entity.setSalesDepartment("");
            entity.setSalesDepartmentName("");
        }
        if (StringUtils.isNotEmpty((String)entity.getRegion())) {
            entity.setRegionName(this.baseDataUtil.provinceData(entity.getRegion()));
        } else {
            entity.setRegionName("");
        }
        BeanUtils.copyProperties((Object)entity, (Object)((Object)oaFrameworkAgreementApplyUpForm));
        this.updateById(entity);
        this.oaContractPaymentApplyService.deleteByContractId(entity.getId());
        List<OaContractPaymentApplyEntity> paymentList = oaFrameworkAgreementApplyUpForm.getPaymentList();
        paymentList.stream().forEach(payment -> {
            payment.setContractId(entity.getId());
            payment.setId(RandomUtil.uuId());
            if (!ObjectUtil.isEmpty((Object)entity.getContractAmount()) && !ObjectUtil.isEmpty((Object)payment.getPaymentRatio())) {
                String multiply = MathUtils.multiply((String)(entity.getContractAmount() + ""), (String)(payment.getPaymentRatio() + ""));
                String divide = MathUtils.divide((String)multiply, (String)"100", (int)2);
                payment.setReceivableAmount(MathUtils.toBigDecimal((Object)divide));
            }
        });
        this.oaContractPaymentApplyService.saveBatch(paymentList);
        this.oaContractProductApplyService.deleteByContractId(entity.getId());
        List<OaContractProductApplyEntity> productList = oaFrameworkAgreementApplyUpForm.getProductList();
        if (CollectionUtil.isNotEmpty(productList)) {
            productList.stream().forEach(product -> product.setContractId(entity.getId()));
            List productEntityList = JsonUtil.getJsonToList(productList, OaContractProductApplyEntity.class);
            this.oaContractProductApplyService.saveBatch(productEntityList);
        }
        this.oaAttachmentService.deleteByContractId(entity.getId(), AttachmentTypeEnum.FRAMEWORK_AGREEMENT.getType());
        List<OaAttachmentEntity> attachmentList = oaFrameworkAgreementApplyUpForm.getAttachmentList();
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setContractId(entity.getId());
                attach.setObjId(entity.getId());
                attach.setFileType(AttachmentTypeEnum.FRAMEWORK_AGREEMENT.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(attachmentEntityList);
        }
        SaleFrameworkAgreementEntity framework = (SaleFrameworkAgreementEntity)JsonUtil.getJsonToBean((Object)entity, SaleFrameworkAgreementEntity.class);
        this.saleFrameworkAgreementService.updateById((Object)framework);
        this.rkContractPaymentService.deleteByContractId(oaFrameworkAgreementApplyUpForm.getId());
        List rkContractPaymentList = JsonUtil.getJsonToList(paymentList, RkContractPaymentEntity.class);
        this.rkContractPaymentService.saveBatch((Collection)rkContractPaymentList);
        this.rkContractProductService.deleteByContractId(oaFrameworkAgreementApplyUpForm.getId());
        List rkContractProductList = JsonUtil.getJsonToList(productList, RkContractProductEntity.class);
        this.rkContractProductService.saveBatch((Collection)rkContractProductList);
        this.rkAttachmentService.deleteByContractId(oaFrameworkAgreementApplyUpForm.getId(), AttachmentTypeEnum.FRAMEWORK_AGREEMENT.getType());
        List rkAttachmentList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
        this.rkAttachmentService.saveBatch((Collection)rkAttachmentList);
    }

    @Override
    public OaFrameworkAgreementApplyInfoVO queryInfo(String id) {
        OaFrameworkAgreementApplyEntity entity = this.getInfo(id);
        OaFrameworkAgreementApplyInfoVO vo = (OaFrameworkAgreementApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaFrameworkAgreementApplyInfoVO.class);
        this.appendVo(vo);
        return vo;
    }

    private void appendVo(OaFrameworkAgreementApplyInfoVO vo) {
        SaleQuotationProfitEntity profit;
        String userSelectValue;
        SaleQuotationEntity quotation;
        if (StringUtils.isNotEmpty((String)vo.getCustomerAddress())) {
            vo.setCustomerAddressName(this.baseDataUtil.provinceData(vo.getCustomerAddress()));
        }
        if (StringUtils.isNotEmpty((String)vo.getOpportunityId())) {
            List<String> idList = Arrays.asList(vo.getOpportunityId().split(","));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(RkProjectReportingEntity::getId, idList);
            List reportingList = this.rkProjectReportingService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)reportingList)) {
                String opportunityName = reportingList.stream().map(RkProjectReportingEntity::getReportingProject).collect(Collectors.joining(","));
                vo.setOpportunityName(opportunityName);
            }
        }
        String quotationPrefix = "";
        if (StringUtils.isNotEmpty((String)vo.getQuotationId()) && null != (quotation = this.saleQuotationService.getInfo(vo.getQuotationId()))) {
            if (StringUtils.isNotEmpty((String)quotation.getSerialNumber())) {
                quotationPrefix = quotation.getSerialNumber();
            } else {
                CrmCustomerEntity customer;
                RkProjectReportingEntity reporting = this.rkProjectReportingService.getInfo(quotation.getOpportunityId());
                if (StringUtils.isNotEmpty((String)reporting.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(reporting.getCustomerId()))) {
                    quotationPrefix = customer.getName();
                }
            }
            userSelectValue = this.baseDataUtil.userSelectValue(quotation.getQuotationUser());
            String quotationName = quotationPrefix + "-" + userSelectValue;
            vo.setQuotationName(quotationName);
        }
        if (StringUtils.isNotEmpty((String)vo.getQuotationProfitId()) && null != (profit = this.saleQuotationProfitService.getInfo(vo.getQuotationProfitId()))) {
            userSelectValue = this.baseDataUtil.userSelectValue(profit.getSaleId());
            vo.setQuotationProfitName(quotationPrefix + "-" + userSelectValue);
        }
        List<OaContractPaymentApplyEntity> paymentApplyEntityList = this.oaContractPaymentApplyService.getListByContractId(vo.getId());
        List paymentList = JsonUtil.getJsonToList(paymentApplyEntityList, RkContractPaymentListVO.class);
        vo.setPaymentList(paymentList);
        List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.getListByContractId(vo.getId());
        vo.setAttachmentList(oaAttachmentEntityList);
    }

    @Override
    public OaFrameworkAgreementApplyInfoVO detailInfo(String id) {
        OaFrameworkAgreementApplyEntity entity = this.getInfo(id);
        OaFrameworkAgreementApplyInfoVO vo = (OaFrameworkAgreementApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaFrameworkAgreementApplyInfoVO.class);
        this.appendVo(vo);
        vo.setIncomeTypeName(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
        vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), "frameworkContractType"));
        vo.setIndustryTypeName(this.baseDataUtil.getDictName(vo.getIndustryType(), "industryType"));
        vo.setIsStampTypeName(this.baseDataUtil.getDictName(vo.getIsStampType(), "stampType"));
        return vo;
    }

    @Override
    public void removeInfo(OaFrameworkAgreementApplyEntity entity) {
        String id = entity.getId();
        FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
        if (taskEntity != null) {
            try {
                FlowUtil.delete((String)id);
            }
            catch (WorkFlowException e) {
                e.printStackTrace();
            }
        }
        this.delete(entity);
        this.oaContractPaymentApplyService.deleteByContractId(id);
        this.oaContractProductApplyService.deleteByContractId(id);
        this.saleFrameworkAgreementService.delete(id);
    }

    @Override
    @FlowCallBackMethod(fullName="\u6846\u67b6\u534f\u8bae\u7533\u8bf7\u56de\u8c03")
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        SaleFrameworkAgreementEntity entity = (SaleFrameworkAgreementEntity)this.saleFrameworkAgreementService.getById((Serializable)((Object)id));
        if (null != entity) {
            entity.setStatus(FrameworkAgreementStatusEnum.AUDIT.getStatus());
            if (ObjectUtil.equal((Object)enableMark, (Object)2)) {
                entity.setStatus(FrameworkAgreementStatusEnum.APPROVED.getStatus());
            } else if (ObjectUtil.equal((Object)enableMark, (Object)3) || ObjectUtil.equal((Object)enableMark, (Object)6)) {
                entity.setStatus(FrameworkAgreementStatusEnum.CANCEL.getStatus());
            } else if (ObjectUtil.equal((Object)enableMark, (Object)5) && "0".equals(model.getRejectAgreeStep())) {
                entity.setStatus(FrameworkAgreementStatusEnum.REFUSE.getStatus());
            }
            return this.saleFrameworkAgreementService.updateById((Object)entity);
        }
        return true;
    }
}

