/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.ContractConstant;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProductEntity;
import com.bringspring.contract.entity.RkContractVerifyEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.service.OaContractCustomerService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractVerifyService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.SaleNoContractStatusEnum;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaContractProductApplyEntity;
import com.bringspring.oa.entity.OaNoContractApplyEntity;
import com.bringspring.oa.mapper.OaNoContractApplyMapper;
import com.bringspring.oa.model.oanocontractapply.OaNoContractApplyCrForm;
import com.bringspring.oa.model.oanocontractapply.OaNoContractApplyPagination;
import com.bringspring.oa.model.oanocontractapply.OaNoContractApplyUpForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaContractProductApplyService;
import com.bringspring.oa.service.OaNoContractApplyService;
import com.bringspring.purchase.entity.OaContractPurchasePlanEntity;
import com.bringspring.purchase.service.OaContractPurchasePlanService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.BillCustomizeUtils;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaNoContractApplyServiceImpl
extends ServiceImpl<OaNoContractApplyMapper, OaNoContractApplyEntity>
implements OaNoContractApplyService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OaContractProductApplyService oaContractProductApplyService;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private RkContractProductService rkContractProductService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private OaContractCustomerService oaContractCustomerService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractVerifyService rkContractVerifyService;
    @Autowired
    private OaContractPurchasePlanService oaContractPurchasePlanService;

    @Override
    public List<OaNoContractApplyEntity> getList(OaNoContractApplyPagination oaNoContractApplyPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaNoContractApplyNum = 0;
        QueryWrapper oaNoContractApplyQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)oaNoContractApplyPagination.getContractName())) {
            ++oaNoContractApplyNum;
            oaNoContractApplyQueryWrapper.lambda().like(OaNoContractApplyEntity::getContractName, (Object)oaNoContractApplyPagination.getContractName());
        }
        if (StringUtils.isNotEmpty((String)oaNoContractApplyPagination.getContractCode())) {
            ++oaNoContractApplyNum;
            oaNoContractApplyQueryWrapper.lambda().like(OaNoContractApplyEntity::getContractCode, (Object)oaNoContractApplyPagination.getContractCode());
        }
        if (AllIdList.size() > 0) {
            oaNoContractApplyQueryWrapper.lambda().in(OaNoContractApplyEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaNoContractApplyPagination.getSidx())) {
            oaNoContractApplyQueryWrapper.lambda().orderByDesc(OaNoContractApplyEntity::getId);
        } else {
            try {
                String sidx = oaNoContractApplyPagination.getSidx();
                OaNoContractApplyEntity oaNoContractApplyEntity = new OaNoContractApplyEntity();
                Field declaredField = oaNoContractApplyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaNoContractApplyQueryWrapper = "asc".equals(oaNoContractApplyPagination.getSort().toLowerCase()) ? (QueryWrapper)oaNoContractApplyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaNoContractApplyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(oaNoContractApplyPagination.getCurrentPage(), oaNoContractApplyPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)oaNoContractApplyQueryWrapper);
            return oaNoContractApplyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return oaNoContractApplyPagination.setData(list, list.size());
    }

    @Override
    public List<OaNoContractApplyEntity> getTypeList(OaNoContractApplyPagination oaNoContractApplyPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaNoContractApplyNum = 0;
        QueryWrapper oaNoContractApplyQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)oaNoContractApplyPagination.getContractName())) {
            ++oaNoContractApplyNum;
            oaNoContractApplyQueryWrapper.lambda().like(OaNoContractApplyEntity::getContractName, (Object)oaNoContractApplyPagination.getContractName());
        }
        if (StringUtils.isNotEmpty((String)oaNoContractApplyPagination.getContractCode())) {
            ++oaNoContractApplyNum;
            oaNoContractApplyQueryWrapper.lambda().like(OaNoContractApplyEntity::getContractCode, (Object)oaNoContractApplyPagination.getContractCode());
        }
        if (AllIdList.size() > 0) {
            oaNoContractApplyQueryWrapper.lambda().in(OaNoContractApplyEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaNoContractApplyPagination.getSidx())) {
            oaNoContractApplyQueryWrapper.lambda().orderByDesc(OaNoContractApplyEntity::getId);
        } else {
            try {
                String sidx = oaNoContractApplyPagination.getSidx();
                OaNoContractApplyEntity oaNoContractApplyEntity = new OaNoContractApplyEntity();
                Field declaredField = oaNoContractApplyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaNoContractApplyQueryWrapper = "asc".equals(oaNoContractApplyPagination.getSort().toLowerCase()) ? (QueryWrapper)oaNoContractApplyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaNoContractApplyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(oaNoContractApplyPagination.getCurrentPage(), oaNoContractApplyPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)oaNoContractApplyQueryWrapper);
                return oaNoContractApplyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return oaNoContractApplyPagination.setData(list, list.size());
        }
        return this.list((Wrapper)oaNoContractApplyQueryWrapper);
    }

    @Override
    public OaNoContractApplyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaNoContractApplyEntity::getId, (Object)id);
        return (OaNoContractApplyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OaNoContractApplyEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OaNoContractApplyEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(OaNoContractApplyEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void insertContractApply(OaNoContractApplyCrForm oaNoContractApplyCrForm) throws DataException {
        List<OaAttachmentEntity> attachmentList;
        OaNoContractApplyEntity entity = (OaNoContractApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaNoContractApplyCrForm), OaNoContractApplyEntity.class);
        entity.setCreatorCompanyId(this.userProvider.get().getOrganizeId());
        entity.setSalerCompanyId(this.saleNoContractService.getUserCompanyId(entity.getSalerId()));
        if (StringUtils.isNotEmpty((String)oaNoContractApplyCrForm.getCustomerAddress())) {
            List addressList = JSON.parseArray((String)oaNoContractApplyCrForm.getCustomerAddress(), String.class);
            if (!addressList.isEmpty()) {
                entity.setCustomerRegion((String)addressList.get(0));
                entity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
            }
            if (addressList.size() > 1) {
                entity.setCustomerProv((String)addressList.get(1));
                entity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
            }
            if (addressList.size() > 2) {
                entity.setCustomerCity((String)addressList.get(2));
                entity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
            }
        }
        oaNoContractApplyCrForm.setCustomerRegionName(entity.getCustomerRegionName());
        oaNoContractApplyCrForm.setCustomerProvName(entity.getCustomerProvName());
        oaNoContractApplyCrForm.setCustomerCityName(entity.getCustomerCityName());
        if (StringUtils.isNotEmpty((String)entity.getCustomerIds())) {
            this.oaContractCustomerService.insertListByCustomerIds(entity.getId(), entity.getCustomerIds());
        }
        if (StringUtils.isEmpty((String)oaNoContractApplyCrForm.getContractCode()) && oaNoContractApplyCrForm.getStatus() != 0 && null != oaNoContractApplyCrForm.getAutoContractCode() && oaNoContractApplyCrForm.getAutoContractCode().booleanValue() && "9".equals(entity.getCompanyId())) {
            entity.setContractCode("AC-" + BillCustomizeUtils.getMJContractBill());
        }
        this.save(entity);
        BeanUtils.copyProperties((Object)entity, (Object)((Object)oaNoContractApplyCrForm));
        List<OaContractProductApplyEntity> productList = oaNoContractApplyCrForm.getProductList();
        if (CollectionUtil.isNotEmpty(productList)) {
            productList.stream().forEach(product -> {
                product.setId(RandomUtil.uuId());
                product.setContractId(entity.getId());
            });
            List productEntityList = JsonUtil.getJsonToList(productList, OaContractProductApplyEntity.class);
            this.oaContractProductApplyService.saveBatch(productEntityList);
        }
        if (CollectionUtil.isNotEmpty(attachmentList = oaNoContractApplyCrForm.getAttachmentList())) {
            attachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setContractId(entity.getId());
                attach.setObjId(entity.getId());
                attach.setFileType(AttachmentTypeEnum.NO_CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(attachmentEntityList);
        }
        SaleNoContractEntity saleNoContractEntity = (SaleNoContractEntity)JsonUtil.getJsonToBean((Object)entity, SaleNoContractEntity.class);
        saleNoContractEntity.setFlowStatus(Integer.valueOf(-1));
        saleNoContractEntity.setDeleteFlag("0");
        if (oaNoContractApplyCrForm.getStatus() == 0) {
            saleNoContractEntity.setStatus(SaleNoContractStatusEnum.DRAFT_STATUS.getStatus());
        } else {
            saleNoContractEntity.setStatus(SaleNoContractStatusEnum.AUDIT_STATUS.getStatus());
        }
        this.saleNoContractService.save((Object)saleNoContractEntity);
        if (StringUtils.isNotEmpty((String)saleNoContractEntity.getCustomerIds())) {
            this.saleContractCustomerService.insertListByCustomerIds(saleNoContractEntity.getId(), saleNoContractEntity.getCustomerIds());
        }
        List rkContractProductList = JsonUtil.getJsonToList(productList, RkContractProductEntity.class);
        this.rkContractProductService.saveBatch((Collection)rkContractProductList);
        List rkAttachmentList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
        this.rkAttachmentService.saveBatch((Collection)rkAttachmentList);
        List<OaContractPurchasePlanEntity> purchasePlanList = oaNoContractApplyCrForm.getPurchasePlanList();
        if (ObjectUtil.isNotEmpty(purchasePlanList)) {
            for (OaContractPurchasePlanEntity p : purchasePlanList) {
                p.setNoContractId(entity.getId());
                p.setId(RandomUtil.uuId());
                p.setCompanyId(entity.getSalerCompanyId());
                p.setContractCode(oaNoContractApplyCrForm.getContractCode());
                p.setContractName(oaNoContractApplyCrForm.getContractName());
                p.setCustomerId(oaNoContractApplyCrForm.getCustomerId());
                p.setSalerId(oaNoContractApplyCrForm.getSalerId());
            }
            this.oaContractPurchasePlanService.saveBatch(purchasePlanList);
        }
    }

    @Override
    public void editContractApply(OaNoContractApplyUpForm oaNoContractApplyUpForm) throws DataException {
        OaNoContractApplyEntity entity = (OaNoContractApplyEntity)JsonUtil.getJsonToBean((Object)((Object)oaNoContractApplyUpForm), OaNoContractApplyEntity.class);
        entity.setSalerCompanyId(this.saleNoContractService.getUserCompanyId(entity.getSalerId()));
        if (StringUtils.isEmpty((String)oaNoContractApplyUpForm.getContractCode()) && oaNoContractApplyUpForm.getStatus() != 0 && null != oaNoContractApplyUpForm.getAutoContractCode() && oaNoContractApplyUpForm.getAutoContractCode().booleanValue() && "9".equals(entity.getCompanyId())) {
            entity.setContractCode("AC-" + BillCustomizeUtils.getMJContractBill());
        }
        if (StringUtils.isNotEmpty((String)oaNoContractApplyUpForm.getCustomerAddress())) {
            List addressList = JSON.parseArray((String)oaNoContractApplyUpForm.getCustomerAddress(), String.class);
            if (!addressList.isEmpty()) {
                entity.setCustomerRegion((String)addressList.get(0));
                entity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
            }
            if (addressList.size() > 1) {
                entity.setCustomerProv((String)addressList.get(1));
                entity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
            }
            if (addressList.size() > 2) {
                entity.setCustomerCity((String)addressList.get(2));
                entity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
            }
        } else {
            entity.setCustomerRegion("");
            entity.setCustomerRegionName("");
            entity.setCustomerProv("");
            entity.setCustomerProvName("");
            entity.setCustomerCity("");
            entity.setCustomerCityName("");
        }
        oaNoContractApplyUpForm.setCustomerRegionName(entity.getCustomerRegionName());
        oaNoContractApplyUpForm.setCustomerProvName(entity.getCustomerProvName());
        oaNoContractApplyUpForm.setCustomerCityName(entity.getCustomerCityName());
        this.oaContractCustomerService.removeByContractId(entity.getId());
        if (StringUtils.isNotEmpty((String)entity.getCustomerIds())) {
            this.oaContractCustomerService.insertListByCustomerIds(entity.getId(), entity.getCustomerIds());
        }
        this.updateById(entity);
        BeanUtils.copyProperties((Object)entity, (Object)((Object)oaNoContractApplyUpForm));
        this.oaContractProductApplyService.deleteByContractId(oaNoContractApplyUpForm.getId());
        List<OaContractProductApplyEntity> productList = oaNoContractApplyUpForm.getProductList();
        if (CollectionUtil.isNotEmpty(productList)) {
            productList.stream().forEach(product -> {
                product.setId(RandomUtil.uuId());
                product.setContractId(oaNoContractApplyUpForm.getId());
            });
            List productEntityList = JsonUtil.getJsonToList(productList, OaContractProductApplyEntity.class);
            this.oaContractProductApplyService.saveBatch(productEntityList);
        }
        this.oaAttachmentService.deleteByContractId(oaNoContractApplyUpForm.getId(), AttachmentTypeEnum.NO_CONTRACT_TYPE.getType());
        List<OaAttachmentEntity> attachmentList = oaNoContractApplyUpForm.getAttachmentList();
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setContractId(entity.getId());
                attach.setObjId(entity.getId());
                attach.setFileType(AttachmentTypeEnum.NO_CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(attachmentEntityList);
        }
        SaleNoContractEntity saleNoContractEntity = (SaleNoContractEntity)JsonUtil.getJsonToBean((Object)entity, SaleNoContractEntity.class);
        this.saleNoContractService.updateById((Object)saleNoContractEntity);
        this.saleContractCustomerService.removeByContractId(saleNoContractEntity.getId());
        if (StringUtils.isNotEmpty((String)saleNoContractEntity.getCustomerIds())) {
            this.saleContractCustomerService.insertListByCustomerIds(saleNoContractEntity.getId(), saleNoContractEntity.getCustomerIds());
        }
        this.rkContractProductService.deleteByContractId(oaNoContractApplyUpForm.getId());
        List rkContractProductList = JsonUtil.getJsonToList(productList, RkContractProductEntity.class);
        this.rkContractProductService.saveBatch((Collection)rkContractProductList);
        this.rkAttachmentService.deleteByContractId(oaNoContractApplyUpForm.getId(), AttachmentTypeEnum.NO_CONTRACT_TYPE.getType());
        List rkAttachmentList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
        this.rkAttachmentService.saveBatch((Collection)rkAttachmentList);
        this.oaContractPurchasePlanService.deleteByNoContractId(entity.getId());
        List<OaContractPurchasePlanEntity> purchasePlanList = oaNoContractApplyUpForm.getPurchasePlanList();
        if (ObjectUtil.isNotEmpty(purchasePlanList)) {
            for (OaContractPurchasePlanEntity p : purchasePlanList) {
                p.setNoContractId(entity.getId());
                p.setId(RandomUtil.uuId());
                p.setCompanyId(entity.getSalerCompanyId());
                p.setContractCode(oaNoContractApplyUpForm.getContractCode());
                p.setContractName(oaNoContractApplyUpForm.getContractName());
                p.setCustomerId(oaNoContractApplyUpForm.getCustomerId());
                p.setSalerId(oaNoContractApplyUpForm.getSalerId());
            }
            this.oaContractPurchasePlanService.saveBatch(purchasePlanList);
        }
    }

    @Override
    @FlowCallBackMethod(fullName="\u65e0\u5408\u540c\u7533\u8bf7\u56de\u8c03")
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        SaleNoContractEntity saleNoContractEntity = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)id));
        saleNoContractEntity.setFlowStatus(enableMark);
        saleNoContractEntity.setStatus(SaleNoContractStatusEnum.AUDIT_STATUS.getStatus());
        if (ObjectUtil.equal((Object)enableMark, (Object)2)) {
            saleNoContractEntity.setStatus(SaleNoContractStatusEnum.UNRECOGNIZED_STATUS.getStatus());
            List planList = this.oaContractPurchasePlanService.getPlanListByNoContractId(id);
            this.oaContractPurchasePlanService.insertPlan(planList);
        } else if (ObjectUtil.equal((Object)enableMark, (Object)3) || ObjectUtil.equal((Object)enableMark, (Object)6)) {
            saleNoContractEntity.setStatus(SaleNoContractStatusEnum.CANCEL_STATUS.getStatus());
        } else if (ObjectUtil.equal((Object)enableMark, (Object)5) && "0".equals(model.getRejectAgreeStep())) {
            saleNoContractEntity.setStatus(SaleNoContractStatusEnum.REFUSE_STATUS.getStatus());
        }
        return this.saleNoContractService.updateById((Object)saleNoContractEntity);
    }

    @Override
    public void generateCode(String type, String id) throws DataException {
        String contractType = "";
        String companyId = "";
        switch (type) {
            case "0": {
                RkContractVerifyEntity contractVerify = this.rkContractVerifyService.getInfo(id);
                if (null == contractVerify) break;
                contractType = contractVerify.getContractType();
                companyId = contractVerify.getCompanyId();
                break;
            }
            case "1": {
                RkContractEntity contract = this.rkContractService.getInfo(id);
                if (null == contract) break;
                contractType = contract.getContractType();
                companyId = contract.getCompanyId();
                break;
            }
            case "2": {
                SaleNoContractEntity saleNoContract = this.saleNoContractService.getInfo(id);
                if (null == saleNoContract) break;
                contractType = saleNoContract.getContractType();
                companyId = saleNoContract.getCompanyId();
                break;
            }
        }
        String billNo = "";
        if ("3".equals(companyId)) {
            if (ContractConstant.contractTypeBillPre.containsKey(contractType)) {
                String billNoPre = (String)ContractConstant.contractTypeBillPre.get(contractType);
                billNo = this.baseDataUtil.getBillNumber("jCContractCode", Boolean.valueOf(false));
                billNo = billNoPre + billNo;
                if ("2".equals(type)) {
                    billNo = billNo + "W";
                }
            } else {
                throw new DataException("\u8be5\u5408\u540c\u7c7b\u578b\u65e0\u7f16\u53f7\u89c4\u5219\uff0c\u751f\u6210\u5931\u8d25");
            }
        }
        if (StringUtils.isNotEmpty((String)billNo)) {
            switch (type) {
                case "0": {
                    UpdateWrapper wrapper = new UpdateWrapper();
                    wrapper.lambda().set(RkContractVerifyEntity::getContractCode, (Object)billNo);
                    wrapper.lambda().eq(RkContractVerifyEntity::getId, (Object)id);
                    this.rkContractVerifyService.update((Wrapper)wrapper);
                    UpdateWrapper updateWrapper = new UpdateWrapper();
                    updateWrapper.lambda().set(RkContractEntity::getContractCode, (Object)billNo);
                    updateWrapper.lambda().eq(RkContractEntity::getId, (Object)id);
                    this.rkContractService.update((Wrapper)updateWrapper);
                    break;
                }
                case "1": {
                    UpdateWrapper verifyWrapper = new UpdateWrapper();
                    verifyWrapper.lambda().set(RkContractVerifyEntity::getContractCode, (Object)billNo);
                    verifyWrapper.lambda().eq(RkContractVerifyEntity::getId, (Object)id);
                    this.rkContractVerifyService.update((Wrapper)verifyWrapper);
                    UpdateWrapper contractWrapper = new UpdateWrapper();
                    contractWrapper.lambda().set(RkContractEntity::getContractCode, (Object)billNo);
                    contractWrapper.lambda().eq(RkContractEntity::getId, (Object)id);
                    this.rkContractService.update((Wrapper)contractWrapper);
                    break;
                }
                case "2": {
                    UpdateWrapper noContractApplyWrapper = new UpdateWrapper();
                    noContractApplyWrapper.lambda().set(OaNoContractApplyEntity::getContractCode, (Object)billNo);
                    noContractApplyWrapper.lambda().eq(OaNoContractApplyEntity::getId, (Object)id);
                    this.update((Wrapper)noContractApplyWrapper);
                    UpdateWrapper noContractWrapper = new UpdateWrapper();
                    noContractWrapper.lambda().set(SaleNoContractEntity::getContractCode, (Object)billNo);
                    noContractWrapper.lambda().eq(SaleNoContractEntity::getId, (Object)id);
                    this.saleNoContractService.update((Wrapper)noContractWrapper);
                    break;
                }
            }
        } else {
            throw new DataException("\u672a\u8bbe\u7f6e\u7f16\u53f7\u751f\u6210\u89c4\u5219\uff0c\u751f\u6210\u5931\u8d25");
        }
    }
}

