/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.AfterSalesProjectWarrantyStateEnum;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectTransferAftersaleEntity;
import com.bringspring.contract.entity.RkProjectTrendsEntity;
import com.bringspring.contract.service.AfterSalesProjectsService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectMemberService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProjectTransferAftersaleService;
import com.bringspring.contract.service.RkProjectTrendsService;
import com.bringspring.contract.utils.ProjectStateEnum;
import com.bringspring.contract.utils.ProjectTrendsEnum;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaProjectTransferAftersaleApplyEntity;
import com.bringspring.oa.mapper.OaProjectTransferAftersaleApplyMapper;
import com.bringspring.oa.model.oaprojecttransferaftersaleapply.OaProjectTransferAftersaleApplyCrForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaProjectTransferAftersaleApplyService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaProjectTransferAftersaleApplyServiceImpl
extends ServiceImpl<OaProjectTransferAftersaleApplyMapper, OaProjectTransferAftersaleApplyEntity>
implements OaProjectTransferAftersaleApplyService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkProjectTrendsService rkProjectTrendsService;
    @Autowired
    private RkProjectTransferAftersaleService rkProjectTransferAftersaleService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private AfterSalesProjectsService afterSalesProjectsService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractProjectMemberService rkContractProjectMemberService;

    @Override
    public OaProjectTransferAftersaleApplyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectTransferAftersaleApplyEntity::getId, (Object)id);
        return (OaProjectTransferAftersaleApplyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OaProjectTransferAftersaleApplyEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OaProjectTransferAftersaleApplyEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(OaProjectTransferAftersaleApplyEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<OaProjectTransferAftersaleApplyEntity> getByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectTransferAftersaleApplyEntity::getProjectId, (Object)projectId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public long countByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectTransferAftersaleApplyEntity::getProjectId, (Object)projectId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void createTransferAfterApply(OaProjectTransferAftersaleApplyCrForm aftersaleApplyCrForm) {
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)aftersaleApplyCrForm.getProjectId()));
        String mainId = aftersaleApplyCrForm.getMainId();
        OaProjectTransferAftersaleApplyEntity entity = (OaProjectTransferAftersaleApplyEntity)JsonUtil.getJsonToBean((Object)((Object)aftersaleApplyCrForm), OaProjectTransferAftersaleApplyEntity.class);
        entity.setId(mainId);
        this.save(entity);
        byId.setTransferApplyId(mainId);
        this.rkContractProjectService.updateById((Object)byId);
        List oaAttachmentEntityList = JsonUtil.getJsonToList(aftersaleApplyCrForm.getAttachmentList(), OaAttachmentEntity.class);
        for (OaAttachmentEntity entitys : oaAttachmentEntityList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setObjId(entity.getId());
            entitys.setFileType("project_" + ProjectStateEnum.toAfterSales_state_apply.getState());
            this.oaAttachmentService.save(entitys);
        }
    }

    @Override
    @FlowCallBackMethod(fullName="\u9879\u76ee\u79fb\u4ea4\u552e\u540e\u7533\u8bf7")
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel flowModel) {
        UserInfo userInfo = this.userProvider.get();
        OaProjectTransferAftersaleApplyEntity info = this.getInfo(id);
        if (ObjectUtil.isNotNull((Object)info)) {
            RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)info.getProjectId()));
            projectEntity.setTransferApplyId(id);
            RkProjectTrendsEntity trendsEntity = new RkProjectTrendsEntity();
            trendsEntity.setCustomerId(projectEntity.getCustomerId());
            trendsEntity.setProjectId(projectEntity.getId());
            trendsEntity.setContractId(projectEntity.getContractId());
            trendsEntity.setId(RandomUtil.uuId());
            if (enableMark == 1) {
                trendsEntity.setNodeType(ProjectTrendsEnum.TRANSFER_APPLY.getNode());
                trendsEntity.setNodeDesc(userInfo.getUserName() + "\u53d1\u8d77\u9879\u76ee\u8f6c\u79fb\u552e\u540e\u7533\u8bf7");
                trendsEntity.setDescription(info.getDescription());
                this.rkProjectTrendsService.save((Object)trendsEntity);
                projectEntity.setState(ProjectStateEnum.toAfterSales_state_apply.getState());
            }
            if (enableMark == 3 || enableMark == 5) {
                if (ObjectUtil.isNotNull((Object)projectEntity)) {
                    projectEntity.setState(ProjectStateEnum.accepted.getState());
                }
                trendsEntity.setNodeType(ProjectTrendsEnum.TRANSFER_APPLY.getNode());
                if (enableMark == 3) {
                    trendsEntity.setNodeDesc(userInfo.getUserName() + "\u64a4\u56de\u4e86\u9879\u76ee\u8f6c\u79fb\u552e\u540e\u7533\u8bf7");
                }
                if (enableMark == 5) {
                    trendsEntity.setNodeDesc(userInfo.getUserName() + "\u62d2\u7edd\u4e86\u9879\u76ee\u8f6c\u79fb\u552e\u540e\u7533\u8bf7");
                }
                this.rkProjectTrendsService.save((Object)trendsEntity);
            }
            if (enableMark == 2) {
                projectEntity.setState(ProjectStateEnum.toAfterSales_state.getState());
                projectEntity.setAfterSalesManager(info.getAfterSalesManager());
                projectEntity.setAfterSaleHeader(info.getAfterSalesPerson());
                projectEntity.setAfterSaleExecuteAssistantsUser(info.getAssistantsUser());
                projectEntity.setAfterSalesAssistant(info.getAfterSalesAssistant());
                RkProjectTransferAftersaleEntity jsonToBean = (RkProjectTransferAftersaleEntity)JsonUtil.getJsonToBean((Object)info, RkProjectTransferAftersaleEntity.class);
                jsonToBean.setApprovedTime(DateUtil.getNowDate());
                this.rkProjectTransferAftersaleService.save((Object)jsonToBean);
                this.rkContractProjectMemberService.dealProjectMember("afterSale", projectEntity);
                List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
                List jsonToList = JsonUtil.getJsonToList(oaAttachmentEntityList, RkAttachmentEntity.class);
                jsonToList.stream().forEach(att -> {
                    att.setObjId(id);
                    att.setProjectId(info.getProjectId());
                });
                trendsEntity.setNodeType(ProjectTrendsEnum.TRANSFER_AUDIT.getNode());
                trendsEntity.setNodeDesc(userInfo.getUserName() + "\u5ba1\u6838\u9879\u76ee\u8f6c\u79fb\u552e\u540e\u901a\u8fc7");
                this.rkProjectTrendsService.save((Object)trendsEntity);
                this.afterSalesProjectsService.saveProject(projectEntity, info.getAfterSalesManager(), info.getAssistantsUser(), info.getAfterSalesPerson(), info.getProduct(), info.getCreatorUserId(), info.getDepartment(), info.getDepartmentTree(), AfterSalesProjectWarrantyStateEnum.WARRANTY_STATE.getState(), jsonToList);
            }
            this.rkContractProjectService.updateById((Object)projectEntity);
        }
        return false;
    }
}

