/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.oa.entity.OaRecordBorrowEntity;
import com.bringspring.oa.entity.OaRecordSubitemEntity;
import com.bringspring.oa.mapper.OaRecordBorrowMapper;
import com.bringspring.oa.model.oaRecord.OaRecordPagination;
import com.bringspring.oa.model.oarecordborrow.OaRecorBorrowTask;
import com.bringspring.oa.model.oarecordborrow.OaRecordBorrowCrForm;
import com.bringspring.oa.model.oarecordborrow.OaRecordBorrowSubitemForm;
import com.bringspring.oa.model.oarecordborrow.OaReturnListVO;
import com.bringspring.oa.model.oarecordborrow.Page;
import com.bringspring.oa.service.OaRecordBorrowService;
import com.bringspring.oa.service.OaRecordSubitemService;
import com.bringspring.system.base.service.DblinkService;
import io.netty.util.internal.ConcurrentSet;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaRecordBorrowServiceImpl
extends ServiceImpl<OaRecordBorrowMapper, OaRecordBorrowEntity>
implements OaRecordBorrowService {
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaRecordSubitemService oaRecordSubitemService;
    @Autowired
    private OaRecordBorrowService oaRecordBorrowService;
    @Autowired
    private OaRecordBorrowMapper oaRecordBorrowMapper;

    @Override
    public void create(OaRecordBorrowEntity entity) {
        this.save(entity);
    }

    @Override
    public OaRecordBorrowEntity getInfo(String id) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.lambda().eq(OaRecordBorrowEntity::getId, (Object)id);
        return (OaRecordBorrowEntity)this.getOne((Wrapper)objectQueryWrapper);
    }

    @Override
    public void borrowAdd(String mainId, OaRecordBorrowCrForm oaRecordBorrowCrForm) {
        UserInfo userInfo = this.userProvider.get();
        oaRecordBorrowCrForm.setCreatorUserId(userInfo.getUserId());
        OaRecordBorrowEntity entity = (OaRecordBorrowEntity)JsonUtil.getJsonToBean((Object)((Object)oaRecordBorrowCrForm), OaRecordBorrowEntity.class);
        for (OaRecordBorrowSubitemForm subitem : oaRecordBorrowCrForm.getOaRecordItemList()) {
            String borrowId = RandomUtil.uuId();
            entity.setSubitemId(subitem.getId());
            entity.setRecordId(subitem.getRecordId());
            OaRecordSubitemEntity info = this.oaRecordSubitemService.getInfo(subitem.getId());
            if (subitem.getBorrowType().equals("508967697330189701") || subitem.getBorrowType().equals("508968436605629829")) {
                QueryWrapper borrowQueryWrapper = new QueryWrapper();
                borrowQueryWrapper.lambda().eq(OaRecordBorrowEntity::getSubitemId, (Object)subitem.getId());
                borrowQueryWrapper.lambda().eq(OaRecordBorrowEntity::getIsReturned, (Object)0);
                List oaRecordBorrowEntities = this.oaRecordBorrowMapper.selectList((Wrapper)borrowQueryWrapper);
                OaRecordSubitemEntity subitemServiceInfo = this.oaRecordSubitemService.getInfo(subitem.getId());
                if (oaRecordBorrowCrForm.getStatus() == 1) {
                    entity.setIsStates(1);
                    entity.setIsReturned(0);
                    info.setSubitemStates(subitemServiceInfo.getNumber() == 1 ? "lend" : "archived");
                }
                this.oaRecordSubitemService.updateById(info);
            } else if (subitem.getBorrowType().equals("578507299195205253")) {
                entity.setIsStates(1);
                entity.setIsReturned(0);
            } else {
                entity.setIsReturned(null);
                entity.setIsStates(0);
            }
            entity.setFileName(info.getRecordSubitemName());
            entity.setFileCode(info.getSubitemCode());
            entity.setProcureCode(info.getProcureCode());
            entity.setBorrowDate(subitem.getBorrowDate());
            entity.setBorrowType(subitem.getBorrowType());
            entity.setNumber(subitem.getNumber());
            entity.setId(borrowId);
            entity.setPrimaryId(mainId);
            entity.setBorrowUse(oaRecordBorrowCrForm.getBorrowUse());
            entity.setRecordName(subitem.getRecordName());
            entity.setChoseType(subitem.getChoseType());
            entity.setSubitemType(subitem.getSubitemType());
            entity.setRecordPosition(subitem.getRecordPosition());
            this.oaRecordBorrowService.save(entity);
        }
    }

    @Override
    public void delePrimaryAllId(String id) {
        if (StringUtils.isNotEmpty((String)id)) {
            QueryWrapper objectQueryWrapper = new QueryWrapper();
            objectQueryWrapper.lambda().eq(OaRecordBorrowEntity::getPrimaryId, (Object)id);
            this.oaRecordBorrowMapper.delete((Wrapper)objectQueryWrapper);
        }
    }

    @Override
    public List<OaRecordBorrowEntity> selectPrimaryAllId(String id) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.lambda().eq(OaRecordBorrowEntity::getPrimaryId, (Object)id);
        List oaRecordBorrowEntities = this.oaRecordBorrowMapper.selectList((Wrapper)objectQueryWrapper);
        return oaRecordBorrowEntities;
    }

    @Override
    public List<OaRecorBorrowTask> getFileReturnTask() {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.lambda().eq(OaRecordBorrowEntity::getIsStates, (Object)1);
        objectQueryWrapper.lambda().eq(OaRecordBorrowEntity::getIsReturned, (Object)0);
        objectQueryWrapper.lambda().ne(OaRecordBorrowEntity::getBorrowType, (Object)"578507299195205253");
        List oaRecordBorrowEntities = this.oaRecordBorrowMapper.selectList((Wrapper)objectQueryWrapper);
        List borrow = JsonUtil.getJsonToList((Object)oaRecordBorrowEntities, OaRecorBorrowTask.class);
        ArrayList<OaRecorBorrowTask> borrowList = new ArrayList<OaRecorBorrowTask>();
        for (OaRecorBorrowTask entity : borrow) {
            int day = OaRecordBorrowServiceImpl.conpareDate(LocalDateTime.now(), entity.getBorrowDate());
            if (day != 3 && day != 1) continue;
            OaRecordSubitemEntity info = this.oaRecordSubitemService.getInfo(entity.getSubitemId());
            entity.setSubitemName(info.getRecordSubitemName());
            entity.setResidueNumber(day);
            borrowList.add(entity);
        }
        return borrowList;
    }

    @Override
    public Page getPage(OaRecordPagination param, List<OaReturnListVO> allList, Integer totalPage) {
        Page<OaReturnListVO> page = new Page<OaReturnListVO>();
        page.setCurrentPage(param.getCurrentPage());
        page.setPageSize(param.getPageSize());
        page.setStar((param.getCurrentPage() - 1L) * param.getPageSize());
        int count = totalPage;
        page.setTotal(totalPage);
        page.setPageDatas(allList.subList((int)page.getStar(), count - (int)page.getStar() > (int)page.getPageSize() ? (int)(page.getStar() + page.getPageSize()) : count));
        return page;
    }

    public static int conpareDate(LocalDateTime now, LocalDateTime validateDate) {
        LocalDateTime of1 = LocalDateTime.of(now.getYear(), now.getMonth(), now.getDayOfMonth(), validateDate.getHour(), validateDate.getMinute(), validateDate.getSecond());
        of1.plusSeconds(1L);
        LocalDateTime of = LocalDateTime.of(validateDate.getYear(), validateDate.getMonth(), validateDate.getDayOfMonth(), validateDate.getHour(), validateDate.getMinute(), validateDate.getSecond());
        Duration duration = Duration.between(of1, of);
        return (int)duration.toDays();
    }

    @Override
    public <T, R> List<T> distinctByKey(List<T> tList, Function<? super T, R> function) {
        ArrayList<T> otherList = new ArrayList<T>();
        ConcurrentSet set = new ConcurrentSet();
        for (T t : tList) {
            R r = function.apply(t);
            if (set.contains(r)) continue;
            set.add(r);
            otherList.add(t);
        }
        return otherList;
    }
}

