/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.purchase.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaBuyDetailEntity;
import com.bringspring.oa.model.oaattachment.OaAttachmentCrForm;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.purchase.entity.OaPurchaseDnquiryDetailEntity;
import com.bringspring.purchase.entity.OaPurchaseDnquiryEntity;
import com.bringspring.purchase.model.oapurchasednquiry.OaPurchaseDnquiryCrForm;
import com.bringspring.purchase.model.oapurchasednquiry.OaPurchaseDnquiryDetailModel;
import com.bringspring.purchase.model.oapurchasednquiry.OaPurchaseDnquiryInfoVO;
import com.bringspring.purchase.model.oapurchasednquiry.OaPurchaseDnquiryListVO;
import com.bringspring.purchase.model.oapurchasednquiry.OaPurchaseDnquiryPagination;
import com.bringspring.purchase.model.oapurchasednquiry.OaPurchaseDnquiryPaginationExportModel;
import com.bringspring.purchase.model.oapurchasednquiry.OaPurchaseDnquiryUpForm;
import com.bringspring.purchase.service.OaPurchaseDnquiryDetailService;
import com.bringspring.purchase.service.OaPurchaseDnquiryService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u91c7\u8d2d\u51b3\u7b56\u5355"}, value="oa")
@RequestMapping(value={"/api/oa/OaPurchaseDnquiry"})
public class OaPurchaseDnquiryController {
    private static final Logger log = LoggerFactory.getLogger(OaPurchaseDnquiryController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaPurchaseDnquiryService oaPurchaseDnquiryService;
    @Autowired
    private OaPurchaseDnquiryDetailService oa_purchaseDnquiryDetailService;
    @Autowired
    private OaAttachmentService oaAttachmentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaPurchaseDnquiryPagination oaPurchaseDnquiryPagination) throws IOException {
        List<OaPurchaseDnquiryEntity> list = this.oaPurchaseDnquiryService.getList(oaPurchaseDnquiryPagination);
        for (OaPurchaseDnquiryEntity oaPurchaseDnquiryEntity : list) {
            oaPurchaseDnquiryEntity.setBuyerId(this.baseDataUtil.userSelectValues(oaPurchaseDnquiryEntity.getBuyerId()));
            oaPurchaseDnquiryEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaPurchaseDnquiryEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaPurchaseDnquiryListVO.class);
        for (OaPurchaseDnquiryListVO oaPurchaseDnquiryVO : listVO) {
            oaPurchaseDnquiryVO.setCompanyId(this.baseDataUtil.getDictName(oaPurchaseDnquiryVO.getCompanyId(), "companyName"));
            oaPurchaseDnquiryVO.setSalerName(this.baseDataUtil.userSelectValue(oaPurchaseDnquiryVO.getSalerId()));
            oaPurchaseDnquiryVO.setBuyerId(this.baseDataUtil.userSelectValue(oaPurchaseDnquiryVO.getBuyerId()));
        }
        for (OaPurchaseDnquiryListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaPurchaseDnquiryPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaPurchaseDnquiryCrForm oaPurchaseDnquiryCrForm = (OaPurchaseDnquiryCrForm)JsonUtil.getJsonToBean(crData, OaPurchaseDnquiryCrForm.class);
        String visualId = "696604008135005445";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oaPurchaseDnquiryCrForm.setFormId(this.baseDataUtil.getBillNumber("OaPurchaseDnquiry", Boolean.valueOf(false)));
        oaPurchaseDnquiryCrForm.setCreatorUserId(userInfo.getUserId());
        oaPurchaseDnquiryCrForm.setCreatorTime(DateUtil.getNow());
        OaPurchaseDnquiryEntity entity = (OaPurchaseDnquiryEntity)JsonUtil.getJsonToBean((Object)oaPurchaseDnquiryCrForm, OaPurchaseDnquiryEntity.class);
        entity.setId(mainId);
        String chooseResults = oaPurchaseDnquiryCrForm.getBusinessChooseResults();
        String resChooseResults = "";
        List Oa_purchase_dnquiry_detailList = JsonUtil.getJsonToList(oaPurchaseDnquiryCrForm.getOapurchasednquiryList(), OaPurchaseDnquiryDetailEntity.class);
        if (CollectionUtil.isNotEmpty((Collection)Oa_purchase_dnquiry_detailList)) {
            for (OaPurchaseDnquiryDetailEntity entitys : Oa_purchase_dnquiry_detailList) {
                String id = RandomUtil.uuId();
                String randId = entitys.getId();
                if (StrUtil.equals((CharSequence)randId, (CharSequence)chooseResults)) {
                    resChooseResults = id;
                }
                entitys.setId(id);
                entitys.setParentId(entity.getId());
                if (StrUtil.equals((CharSequence)oaPurchaseDnquiryCrForm.getChooseResults(), (CharSequence)entitys.getId())) {
                    entity.setChooseResultsSupplier(entitys.getSupplierName());
                    entity.setChooseSupplierPrice(entitys.getPurchasePrice());
                }
                this.oa_purchaseDnquiryDetailService.save(entitys);
            }
            entity.setChooseSupplier(Oa_purchase_dnquiry_detailList.stream().map(OaPurchaseDnquiryDetailEntity::getSupplierName).collect(Collectors.joining(",")));
        }
        entity.setBusinessChooseResults(resChooseResults);
        oaPurchaseDnquiryCrForm.setBusinessChooseResults(resChooseResults);
        List<OaAttachmentCrForm> attachList = oaPurchaseDnquiryCrForm.getAttachList();
        attachList.stream().forEach(attach -> attach.setContractId(mainId));
        List licenseEntityList = JsonUtil.getJsonToList(attachList, OaAttachmentEntity.class);
        this.oaAttachmentService.saveBatch(licenseEntityList);
        this.oaPurchaseDnquiryService.save(entity);
        FlowUtil.saveOrSubmit((String)oaPurchaseDnquiryCrForm.getTaskId(), (String)oaPurchaseDnquiryCrForm.getFlowId(), (String)oaPurchaseDnquiryCrForm.getTemplateId(), (String)mainId, (Object)oaPurchaseDnquiryCrForm, (Integer)oaPurchaseDnquiryCrForm.getStatus(), (String)oaPurchaseDnquiryCrForm.getProjectId());
        if (FlowTaskStatusEnum.Handle.getCode().equals(oaPurchaseDnquiryCrForm.getStatus())) {
            return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85");
        }
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaPurchaseDnquiryPaginationExportModel oaPurchaseDnquiryPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaPurchaseDnquiryPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaPurchaseDnquiryPagination oaPurchaseDnquiryPagination = (OaPurchaseDnquiryPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaPurchaseDnquiryPaginationExportModel), OaPurchaseDnquiryPagination.class));
        List<OaPurchaseDnquiryEntity> list = this.oaPurchaseDnquiryService.getTypeList(oaPurchaseDnquiryPagination, oaPurchaseDnquiryPaginationExportModel.getDataType());
        for (OaPurchaseDnquiryEntity oaPurchaseDnquiryEntity : list) {
            oaPurchaseDnquiryEntity.setBuyerId(this.baseDataUtil.userSelectValues(oaPurchaseDnquiryEntity.getBuyerId()));
            oaPurchaseDnquiryEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(oaPurchaseDnquiryEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaPurchaseDnquiryListVO.class);
        for (OaPurchaseDnquiryListVO oaPurchaseDnquiryVO : listVO) {
            oaPurchaseDnquiryVO.setSalerName(this.baseDataUtil.userSelectValue(oaPurchaseDnquiryVO.getSalerId()));
            oaPurchaseDnquiryVO.setBuyerId(this.baseDataUtil.userSelectValue(oaPurchaseDnquiryVO.getBuyerId()));
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtils.isEmpty((String)oaPurchaseDnquiryPaginationExportModel.getSelectKey()) ? oaPurchaseDnquiryPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block54: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "formId": {
                        entitys.add(new ExcelExportEntity("\u8868\u5355\u7f16\u7801", (Object)"formId"));
                        continue block54;
                    }
                    case "projectId": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0\u53ca\u7f16\u53f7", (Object)"projectId"));
                        continue block54;
                    }
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u5ba2\u6237", (Object)"customerId"));
                        continue block54;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u5ba2\u6237", (Object)"customerName"));
                        continue block54;
                    }
                    case "industryType": {
                        entitys.add(new ExcelExportEntity("\u884c\u4e1a", (Object)"industryType"));
                        continue block54;
                    }
                    case "areaType": {
                        entitys.add(new ExcelExportEntity("\u533a\u57df", (Object)"areaType"));
                        continue block54;
                    }
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyId"));
                        continue block54;
                    }
                    case "salerId": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e", (Object)"salerId"));
                        continue block54;
                    }
                    case "salerName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e", (Object)"salerName"));
                        continue block54;
                    }
                    case "procureId": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540cid", (Object)"procureId"));
                        continue block54;
                    }
                    case "procureCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u53f7", (Object)"procureCode"));
                        continue block54;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546", (Object)"supplierName"));
                        continue block54;
                    }
                    case "buyerId": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5458", (Object)"buyerId"));
                        continue block54;
                    }
                    case "chooseReason": {
                        entitys.add(new ExcelExportEntity("\u9009\u62e9\u539f\u56e0", (Object)"chooseReason"));
                        continue block54;
                    }
                    case "chooseResults": {
                        entitys.add(new ExcelExportEntity("\u9009\u62e9\u7ed3\u679c ", (Object)"chooseResults"));
                        continue block54;
                    }
                    case "inquiryId": {
                        entitys.add(new ExcelExportEntity("\u8be2\u4ef7\u660e\u7ec6id ", (Object)"inquiryId"));
                        continue block54;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block54;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65e5\u671f", (Object)"creatorTime"));
                        continue block54;
                    }
                    case "chooseSupplier": {
                        entitys.add(new ExcelExportEntity("\u8be2\u4ef7\u4f9b\u5e94\u5546", (Object)"chooseSupplier"));
                        continue block54;
                    }
                    case "chooseResultsSupplier": {
                        entitys.add(new ExcelExportEntity("\u9009\u62e9\u4f9b\u5e94\u5546", (Object)"chooseResultsSupplier"));
                        continue block54;
                    }
                    case "chooseSupplierPrice": {
                        entitys.add(new ExcelExportEntity("\u9009\u62e9\u91c7\u8d2d\u4ef7\u683c", (Object)"chooseSupplierPrice"));
                        continue block54;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaPurchaseDnquiryInfoVO> info(@PathVariable(value="id") String id) {
        OaPurchaseDnquiryEntity entity = this.oaPurchaseDnquiryService.getInfo(id);
        OaPurchaseDnquiryInfoVO vo = (OaPurchaseDnquiryInfoVO)JsonUtil.getJsonToBean((Object)entity, OaPurchaseDnquiryInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        List<OaPurchaseDnquiryDetailEntity> Oa_purchase_dnquiry_detailList = this.oaPurchaseDnquiryService.getOa_purchase_dnquiry_detailList(id);
        for (OaPurchaseDnquiryDetailEntity oaPurchaseDnquiryDetailEntity : Oa_purchase_dnquiry_detailList) {
        }
        vo.setOaPurchaseDnquiryList(JsonUtil.getJsonToList(Oa_purchase_dnquiry_detailList, OaPurchaseDnquiryDetailModel.class));
        List<OaAttachmentEntity> attachList = this.oaAttachmentService.getListByContractId(id);
        vo.setAttachList(JsonUtil.getJsonToList(attachList, OaAttachmentCrForm.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaPurchaseDnquiryUpForm oaPurchaseDnquiryUpForm = (OaPurchaseDnquiryUpForm)JsonUtil.getJsonToBean(upData, OaPurchaseDnquiryUpForm.class);
        String visualId = "696604008135005445";
        UserInfo userInfo = this.userProvider.get();
        OaPurchaseDnquiryEntity entity = this.oaPurchaseDnquiryService.getInfo(id);
        if (entity != null) {
            OaPurchaseDnquiryEntity subentity = (OaPurchaseDnquiryEntity)JsonUtil.getJsonToBean((Object)oaPurchaseDnquiryUpForm, OaPurchaseDnquiryEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            QueryWrapper Oa_purchase_dnquiry_detailqueryWrapper = new QueryWrapper();
            Oa_purchase_dnquiry_detailqueryWrapper.lambda().eq(OaPurchaseDnquiryDetailEntity::getParentId, (Object)entity.getId());
            this.oa_purchaseDnquiryDetailService.remove((Wrapper)Oa_purchase_dnquiry_detailqueryWrapper);
            String chooseResults = oaPurchaseDnquiryUpForm.getBusinessChooseResults();
            String demanderChooseResults = oaPurchaseDnquiryUpForm.getDemanderChooseResults();
            String lastChooseResults = oaPurchaseDnquiryUpForm.getChooseResults();
            String resChooseResults = "";
            String resDemanderChooseResults = "";
            String resLastChooseResults = "";
            List Oa_purchase_dnquiry_detailList = JsonUtil.getJsonToList(oaPurchaseDnquiryUpForm.getOapurchasednquiryList(), OaPurchaseDnquiryDetailEntity.class);
            if (CollectionUtil.isNotEmpty((Collection)Oa_purchase_dnquiry_detailList)) {
                for (OaPurchaseDnquiryDetailEntity entitys : Oa_purchase_dnquiry_detailList) {
                    String detailId = RandomUtil.uuId();
                    String randId = entitys.getId();
                    if (StrUtil.equals((CharSequence)randId, (CharSequence)chooseResults)) {
                        resChooseResults = detailId;
                    }
                    if (StrUtil.equals((CharSequence)randId, (CharSequence)demanderChooseResults)) {
                        resDemanderChooseResults = detailId;
                    }
                    if (StrUtil.equals((CharSequence)randId, (CharSequence)lastChooseResults)) {
                        resLastChooseResults = detailId;
                    }
                    entitys.setId(detailId);
                    entitys.setParentId(entity.getId());
                    if (StrUtil.equals((CharSequence)oaPurchaseDnquiryUpForm.getChooseResults(), (CharSequence)entitys.getId())) {
                        entity.setChooseResultsSupplier(entitys.getSupplierName());
                        entity.setChooseSupplierPrice(entitys.getPurchasePrice());
                    }
                    this.oa_purchaseDnquiryDetailService.save(entitys);
                }
                entity.setChooseSupplier(Oa_purchase_dnquiry_detailList.stream().map(OaPurchaseDnquiryDetailEntity::getSupplierName).collect(Collectors.joining(",")));
            }
            subentity.setBusinessChooseResults(resChooseResults);
            subentity.setDemanderChooseResults(resDemanderChooseResults);
            subentity.setChooseResults(resLastChooseResults);
            this.oaPurchaseDnquiryService.update(id, subentity);
            this.oaAttachmentService.deleteByContractId(id);
            List<OaAttachmentCrForm> attachList = oaPurchaseDnquiryUpForm.getAttachList();
            attachList.stream().forEach(attach -> attach.setContractId(id));
            List licenseEntityList = JsonUtil.getJsonToList(attachList, OaAttachmentEntity.class);
            this.oaAttachmentService.saveBatch(licenseEntityList);
            FlowUtil.saveOrSubmit((String)oaPurchaseDnquiryUpForm.getTaskId(), (String)oaPurchaseDnquiryUpForm.getFlowId(), (String)oaPurchaseDnquiryUpForm.getTemplateId(), (String)id, (Object)oaPurchaseDnquiryUpForm, (Integer)oaPurchaseDnquiryUpForm.getStatus(), (String)oaPurchaseDnquiryUpForm.getProjectId());
            if (FlowTaskStatusEnum.Handle.getCode().equals(oaPurchaseDnquiryUpForm.getStatus())) {
                return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85");
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaPurchaseDnquiryEntity entity = this.oaPurchaseDnquiryService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaPurchaseDnquiryService.delete(entity);
            QueryWrapper queryWrapperOa_purchase_dnquiry_detail = new QueryWrapper();
            queryWrapperOa_purchase_dnquiry_detail.lambda().eq(OaPurchaseDnquiryDetailEntity::getParentId, (Object)entity.getId());
            this.oa_purchaseDnquiryDetailService.remove((Wrapper)queryWrapperOa_purchase_dnquiry_detail);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/getDetailList"})
    public ActionResult getDetailList(@RequestBody @Valid Map<String, Object> crData) throws IOException {
        Object checkedRows = crData.get("checkedRows");
        ArrayList<OaBuyDetailEntity> resultList = new ArrayList<OaBuyDetailEntity>();
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isNotEmpty((Object)checkedRows)) {
            List detailList = JsonUtil.getJsonToList((Object)checkedRows, OaPurchaseDnquiryListVO.class);
            for (OaPurchaseDnquiryListVO vo : detailList) {
                OaPurchaseDnquiryDetailEntity entity = (OaPurchaseDnquiryDetailEntity)this.oa_purchaseDnquiryDetailService.getById((Serializable)((Object)vo.getChooseResults()));
                OaBuyDetailEntity o = new OaBuyDetailEntity();
                o.setId(RandomUtil.uuId());
                o.setBuyName(entity.getPurchaseName());
                o.setSupplierName(entity.getSupplierName());
                o.setContacts(userInfo.getRealName());
                o.setBuyBrand(entity.getSupplierName());
                if (NumberUtil.isNumber((CharSequence)entity.getPurchasePrice())) {
                    o.setBuyPrice(new BigDecimal(entity.getPurchasePrice()));
                }
                resultList.add(o);
            }
        }
        return ActionResult.success(resultList);
    }
}

