/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.quotation.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.quotation.entity.OaSaleQuotationEntity;
import com.bringspring.quotation.entity.OaSaleQuotationProfitApplyEntity;
import com.bringspring.quotation.entity.OaSaleQuotationProfitDetailApplyEntity;
import com.bringspring.quotation.model.oaSaleQuotationProfitDetailApply.OaSaleQuotationProfitDetailApplyModel;
import com.bringspring.quotation.model.oasalequotationprofitapply.OaSaleQuotationProfitApplyCrForm;
import com.bringspring.quotation.model.oasalequotationprofitapply.OaSaleQuotationProfitApplyInfoVO;
import com.bringspring.quotation.model.oasalequotationprofitapply.OaSaleQuotationProfitApplyListVO;
import com.bringspring.quotation.model.oasalequotationprofitapply.OaSaleQuotationProfitApplyPagination;
import com.bringspring.quotation.model.oasalequotationprofitapply.OaSaleQuotationProfitApplyPaginationExportModel;
import com.bringspring.quotation.model.oasalequotationprofitapply.OaSaleQuotationProfitApplyUpForm;
import com.bringspring.quotation.service.OaSaleQuotationProfitApplyService;
import com.bringspring.quotation.service.OaSaleQuotationProfitDetailApplyService;
import com.bringspring.quotation.service.OaSaleQuotationService;
import com.bringspring.quotation.utils.QuotationProfitEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u62a5\u4ef7\u6bdb\u5229\u7533\u8bf7"}, value="quotation")
@RequestMapping(value={"/api/quotation/OaSaleQuotationProfitApply"})
public class OaSaleQuotationProfitApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaSaleQuotationProfitApplyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaSaleQuotationProfitApplyService oaSaleQuotationProfitApplyService;
    @Autowired
    private OaSaleQuotationProfitDetailApplyService oaSaleQuotationProfitDetailApplyService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private OaSaleQuotationService oaSaleQuotationService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaSaleQuotationProfitApplyPagination oaSaleQuotationProfitApplyPagination) throws IOException {
        List<OaSaleQuotationProfitApplyEntity> list = this.oaSaleQuotationProfitApplyService.getList(oaSaleQuotationProfitApplyPagination);
        for (OaSaleQuotationProfitApplyEntity oaSaleQuotationProfitApplyEntity : list) {
            oaSaleQuotationProfitApplyEntity.setDistributionMethod(this.baseDataUtil.getDictName(oaSaleQuotationProfitApplyEntity.getDistributionMethod(), "606809025312457029"));
            oaSaleQuotationProfitApplyEntity.setSaleId(this.baseDataUtil.userSelectValues(oaSaleQuotationProfitApplyEntity.getSaleId()));
            oaSaleQuotationProfitApplyEntity.setProductType(this.baseDataUtil.getDictName(oaSaleQuotationProfitApplyEntity.getProductType(), "606810185641492805"));
            oaSaleQuotationProfitApplyEntity.setRegionId(this.baseDataUtil.userSelectValues(oaSaleQuotationProfitApplyEntity.getRegionId()));
            oaSaleQuotationProfitApplyEntity.setAddress(this.baseDataUtil.provinceData(oaSaleQuotationProfitApplyEntity.getAddress()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaSaleQuotationProfitApplyListVO.class);
        for (OaSaleQuotationProfitApplyListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaSaleQuotationProfitApplyPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid OaSaleQuotationProfitApplyCrForm oaSaleQuotationProfitApplyCrForm) throws DataException {
        RkProjectReportingEntity byId1;
        OaSaleQuotationEntity byId;
        String flowEngineId = "606807099011236165";
        String mainId = RandomUtil.uuId();
        oaSaleQuotationProfitApplyCrForm.setId(mainId);
        this.oaSaleQuotationProfitApplyService.createProfitApply(oaSaleQuotationProfitApplyCrForm);
        String title = "";
        if (StrUtil.isNotEmpty((CharSequence)oaSaleQuotationProfitApplyCrForm.getQuotationId()) && ObjectUtil.isNotNull((Object)(byId = (OaSaleQuotationEntity)this.oaSaleQuotationService.getById((Serializable)((Object)oaSaleQuotationProfitApplyCrForm.getQuotationId())))) && ObjectUtil.isNotNull((Object)(byId1 = (RkProjectReportingEntity)this.rkProjectReportingService.getById((Serializable)((Object)byId.getOpportunityId()))))) {
            title = byId1.getReportingProject();
        }
        try {
            FlowUtil.saveOrSubmit((String)oaSaleQuotationProfitApplyCrForm.getTaskId(), (String)flowEngineId, (String)oaSaleQuotationProfitApplyCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaSaleQuotationProfitApplyCrForm), (Integer)oaSaleQuotationProfitApplyCrForm.getStatus(), (String)title);
        }
        catch (WorkFlowException e) {
            e.printStackTrace();
        }
        if (oaSaleQuotationProfitApplyCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaSaleQuotationProfitApplyPaginationExportModel oaSaleQuotationProfitApplyPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaSaleQuotationProfitApplyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaSaleQuotationProfitApplyPagination oaSaleQuotationProfitApplyPagination = (OaSaleQuotationProfitApplyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaSaleQuotationProfitApplyPaginationExportModel), OaSaleQuotationProfitApplyPagination.class));
        List<OaSaleQuotationProfitApplyEntity> list = this.oaSaleQuotationProfitApplyService.getTypeList(oaSaleQuotationProfitApplyPagination, oaSaleQuotationProfitApplyPaginationExportModel.getDataType());
        for (OaSaleQuotationProfitApplyEntity oaSaleQuotationProfitApplyEntity : list) {
            oaSaleQuotationProfitApplyEntity.setDistributionMethod(this.baseDataUtil.getDictName(oaSaleQuotationProfitApplyEntity.getDistributionMethod(), "606809025312457029"));
            oaSaleQuotationProfitApplyEntity.setSaleId(this.baseDataUtil.userSelectValues(oaSaleQuotationProfitApplyEntity.getSaleId()));
            oaSaleQuotationProfitApplyEntity.setProductType(this.baseDataUtil.getDictName(oaSaleQuotationProfitApplyEntity.getProductType(), "606810185641492805"));
            oaSaleQuotationProfitApplyEntity.setRegionId(this.baseDataUtil.userSelectValues(oaSaleQuotationProfitApplyEntity.getRegionId()));
            oaSaleQuotationProfitApplyEntity.setAddress(this.baseDataUtil.provinceData(oaSaleQuotationProfitApplyEntity.getAddress()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaSaleQuotationProfitApplyListVO.class);
        for (OaSaleQuotationProfitApplyListVO oaSaleQuotationProfitApplyListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaSaleQuotationProfitApplyPaginationExportModel.getSelectKey()) ? oaSaleQuotationProfitApplyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block34: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "distributionMethod": {
                        entitys.add(new ExcelExportEntity("\u5206\u9500\u65b9\u5f0f", (Object)"distributionMethod"));
                        continue block34;
                    }
                    case "saleId": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u9500\u552e", (Object)"saleId"));
                        continue block34;
                    }
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u533b\u9662\u540d\u79f0", (Object)"customerId"));
                        continue block34;
                    }
                    case "productType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5206\u7c7b", (Object)"productType"));
                        continue block34;
                    }
                    case "regionId": {
                        entitys.add(new ExcelExportEntity("\u533a\u57df\u8d1f\u8d23\u4eba", (Object)"regionId"));
                        continue block34;
                    }
                    case "quotationId": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4ef7", (Object)"quotationId"));
                        continue block34;
                    }
                    case "address": {
                        entitys.add(new ExcelExportEntity("\u5730\u533a", (Object)"address"));
                        continue block34;
                    }
                    case "productId": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1", (Object)"productId"));
                        continue block34;
                    }
                    case "amount": {
                        entitys.add(new ExcelExportEntity("\u6bdb\u5229\u91d1\u989d", (Object)"amount"));
                        continue block34;
                    }
                    case "amountCapital": {
                        entitys.add(new ExcelExportEntity("\u91d1\u989d\u5927\u5199", (Object)"amountCapital"));
                        continue block34;
                    }
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u516c\u53f8id", (Object)"companyId"));
                        continue block34;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaSaleQuotationProfitApplyInfoVO> info(@PathVariable(value="id") String id) {
        CrmCustomerEntity byId;
        List<String> list1;
        List productCategoryList;
        OaSaleQuotationProfitApplyEntity entity = this.oaSaleQuotationProfitApplyService.getInfo(id);
        OaSaleQuotationProfitApplyInfoVO vo = (OaSaleQuotationProfitApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OaSaleQuotationProfitApplyInfoVO.class);
        OaSaleQuotationEntity quotationEntity = (OaSaleQuotationEntity)this.oaSaleQuotationService.getById((Serializable)((Object)vo.getQuotationId()));
        if (ObjectUtil.isNotNull((Object)quotationEntity)) {
            RkProjectReportingEntity reportingEntity = (RkProjectReportingEntity)this.rkProjectReportingService.getById((Serializable)((Object)quotationEntity.getOpportunityId()));
            if (ObjectUtil.isNotNull((Object)reportingEntity)) {
                vo.setOppName(StrUtil.isBlank((CharSequence)quotationEntity.getSerialNumber()) ? reportingEntity.getReportingProject() + " - " + this.baseDataUtil.userSelectValue(quotationEntity.getQuotationUser()) : quotationEntity.getSerialNumber() + " - " + this.baseDataUtil.userSelectValue(quotationEntity.getQuotationUser()));
            } else {
                vo.setOppName(this.baseDataUtil.userSelectValue(vo.getSaleId()));
            }
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getProductCategoryId()) && CollectionUtil.isNotEmpty((Collection)(productCategoryList = this.crmProductCategoryService.getInfoByIdList(list1 = Arrays.asList(vo.getProductCategoryId().split(",")))))) {
            String productCategoryName = productCategoryList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(","));
            vo.setProductCategoryName(productCategoryName);
        }
        List<OaSaleQuotationProfitDetailApplyEntity> OaSaleQuotationProfitDetailApplyList = this.oaSaleQuotationProfitApplyService.GetOaSaleQuotationProfitDetailApplyList(id);
        List saleList = OaSaleQuotationProfitDetailApplyList.stream().filter(detail -> StrUtil.equals((CharSequence)detail.getType(), (CharSequence)QuotationProfitEnum.SALE_TYPE.getType())).collect(Collectors.toList());
        List devList = OaSaleQuotationProfitDetailApplyList.stream().filter(detail -> StrUtil.equals((CharSequence)detail.getType(), (CharSequence)QuotationProfitEnum.DEV_TYPE.getType())).collect(Collectors.toList());
        List executeList = OaSaleQuotationProfitDetailApplyList.stream().filter(detail -> StrUtil.equals((CharSequence)detail.getType(), (CharSequence)QuotationProfitEnum.EXECUTE_TYPE.getType())).collect(Collectors.toList());
        List bussinessList = OaSaleQuotationProfitDetailApplyList.stream().filter(detail -> StrUtil.equals((CharSequence)detail.getType(), (CharSequence)QuotationProfitEnum.BUSSINESS_TYPE.getType())).collect(Collectors.toList());
        List profitList = OaSaleQuotationProfitDetailApplyList.stream().filter(detail -> StrUtil.equals((CharSequence)detail.getType(), (CharSequence)QuotationProfitEnum.PROFIT_TYPE.getType())).collect(Collectors.toList());
        vo.setSaleList(JsonUtil.getJsonToList(saleList, OaSaleQuotationProfitDetailApplyModel.class));
        vo.setExecuteList(JsonUtil.getJsonToList(executeList, OaSaleQuotationProfitDetailApplyModel.class));
        vo.setDevList(JsonUtil.getJsonToList(devList, OaSaleQuotationProfitDetailApplyModel.class));
        vo.setBusinessList(JsonUtil.getJsonToList(bussinessList, OaSaleQuotationProfitDetailApplyModel.class));
        vo.setProfitList(JsonUtil.getJsonToList(profitList, OaSaleQuotationProfitDetailApplyModel.class));
        vo.setOaSaleQuotationProfitApplyList(JsonUtil.getJsonToList(OaSaleQuotationProfitDetailApplyList, OaSaleQuotationProfitDetailApplyModel.class));
        List<OaAttachmentEntity> oaAttachmentEntityList = this.oaAttachmentService.listByBussinessObjId(id);
        vo.setAttachmentList(oaAttachmentEntityList);
        if (StrUtil.isNotEmpty((CharSequence)vo.getCustomerId()) && ObjectUtil.isNotNull((Object)(byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo.getCustomerId()))))) {
            vo.setCustomerName(byId.getName());
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaSaleQuotationProfitApplyUpForm oaSaleQuotationProfitApplyUpForm) throws DataException {
        String flowEngineId = "606807099011236165";
        UserInfo userInfo = this.userProvider.get();
        OaSaleQuotationProfitApplyEntity entity = this.oaSaleQuotationProfitApplyService.getInfo(id);
        if (entity != null) {
            RkProjectReportingEntity byId1;
            OaSaleQuotationEntity byId;
            this.oaSaleQuotationProfitApplyService.updateProfitApply(oaSaleQuotationProfitApplyUpForm);
            String title = "";
            if (StrUtil.isNotEmpty((CharSequence)oaSaleQuotationProfitApplyUpForm.getQuotationId()) && ObjectUtil.isNotNull((Object)(byId = (OaSaleQuotationEntity)this.oaSaleQuotationService.getById((Serializable)((Object)oaSaleQuotationProfitApplyUpForm.getQuotationId())))) && ObjectUtil.isNotNull((Object)(byId1 = (RkProjectReportingEntity)this.rkProjectReportingService.getById((Serializable)((Object)byId.getOpportunityId()))))) {
                title = byId1.getReportingProject();
            }
            try {
                FlowUtil.saveOrSubmit((String)oaSaleQuotationProfitApplyUpForm.getTaskId(), (String)flowEngineId, (String)oaSaleQuotationProfitApplyUpForm.getTemplateId(), (String)id, (Object)((Object)oaSaleQuotationProfitApplyUpForm), (Integer)oaSaleQuotationProfitApplyUpForm.getStatus(), (String)title);
            }
            catch (WorkFlowException e) {
                e.printStackTrace();
            }
            if (oaSaleQuotationProfitApplyUpForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaSaleQuotationProfitApplyEntity entity = this.oaSaleQuotationProfitApplyService.getInfo(id);
        List<OaSaleQuotationEntity> listByProfitApplyEntity = this.oaSaleQuotationService.getListByProfitApplyEntity(id);
        if (!listByProfitApplyEntity.isEmpty()) {
            return ActionResult.success((String)"prohibitDelete");
        }
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaSaleQuotationProfitApplyService.delete(entity);
            QueryWrapper queryWrapperOaSaleQuotationProfitDetailApply = new QueryWrapper();
            queryWrapperOaSaleQuotationProfitDetailApply.lambda().eq(OaSaleQuotationProfitDetailApplyEntity::getProfitId, (Object)entity.getId());
            this.oaSaleQuotationProfitDetailApplyService.remove((Wrapper)queryWrapperOaSaleQuotationProfitDetailApply);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

