/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.tender.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.tender.entity.OaManufacturerAuthorizationEntity;
import com.bringspring.tender.model.oaManufacturerAuthorization.OaManufacturerAuthorizationCrForm;
import com.bringspring.tender.model.oaManufacturerAuthorization.OaManufacturerAuthorizationImportReturnVO;
import com.bringspring.tender.model.oaManufacturerAuthorization.OaManufacturerAuthorizationImportVO;
import com.bringspring.tender.model.oaManufacturerAuthorization.OaManufacturerAuthorizationInfoVO;
import com.bringspring.tender.model.oaManufacturerAuthorization.OaManufacturerAuthorizationListVO;
import com.bringspring.tender.model.oaManufacturerAuthorization.OaManufacturerAuthorizationPagination;
import com.bringspring.tender.model.oaManufacturerAuthorization.OaManufacturerAuthorizationPaginationExportModel;
import com.bringspring.tender.model.oaManufacturerAuthorization.OaManufacturerAuthorizationUpForm;
import com.bringspring.tender.service.OaManufacturerAuthorizationService;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u5382\u5bb6\u6388\u6743\u7533\u8bf7\u8868"}, value="oa")
@RequestMapping(value={"/api/oa/OaManufacturerAuthorization"})
public class OaManufacturerAuthorizationController {
    private static final Logger log = LoggerFactory.getLogger(OaManufacturerAuthorizationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaManufacturerAuthorizationService oaManufacturerAuthorizationService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaManufacturerAuthorizationPagination oaManufacturerAuthorizationPagination) throws IOException {
        List<OaManufacturerAuthorizationEntity> list = this.oaManufacturerAuthorizationService.getList(oaManufacturerAuthorizationPagination);
        for (OaManufacturerAuthorizationEntity entity : list) {
            entity.setIsSend(this.baseDataUtil.getDictName(entity.getIsSend(), "whether"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaManufacturerAuthorizationListVO.class);
        Date nowdate = new Date();
        for (OaManufacturerAuthorizationListVO oaManufacturerAuthorizationVO : listVO) {
            Date endDate = oaManufacturerAuthorizationVO.getAuthorizationEndDate();
            if (DateUtil.compare((Date)nowdate, (Date)oaManufacturerAuthorizationVO.getAuthorizationEndDate()) > 0) {
                oaManufacturerAuthorizationVO.setIsOver("\u662f");
            } else {
                oaManufacturerAuthorizationVO.setIsOver("\u5426");
            }
            oaManufacturerAuthorizationVO.setProducer(this.baseDataUtil.userSelectValue(oaManufacturerAuthorizationVO.getProducer()));
        }
        for (OaManufacturerAuthorizationListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaManufacturerAuthorizationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        List cList;
        List ids;
        OaManufacturerAuthorizationCrForm oaManufacturerAuthorizationCrForm = (OaManufacturerAuthorizationCrForm)JsonUtil.getJsonToBean(crData, OaManufacturerAuthorizationCrForm.class);
        if (StrUtil.isNotEmpty((CharSequence)oaManufacturerAuthorizationCrForm.getOpportunityId())) {
            oaManufacturerAuthorizationCrForm.setOpportunityName(this.rkProjectReportingService.getInfo(oaManufacturerAuthorizationCrForm.getOpportunityId()).getCustomerName());
        }
        if (StringUtils.isNotEmpty((String)oaManufacturerAuthorizationCrForm.getProductId()) && CollectionUtil.isNotEmpty((Collection)(ids = JsonUtil.getJsonToList((String)oaManufacturerAuthorizationCrForm.getProductId(), String.class))) && CollectionUtil.isNotEmpty((Collection)(cList = this.crmProductCategoryService.getInfoByIdList(ids)))) {
            oaManufacturerAuthorizationCrForm.setProductName(cList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(",")));
        }
        oaManufacturerAuthorizationCrForm.setCreatorTime(new Date().getTime());
        oaManufacturerAuthorizationCrForm.setCreatorUserId(this.userProvider.get().getUserId());
        oaManufacturerAuthorizationCrForm.setFormCode(this.baseDataUtil.getBillNumber("OaManufacturerAuthorization", Boolean.valueOf(false)));
        String visualId = "631095555786803141";
        if (StringUtils.isEmpty((String)oaManufacturerAuthorizationCrForm.getFlowId())) {
            oaManufacturerAuthorizationCrForm.setFlowId(visualId);
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OaManufacturerAuthorizationEntity entity = (OaManufacturerAuthorizationEntity)JsonUtil.getJsonToBean((Object)oaManufacturerAuthorizationCrForm, OaManufacturerAuthorizationEntity.class);
        entity.setId(mainId);
        entity.setEnabledMark(0);
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setCreatorUserName(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
        this.oaManufacturerAuthorizationService.save(entity);
        FlowUtil.saveOrSubmit((String)oaManufacturerAuthorizationCrForm.getTaskId(), (String)oaManufacturerAuthorizationCrForm.getFlowId(), (String)oaManufacturerAuthorizationCrForm.getTemplateId(), (String)mainId, (Object)oaManufacturerAuthorizationCrForm, (Integer)oaManufacturerAuthorizationCrForm.getStatus(), (String)oaManufacturerAuthorizationCrForm.getProjectName());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaManufacturerAuthorizationInfoVO> info(@PathVariable(value="id") String id) {
        OaManufacturerAuthorizationEntity entity = this.oaManufacturerAuthorizationService.getInfo(id);
        OaManufacturerAuthorizationInfoVO vo = (OaManufacturerAuthorizationInfoVO)JsonUtil.getJsonToBean((Object)entity, OaManufacturerAuthorizationInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        List cList;
        List ids;
        OaManufacturerAuthorizationUpForm oaManufacturerAuthorizationUpForm = (OaManufacturerAuthorizationUpForm)JsonUtil.getJsonToBean(upData, OaManufacturerAuthorizationUpForm.class);
        if (StrUtil.isNotEmpty((CharSequence)oaManufacturerAuthorizationUpForm.getOpportunityId())) {
            oaManufacturerAuthorizationUpForm.setOpportunityName(this.rkProjectReportingService.getInfo(oaManufacturerAuthorizationUpForm.getOpportunityId()).getCustomerName());
        }
        if (StringUtils.isNotEmpty((String)oaManufacturerAuthorizationUpForm.getProductId()) && CollectionUtil.isNotEmpty((Collection)(ids = JsonUtil.getJsonToList((String)oaManufacturerAuthorizationUpForm.getProductId(), String.class))) && CollectionUtil.isNotEmpty((Collection)(cList = this.crmProductCategoryService.getInfoByIdList(ids)))) {
            oaManufacturerAuthorizationUpForm.setProductName(cList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(",")));
        }
        String visualId = "631095555786803141";
        if (StringUtils.isEmpty((String)oaManufacturerAuthorizationUpForm.getFlowId())) {
            oaManufacturerAuthorizationUpForm.setFlowId(visualId);
        }
        UserInfo userInfo = this.userProvider.get();
        OaManufacturerAuthorizationEntity entity = this.oaManufacturerAuthorizationService.getInfo(id);
        if (entity != null) {
            OaManufacturerAuthorizationEntity subentity = (OaManufacturerAuthorizationEntity)JsonUtil.getJsonToBean((Object)oaManufacturerAuthorizationUpForm, OaManufacturerAuthorizationEntity.class);
            subentity.setCreatorTime(entity.getCreatorTime());
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setLastModifyTime(new Date());
            subentity.setLastModifyUserId(userInfo.getUserId());
            subentity.setEnabledMark(0);
            subentity.setCompanyId(entity.getCompanyId());
            subentity.setFormCode(entity.getFormCode());
            subentity.setCreatorUserName(this.baseDataUtil.userSelectValue(subentity.getCreatorUserId()));
            this.oaManufacturerAuthorizationService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)oaManufacturerAuthorizationUpForm.getTaskId(), (String)oaManufacturerAuthorizationUpForm.getFlowId(), (String)oaManufacturerAuthorizationUpForm.getTemplateId(), (String)id, (Object)oaManufacturerAuthorizationUpForm, (Integer)oaManufacturerAuthorizationUpForm.getStatus(), (String)oaManufacturerAuthorizationUpForm.getProjectName());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaManufacturerAuthorizationEntity entity = this.oaManufacturerAuthorizationService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaManufacturerAuthorizationService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u5382\u5bb6\u6388\u6743.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u5382\u5bb6\u6388\u6743.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OaManufacturerAuthorizationPaginationExportModel oaManufacturerAuthorizationPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)oaManufacturerAuthorizationPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OaManufacturerAuthorizationPagination oaManufacturerAuthorizationPagination = (OaManufacturerAuthorizationPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)oaManufacturerAuthorizationPaginationExportModel), OaManufacturerAuthorizationPagination.class));
        List<OaManufacturerAuthorizationEntity> list = this.oaManufacturerAuthorizationService.getTypeList(oaManufacturerAuthorizationPagination, oaManufacturerAuthorizationPaginationExportModel.getDataType());
        for (OaManufacturerAuthorizationEntity entity : list) {
            entity.setCreatorUserName(this.baseDataUtil.userSelectValues(entity.getCreatorUserId()));
            entity.setIsSend(this.baseDataUtil.getDictName(entity.getIsSend(), "401373862127762245"));
        }
        List listVO = JsonUtil.getJsonToList(list, OaManufacturerAuthorizationListVO.class);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)oaManufacturerAuthorizationPaginationExportModel.getSelectKey()) ? oaManufacturerAuthorizationPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block36: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "formCode": {
                        entitys.add(new ExcelExportEntity("\u7f16\u7801", (Object)"formCode"));
                        continue block36;
                    }
                    case "creatorUserName": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserName"));
                        continue block36;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block36;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block36;
                    }
                    case "authorizationStartDate": {
                        entitys.add(new ExcelExportEntity("\u6388\u6743\u5f00\u59cb\u65e5\u671f", (Object)"authorizationStartDate"));
                        continue block36;
                    }
                    case "authorizationEndDate": {
                        entitys.add(new ExcelExportEntity("\u6388\u6743\u7ed3\u675f\u65e5\u671f", (Object)"authorizationEndDate"));
                        continue block36;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block36;
                    }
                    case "isSend": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u90ae\u5bc4", (Object)"isSend"));
                        continue block36;
                    }
                    case "sendAddress": {
                        entitys.add(new ExcelExportEntity("\u90ae\u5bc4\u5730\u5740\u4fe1\u606f", (Object)"sendAddress"));
                        continue block36;
                    }
                    case "opportunityName": {
                        entitys.add(new ExcelExportEntity("\u5546\u673a", (Object)"opportunityName"));
                        continue block36;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546", (Object)"supplierName"));
                        continue block36;
                    }
                    case "productName": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5206\u7c7b", (Object)"productName"));
                        continue block36;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List fileImportList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, OaManufacturerAuthorizationImportVO.class);
        if (CollectionUtil.isEmpty((Collection)fileImportList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fileImportList.size() > 200) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e200\u6761");
        }
        Map<String, Object> map = this.oaManufacturerAuthorizationService.importPreview(fileImportList);
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<OaManufacturerAuthorizationImportReturnVO> ImportData(@RequestBody OaManufacturerAuthorizationImportVO data) throws DataException {
        List dataList = JsonUtil.getJsonToList(data.getList(), OaManufacturerAuthorizationImportVO.class);
        OaManufacturerAuthorizationImportReturnVO result = this.oaManufacturerAuthorizationService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }
}

