/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.lucene;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apdplat.word.recognition.StopWord;
import org.apdplat.word.segmentation.Segmentation;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.apdplat.word.segmentation.Word;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChineseWordTokenizer
extends Tokenizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChineseWordTokenizer.class);
    private final CharTermAttribute charTermAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAttribute = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute positionIncrementAttribute = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private Segmentation segmentation = null;
    private BufferedReader reader = null;
    private final Queue<Word> words = new LinkedTransferQueue<Word>();
    private int startOffset = 0;

    public ChineseWordTokenizer(Reader reader) {
        super(reader);
        this.segmentation = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMaximumMatching);
        this.reader = new BufferedReader(reader);
    }

    public ChineseWordTokenizer(Reader reader, Segmentation segmentation) {
        super(reader);
        this.segmentation = segmentation;
        this.reader = new BufferedReader(reader);
    }

    private Word getWord() throws IOException {
        Word word = this.words.poll();
        if (word == null) {
            String string;
            while ((string = this.reader.readLine()) != null) {
                this.words.addAll(this.segmentation.seg(string));
            }
            this.startOffset = 0;
            word = this.words.poll();
        }
        return word;
    }

    public final boolean incrementToken() throws IOException {
        Word word = this.getWord();
        if (word != null) {
            int n = 1;
            while (StopWord.is(word.getText())) {
                ++n;
                this.startOffset += word.getText().length();
                LOGGER.debug("\u5ffd\u7565\u505c\u7528\u8bcd\uff1a" + word.getText());
                word = this.getWord();
                if (word != null) continue;
                return false;
            }
            this.charTermAttribute.setEmpty().append(word.getText());
            this.offsetAttribute.setOffset(this.startOffset, this.startOffset + word.getText().length());
            this.positionIncrementAttribute.setPositionIncrement(n);
            this.startOffset += word.getText().length();
            return true;
        }
        return false;
    }
}

