/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.base.Page;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.AreagroupEntity;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.model.areagroup.AreagroupQuery;
import com.bringspring.system.base.model.province.AreaModel;
import com.bringspring.system.base.model.province.ProvinceCrForm;
import com.bringspring.system.base.model.province.ProvinceInfoVO;
import com.bringspring.system.base.model.province.ProvinceListQuery;
import com.bringspring.system.base.model.province.ProvinceListVO;
import com.bringspring.system.base.model.province.ProvinceModel;
import com.bringspring.system.base.model.province.ProvinceSelectListVO;
import com.bringspring.system.base.model.province.ProvinceSelector;
import com.bringspring.system.base.model.province.ProvinceUpForm;
import com.bringspring.system.base.service.AreagroupService;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.base.util.JsonUtilEx;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u884c\u653f\u533a\u5212"}, value="Area")
@RestController
@RequestMapping(value={"/api/system/Area"})
public class AreaController {
    @Autowired
    private ProvinceService provinceService;
    @Autowired
    private AreagroupService areagroupService;

    @ApiOperation(value="\u5217\u8868\uff08\u5f02\u6b65\u52a0\u8f7d\uff09")
    @GetMapping(value={"/{nodeId}"})
    public ActionResult<ListVO<ProvinceListVO>> list(@PathVariable(value="nodeId") String nodeId, Page page) {
        List<ProvinceEntity> data;
        List<ProvinceEntity> dataAll = data = this.provinceService.getListByNodeId(nodeId, page);
        List result = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(data, dataAll), ProvinceEntity.class);
        List treeList = JsonUtil.getJsonToList((Object)result, ProvinceListVO.class);
        int i = 0;
        for (ProvinceListVO entity : treeList) {
            boolean childNode = this.provinceService.getListByParentId(entity.getId()).size() <= 0;
            ProvinceListVO provinceListVO = (ProvinceListVO)JsonUtil.getJsonToBean((Object)entity, ProvinceListVO.class);
            provinceListVO.setIsLeaf(childNode);
            provinceListVO.setHasChildren(!childNode);
            treeList.set(i, provinceListVO);
            ++i;
        }
        ListVO vo = new ListVO();
        vo.setList(treeList);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u533a\u5212\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<ProvinceSelector>> getSelector(ProvinceListQuery query) {
        List<ProvinceEntity> allList = this.provinceService.getListAll(query);
        List data = allList.stream().filter(t -> EnabledMarkEnum.ENABLE.getCode() == t.getEnabledMark()).collect(Collectors.toList());
        List models = JsonUtil.getJsonToList(data, ProvinceModel.class);
        List trees = TreeDotUtils.convertListToTreeDot((List)models);
        List listVO = JsonUtil.getJsonToList((Object)trees, ProvinceSelector.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u884c\u653f\u533a\u5212\u4e0b\u62c9\u6846\u6570\u636e")
    @GetMapping(value={"/{parentId}/Selector/{ignoreIds}"})
    public ActionResult<ListVO<ProvinceSelectListVO>> selectList(@PathVariable(value="parentId") String parentId, @PathVariable(value="ignoreIds") String ignoreIds) {
        List<ProvinceEntity> data = this.provinceService.getListByParentId(parentId);
        if (!"0".equals(ignoreIds)) {
            this.filterData(data, new ArrayList<String>(Arrays.asList(ignoreIds)));
        }
        List treeList = JsonUtil.getJsonToList(data, ProvinceSelectListVO.class);
        int i = 0;
        for (ProvinceSelectListVO entity : treeList) {
            ProvinceSelectListVO provinceListVO = (ProvinceSelectListVO)JsonUtil.getJsonToBean((Object)entity, ProvinceSelectListVO.class);
            provinceListVO.setIsLeaf(false);
            treeList.set(i, provinceListVO);
            ++i;
        }
        ListVO vo = new ListVO();
        vo.setList(treeList);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u884c\u653f\u533a\u5212\u4e0b\u62c9\u6846\u6570\u636e")
    @PostMapping(value={"/SelectorAuth"})
    public ActionResult<ListVO<ProvinceSelectListVO>> SelectorAuth(@RequestBody @Valid AreagroupQuery areagroupQuery) {
        List<Object> data = new ArrayList();
        data = !"1".equals(areagroupQuery.getIgnoreIds()) ? this.provinceService.getListByParentId(areagroupQuery.getParentId()) : this.provinceService.getListByParentIdAuth(areagroupQuery.getParentId(), areagroupQuery.getMenuId());
        List treeList = JsonUtil.getJsonToList(data, ProvinceSelectListVO.class);
        int i = 0;
        for (ProvinceSelectListVO entity : treeList) {
            ProvinceSelectListVO provinceListVO = (ProvinceSelectListVO)JsonUtil.getJsonToBean((Object)entity, ProvinceSelectListVO.class);
            provinceListVO.setIsLeaf(false);
            treeList.set(i, provinceListVO);
            ++i;
        }
        ListVO vo = new ListVO();
        vo.setList(treeList);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6839\u636e\u4e0a\u7ea7\u533a\u5212id\u548c\u5206\u7ec4\u7c7b\u578b\u3001\u516c\u53f8id\u83b7\u53d6\u884c\u653f\u533a\u5212\u4e0b\u62c9\u6846\u6570\u636e\u5e26\u6743\u9650")
    @PostMapping(value={"/SelectorAuthByGroup"})
    public ActionResult<ListVO<ProvinceSelectListVO>> SelectorAuthByGroup(@RequestBody @Valid AreagroupQuery areagroupQuery) {
        List<Object> data = new ArrayList();
        if ("0".equals(areagroupQuery.getIgnoreIds())) {
            List<AreagroupEntity> listByCompanyType = this.areagroupService.getListByCompanyType(areagroupQuery.getCompanyId(), areagroupQuery.getGroupType());
            if (ObjectUtil.isEmpty(listByCompanyType)) {
                listByCompanyType = this.areagroupService.getListByCompanyType(areagroupQuery.getCompanyId(), null);
            }
            if (ObjectUtil.isEmpty(listByCompanyType)) {
                data = this.provinceService.getListByParentId(areagroupQuery.getParentId());
            }
            if (ObjectUtil.isNotEmpty(listByCompanyType)) {
                for (AreagroupEntity areagroupEntity : listByCompanyType) {
                    ProvinceEntity provinceEntity = new ProvinceEntity();
                    provinceEntity.setId(areagroupEntity.getId());
                    provinceEntity.setFullName(areagroupEntity.getFullName());
                    data.add(provinceEntity);
                }
            }
        } else if (!"1".equals(areagroupQuery.getIgnoreIds())) {
            data = this.provinceService.getListByParentId(areagroupQuery.getParentId());
        } else {
            data = this.provinceService.SelectorAuthByGroup(areagroupQuery.getParentId());
            if (ObjectUtil.isEmpty(data)) {
                data = this.provinceService.getListByParentId(areagroupQuery.getParentId());
            }
        }
        List treeList = JsonUtil.getJsonToList(data, ProvinceSelectListVO.class);
        int i = 0;
        for (ProvinceSelectListVO entity : treeList) {
            ProvinceSelectListVO provinceListVO = (ProvinceSelectListVO)JsonUtil.getJsonToBean((Object)entity, ProvinceSelectListVO.class);
            provinceListVO.setIsLeaf(false);
            treeList.set(i, provinceListVO);
            ++i;
        }
        ListVO listVO = new ListVO();
        listVO.setList(treeList);
        return ActionResult.success((Object)listVO);
    }

    private void filterData(List<ProvinceEntity> data, List<String> id) {
        List collect = null;
        for (String ids : id) {
            collect = data.stream().filter(t -> ids.equals(t.getParentId())).collect(Collectors.toList());
            data.removeAll(collect);
        }
        if (collect != null && collect.size() > 0) {
            this.filterData(data, collect.stream().map(t -> t.getId()).collect(Collectors.toList()));
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u884c\u653f\u533a\u5212\u4fe1\u606f")
    @GetMapping(value={"/{id}/Info"})
    public ActionResult<ProvinceInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        ProvinceEntity entity = this.provinceService.getInfo(id);
        ProvinceInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, ProvinceInfoVO.class);
        if (!"-1".equals(entity.getParentId())) {
            ProvinceEntity parent = this.provinceService.getInfo(entity.getParentId());
            vo.setParentName(parent.getFullName());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6dfb\u52a0\u884c\u653f\u533a\u5212")
    @PostMapping
    public ActionResult create(@RequestBody @Valid ProvinceCrForm provinceCrForm) {
        ProvinceEntity entity = (ProvinceEntity)JsonUtil.getJsonToBean((Object)provinceCrForm, ProvinceEntity.class);
        if (this.provinceService.isExistByEnCode(provinceCrForm.getEnCode(), entity.getId())) {
            return ActionResult.fail((String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        if (StringUtils.isEmpty((String)provinceCrForm.getParentId())) {
            entity.setParentId("-1");
        }
        this.provinceService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539\u884c\u653f\u533a\u5212")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ProvinceUpForm provinceUpForm) {
        ProvinceEntity entity = (ProvinceEntity)JsonUtil.getJsonToBean((Object)provinceUpForm, ProvinceEntity.class);
        if (this.provinceService.isExistByEnCode(provinceUpForm.getEnCode(), id)) {
            return ActionResult.fail((String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        boolean flag = this.provinceService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        if (this.provinceService.getListByParentId(id).size() == 0) {
            ProvinceEntity entity = this.provinceService.getInfo(id);
            if (entity != null) {
                this.provinceService.delete(entity);
                return ActionResult.success((String)MsgCode.SU003.get());
            }
            return ActionResult.fail((String)MsgCode.FA003.get());
        }
        return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25\uff0c\u5f53\u524d\u6709\u5b50\u8282\u70b9\u6570\u636e");
    }

    @ApiOperation(value="\u66f4\u65b0\u884c\u653f\u533a\u5212\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult upState(@PathVariable(value="id") String id) {
        ProvinceEntity entity = this.provinceService.getInfo(id);
        if (entity.getEnabledMark() == null || "1".equals(String.valueOf(entity.getEnabledMark()))) {
            entity.setEnabledMark(0);
        } else {
            entity.setEnabledMark(1);
        }
        boolean flag = this.provinceService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u884c\u653f\u533a\u5212id\u8f6c\u540d\u79f0")
    @PostMapping(value={"/GetAreaByIds"})
    public ActionResult getAreaByIds(@RequestBody AreaModel model) {
        LinkedList list = new LinkedList();
        for (List<String> idList : model.getIdsList()) {
            List<ProvinceEntity> proList = this.provinceService.getProList(idList);
            List collect = proList.stream().map(ProvinceEntity::getFullName).collect(Collectors.toList());
            list.add(collect);
        }
        return ActionResult.success(list);
    }

    @ApiOperation(value="\u884c\u653f\u533a\u5212id\u52a0\u5206\u7ec4\u8f6c\u540d\u79f0")
    @PostMapping(value={"/GetAreaGroupByIds"})
    public ActionResult GetAreaGroupByIds(@RequestBody AreaModel model) {
        LinkedList list = new LinkedList();
        for (List<String> idList : model.getIdsList()) {
            AreagroupEntity groupInfo = this.areagroupService.getInfo(idList.get(0));
            List<ProvinceEntity> proList = this.provinceService.getProList(idList);
            ArrayList<String> collect = new ArrayList<String>();
            if (ObjectUtil.isNotNull((Object)groupInfo)) {
                collect.add(groupInfo.getFullName());
            }
            collect.addAll(proList.stream().map(ProvinceEntity::getFullName).collect(Collectors.toList()));
            list.add(collect);
        }
        return ActionResult.success(list);
    }

    @ApiOperation(value="\u884c\u653f\u533a\u5212id\u8f6c\u540d\u79f0")
    @PostMapping(value={"/getAreaFullNameByIds"})
    public ActionResult getAreaFullNameByIds(@RequestBody List<String> idList) {
        if (CollectionUtil.isEmpty(idList)) {
            return ActionResult.success(new ArrayList());
        }
        LinkedList list = new LinkedList();
        List provinceEntities = this.provinceService.listByIds(idList);
        provinceEntities.stream().forEach(t -> {
            if (StringUtils.isNotEmpty((String)t.getParentIdTree())) {
                List<String> ids = Arrays.asList(t.getParentIdTree().split(","));
                List<ProvinceEntity> proList = this.provinceService.getProList(ids);
                List collect = proList.stream().map(ProvinceEntity::getFullName).collect(Collectors.toList());
                list.add(collect);
            }
        });
        return ActionResult.success(list);
    }
}

