/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.AreagroupEntity;
import com.bringspring.system.base.entity.ArearelationEntity;
import com.bringspring.system.base.model.areagroup.AreagroupCrForm;
import com.bringspring.system.base.model.areagroup.AreagroupInfoVO;
import com.bringspring.system.base.model.areagroup.AreagroupListVO;
import com.bringspring.system.base.model.areagroup.AreagroupPagination;
import com.bringspring.system.base.model.areagroup.AreagroupUpForm;
import com.bringspring.system.base.service.AreagroupService;
import com.bringspring.system.base.service.ArearelationService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u533a\u57df\u5206\u7ec4\u7ba1\u7406"}, value="system")
@RequestMapping(value={"/api/system/Areagroup"})
public class AreagroupController {
    private static final Logger log = LoggerFactory.getLogger(AreagroupController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AreagroupService areagroupService;
    @Autowired
    private ArearelationService arearelationService;

    @PostMapping(value={"/getList"})
    @ApiOperation(value="\u533a\u57df\u5206\u7ec4\u7ba1\u7406\u5217\u8868")
    public ActionResult list(@RequestBody AreagroupPagination areagroupPagination) throws IOException {
        List<AreagroupEntity> list = this.areagroupService.getList(areagroupPagination);
        for (AreagroupEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, AreagroupListVO.class);
        for (AreagroupListVO areagroupVO : listVO) {
            List<String> collect = this.arearelationService.getList(null, areagroupVO.getId()).stream().map(v -> v.getProvinceId()).collect(Collectors.toList());
            areagroupVO.setAreaList(collect);
            areagroupVO.setCompanyName(this.baseDataUtil.comSelectValue(areagroupVO.getCompanyId(), null));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)areagroupPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @ApiOperation(value="\u533a\u57df\u5206\u7ec4\u7ba1\u7406\u521b\u5efa")
    @PostMapping
    public ActionResult create(@RequestBody @Valid AreagroupCrForm areagroupCrForm) throws DataException {
        this.areagroupService.create(areagroupCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u533a\u57df\u5206\u7ec4\u7ba1\u7406\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<AreagroupInfoVO> info(@PathVariable(value="id") String id) {
        AreagroupEntity entity = this.areagroupService.getInfo(id);
        AreagroupInfoVO vo = (AreagroupInfoVO)JsonUtil.getJsonToBean((Object)entity, AreagroupInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u533a\u57df\u5206\u7ec4\u7ba1\u7406\u8868\u5355\u4fe1\u606f(\u8be6\u60c5\u9875)")
    @GetMapping(value={"/detail/{id}"})
    public ActionResult<AreagroupInfoVO> detailInfo(@PathVariable(value="id") String id) {
        AreagroupEntity entity = this.areagroupService.getInfo(id);
        AreagroupInfoVO vo = (AreagroupInfoVO)JsonUtil.getJsonToBean((Object)entity, AreagroupInfoVO.class);
        vo.setType(this.baseDataUtil.getDictName(vo.getType(), "691995563444407301"));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u533a\u57df\u5206\u7ec4\u7ba1\u7406\u66f4\u65b0")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AreagroupUpForm areagroupUpForm) throws DataException {
        this.areagroupService.update(id, areagroupUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u533a\u57df\u5206\u7ec4\u7ba1\u7406\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        AreagroupEntity entity = this.areagroupService.getInfo(id);
        if (entity != null) {
            this.areagroupService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u7ec4\u5185\u533a\u57df")
    @PostMapping(value={"/getAreaList"})
    public ActionResult getAreaList(@RequestBody @Valid AreagroupCrForm areagroupCrForm) {
        List collect = this.arearelationService.getList(null, areagroupCrForm.getId()).stream().map(v -> v.getProvinceId()).collect(Collectors.toList());
        return ActionResult.success(collect);
    }

    @ApiOperation(value="\u521b\u5efa\u5206\u7ec4\u5185\u533a\u57df")
    @PostMapping(value={"/creatAreaList"})
    public ActionResult creatAreaList(@RequestBody @Valid AreagroupCrForm areagroupCrForm) {
        QueryWrapper arearelationDelete = new QueryWrapper();
        arearelationDelete.lambda().eq(ArearelationEntity::getObjectId, (Object)areagroupCrForm.getId());
        this.arearelationService.remove((Wrapper)arearelationDelete);
        List arearelationList = this.arearelationService.list((Wrapper)arearelationDelete);
        List<String> areaList = areagroupCrForm.getAreaList();
        areaList.forEach(v -> {
            ArearelationEntity arearelationEntity = new ArearelationEntity();
            arearelationEntity.setId(RandomUtil.uuId());
            arearelationEntity.setProvinceId((String)v);
            arearelationEntity.setObjectType("group");
            arearelationEntity.setObjectId(areagroupCrForm.getId());
            arearelationList.add(arearelationEntity);
        });
        boolean b = this.arearelationService.saveBatch(arearelationList);
        return ActionResult.success((Object)b);
    }
}

