/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.DbBackupEntity;
import com.bringspring.system.base.model.dbbackup.DbBackupListVO;
import com.bringspring.system.base.service.DbBackupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u5907\u4efd"}, value="DataBackup")
@RestController
@RequestMapping(value={"/api/system/DataBackup"})
public class DbBackupController {
    @Autowired
    private DbBackupService dbBackupService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5907\u4efd\u5217\u8868(\u5e26\u5206\u9875)")
    @GetMapping
    public ActionResult<PageListVO<DbBackupListVO>> list(Pagination pagination) {
        UserInfo userInfo = this.userProvider.get();
        List<DbBackupEntity> list = this.dbBackupService.getList(pagination);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        List listVos = JsonUtil.getJsonToList(list, DbBackupListVO.class);
        for (DbBackupListVO dbList : listVos) {
            String filePath = this.configValueUtil.getDataBackupFilePath() + dbList.getFileName();
            if (!FileUtil.fileIsFile((String)filePath)) continue;
            dbList.setFileUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + dbList.getFileName() + "#dataBackup")));
        }
        return ActionResult.page((List)listVos, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5907\u4efd")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) throws DataException {
        DbBackupEntity entity = this.dbBackupService.getInfo(id);
        if (entity != null) {
            this.dbBackupService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }
}

