/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.enums.DictionaryDataEnum;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.model.dblink.DbLinkBaseForm;
import com.bringspring.system.base.model.dblink.DbLinkCreUpForm;
import com.bringspring.system.base.model.dblink.DbLinkInfoVO;
import com.bringspring.system.base.model.dblink.DbLinkListVO;
import com.bringspring.system.base.model.dblink.DbLinkModel;
import com.bringspring.system.base.model.dblink.DbLinkSelectorListVO;
import com.bringspring.system.base.model.dblink.PaginationDbLink;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u8fde\u63a5"}, value="DataSource")
@RestController
@RequestMapping(value={"/api/system/DataSource"})
public class DbLinkController {
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private UserService userService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DataSourceModel dataSourceModel;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;

    @GetMapping(value={"/Selector"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u8fde\u63a5\u4e0b\u62c9\u6846\u5217\u8868")
    public ActionResult<ListVO<DbLinkSelectorListVO>> selectorList(String type) {
        DbLinkModel model;
        LinkedList<DbLinkModel> modelAll = new LinkedList<DbLinkModel>();
        List<DbLinkEntity> data = this.dblinkService.getList();
        List<DictionaryDataEntity> dataEntityList = this.dictionaryDataService.getList(DictionaryDataEnum.SYSTEM_DBLINK.getDictionaryTypeId());
        for (DictionaryDataEntity dictionaryDataEntity : dataEntityList) {
            model = new DbLinkModel();
            model.setFullName(dictionaryDataEntity.getFullName());
            model.setParentId("-1");
            model.setId(dictionaryDataEntity.getId());
            Long num = data.stream().filter(t -> t.getDbType().equals(entity.getEnCode())).count();
            model.setNum(num);
            if (num <= 0L) continue;
            modelAll.add(model);
        }
        for (DbLinkEntity dbLinkEntity : data) {
            model = (DbLinkModel)((Object)JsonUtil.getJsonToBean((Object)dbLinkEntity, DbLinkModel.class));
            DictionaryDataEntity dataEntity = dataEntityList.stream().filter(t -> t.getEnCode().equals(dbLinkEntity.getDbType())).findFirst().orElse(null);
            if (dataEntity == null) continue;
            model.setParentId(dataEntity.getId());
            modelAll.add(model);
        }
        List trees = TreeDotUtils.convertListToTreeDot(modelAll);
        ArrayList<DbLinkSelectorListVO> arrayList = new ArrayList<DbLinkSelectorListVO>();
        if (type == null) {
            DbLinkSelectorListVO defaultDb = new DbLinkSelectorListVO();
            defaultDb.setFullName("");
            DbLinkListVO dbLink = new DbLinkListVO();
            dbLink.setFullName("\u9ed8\u8ba4\u6570\u636e\u5e93");
            dbLink.setId("0");
            dbLink.setDbType(this.dataSourceModel.getDbType());
            defaultDb.setChildren(Collections.singletonList(dbLink));
            arrayList.add(defaultDb);
        }
        arrayList.addAll(JsonUtil.getJsonToList((Object)trees, DbLinkSelectorListVO.class));
        ListVO vo = new ListVO();
        vo.setList(arrayList);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/ByPermissionSelector"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u6743\u9650\u83b7\u53d6\u6570\u636e\u8fde\u63a5\u4e0b\u62c9\u6846\u5217\u8868")
    public ActionResult<ListVO<DbLinkSelectorListVO>> byPermissionSelectorList(PaginationDbLink page) {
        DbLinkModel model;
        UserInfo userInfo = this.userProvider.get();
        LinkedList<DbLinkModel> modelAll = new LinkedList<DbLinkModel>();
        List<DbLinkEntity> data = this.dblinkService.getListByPermission(page);
        List<DictionaryDataEntity> dataEntityList = this.dictionaryDataService.getList(DictionaryDataEnum.SYSTEM_DBLINK.getDictionaryTypeId());
        for (DictionaryDataEntity dictionaryDataEntity : dataEntityList) {
            model = new DbLinkModel();
            model.setFullName(dictionaryDataEntity.getFullName());
            model.setParentId("-1");
            model.setId(dictionaryDataEntity.getId());
            Long num = data.stream().filter(t -> t.getDbType().equals(entity.getEnCode())).count();
            model.setNum(num);
            if (num <= 0L) continue;
            modelAll.add(model);
        }
        for (DbLinkEntity dbLinkEntity : data) {
            model = (DbLinkModel)((Object)JsonUtil.getJsonToBean((Object)dbLinkEntity, DbLinkModel.class));
            DictionaryDataEntity dataEntity = dataEntityList.stream().filter(t -> t.getEnCode().equals(dbLinkEntity.getDbType())).findFirst().orElse(null);
            if (dataEntity == null) continue;
            model.setParentId(dataEntity.getId());
            modelAll.add(model);
        }
        List trees = TreeDotUtils.convertListToTreeDot(modelAll);
        ArrayList<DbLinkSelectorListVO> arrayList = new ArrayList<DbLinkSelectorListVO>();
        if (userInfo.getIsAdministrator().booleanValue()) {
            DbLinkSelectorListVO defaultDb = new DbLinkSelectorListVO();
            defaultDb.setFullName("");
            DbLinkListVO dbLink = new DbLinkListVO();
            dbLink.setFullName("\u9ed8\u8ba4\u6570\u636e\u5e93");
            dbLink.setId("0");
            dbLink.setDbType(this.dataSourceModel.getDbType());
            defaultDb.setChildren(Collections.singletonList(dbLink));
            arrayList.add(defaultDb);
        }
        arrayList.addAll(JsonUtil.getJsonToList((Object)trees, DbLinkSelectorListVO.class));
        ListVO vo = new ListVO();
        vo.setList(arrayList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u8fde\u63a5\u5217\u8868")
    public ActionResult getList(PaginationDbLink page) {
        List<DbLinkEntity> data = this.dblinkService.getList(page);
        List<String> userId = data.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList());
        List<String> lastUserId = data.stream().map(t -> t.getLastModifyUserId()).collect(Collectors.toList());
        List<UserEntity> userEntities = this.userService.getUserName(userId);
        List<UserEntity> lastUserIdEntities = this.userService.getUserName(lastUserId);
        List<DictionaryDataEntity> typeList = this.dictionaryDataService.getList(DictionaryDataEnum.SYSTEM_DBLINK.getDictionaryTypeId());
        List jsonToList = JsonUtil.getJsonToList(data, DbLinkListVO.class);
        for (DbLinkListVO vo : jsonToList) {
            DictionaryDataEntity dataEntity = typeList.stream().filter(t -> t.getEnCode().equals(vo.getDbType())).findFirst().orElse(null);
            if (dataEntity != null) {
                vo.setDbType(dataEntity.getFullName());
            } else {
                vo.setDbType("");
            }
            UserEntity creatorUser = userEntities.stream().filter(t -> t.getId().equals(vo.getCreatorUserId())).findFirst().orElse(null);
            vo.setCreatorUserId(creatorUser != null ? creatorUser.getRealName() : vo.getCreatorUserId());
            UserEntity lastModifyUser = lastUserIdEntities.stream().filter(t -> t.getId().equals(vo.getLastModifyUserId())).findFirst().orElse(null);
            vo.setLastModifyUserId(lastModifyUser != null ? lastModifyUser.getRealName() : vo.getLastModifyUserId());
            if (!StringUtils.isNotEmpty((String)vo.getCompanyId())) continue;
            vo.setCompanyId(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)page), PaginationVO.class);
        return ActionResult.page((List)jsonToList, (PaginationVO)paginationVO);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u8fde\u63a5")
    public ActionResult<DbLinkInfoVO> get(@PathVariable(value="id") String id) throws DataException {
        return ActionResult.success((Object)new DbLinkInfoVO().getDbLinkInfoVO(this.dblinkService.getInfo(XSSEscape.escape((String)id))));
    }

    @PostMapping
    @ApiOperation(value="\u6dfb\u52a0\u6570\u636e\u8fde\u63a5")
    public ActionResult<String> create(@RequestBody @Valid DbLinkCreUpForm dbLinkCreUpForm) {
        DbLinkEntity entity = dbLinkCreUpForm.getDbLinkEntity(dbLinkCreUpForm);
        if (this.dblinkService.isExistByFullName(entity.getFullName(), entity.getId())) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        this.dblinkService.create(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @PutMapping(value={"/{id}"})
    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u8fde\u63a5")
    public ActionResult<String> update(@PathVariable(value="id") String id, @RequestBody @Valid DbLinkCreUpForm dbLinkCreUpForm) {
        id = XSSEscape.escape((String)id);
        DbLinkEntity entity = dbLinkCreUpForm.getDbLinkEntity(dbLinkCreUpForm);
        if (this.dblinkService.isExistByFullName(entity.getFullName(), id)) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        if (!this.dblinkService.update(id, entity)) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664\u6570\u636e\u8fde\u63a5")
    public ActionResult<String> delete(@PathVariable(value="id") String id) {
        DbLinkEntity entity = this.dblinkService.getInfo(id);
        if (entity != null) {
            this.dblinkService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @PostMapping(value={"/Actions/Test"})
    @ApiOperation(value="\u6d4b\u8bd5\u8fde\u63a5")
    public ActionResult<String> test(@RequestBody DbLinkBaseForm dbLinkBaseForm) throws DataException {
        boolean data = this.dblinkService.testDbConnection(dbLinkBaseForm.getDbLinkEntity(dbLinkBaseForm));
        if (data) {
            return ActionResult.success((String)"\u8fde\u63a5\u6210\u529f");
        }
        return ActionResult.fail((String)"\u8fde\u63a5\u5931\u8d25");
    }
}

