/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.model.dictionarydata.DictionaryDataAllModel;
import com.bringspring.system.base.model.dictionarydata.DictionaryDataAllVO;
import com.bringspring.system.base.model.dictionarydata.DictionaryDataCrForm;
import com.bringspring.system.base.model.dictionarydata.DictionaryDataInfoVO;
import com.bringspring.system.base.model.dictionarydata.DictionaryDataListVO;
import com.bringspring.system.base.model.dictionarydata.DictionaryDataModel;
import com.bringspring.system.base.model.dictionarydata.DictionaryDataSelectVO;
import com.bringspring.system.base.model.dictionarydata.DictionaryDataUpForm;
import com.bringspring.system.base.model.dictionarydata.PageDictionaryData;
import com.bringspring.system.base.model.dictionarytype.DictionaryExportModel;
import com.bringspring.system.base.model.dictionarytype.DictionaryTypeSelectModel;
import com.bringspring.system.base.model.dictionarytype.DictionaryTypeSelectVO;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.OrganizeRelationEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6570\u636e\u5b57\u5178"}, value="DictionaryData")
@RestController
@RequestMapping(value={"/api/system/DictionaryData"})
public class DictionaryDataController {
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeService organizeService;

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5b57\u5178\u5217\u8868")
    @GetMapping(value={"/{dictionaryTypeId}"})
    public ActionResult bindDictionary(@PathVariable(value="dictionaryTypeId") String dictionaryTypeId, PageDictionaryData pageDictionaryData) {
        List<DictionaryDataEntity> data;
        List<DictionaryDataEntity> dataAll = data = this.dictionaryDataService.getList(dictionaryTypeId);
        if (StringUtils.isNotEmpty((String)pageDictionaryData.getKeyword())) {
            data = data.stream().filter(t -> t.getFullName().contains(pageDictionaryData.getKeyword()) || t.getEnCode().contains(pageDictionaryData.getKeyword())).collect(Collectors.toList());
        }
        if (pageDictionaryData.getIsTree() != null && "1".equals(pageDictionaryData.getIsTree())) {
            List treeData = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(data, dataAll), DictionaryDataEntity.class);
            List voListVO = JsonUtil.getJsonToList((Object)treeData, DictionaryDataModel.class);
            List sumTrees = TreeDotUtils.convertListToTreeDot((List)voListVO);
            List list = JsonUtil.getJsonToList((Object)sumTrees, DictionaryDataListVO.class);
            ListVO treeVo = new ListVO();
            treeVo.setList(list);
            return ActionResult.success((Object)treeVo);
        }
        List voListVO = JsonUtil.getJsonToList(data, DictionaryDataModel.class);
        voListVO.stream().forEach(x -> {
            if (StringUtils.isNotBlank((CharSequence)x.getCompanyId())) {
                OrganizeEntity info = this.organizeService.getInfo(x.getCompanyId());
                OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)info.getPropertyJson(), OrganizeCrModel.class);
                x.setCompanyName(jsonToBean.getShortName());
            }
        });
        ListVO treeVo = new ListVO();
        treeVo.setList(voListVO);
        return ActionResult.success((Object)treeVo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5b57\u5178\u5217\u8868(\u5206\u7c7b+\u5185\u5bb9)")
    @GetMapping(value={"/All"})
    public ActionResult allBindDictionary() {
        List<DictionaryTypeEntity> dictionaryTypeList = this.dictionaryTypeService.getList();
        ArrayList list = new ArrayList();
        for (DictionaryTypeEntity dictionaryTypeEntity : dictionaryTypeList) {
            HashMap<String, String> ht;
            ArrayList selectList;
            List<DictionaryDataEntity> childNodeList = this.dictionaryDataService.getList(dictionaryTypeEntity.getId(), true);
            if (dictionaryTypeEntity.getIsTree().compareTo(1) == 0) {
                selectList = new ArrayList();
                for (DictionaryDataEntity item : childNodeList) {
                    ht = new HashMap<String, String>(16);
                    ht.put("fullName", item.getFullName());
                    ht.put("id", item.getId());
                    ht.put("parentId", item.getParentId());
                    ht.put("enCode", item.getEnCode());
                    selectList.add(ht);
                }
                List jsonToList = JsonUtil.getJsonToList(selectList, DictionaryDataAllModel.class);
                List list1 = TreeDotUtils.convertListToTreeDot((List)jsonToList);
                List list2 = JsonUtil.getJsonToList((Object)list1, DictionaryDataAllVO.class);
                HashMap<String, Object> htItem = new HashMap<String, Object>(16);
                htItem.put("id", dictionaryTypeEntity.getId());
                htItem.put("enCode", dictionaryTypeEntity.getEnCode());
                htItem.put("dictionaryList", list2);
                htItem.put("isTree", 1);
                list.add(htItem);
                continue;
            }
            selectList = new ArrayList();
            for (DictionaryDataEntity item : childNodeList) {
                ht = new HashMap(16);
                ht.put("enCode", item.getEnCode());
                ht.put("id", item.getId());
                ht.put("fullName", item.getFullName());
                selectList.add(ht);
            }
            HashMap<String, Object> htItem = new HashMap<String, Object>(16);
            htItem.put("id", dictionaryTypeEntity.getId());
            htItem.put("enCode", dictionaryTypeEntity.getEnCode());
            htItem.put("dictionaryList", selectList);
            htItem.put("isTree", 0);
            list.add(htItem);
        }
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5b57\u5178\u5206\u7c7b\u4e0b\u62c9\u6846\u6570\u636e")
    @GetMapping(value={"{dictionaryTypeId}/Selector/{id}"})
    public ActionResult<ListVO<DictionaryDataSelectVO>> treeView(@PathVariable(value="dictionaryTypeId") String dictionaryTypeId, String isTree, @PathVariable(value="id") String id) {
        DictionaryTypeEntity typeEntity = this.dictionaryTypeService.getInfo(dictionaryTypeId);
        ArrayList<DictionaryDataModel> treeList = new ArrayList<DictionaryDataModel>();
        DictionaryDataModel treeViewModel = new DictionaryDataModel();
        treeViewModel.setId("0");
        treeViewModel.setFullName(typeEntity.getFullName());
        treeViewModel.setParentId("-1");
        treeViewModel.setIcon("fa fa-tags");
        treeList.add(treeViewModel);
        if ("1".equals(isTree)) {
            List data = this.dictionaryDataService.getList(dictionaryTypeId).stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
            if (!"0".equals(id)) {
                data.remove(this.dictionaryDataService.getInfo(id));
            }
            for (DictionaryDataEntity entity : data) {
                DictionaryDataModel treeModel = new DictionaryDataModel();
                treeModel.setId(entity.getId());
                treeModel.setFullName(entity.getFullName());
                treeModel.setParentId("-1".equals(entity.getParentId()) ? entity.getDictionaryTypeId() : entity.getParentId());
                treeList.add(treeModel);
            }
        }
        List sumTrees = TreeDotUtils.convertListToTreeDotFilter(treeList);
        List list = JsonUtil.getJsonToList((Object)sumTrees, DictionaryDataSelectVO.class);
        ListVO treeVo = new ListVO();
        treeVo.setList(list);
        return ActionResult.success((Object)treeVo);
    }

    @ApiOperation(value="\u83b7\u53d6\u67d0\u4e2a\u5b57\u5178\u6570\u636e\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(path={"{dictionaryTypeId}/Data/Selector/{companyId}", "{dictionaryTypeId}/Data/Selector"})
    public ActionResult<ListVO<DictionaryTypeSelectVO>> selectorOneTreeView(@PathVariable(value="dictionaryTypeId") String dictionaryTypeId, @PathVariable(value="companyId", required=false) String companyId) {
        if (StringUtils.isEmpty((String)companyId)) {
            companyId = this.userProvider.get().getOrganizeId();
        }
        List<DictionaryDataEntity> data = this.dictionaryDataService.getList(dictionaryTypeId, true, companyId);
        List voListVO = JsonUtil.getJsonToList(data, DictionaryTypeSelectModel.class);
        List sumTrees = TreeDotUtils.convertListToTreeDot((List)voListVO);
        List list = JsonUtil.getJsonToList((Object)sumTrees, DictionaryTypeSelectVO.class);
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u67d0\u4e2a\u5b57\u5178\u6570\u636e\u6307\u5b9a\u516c\u53f8\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/{dictionaryTypeId}/{companyId}/Data/Selector"})
    public ActionResult<ListVO<DictionaryTypeSelectVO>> selectorCompanyOneTreeView(@PathVariable(value="dictionaryTypeId") String dictionaryTypeId, @PathVariable(value="companyId") String companyId) {
        List<DictionaryDataEntity> data = this.dictionaryDataService.getListByTypeIdAndCompanyId(dictionaryTypeId, true, companyId);
        List voListVO = JsonUtil.getJsonToList(data, DictionaryTypeSelectModel.class);
        List sumTrees = TreeDotUtils.convertListToTreeDot((List)voListVO);
        List list = JsonUtil.getJsonToList((Object)sumTrees, DictionaryTypeSelectVO.class);
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u67d0\u4e2a\u5b57\u5178\u6570\u636e\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/enCode/{dictionaryTypeEncode}/Data/Selector"})
    public ActionResult<ListVO<DictionaryTypeSelectVO>> selectorOneTreeViewByEncode(@PathVariable(value="dictionaryTypeEncode") String dictionaryTypeEncode) {
        DictionaryTypeEntity dictionaryTypeEntity = this.dictionaryTypeService.getInfoByEnCode(dictionaryTypeEncode);
        List<DictionaryDataEntity> data = this.dictionaryDataService.getList(dictionaryTypeEntity.getId(), true);
        List voListVO = JsonUtil.getJsonToList(data, DictionaryTypeSelectModel.class);
        List sumTrees = TreeDotUtils.convertListToTreeDot((List)voListVO);
        List list = JsonUtil.getJsonToList((Object)sumTrees, DictionaryTypeSelectVO.class);
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5b57\u5178\u4fe1\u606f")
    @GetMapping(value={"/{id}/Info"})
    public ActionResult<DictionaryDataInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        DictionaryDataEntity entity = this.dictionaryDataService.getInfo(id);
        DictionaryDataInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, DictionaryDataInfoVO.class);
        List<OrganizeRelationEntity> relationListByObjectIdAndType = this.organizeRelationService.getRelationListByObjectIdAndType("Dictionary", id);
        if (CollectionUtil.isNotEmpty(relationListByObjectIdAndType)) {
            vo.setCompanyId(relationListByObjectIdAndType.get(0).getOrganizeId());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\uff08\u5f85\u5b9a\uff09\u91cd\u590d\u9a8c\u8bc1\uff08\u540d\u79f0\uff09")
    @GetMapping(value={"/IsExistByFullName"})
    public ActionResult isExistByFullName(String dictionaryTypeId, String fullName, String id) {
        boolean data = this.dictionaryDataService.isExistByFullName(dictionaryTypeId, fullName, id);
        return ActionResult.success((Object)data);
    }

    @ApiOperation(value="\uff08\u5f85\u5b9a\uff09\u91cd\u590d\u9a8c\u8bc1\uff08\u7f16\u7801\uff09")
    @GetMapping(value={"/IsExistByEnCode"})
    public ActionResult isExistByEnCode(String dictionaryTypeId, String enCode, String id) {
        boolean data = this.dictionaryDataService.isExistByEnCode(dictionaryTypeId, enCode, id);
        return ActionResult.success((Object)data);
    }

    @ApiOperation(value="\u6dfb\u52a0\u6570\u636e\u5b57\u5178")
    @PostMapping
    public ActionResult create(@RequestBody @Valid DictionaryDataCrForm dictionaryDataCrForm) throws PermissionException {
        DictionaryDataEntity entity = (DictionaryDataEntity)JsonUtil.getJsonToBean((Object)dictionaryDataCrForm, DictionaryDataEntity.class);
        if (this.dictionaryDataService.isExistByFullName(entity.getDictionaryTypeId(), entity.getFullName(), entity.getId())) {
            return ActionResult.fail((String)"\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.dictionaryDataService.isExistByEnCode(entity.getDictionaryTypeId(), entity.getEnCode(), entity.getId())) {
            return ActionResult.fail((String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        this.dictionaryDataService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u5b57\u5178")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DictionaryDataUpForm dictionaryDataUpForm) throws PermissionException {
        DictionaryDataEntity entity = (DictionaryDataEntity)JsonUtil.getJsonToBean((Object)dictionaryDataUpForm, DictionaryDataEntity.class);
        if (this.dictionaryDataService.isExistByFullName(entity.getDictionaryTypeId(), entity.getFullName(), id)) {
            return ActionResult.fail((String)"\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.dictionaryDataService.isExistByEnCode(entity.getDictionaryTypeId(), entity.getEnCode(), id)) {
            return ActionResult.fail((String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        boolean flag = this.dictionaryDataService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5b57\u5178")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        DictionaryDataEntity entity = this.dictionaryDataService.getInfo(id);
        if (entity != null) {
            if (this.dictionaryDataService.isExistSubset(entity.getId()).booleanValue()) {
                return ActionResult.fail((String)"\u5b57\u5178\u7c7b\u578b\u4e0b\u9762\u6709\u5b57\u5178\u503c\u7981\u6b62\u5220\u9664");
            }
            this.dictionaryDataService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u5b57\u5178\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult update(@PathVariable(value="id") String id) {
        DictionaryDataEntity entity = this.dictionaryDataService.getInfo(id);
        if (entity != null) {
            if ("1".equals(String.valueOf(entity.getEnabledMark()))) {
                entity.setEnabledMark(0);
            } else {
                entity.setEnabledMark(1);
            }
            boolean flag = this.dictionaryDataService.update(entity.getId(), entity);
            if (!flag) {
                return ActionResult.success((String)MsgCode.FA002.get());
            }
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u5b57\u5178\u6570\u636e")
    @GetMapping(value={"/{id}/Action/Export"})
    public ActionResult exportFile(@PathVariable(value="id") String id) {
        DownloadVO downloadVO = this.dictionaryDataService.exportData(id);
        return ActionResult.success((Object)downloadVO);
    }

    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u5bfc\u5165\u529f\u80fd")
    @PostMapping(value={"/Action/Import"}, consumes={"multipart/form-data"})
    public ActionResult importFile(@RequestPart(value="file") MultipartFile multipartFile) throws DataException {
        if (FileUtil.existsSuffix((MultipartFile)multipartFile, (String)ModuleTypeEnum.SYSTEM_DICTIONARYDATA.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get());
        }
        String fileContent = FileUtil.getFileContent((MultipartFile)multipartFile, (String)this.configValueUtil.getTemporaryFilePath());
        try {
            boolean isExists;
            DictionaryExportModel exportModel = (DictionaryExportModel)JsonUtil.getJsonToBean((String)fileContent, DictionaryExportModel.class);
            List<DictionaryTypeEntity> list = exportModel.getList();
            if (list.size() == 1 && !"-1".equals(list.get(0).getParentId()) && this.dictionaryTypeService.getInfo(list.get(0).getParentId()) == null) {
                return ActionResult.fail((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u67e5\u8be2\u4e0d\u5230\u4e0a\u7ea7\u5206\u7c7b");
            }
            if (list.stream().filter(t -> "-1".equals(t.getParentId())).count() < 1L) {
                for (DictionaryTypeEntity dictionaryTypeEntity : list) {
                    if (this.dictionaryTypeService.getInfo(dictionaryTypeEntity.getParentId()) != null) continue;
                    return ActionResult.fail((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u67e5\u8be2\u4e0d\u5230\u4e0a\u7ea7\u5206\u7c7b");
                }
            }
            if (isExists = this.dictionaryDataService.importData(exportModel)) {
                return ActionResult.fail((String)MsgCode.IMP003.get());
            }
        }
        catch (Exception e) {
            throw new DataException(MsgCode.IMP004.get());
        }
        return ActionResult.success((String)MsgCode.IMP001.get());
    }
}

