/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.model.dictionarytype.DictionaryTypeCrForm;
import com.bringspring.system.base.model.dictionarytype.DictionaryTypeInfoVO;
import com.bringspring.system.base.model.dictionarytype.DictionaryTypeListVO;
import com.bringspring.system.base.model.dictionarytype.DictionaryTypeModel;
import com.bringspring.system.base.model.dictionarytype.DictionaryTypeSelectModel;
import com.bringspring.system.base.model.dictionarytype.DictionaryTypeSelectVO;
import com.bringspring.system.base.model.dictionarytype.DictionaryTypeUpForm;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.base.util.JsonUtilEx;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.LinkedList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u5b57\u5178\u5206\u7c7b"}, value="DictionaryType")
@RestController
@RequestMapping(value={"/api/system/DictionaryType"})
public class DictionaryTypeController {
    @Autowired
    private DictionaryTypeService dictionaryTypeService;

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u5206\u7c7b")
    @GetMapping
    public ActionResult<ListVO<DictionaryTypeListVO>> treeView() {
        List<DictionaryTypeEntity> data = this.dictionaryTypeService.getList();
        List voListVO = JsonUtil.getJsonToList(data, DictionaryTypeModel.class);
        List sumTrees = TreeDotUtils.convertListToTreeDot((List)voListVO);
        List list = JsonUtil.getJsonToList((Object)sumTrees, DictionaryTypeListVO.class);
        LinkedList<DictionaryTypeListVO> listVo = new LinkedList<DictionaryTypeListVO>();
        for (DictionaryTypeListVO dictionaryTypeListVO : list) {
            if (!"-1".equals(dictionaryTypeListVO.getParentId())) continue;
            listVo.add(dictionaryTypeListVO);
        }
        ListVO vo = new ListVO();
        vo.setList(listVo);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u5206\u7c7b")
    @PostMapping(value={"/getListByIdList"})
    public ActionResult<ListVO<DictionaryTypeListVO>> getListByIdList(@RequestBody List<String> idList) {
        List<DictionaryTypeEntity> data = this.dictionaryTypeService.getListByIdList(idList);
        List voListVO = JsonUtil.getJsonToList(data, DictionaryTypeModel.class);
        List sumTrees = TreeDotUtils.convertListToTreeDot((List)voListVO);
        List list = JsonUtil.getJsonToList((Object)sumTrees, DictionaryTypeListVO.class);
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u5206\u7c7b\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/Selector/{id}"})
    public ActionResult<ListVO<DictionaryTypeSelectVO>> selectorTreeView(@PathVariable(value="id") String id) {
        List<DictionaryTypeEntity> data = this.dictionaryTypeService.getList();
        if (!"0".equals(id)) {
            data.remove(this.dictionaryTypeService.getInfo(id));
        }
        List voListVO = JsonUtil.getJsonToList(data, DictionaryTypeSelectModel.class);
        List sumTrees = TreeDotUtils.convertListToTreeDotFilter((List)voListVO);
        List list = JsonUtil.getJsonToList((Object)sumTrees, DictionaryTypeSelectVO.class);
        LinkedList<DictionaryTypeSelectVO> listVo = new LinkedList<DictionaryTypeSelectVO>();
        for (DictionaryTypeSelectVO dictionaryTypeListVO : list) {
            if (!"-1".equals(dictionaryTypeListVO.getParentId())) continue;
            listVo.add(dictionaryTypeListVO);
        }
        ListVO vo = new ListVO();
        vo.setList(listVo);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u5206\u7c7b\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<DictionaryTypeInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        DictionaryTypeEntity entity = this.dictionaryTypeService.getInfo(id);
        DictionaryTypeInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, DictionaryTypeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6839\u636e\u7236\u7ea7Id\u83b7\u53d6\u5b57\u5178\u5206\u7c7b\u4fe1\u606f")
    @GetMapping(value={"listByParentId/{parentId}"})
    public ActionResult getDictByParentId(@PathVariable(value="parentId") String parentId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(DictionaryTypeEntity::getParentId, (Object)parentId);
        List list = this.dictionaryTypeService.list((Wrapper)wrapper);
        return ActionResult.success((Object)list);
    }

    @ApiOperation(value="\u6dfb\u52a0\u5b57\u5178\u5206\u7c7b")
    @PostMapping
    public ActionResult create(@RequestBody @Valid DictionaryTypeCrForm dictionaryTypeCrForm) {
        DictionaryTypeEntity entity = (DictionaryTypeEntity)JsonUtil.getJsonToBean((Object)dictionaryTypeCrForm, DictionaryTypeEntity.class);
        entity.setParentId(entity.getParentId());
        if (this.dictionaryTypeService.isExistByFullName(entity.getFullName(), entity.getId())) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        if (this.dictionaryTypeService.isExistByEnCode(entity.getEnCode(), entity.getId())) {
            return ActionResult.fail((String)MsgCode.EXIST002.get());
        }
        this.dictionaryTypeService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539\u5b57\u5178\u5206\u7c7b")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DictionaryTypeUpForm dictionaryTypeUpForm) {
        DictionaryTypeEntity entity = (DictionaryTypeEntity)JsonUtil.getJsonToBean((Object)dictionaryTypeUpForm, DictionaryTypeEntity.class);
        if (this.dictionaryTypeService.isExistByFullName(entity.getFullName(), id)) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        if (this.dictionaryTypeService.isExistByEnCode(entity.getEnCode(), id)) {
            return ActionResult.fail((String)MsgCode.EXIST002.get());
        }
        boolean flag = this.dictionaryTypeService.update(id, entity);
        if (!flag) {
            return ActionResult.success((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u5b57\u5178\u5206\u7c7b")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        DictionaryTypeEntity entity = this.dictionaryTypeService.getInfo(id);
        if (entity != null) {
            boolean isOk = this.dictionaryTypeService.delete(entity);
            if (isOk) {
                return ActionResult.success((String)MsgCode.SU003.get());
            }
            return ActionResult.fail((String)"\u5b57\u5178\u7c7b\u578b\u4e0b\u9762\u6709\u5b57\u5178\u503c\u7981\u6b62\u5220\u9664");
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }
}

