/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.login.UserMenuModel;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.TreeViewModel;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.model.module.MenuListVO;
import com.bringspring.system.base.model.module.MenuSelectAllVO;
import com.bringspring.system.base.model.module.MenuSelectVO;
import com.bringspring.system.base.model.module.ModuleCrForm;
import com.bringspring.system.base.model.module.ModuleExportModel;
import com.bringspring.system.base.model.module.ModuleInfoVO;
import com.bringspring.system.base.model.module.ModuleModel;
import com.bringspring.system.base.model.module.ModuleUpForm;
import com.bringspring.system.base.model.module.PaginationMenu;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.base.util.JsonUtilEx;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7cfb\u7edf\u83dc\u5355"}, value="menu")
@RestController
@RequestMapping(value={"/api/system/Menu"})
public class ModuleController {
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u5217\u8868")
    @GetMapping(value={"/systemList"})
    public ActionResult<ListVO<MenuListVO>> systemList(PaginationMenu paginationMenu) {
        List<ModuleEntity> data = this.moduleService.getList(paginationMenu.getCategory(), paginationMenu.getKeyword(), paginationMenu.getType(), null, null);
        List list = JsonUtil.getJsonToList(data, UserMenuModel.class);
        List menuList = TreeDotUtils.convertListToTreeDot((List)list);
        List menuvo = JsonUtil.getJsonToList((Object)menuList, ModuleModel.class);
        ListVO vo = new ListVO();
        vo.setList(menuvo);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u5217\u8868")
    @GetMapping
    public ActionResult<ListVO<MenuListVO>> list(PaginationMenu paginationMenu) {
        List<ModuleEntity> data = this.moduleService.getList(paginationMenu.getCategory(), paginationMenu.getKeyword(), paginationMenu.getType(), null, paginationMenu.getParentId());
        List list = JsonUtil.getJsonToList(data, UserMenuModel.class);
        List menuList = TreeDotUtils.convertListToTreeDot((List)list);
        List menuvo = JsonUtil.getJsonToList((Object)menuList, MenuListVO.class);
        ArrayList<MenuListVO> resultMenuList = new ArrayList<MenuListVO>();
        if (StringUtils.isNotEmpty((String)paginationMenu.getParentId())) {
            for (MenuListVO menuListVO : menuvo) {
                if (menuListVO.getId().equals(paginationMenu.getParentId()) && StringUtils.isNotEmpty(menuListVO.getChildren())) {
                    resultMenuList.addAll(menuListVO.getChildren());
                    continue;
                }
                if (menuListVO.getParentId().equals(paginationMenu.getParentId())) {
                    resultMenuList.add(menuListVO);
                    continue;
                }
                if (menuListVO.getParentId().equals(paginationMenu.getParentId())) continue;
                resultMenuList.add(menuListVO);
            }
        }
        ListVO vo = new ListVO();
        vo.setList(resultMenuList);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u5217\u8868(\u4e0b\u62c9\u6846)")
    @GetMapping(value={"/Selector/{id}"})
    public ActionResult<ListVO<MenuSelectVO>> treeView(String category, @PathVariable(value="id") String id) {
        List<ModuleEntity> moduleList = this.moduleService.getList(category, null, "1", null, null);
        List<ModuleEntity> systemModuleList = this.moduleService.getList(null, null, "0", null, null);
        systemModuleList.addAll(moduleList);
        if (!"0".equals(id)) {
            systemModuleList.remove(this.moduleService.getInfo(id));
        }
        List list = JsonUtil.getJsonToList(systemModuleList, UserMenuModel.class);
        List menuList = TreeDotUtils.convertListToTreeDotFilter((List)list);
        List menuvo = JsonUtil.getJsonToList((Object)menuList, MenuSelectVO.class);
        ListVO vo = new ListVO();
        vo.setList(menuvo);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u5217\u8868\u4e0b\u62c9\u6846")
    @GetMapping(value={"/Selector/All"})
    public ActionResult<ListVO<MenuSelectVO>> menuSelect(String category) {
        List<ModuleEntity> data = this.moduleService.getList(category, null, null, "1", null);
        List list = JsonUtil.getJsonToList(data, UserMenuModel.class);
        List menuList = TreeDotUtils.convertListToTreeDot((List)list);
        List menuvo = JsonUtil.getJsonToList((Object)menuList, MenuSelectAllVO.class);
        ListVO vo = new ListVO();
        vo.setList(menuvo);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u7cfb\u7edf\u529f\u80fd\u7c7b\u522b\u6811\u5f62")
    @GetMapping(value={"/TreeView"})
    public ActionResult treeView() {
        List<ModuleEntity> moduleList = this.moduleService.getList(null, null, null, null, "0");
        ArrayList<TreeViewModel> treeList = new ArrayList<TreeViewModel>();
        TreeViewModel treeViewModel = new TreeViewModel();
        treeViewModel.setId("apply");
        treeViewModel.setText("\u8f6f\u4ef6\u5f00\u53d1\u5e73\u53f0");
        treeViewModel.setParentId("0");
        treeViewModel.setImg("fa fa-windows apply");
        treeList.add(treeViewModel);
        for (ModuleEntity entity : moduleList) {
            TreeViewModel treeModel = new TreeViewModel();
            treeModel.setId(entity.getId());
            treeModel.setText(entity.getFullName());
            treeModel.setParentId("apply");
            treeModel.setImg("fa fa-tags");
            treeList.add(treeModel);
        }
        return ActionResult.success((Object)ListToTreeUtil.toTreeView(treeList));
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult info(@PathVariable(value="id") String id) throws DataException {
        ModuleEntity entity = this.moduleService.getInfo(id);
        ModuleInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, ModuleInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa\u7cfb\u7edf\u529f\u80fd")
    @PostMapping
    public ActionResult create(@RequestBody @Valid ModuleCrForm moduleCrForm) {
        ModuleEntity entity = (ModuleEntity)JsonUtil.getJsonToBean((Object)moduleCrForm, ModuleEntity.class);
        if (entity.getUrlAddress() != null) {
            entity.setUrlAddress(entity.getUrlAddress().trim());
        }
        if (this.moduleService.isExistByFullName(entity, moduleCrForm.getCategory())) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        if (this.moduleService.isExistByEnCode(entity, moduleCrForm.getCategory())) {
            return ActionResult.fail((String)MsgCode.EXIST002.get());
        }
        this.moduleService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u7cfb\u7edf\u529f\u80fd")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ModuleUpForm moduleUpForm) {
        ModuleEntity entity = (ModuleEntity)JsonUtil.getJsonToBean((Object)moduleUpForm, ModuleEntity.class);
        ModuleEntity moduleEntity = this.moduleService.getInfo(id);
        if (moduleEntity != null && moduleEntity.getType() == 1 && entity.getType() != 1 && this.moduleService.getList(moduleEntity.getId()).size() > 0) {
            return ActionResult.fail((String)"\u5f53\u524d\u76ee\u5f55\u5b58\u5728\u6570\u636e,\u4e0d\u80fd\u4fee\u6539\u7c7b\u578b");
        }
        if (entity.getUrlAddress() != null) {
            entity.setUrlAddress(entity.getUrlAddress().trim());
        }
        if (this.moduleService.isExistByFullName(entity, moduleUpForm.getCategory())) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        if (this.moduleService.isExistByEnCode(entity, moduleUpForm.getCategory())) {
            return ActionResult.fail((String)MsgCode.EXIST002.get());
        }
        boolean flag = this.moduleService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u7cfb\u7edf\u529f\u80fd")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        ModuleEntity entity = this.moduleService.getInfo(id);
        if (entity != null) {
            List list = this.moduleService.getList().stream().filter(t -> t.getParentId().equals(entity.getId())).collect(Collectors.toList());
            if (list.size() > 0) {
                return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u5148\u5220\u9664\u5b50\u83dc\u5355\u3002");
            }
            this.moduleService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u83dc\u5355\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult upState(@PathVariable(value="id") String id) {
        ModuleEntity entity = this.moduleService.getInfo(id);
        if (entity != null) {
            if (entity.getEnabledMark() == null || "1".equals(String.valueOf(entity.getEnabledMark()))) {
                entity.setEnabledMark(0);
            } else {
                entity.setEnabledMark(1);
            }
            this.moduleService.update(id, entity);
            String cacheKey = this.cacheKeyUtil.getUserAuthorize() + this.userProvider.get().getUserId();
            if (this.cacheUtil.exists("loginCacheSpace", cacheKey)) {
                this.cacheUtil.remove("loginCacheSpace", cacheKey);
            }
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @ApiOperation(value="\u5bfc\u51fa\u7cfb\u7edf\u83dc\u5355\u6570\u636e")
    @GetMapping(value={"/{id}/Action/Export"})
    public ActionResult exportFile(@PathVariable(value="id") String id) {
        DownloadVO downloadVO = this.moduleService.exportData(id);
        return ActionResult.success((Object)downloadVO);
    }

    @ApiOperation(value="\u7cfb\u7edf\u83dc\u5355\u5bfc\u5165\u529f\u80fd")
    @PostMapping(value={"/Action/Import"}, consumes={"multipart/form-data"})
    public ActionResult importFile(@RequestPart(value="file") MultipartFile multipartFile) throws DataException {
        if (FileUtil.existsSuffix((MultipartFile)multipartFile, (String)ModuleTypeEnum.SYSTEM_MODULE.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get());
        }
        String fileContent = FileUtil.getFileContent((MultipartFile)multipartFile, (String)this.configValueUtil.getTemporaryFilePath());
        try {
            ModuleExportModel exportModel = (ModuleExportModel)JsonUtil.getJsonToBean((String)fileContent, ModuleExportModel.class);
            ModuleEntity moduleEntity = exportModel.getModuleEntity();
            if (!"-1".equals(moduleEntity.getParentId()) && this.moduleService.getInfo(moduleEntity.getParentId()) == null) {
                return ActionResult.fail((String)"\u5bfc\u5165\u5931\u8d25,\u67e5\u8be2\u4e0d\u5230\u4e0a\u7ea7\u5206\u7c7b");
            }
            boolean isExists = this.moduleService.importData(exportModel);
            if (isExists) {
                return ActionResult.fail((String)MsgCode.IMP003.get());
            }
        }
        catch (Exception e) {
            throw new DataException(MsgCode.IMP004.get());
        }
        return ActionResult.success((String)MsgCode.IMP001.get());
    }
}

