/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.entity.ModuleDataAuthorizeSchemeEntity;
import com.bringspring.system.base.model.moduledataauthorizescheme.DataAuthorizeSchemeCrForm;
import com.bringspring.system.base.model.moduledataauthorizescheme.DataAuthorizeSchemeInfoVO;
import com.bringspring.system.base.model.moduledataauthorizescheme.DataAuthorizeSchemeListVO;
import com.bringspring.system.base.model.moduledataauthorizescheme.DataAuthorizeSchemeUpForm;
import com.bringspring.system.base.service.ModuleDataAuthorizeSchemeService;
import com.bringspring.system.base.util.JsonUtilEx;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u6743\u9650\u65b9\u6848"}, value="ModuleDataAuthorizeScheme")
@RestController
@RequestMapping(value={"/api/system/ModuleDataAuthorizeScheme"})
public class ModuleDataAuthorizeSchemeController {
    @Autowired
    private ModuleDataAuthorizeSchemeService schemeService;

    @ApiOperation(value="\u65b9\u6848\u5217\u8868")
    @GetMapping(value={"/{moduleId}/List"})
    public ActionResult<ListVO<DataAuthorizeSchemeListVO>> list(@PathVariable(value="moduleId") String moduleId) {
        List<ModuleDataAuthorizeSchemeEntity> data = this.schemeService.getList(moduleId);
        List list = JsonUtil.getJsonToList(data, DataAuthorizeSchemeListVO.class);
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u65b9\u6848\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<DataAuthorizeSchemeInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        ModuleDataAuthorizeSchemeEntity entity = this.schemeService.getInfo(id);
        DataAuthorizeSchemeInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, DataAuthorizeSchemeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa\u65b9\u6848")
    @PostMapping
    public ActionResult create(@RequestBody @Valid DataAuthorizeSchemeCrForm dataAuthorizeSchemeCrForm) {
        ModuleDataAuthorizeSchemeEntity entity = (ModuleDataAuthorizeSchemeEntity)JsonUtil.getJsonToBean((Object)dataAuthorizeSchemeCrForm, ModuleDataAuthorizeSchemeEntity.class);
        if (this.schemeService.isExistByEnCode(entity.getId(), entity.getEnCode(), entity.getModuleId()).booleanValue()) {
            return ActionResult.fail((String)"\u8be5\u65b9\u6848\u5df2\u65b0\u589e\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0");
        }
        if (this.schemeService.isExistByFullName(entity.getId(), entity.getFullName(), entity.getModuleId()).booleanValue()) {
            return ActionResult.fail((String)"\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0");
        }
        this.schemeService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u65b9\u6848")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DataAuthorizeSchemeUpForm dataAuthorizeSchemeUpForm) {
        ModuleDataAuthorizeSchemeEntity entity = (ModuleDataAuthorizeSchemeEntity)JsonUtil.getJsonToBean((Object)dataAuthorizeSchemeUpForm, ModuleDataAuthorizeSchemeEntity.class);
        if ("1".equals(String.valueOf(entity.getAllData()))) {
            return ActionResult.fail((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u65b9\u6848\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        if (this.schemeService.isExistByFullName(id, entity.getFullName(), entity.getModuleId()).booleanValue()) {
            return ActionResult.fail((String)"\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0");
        }
        if (this.schemeService.isExistByEnCode(id, entity.getEnCode(), entity.getModuleId()).booleanValue()) {
            return ActionResult.fail((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801");
        }
        boolean flag = this.schemeService.update(id, entity);
        if (!flag) {
            return ActionResult.success((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u65b9\u6848")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        ModuleDataAuthorizeSchemeEntity entity = this.schemeService.getInfo(id);
        if (entity != null) {
            this.schemeService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }
}

