/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.PadUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.BillRuleEntity;
import com.bringspring.system.base.mapper.BillRuleMapper;
import com.bringspring.system.base.service.BillRuleService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BillRuleServiceImpl
extends ServiceImpl<BillRuleMapper, BillRuleEntity>
implements BillRuleService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CacheUtil cacheUtil;

    @Override
    public List<BillRuleEntity> getList(Pagination pagination) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(BillRuleEntity::getFullName, (Object)pagination.getKeyword())).or()).like(BillRuleEntity::getEnCode, (Object)pagination.getKeyword());
            });
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(BillRuleEntity::getSortCode)).orderByDesc(BillRuleEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(BillRuleEntity::getLastModifyTime);
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<BillRuleEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BillRuleEntity::getEnabledMark, (Object)1);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(BillRuleEntity::getSortCode)).orderByDesc(BillRuleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public BillRuleEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BillRuleEntity::getId, (Object)id);
        return (BillRuleEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BillRuleEntity::getFullName, (Object)fullName);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(BillRuleEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BillRuleEntity::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(BillRuleEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    @DSTransactional
    public String getNumber(String enCode) throws DataException {
        Integer startNumber;
        StringBuilder strNumber = new StringBuilder();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BillRuleEntity::getEnCode, (Object)enCode);
        BillRuleEntity entity = (BillRuleEntity)this.getOne((Wrapper)queryWrapper);
        if (entity != null) {
            startNumber = Integer.parseInt(entity.getStartNumber());
            String dateFor = entity.getDateFormat();
            if (entity.getOutputNumber() != null) {
                entity.setThisNumber(entity.getThisNumber() + 1);
                if (!"no".equals(dateFor)) {
                    String thisDate = DateUtil.dateNow((String)entity.getDateFormat());
                    String serialDate = entity.getOutputNumber().substring(entity.getOutputNumber().length() - dateFor.length() - entity.getDigit(), entity.getOutputNumber().length() - entity.getDigit());
                    if (!serialDate.equals(thisDate)) {
                        entity.setThisNumber(0);
                    }
                }
            } else {
                entity.setThisNumber(0);
            }
            strNumber.append(entity.getPrefix());
            if (!"no".equals(dateFor)) {
                strNumber.append(DateUtil.dateNow((String)entity.getDateFormat()));
            }
        } else {
            throw new DataException("\u5355\u636e\u89c4\u5219\u4e0d\u5b58\u5728");
        }
        strNumber.append(PadUtil.padRight((String)String.valueOf(startNumber + entity.getThisNumber()), (int)entity.getDigit(), (char)'0'));
        entity.setOutputNumber(strNumber.toString());
        this.updateById(entity);
        return strNumber.toString();
    }

    @Override
    public void create(BillRuleEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    public boolean update(String id, BillRuleEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public void delete(BillRuleEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    @DSTransactional
    public boolean first(String id) {
        boolean isOk = false;
        BillRuleEntity upEntity = (BillRuleEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = upEntity.getSortCode() == null ? 0L : upEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().lt(BillRuleEntity::getSortCode, (Object)upSortCode)).orderByDesc(BillRuleEntity::getSortCode);
        List downEntity = this.list((Wrapper)queryWrapper);
        if (downEntity.size() > 0) {
            Long temp = upEntity.getSortCode();
            upEntity.setSortCode(((BillRuleEntity)downEntity.get(0)).getSortCode());
            ((BillRuleEntity)downEntity.get(0)).setSortCode(temp);
            this.updateById(downEntity.get(0));
            this.updateById(upEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    @DSTransactional
    public boolean next(String id) {
        boolean isOk = false;
        BillRuleEntity downEntity = (BillRuleEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = downEntity.getSortCode() == null ? 0L : downEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().gt(BillRuleEntity::getSortCode, (Object)upSortCode)).orderByAsc(BillRuleEntity::getSortCode);
        List upEntity = this.list((Wrapper)queryWrapper);
        if (upEntity.size() > 0) {
            Long temp = downEntity.getSortCode();
            downEntity.setSortCode(((BillRuleEntity)upEntity.get(0)).getSortCode());
            ((BillRuleEntity)upEntity.get(0)).setSortCode(temp);
            this.updateById(upEntity.get(0));
            this.updateById(downEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    public String getBillNumber(String enCode, boolean isCache) throws DataException {
        String strNumber;
        String tenantId;
        String string = tenantId = !StringUtils.isEmpty((String)this.userProvider.get().getTenantId()) ? this.userProvider.get().getTenantId() : "";
        if (isCache) {
            String cacheKey = tenantId + this.userProvider.get().getUserId() + enCode;
            if (!this.cacheUtil.exists("foreverCacheSpace", cacheKey)) {
                strNumber = this.getNumber(enCode);
                this.cacheUtil.insert("foreverCacheSpace", cacheKey, (Object)strNumber);
            } else {
                strNumber = String.valueOf(this.cacheUtil.query("foreverCacheSpace", cacheKey));
            }
        } else {
            strNumber = this.getNumber(enCode);
        }
        return strNumber;
    }

    @Override
    public void useBillNumber(String enCode) {
        String cacheKey = this.userProvider.get().getTenantId() + this.userProvider.get().getUserId() + enCode;
        this.cacheUtil.remove("foreverCacheSpace", cacheKey);
    }

    @Override
    public ActionResult ImportData(BillRuleEntity entity) throws DataException {
        if (entity != null) {
            if (this.isExistByFullName(entity.getFullName(), null)) {
                return ActionResult.fail((String)MsgCode.EXIST001.get());
            }
            if (this.isExistByEnCode(entity.getEnCode(), null)) {
                return ActionResult.fail((String)MsgCode.EXIST002.get());
            }
            try {
                this.save(entity);
            }
            catch (Exception e) {
                throw new DataException(MsgCode.IMP003.get());
            }
            return ActionResult.success((String)MsgCode.IMP001.get());
        }
        return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e");
    }
}

