/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.IpUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.DataInterfaceLogEntity;
import com.bringspring.system.base.mapper.DataInterfaceLogMapper;
import com.bringspring.system.base.service.DataInterfaceLogService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataInterfaceLogServiceImpl
extends ServiceImpl<DataInterfaceLogMapper, DataInterfaceLogEntity>
implements DataInterfaceLogService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public void create(String dateInterfaceId, Integer invokWasteTime) {
        DataInterfaceLogEntity entity = new DataInterfaceLogEntity();
        entity.setId(RandomUtil.uuId());
        entity.setInvokTime(DateUtil.getNowDate());
        entity.setUserId(this.userProvider.get().getUserId());
        entity.setInvokId(dateInterfaceId);
        entity.setInvokIp(IpUtil.getIpAddr());
        entity.setInvokType("GET");
        entity.setInvokDevice(ServletUtils.getUserAgent());
        entity.setInvokWasteTime(invokWasteTime);
        this.save(entity);
    }

    @Override
    public List<DataInterfaceLogEntity> getList(String invokId, Pagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(DataInterfaceLogEntity::getInvokId, (Object)invokId)).orderByDesc(DataInterfaceLogEntity::getInvokTime);
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(DataInterfaceLogEntity::getUserId, (Object)pagination.getKeyword())).or()).like(DataInterfaceLogEntity::getInvokIp, (Object)pagination.getKeyword())).or()).like(DataInterfaceLogEntity::getInvokDevice, (Object)pagination.getKeyword())).or()).like(DataInterfaceLogEntity::getInvokType, (Object)pagination.getKeyword());
            });
        }
        queryWrapper.lambda().orderByDesc(DataInterfaceLogEntity::getInvokTime);
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(iPage.getRecords(), page.getTotal());
    }
}

